/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.datebinner;

import com.dataiku.dip.pivot.backend.common.datebinner.AbstractTimelineBinner;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

abstract class AbstractDateTimelineBinner
extends AbstractTimelineBinner {
    private final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(this.dateTemplate());

    AbstractDateTimelineBinner() {
    }

    abstract int durationInMillis();

    abstract String dateTemplate();

    @Override
    public long getBinId(long timestamp) {
        return timestamp / (long)this.durationInMillis();
    }

    @Override
    public long getBinStartTimestamp(long binId) {
        return binId * (long)this.durationInMillis();
    }

    @Override
    public String getLabel(long binId) {
        return this.dateFormat.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(binId * (long)this.durationInMillis()), ZoneOffset.UTC));
    }

    static String secondDatePartExpression(String input, SQLDialect dialect) {
        if (dialect instanceof OracleSQLDialect) {
            return input;
        }
        return dialect.dateTrunc(input, DateRounding.SECOND);
    }
}

