/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFilter;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class StringDictAxisFilter
implements AxisFilter {
    private boolean[] keeps;
    private RowFilter filter;

    public StringDictAxisFilter(RowFilter filter, LinoMetaFile.ColumnHeader header) {
        this.filter = filter;
        List<String> linoDict = header.stringDict;
        this.keeps = new boolean[linoDict.size()];
        if (filter.selectedValues == null && filter.excludedValues == null) {
            Arrays.fill(this.keeps, true);
            return;
        }
        boolean useSelectedValues = FilterUtils.isASelectedValuesFilter(filter);
        Arrays.fill(this.keeps, !useSelectedValues);
        HashMap<String, Integer> linoMap = new HashMap<String, Integer>();
        for (int i = 0; i < linoDict.size(); ++i) {
            linoMap.put(linoDict.get(i), i);
        }
        if (useSelectedValues) {
            for (String included : filter.selectedValues) {
                Integer idx = (Integer)linoMap.get(included);
                if (idx == null || idx < 0) continue;
                this.keeps[idx.intValue()] = true;
            }
        } else {
            for (String excluded : filter.excludedValues) {
                Integer idx = (Integer)linoMap.get(excluded);
                if (idx == null || idx < 0) continue;
                this.keeps[idx.intValue()] = false;
            }
        }
    }

    @Override
    public boolean filter(Row row) {
        throw new Error("Bad row");
    }

    @Override
    public void filter(LinoReader reader, int blockIdx, boolean[] ret) throws IOException {
        ColumnBlock block = reader.readColumnBlock(this.filter.column, blockIdx);
        int i = 0;
        while (i < block.nbRecords()) {
            int idx = block.ints[i];
            int n = i++;
            ret[n] = ret[n] & this.keeps[idx];
        }
    }
}

