/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.DateAxisParams;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.FilterToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.pivot.backend.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.pivot.backend.sql.utils.PartitionUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.SQLDialect;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;

public class BasicStatsToSQL {
    private PivotTableRequest req;
    private InputTable input;
    private ColumnMapper colMapping;
    private SQLDialect dialect;

    public BasicStatsToSQL(InputTable input, PivotTableRequest req, ColumnMapper colMapping) {
        this.input = input;
        this.req = req;
        this.dialect = input.dialect;
        this.colMapping = colMapping;
    }

    public static boolean axisRequireMinmax(AxisDef axis) {
        boolean isNumericalAxisWithFixedNumberOfBins = axis.type == AxisDef.Type.NUMERICAL && axis.numParams.mode == NumericalAxisParams.BinningMode.FIXED_NB;
        boolean isCustomBinning = axis.type == AxisDef.Type.NUMERICAL && axis.numParams.mode == NumericalAxisParams.BinningMode.CUSTOM;
        boolean isAutomaticDateAxis = AxisDef.Type.DATE.equals((Object)axis.type) && DateAxisParams.BinningMode.AUTOMATIC.equals((Object)axis.dateParams.mode);
        return isNumericalAxisWithFixedNumberOfBins || isAutomaticDateAxis || isCustomBinning;
    }

    public static boolean filterRequireMinmax(RowFilter rowFilter) {
        boolean isNumericalFilter = rowFilter.filterType == ChartFilter.FilterType.NUMERICAL_FACET;
        boolean isDateFilter = rowFilter.filterType == ChartFilter.FilterType.DATE_FACET;
        return isNumericalFilter || isDateFilter || BasicStatsToSQL.isNumericalNoFacets(rowFilter);
    }

    public static boolean isNumericalNoFacets(RowFilter rowFilter) {
        return rowFilter.filterType == ChartFilter.FilterType.ALPHANUM && rowFilter.columnType == AxisDef.Type.NUMERICAL;
    }

    public FieldStatMapping aggregateColumn(SelectQueryBuilder query, AxisDef axis) {
        String inputExpression = switch (axis.type) {
            case AxisDef.Type.NUMERICAL -> this.colMapping.getAs((String)axis.column, (ColumnMapper.ExprType)ColumnMapper.ExprType.NUMBER).expr;
            case AxisDef.Type.DATE -> this.dialect.datePartExpression(this.colMapping.getAs((String)axis.column, (ColumnMapper.ExprType)ColumnMapper.ExprType.DATE).expr, DatePart.SECOND_FROM_EPOCH);
            default -> throw new IllegalArgumentException(String.format("Unsupported axis type: %s", new Object[]{axis.type}));
        };
        FieldStatMapping map = new FieldStatMapping();
        map.min = query.select("min(" + inputExpression + ")");
        map.max = query.select("max(" + inputExpression + ")");
        map.type = axis.type;
        return map;
    }

    public static List<AxisDef> determineDependentColumns(PivotTableRequest req) {
        return BasicStatsToSQL.determineDependentColumns(req, false);
    }

    public static List<AxisDef> determineDependentColumns(PivotTableRequest req, boolean needStatsForFilters) {
        ArrayList<AxisDef> out = new ArrayList<AxisDef>();
        if (req instanceof PivotTableTensorRequest) {
            PivotTableTensorRequest treq = (PivotTableTensorRequest)req;
            for (AxisDef axisDef : treq.axes) {
                if (!BasicStatsToSQL.axisRequireMinmax(axisDef)) continue;
                out.add(axisDef);
            }
        }
        if (needStatsForFilters) {
            for (RowFilter filter : req.filters) {
                if (!BasicStatsToSQL.filterRequireMinmax(filter)) continue;
                out.add(BasicStatsToSQL.filterToAxisDef(filter));
            }
        }
        return out;
    }

    private static AxisDef filterToAxisDef(RowFilter filter) {
        AxisDef axisDef = new AxisDef();
        axisDef.column = filter.column;
        if (filter.filterType == ChartFilter.FilterType.NUMERICAL_FACET) {
            axisDef.type = AxisDef.Type.NUMERICAL;
        } else if (filter.filterType == ChartFilter.FilterType.DATE_FACET) {
            axisDef.type = AxisDef.Type.DATE;
        } else if (filter.filterType == ChartFilter.FilterType.ALPHANUM) {
            axisDef.type = filter.columnType;
        }
        return axisDef;
    }

    public BasicStatsQueryContext buildQuery(Future<BasicStatsBuilder.BasicStats> globalStatsFuture) throws ExecutionException, InterruptedException {
        return this.buildQuery(true, globalStatsFuture);
    }

    public BasicStatsQueryContext buildQuery(boolean includeFilters, Future<BasicStatsBuilder.BasicStats> globalStatsFuture) throws ExecutionException, InterruptedException {
        BasicStatsQueryContext plan = new BasicStatsQueryContext();
        plan.query = new SelectQueryBuilder(this.dialect);
        plan.query.fromTable(this.input.table);
        BasicStatsBuilder.BasicStats globalStats = null;
        if (globalStatsFuture != null && this.needGlobalStats(this.req)) {
            globalStats = globalStatsFuture.get();
        }
        FilterToSQL filterComputer = new FilterToSQL(this.dialect, this.colMapping, globalStats);
        if (includeFilters) {
            String fullFilterExpr = filterComputer.buildFilterExpression(this.dialect, this.req.filters);
            if (fullFilterExpr != null) {
                plan.filterPredRef = plan.query.select(this.dialect.getColumnExpressionForBoolean(fullFilterExpr));
                if (!FilterUtils.hasOnlyAlphanumAndEmptyFilters(this.req.filters)) {
                    plan.query.group(plan.filterPredRef);
                }
            } else {
                plan.filterPredRef = null;
            }
        }
        plan.countRef = plan.query.select("COUNT(*)");
        plan.fields = new HashMap<String, FieldStatMapping>();
        for (AxisDef col : BasicStatsToSQL.determineDependentColumns(this.req, !includeFilters)) {
            plan.fields.put(col.column, this.aggregateColumn(plan.query, col));
            plan.requiredByPivot = true;
        }
        PartitionUtils.appendPartitionFilteringClause(this.input, plan.query);
        return plan;
    }

    private boolean needGlobalStats(PivotTableRequest req) {
        for (RowFilter filter : req.filters) {
            if (!BasicStatsToSQL.isNumericalNoFacets(filter) || Objects.requireNonNullElseGet(filter.customOptions, (Supplier<ChartFilter.CustomOptions>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lcom/dataiku/dip/pivot/frontend/model/ChartFilter$CustomOptions;)()).decimalPlaces != null) continue;
            return true;
        }
        return false;
    }

    public static class FieldStatMapping {
        public AxisDef.Type type;
        public SelectQueryBuilder.SelectRef min;
        public SelectQueryBuilder.SelectRef max;
    }

    public static class BasicStatsQueryContext {
        public SelectQueryBuilder.SelectRef filterPredRef;
        public SelectQueryBuilder.SelectRef countRef;
        public Map<String, FieldStatMapping> fields;
        public SelectQueryBuilder query;
        public boolean requiredByPivot;
    }
}

