/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.pivot.backend.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.PrestoSQLDialect;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.DKULogger;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SQLTypeSniffer {
    private final InputTable table;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.charts.sql.sniffer");

    public SQLTypeSniffer(InputTable table) {
        this.table = table;
    }

    public String buildQuery() {
        SelectQueryBuilder query = new SelectQueryBuilder(this.table.dialect);
        query.fromTable(this.table.table);
        query.limit(1L);
        return query.toSQL();
    }

    public ColumnMapper buildMapper(ResultSetMetaData rsmd) throws SQLException {
        SQLDialect dialect = this.table.dialect;
        ColumnMapper colMapping = new ColumnMapper(dialect);
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            ColumnMapper.ExprType exprType;
            String columnName = rsmd.getColumnName(i);
            boolean isNullable = rsmd.isNullable(i) != 0;
            int sqlType = rsmd.getColumnType(i);
            String sqlTypeName = rsmd.getColumnTypeName(i);
            int sqlPrecision = rsmd.getPrecision(i);
            TimezoneShifter timezoneShift = null;
            DatetimeToTimestamp datetimeToTimestamp = null;
            switch (sqlType) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 100: 
                case 101: {
                    exprType = isNullable ? ColumnMapper.ExprType.NUMBER : ColumnMapper.ExprType.NON_NULL_NUMBER;
                    break;
                }
                case 91: {
                    if (this.table.dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                        exprType = isNullable ? ColumnMapper.ExprType.STRING : ColumnMapper.ExprType.NON_NULL_STRING;
                        break;
                    }
                    if (this.table.dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                        ColumnMapper.ExprType exprType2 = exprType = isNullable ? ColumnMapper.ExprType.DATE : ColumnMapper.ExprType.NON_NULL_DATE;
                        if (dialect.supportsFromTimezoneNtzOperator()) {
                            timezoneShift = new TimezoneShifterNTZ(dialect, this.table.assumedDBTzForUnknownTz);
                            break;
                        }
                        timezoneShift = new TimezoneShifter(dialect, this.table.assumedDBTzForUnknownTz);
                        break;
                    }
                    exprType = isNullable ? ColumnMapper.ExprType.DATE : ColumnMapper.ExprType.NON_NULL_DATE;
                    break;
                }
                case 93: 
                case 2014: {
                    if ("date".equalsIgnoreCase(sqlTypeName)) {
                        if (this.table.dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                            exprType = isNullable ? ColumnMapper.ExprType.STRING : ColumnMapper.ExprType.NON_NULL_STRING;
                            break;
                        }
                        if (this.table.dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                            ColumnMapper.ExprType exprType3 = exprType = isNullable ? ColumnMapper.ExprType.DATE : ColumnMapper.ExprType.NON_NULL_DATE;
                            if (dialect.supportsFromTimezoneNtzOperator()) {
                                timezoneShift = new TimezoneShifterNTZ(dialect, this.table.assumedDBTzForUnknownTz);
                                break;
                            }
                            timezoneShift = new TimezoneShifter(dialect, this.table.assumedDBTzForUnknownTz);
                            break;
                        }
                        exprType = isNullable ? ColumnMapper.ExprType.DATE : ColumnMapper.ExprType.NON_NULL_DATE;
                        break;
                    }
                    if (this.table.dialect.lacksTimezoneInfo(sqlTypeName, sqlPrecision) && !dialect.considerTypeTimestampAsDate()) {
                        if (this.table.datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                            ColumnMapper.ExprType exprType4 = exprType = isNullable ? ColumnMapper.ExprType.DATE : ColumnMapper.ExprType.NON_NULL_DATE;
                            if (dialect.supportsFromTimezoneNtzOperator()) {
                                timezoneShift = new TimezoneShifterNTZ(dialect, this.table.assumedDBTzForUnknownTz);
                                break;
                            }
                            timezoneShift = new TimezoneShifter(dialect, this.table.assumedDBTzForUnknownTz);
                            break;
                        }
                        if (this.table.datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                            exprType = isNullable ? ColumnMapper.ExprType.STRING : ColumnMapper.ExprType.NON_NULL_STRING;
                            break;
                        }
                        exprType = isNullable ? ColumnMapper.ExprType.DATE : ColumnMapper.ExprType.NON_NULL_DATE;
                        datetimeToTimestamp = new DatetimeToTimestamp(dialect);
                        break;
                    }
                    exprType = isNullable ? ColumnMapper.ExprType.DATE : ColumnMapper.ExprType.NON_NULL_DATE;
                    break;
                }
                case -155: 
                case -102: 
                case -101: {
                    exprType = isNullable ? ColumnMapper.ExprType.DATE : ColumnMapper.ExprType.NON_NULL_DATE;
                    break;
                }
                case 12: {
                    if (dialect instanceof PrestoSQLDialect && "timestamp with time zone".equalsIgnoreCase(sqlTypeName)) {
                        exprType = isNullable ? ColumnMapper.ExprType.DATE : ColumnMapper.ExprType.NON_NULL_DATE;
                        break;
                    }
                }
                case -16: 
                case -9: 
                case -1: 
                case 1: {
                    exprType = isNullable ? ColumnMapper.ExprType.STRING : ColumnMapper.ExprType.NON_NULL_STRING;
                    break;
                }
                default: {
                    ColumnMapper.ExprType exprType5 = exprType = isNullable ? ColumnMapper.ExprType.UNKNOWN : ColumnMapper.ExprType.NON_NULL_UNKNOWN;
                }
            }
            if (exprType == ColumnMapper.ExprType.UNKNOWN || exprType == ColumnMapper.ExprType.NON_NULL_UNKNOWN) {
                logger.info((Object)("Unknown SQL type: " + String.valueOf((Object)exprType) + " sqlType=" + sqlType + " sqlTypeName=" + sqlTypeName));
            }
            colMapping.addColumn(columnName, exprType);
            if ((sqlType == 16 || sqlType == -7) && (dialect instanceof PostgreSQLDialect || dialect instanceof RedshiftSQLDialect || dialect instanceof SnowflakeSQLDialect)) {
                colMapping.map(columnName, new BoolToVarcharConverter());
            }
            if (!(sqlType != 91 && !"date".equalsIgnoreCase(sqlTypeName) || exprType.type != ColumnMapper.BaseType.DATE || timezoneShift != null && timezoneShift instanceof TimezoneShifterNTZ)) {
                colMapping.map(columnName, new DateToTimestamp(dialect));
            }
            if (datetimeToTimestamp != null) {
                colMapping.map(columnName, datetimeToTimestamp);
            }
            if (timezoneShift == null) continue;
            colMapping.map(columnName, timezoneShift);
        }
        return colMapping;
    }

    private static class TimezoneShifterNTZ
    extends TimezoneShifter {
        public TimezoneShifterNTZ(SQLDialect dialect, String dbTimezoneId) {
            super(dialect, dbTimezoneId);
        }

        @Override
        public ColumnMapper.TypedExpr compute(ColumnMapper.TypedExpr tv) {
            return new ColumnMapper.TypedExpr(this.dialect.applyOperator(QueryUtils.OperatorType.FROM_TIMEZONE_NTZ, new QueryAst.InlineExpr(tv.expr), new QueryAst.ConstExpr(this.dbTimezoneId)), tv.type);
        }
    }

    private static class TimezoneShifter
    implements ColumnMapper.ValueComputer {
        protected final String dbTimezoneId;
        protected final SQLDialect dialect;

        public TimezoneShifter(SQLDialect dialect, String dbTimezoneId) {
            this.dialect = dialect;
            this.dbTimezoneId = dbTimezoneId;
        }

        @Override
        public ColumnMapper.TypedExpr compute(ColumnMapper.TypedExpr tv) {
            return new ColumnMapper.TypedExpr(this.dialect.applyOperator(QueryUtils.OperatorType.FROM_TIMEZONE, new QueryAst.InlineExpr(tv.expr), new QueryAst.ConstExpr(this.dbTimezoneId)), tv.type);
        }
    }

    public static class DatetimeToTimestamp
    implements ColumnMapper.ValueComputer {
        private final SQLDialect dialect;

        public DatetimeToTimestamp(SQLDialect dialect) {
            this.dialect = dialect;
        }

        @Override
        public ColumnMapper.TypedExpr compute(ColumnMapper.TypedExpr tv) {
            return new ColumnMapper.TypedExpr(this.dialect.applyOperator(QueryUtils.OperatorType.CAST, new QueryAst.InlineExpr(tv.expr).withExprType(Type.DATETIMENOTZ), new QueryAst.ConstExpr(Type.DATE)), tv.type);
        }
    }

    private static class BoolToVarcharConverter
    implements ColumnMapper.ValueComputer {
        private BoolToVarcharConverter() {
        }

        @Override
        public ColumnMapper.TypedExpr compute(ColumnMapper.TypedExpr tv) {
            return new ColumnMapper.TypedExpr("case when (" + tv.expr + ") is null then null else case when (" + tv.expr + ") then 'true' else 'false' end end", ColumnMapper.ExprType.STRING);
        }
    }

    public static class DateToTimestamp
    implements ColumnMapper.ValueComputer {
        private final SQLDialect dialect;

        public DateToTimestamp(SQLDialect dialect) {
            this.dialect = dialect;
        }

        @Override
        public ColumnMapper.TypedExpr compute(ColumnMapper.TypedExpr tv) {
            return new ColumnMapper.TypedExpr(this.dialect.applyOperator(QueryUtils.OperatorType.CAST, new QueryAst.InlineExpr(tv.expr).withExprType(Type.DATEONLY), new QueryAst.ConstExpr(Type.DATE)), tv.type);
        }
    }
}

