/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunLocalFilesHelper;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Supplier;
import org.apache.log4j.Logger;

public class RemoteRunEnvHelper {
    public static final String ENV_DEF_FILE_NAME = "remote-run-env-def.json";
    private static RemoteRunEnvDef currentEnv = null;
    private static Logger logger = Logger.getLogger((String)"dku.remoterun.envhelper");

    private static RemoteRunEnvDef fetchEnvDef() {
        DSSConnection.registerAdapter();
        return RemoteRunLocalFilesHelper.readResourceOrFileAsObject(ENV_DEF_FILE_NAME, RemoteRunEnvDef.class, new Supplier<RemoteRunEnvDef>(){

            public RemoteRunEnvDef get() {
                logger.info((Object)" > No env def file found, creating default env def");
                RemoteRunEnvDef envResource = new RemoteRunEnvDef();
                envResource.runsRemotely = false;
                envResource.env.putAll(DKUtils.getEnvironment());
                return envResource;
            }
        });
    }

    public static void killEnv() {
        logger.info((Object)"Kill ENV");
        currentEnv = null;
    }

    static RemoteRunEnvDef getEnvDefNoFetch() {
        return currentEnv;
    }

    public static RemoteRunEnvDef getEnvDef() {
        if (currentEnv == null) {
            logger.debug((Object)"Fetching remote run env def");
            currentEnv = RemoteRunEnvHelper.fetchEnvDef();
        }
        return currentEnv;
    }

    public static String getEnv(String key) {
        return RemoteRunEnvHelper.getEnvDef().env.get(key);
    }
}

