/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.resourceusage;

import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageCompleteEvent;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageStartEvent;
import com.dataiku.dip.resourceusage.ComputeResourceUsageUpdateEvent;
import com.dataiku.dip.resourceusage.k8s.KubernetesClusterUsageStatus;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class AbstractJEKComputeResourceUsageReportingService
implements ComputeResourceUsageReportingService {
    protected ExecutorService es = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("usage-reporting-queue-%d").build());
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.cru.reporting.jek.abstract");

    protected abstract void publishPubSubEvent(DSSEvent var1);

    public void reportStart(ComputeResourceUsage usage) {
        this.publishPubSubEvent((DSSEvent)new ComputeResourceUsageStartEvent(usage));
    }

    public void reportUpdate(ComputeResourceUsage usage) {
        this.publishPubSubEvent((DSSEvent)new ComputeResourceUsageUpdateEvent(usage));
    }

    public void reportComplete(ComputeResourceUsage usage) {
        this.publishPubSubEvent((DSSEvent)new ComputeResourceUsageCompleteEvent(usage));
    }

    public void reportK8SClusterStatus(KubernetesClusterUsageStatus status) {
        throw new Error("should not be called in a JEK");
    }

    protected void shutdown() {
        this.es.shutdown();
        try {
            if (!this.es.awaitTermination(1L, TimeUnit.MINUTES)) {
                logger.warn((Object)"CRU Reporting Service has terminated in a timeout!!");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn((Object)"Interrupted while waiting on terminating CRU Reporting Service", (Throwable)e);
        }
    }
}

