/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.sanitycheck.detectors.ExecutionException;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
class DockerImageInformation {
    DockerImageInformation() {
    }

    Optional<Instant> getCreationDate(String imageId) throws ExecutionException {
        ProcessBuilder pb = new ProcessBuilder("docker", "image", "inspect", "--format", "{{.Created}}", imageId);
        try {
            byte[] outputArray = DKUtils.execAndGetOutput((ProcessBuilder)pb);
            if (outputArray.length == 0) {
                throw new ExecutionException("Execution output is empty");
            }
            String outputString = new String(outputArray, StandardCharsets.UTF_8);
            return Optional.of(Instant.parse(outputString.trim()));
        }
        catch (DateTimeParseException e) {
            throw new ExecutionException("Unexpected output: " + e.getParsedString());
        }
        catch (ProcessDiedException e) {
            if (e.getExitCode() == 1) {
                return Optional.empty();
            }
            throw new ExecutionException(e);
        }
        catch (IOException | InterruptedException e) {
            throw new ExecutionException(e);
        }
    }

    Optional<String> getDssVersion(String imageId) throws ExecutionException {
        ProcessBuilder pb = new ProcessBuilder("docker", "run", "-t", "--entrypoint", "/bin/cat", imageId, "/opt/dataiku/dss-version.json");
        try {
            byte[] outputArray = DKUtils.execAndGetOutput((ProcessBuilder)pb);
            if (outputArray.length == 0) {
                throw new ExecutionException("Execution output is empty");
            }
            String outputString = new String(outputArray, StandardCharsets.UTF_8);
            return Optional.ofNullable(((DKUApp.DSSVersion)JSON.parse((String)outputString, DKUApp.DSSVersion.class)).product_version);
        }
        catch (JsonSyntaxException e) {
            throw new ExecutionException("Parse exception: " + e.getMessage());
        }
        catch (ProcessDiedException e) {
            if (e.getExitCode() == 125) {
                return Optional.empty();
            }
            throw new ExecutionException(e);
        }
        catch (IOException | InterruptedException e) {
            throw new ExecutionException(e);
        }
    }
}

