/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler;

import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedIntegrationChannelsDAO
implements IntegrationChannelsDAO {
    public RelFile getMessagingChannelsFile() {
        return RelFile.global((String)"messaging-channels.json");
    }

    private List<IntegrationChannel> read(TransactionRef t) throws IOException {
        RelFile channelsFile = this.getMessagingChannelsFile();
        if (!t.exists(channelsFile)) {
            return Lists.newArrayList();
        }
        return ((ChannelsFile)t.readObject((RelFile)channelsFile, ChannelsFile.class)).channels;
    }

    @Override
    public void save(List<IntegrationChannel> data) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile channelsFile = this.getMessagingChannelsFile();
        ChannelsFile channels = new ChannelsFile();
        if (t.exists(channelsFile)) {
            channels = (ChannelsFile)t.readObject(channelsFile, ChannelsFile.class);
        }
        if (data == null) {
            data = channels.channels;
        }
        channels.channels = data;
        t.writeObject(channelsFile, (Object)channels);
    }

    @Override
    public IntegrationChannel getOrNull(String channelId) throws IOException {
        if (channelId == null) {
            return null;
        }
        TransactionRef t = TransactionContext.retrieveRead();
        List<IntegrationChannel> channels = this.read(t);
        for (IntegrationChannel channel : channels) {
            if (!channel.getId().equals(channelId)) continue;
            return channel;
        }
        return null;
    }

    @Override
    public IntegrationChannel getMandatory(String channelId) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)channelId), (Object)"Channel id is not specified");
        IntegrationChannel channel = this.getOrNull(channelId);
        if (channel == null) {
            throw new NotFoundException("The integration channel does not exist: " + channelId);
        }
        return channel;
    }

    @Override
    public List<IntegrationChannel> list() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return this.read(t);
    }

    public static class ChannelsFile {
        public List<IntegrationChannel> channels = Lists.newArrayList();
    }
}

