/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterRegistry;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.custom.UnavailablePluginItemInfo;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StartClusterStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return StartClusterStepParams.class;
        }

        @Override
        public String getType() {
            return "start_cluster";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new StartClusterStepRunner(step.getParamsAs(StartClusterStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "Start cluster";
        }

        @Override
        public String buildId(Step step) {
            StartClusterStepParams stepParams = step.getParamsAs(StartClusterStepParams.class);
            return "start_cluster" + (String)(stepParams != null ? "_" + stepParams.clusterId : "");
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return StartClusterStepRunner.doCheckClusterRunnable(sc, step, pluginUsagesInspector);
        }
    };
    @Autowired
    private ClustersService clustersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private IPermissionsService permissionsService;
    private final StartClusterStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.startcluster");

    public static StepMeta.UnavailableStepInfo doCheckClusterRunnable(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
        StartClusterStepParams stepParams = (StartClusterStepParams)step.params;
        if (StringUtils.isBlank((String)stepParams.clusterId)) {
            return null;
        }
        String clusterId = pluginUsagesInspector.variablesService.getForProject(sc.getProjectKey()).expand(stepParams.clusterId);
        try {
            Cluster cluster = pluginUsagesInspector.clustersService.getMandatoryUnsafe(clusterId);
            try {
                ClusterRegistry.getMeta(cluster.type);
            }
            catch (UnavailableDSSObjectException ue) {
                logger.error((Object)"Unavailable DSS object", (Throwable)((Object)ue));
                return new StepMeta.UnavailableStepInfo(step, UnavailablePluginItemInfo.fromObjectTypeAndType(null, cluster.type));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while checking if step " + step.id + " is runnable"), (Throwable)e);
        }
        return null;
    }

    public StartClusterStepRunner(StartClusterStepParams params) {
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        Cluster cluster;
        if (StringUtils.isBlank((String)this.params.clusterId)) {
            throw new Exception("Missing cluster id");
        }
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        logger.info((Object)("Start cluster " + this.params.clusterId));
        try (Transaction t = this.transactionService.beginRead();){
            String clusterId = this.variablesService.getForProject(stepRun.getScenarioRun().getScenario().getProjectKey()).expand(this.params.clusterId);
            logger.info((Object)("Resolved cluster id " + clusterId));
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.UPDATE);
            cluster = this.clustersService.getMandatoryUnsafe(clusterId);
        }
        logger.info((Object)("Starting cluster " + cluster.id));
        ReportTargetItem.ClusterItem clusterItem = new ReportTargetItem.ClusterItem(cluster.id);
        AnyLoc clusterLoc = new AnyLoc("__DKU_INSTANCE_CLUSTERS__", cluster.id);
        ReportItem.StartedCluster reportItem = (ReportItem.StartedCluster)new ReportItem.StartedCluster(clusterItem).withStart(DateTime.now().getMillis());
        try {
            FutureResponse fr;
            try (Transaction t = this.transactionService.beginRead();){
                fr = this.clustersService.start(authCtx, stepRun.getScenarioRun().getScenario().getProjectKey(), cluster);
            }
            fr = this.futureService.waitForFinalResponse(fr);
            logger.info((Object)"Cluster started");
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
        }
        catch (Throwable ex) {
            logger.warn((Object)("Failed to start cluster " + cluster.id), ex);
            reportItem.withThrown(ex).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            throw ex;
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(clusterLoc, null, null, stepRun.getScenarioRun(), stepRun, reportItem);
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    public static class StartClusterStepParams
    implements StepParams {
        public String clusterId;
    }
}

