/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dataflow.streaming.ContinuousActivitiesManager;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class StopContinuousActivityStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public String getType() {
            return "stop_continuous_activity";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return StopContinuousActivityParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new StopContinuousActivityStepRunner(scenario, step, step.getParamsAs(StopContinuousActivityParams.class));
        }

        @Override
        public String buildName(Step step) {
            StopContinuousActivityParams params = step.getParamsAs(StopContinuousActivityParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("Stop continuous activities");
            if (params != null) {
                for (String stopped : params.continuousActivityIds) {
                    sb.append(" ");
                    sb.append(stopped);
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            StopContinuousActivityParams params = step.getParamsAs(StopContinuousActivityParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("stop_cak");
            if (params != null) {
                sb.append("_");
                for (String stopped : params.continuousActivityIds) {
                    sb.append("_");
                    sb.append(stopped);
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private ContinuousActivitiesManager continuousActivitiesManager;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private final StopContinuousActivityParams params;
    private final Step step;
    private final Scenario scenario;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.stopcak");

    public StopContinuousActivityStepRunner(Scenario scenario, Step step, StopContinuousActivityParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Stop step " + this.step.name));
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        String projectKey = this.scenario.getProjectKey();
        Exception thrown = null;
        for (String item : this.params.continuousActivityIds) {
            ReportTargetItem.ContinuousActivityItem caItem = new ReportTargetItem.ContinuousActivityItem(this.scenario.getProjectKey(), item);
            logger.info((Object)("Will stop " + item));
            ReportItem stopItem = new ReportItem.StoppedContinuousActivity(caItem).withStart(DateTime.now().getMillis());
            try {
                this.continuousActivitiesManager.stop_NT(authCtx, projectKey, item);
                stopItem.withOutcome(ReportItem.Outcome.SUCCESS);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to stop CAK", (Throwable)e);
                thrown = e;
                stopItem.withOutcome(ReportItem.Outcome.FAILED);
            }
            finally {
                stopItem.withEnd(DateTime.now().getMillis());
            }
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(caItem.projectKey, caItem.continuousActivityId), null, null, stepRun.getScenarioRun(), stepRun, stopItem);
        }
        if (thrown != null) {
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED).withThrown(thrown);
        } else {
            stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        }
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class StopContinuousActivityParams
    extends NonFatalStepParams
    implements StepParams {
        public List<String> continuousActivityIds = Lists.newArrayList();
    }
}

