/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.trust;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.digest.DigestUtils;

public class FingerprintComputer {
    private final Cache<RelFile, Fingerprint> cache;

    public FingerprintComputer(Cache<RelFile, Fingerprint> cache) {
        this.cache = cache;
    }

    public byte[] getFingerprint(ReadOnlyFS fs, List<RelFile> files) throws IOException {
        MessageDigest digester = DigestUtils.getSha256Digest();
        TreeSet<RelFile> sortedFiles = new TreeSet<RelFile>(files);
        for (RelFile file : sortedFiles) {
            digester.update(this.getCacheEntry(file).getOrComputeFingerprint(fs));
        }
        return digester.digest();
    }

    public byte[] getFingerprint(ReadOnlyFS fs, RelFile file) throws IOException {
        return this.getFingerprint(fs, (List<RelFile>)ImmutableList.of((Object)file));
    }

    private Fingerprint getCacheEntry(RelFile file) {
        try {
            return (Fingerprint)this.cache.get((Object)file, () -> new Fingerprint(file));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Impossible", e);
        }
    }

    public class Fingerprint {
        final RelFile file;
        byte[] cachedFingerprint;
        long lastModified;
        long length;
        RelFileAttribute.FileType type;

        private Fingerprint(RelFile file) {
            this.file = file;
        }

        private void computeDirectory(ReadOnlyFS fs) throws IOException {
            MessageDigest digest = DigestUtils.getSha256Digest();
            digest.update((byte)68);
            List children = fs.listFiles(this.file);
            for (RelFile child : children) {
                digest.update(DigestUtils.sha256((String)child.getLeafName()));
                digest.update(FingerprintComputer.this.getCacheEntry(child).getOrComputeFingerprint(fs));
            }
            this.type = RelFileAttribute.FileType.DIRECTORY;
            this.lastModified = -1L;
            this.length = -1L;
            this.cachedFingerprint = digest.digest();
        }

        private void computeFile(ReadOnlyFS fs, RelFileAttribute attrs) throws IOException {
            MessageDigest digest = DigestUtils.getSha256Digest();
            digest.update((byte)70);
            try (RelFileInputStream stream = fs.readStream(this.file);){
                DigestUtils.updateDigest((MessageDigest)digest, (InputStream)stream);
            }
            this.type = RelFileAttribute.FileType.FILE;
            this.lastModified = attrs.getLastModified();
            this.length = attrs.getLength();
            this.cachedFingerprint = digest.digest();
        }

        private void computeMissing() {
            this.type = null;
            this.lastModified = -1L;
            this.length = -1L;
            this.cachedFingerprint = DigestUtils.sha256((String)"?");
        }

        private void compute(ReadOnlyFS fs) throws IOException {
            RelFileAttribute attrs = fs.getAttributes(this.file);
            if (attrs != null && attrs.getFileType() == RelFileAttribute.FileType.DIRECTORY) {
                this.computeDirectory(fs);
            } else if (attrs != null && attrs.getFileType() == RelFileAttribute.FileType.FILE) {
                this.computeFile(fs, attrs);
            } else {
                this.computeMissing();
            }
        }

        private boolean shouldRecomputeFingerprint(ReadOnlyFS fs) throws IOException {
            if (this.cachedFingerprint == null) {
                return true;
            }
            if (this.type != RelFileAttribute.FileType.FILE) {
                return true;
            }
            RelFileAttribute attrs = fs.getAttributes(this.file);
            if (attrs == null) {
                return true;
            }
            return attrs.getLastModified() != this.lastModified || attrs.getLength() != this.length;
        }

        private byte[] getOrComputeFingerprint(ReadOnlyFS fs) throws IOException {
            if (this.shouldRecomputeFingerprint(fs)) {
                this.compute(fs);
            }
            return this.cachedFingerprint;
        }
    }
}

