/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.massimport.HiveImportabilityChecker;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.connections.ConnectionsImportService;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlationImportService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.import.alation");
    private Map<String, AlationOpenRequest> pendingOpenRequests = new HashMap<String, AlationOpenRequest>();

    public ConnectionsImportService.TableImportCandidates getTableImportCandidatesFromAlationSelection_NT(AuthCtx authCtx, String targetProjectKey, AlationCatalogSelection catalogSelection) throws Exception {
        Validate.notNull((Object)catalogSelection.dataSource);
        Validate.notNull((Object)catalogSelection.dataSource.catalogUrl);
        Validate.notNull((Object)catalogSelection.qualifiedName);
        ConnectionsImportService.TableImportCandidates ret = new ConnectionsImportService.TableImportCandidates();
        if ("hive2".equals(catalogSelection.dataSource.type)) {
            StringTransmogrifier st2 = new StringTransmogrifier();
            ArrayList conns = Lists.newArrayList();
            try (Transaction t = this.transactionService.beginRead();){
                conns.addAll(this.connectionsService.listUsableHdfsConnectionsUnsafe(authCtx, null));
                if (conns.size() == 0) {
                    throw new IllegalArgumentException("No HDFS connection to import Hive tables into");
                }
                for (SerializedDataset sd : this.datasetsDAO.listUnsafe(targetProjectKey)) {
                    st2.addAlreadyTransmogrified(sd.name);
                }
            }
            String[] chunks = StringUtils.split((String)catalogSelection.qualifiedName, (String)".");
            String database = chunks[0];
            String table = chunks[1];
            String expectedDatasetName = st2.transmogrify(table);
            HiveImportabilityChecker.HiveTableImportCandidate htic = new HiveImportabilityChecker.HiveTableImportCandidate();
            try {
                logger.info((Object)("Importing " + database + "." + table + " into " + targetProjectKey));
                String clusterId = new ClusterSelector().getClusterForProject(targetProjectKey, Cluster.ClusterArchitecture.HADOOP);
                TableSchema tableSchema = this.metastoreInspectionService.newInspector(authCtx, targetProjectKey).getTableSchema(clusterId, database, table, null, authCtx, targetProjectKey);
                HiveImportabilityChecker checker = new HiveImportabilityChecker();
                htic = checker.computeTableImportCandidate(targetProjectKey, clusterId, authCtx, database, table, null, tableSchema, st2, conns, new HashMap<String, SQLUtils.SQLTable>());
                if (!htic.messages.anyFatal()) {
                    htic.newDataset.projectKey = targetProjectKey;
                    if (StringUtils.isNotBlank((String)expectedDatasetName)) {
                        htic.newDataset.name = expectedDatasetName;
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Import failed", t);
                htic.messages.withFatal((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)t));
            }
            ret.hiveImportCandidates.add(htic);
        } else {
            AbstractSQLConnection sqlConnection;
            StringTransmogrifier st3 = new StringTransmogrifier();
            try (Transaction t = this.transactionService.beginRead();){
                DSSConnection connection = null;
                for (DSSConnection conn : this.connectionsDAO.listUnsafe().values()) {
                    if (conn.associatedAlationDatasource == null || !conn.associatedAlationDatasource.equals(catalogSelection.dataSource.catalogUrl)) continue;
                    connection = conn;
                    break;
                }
                if (connection == null) {
                    throw ErrorContext.iaef((String)"Could not find a DSS connection matching Alation source %s", (Object)catalogSelection.dataSource.catalogUrl, (Object[])new Object[0]);
                }
                if (!(connection instanceof AbstractSQLConnection)) {
                    throw ErrorContext.iaef((String)"Expected SQL connection type, got %s", (Object)connection.getType(), (Object[])new Object[0]);
                }
                if (!connection.isFreelyUsableBy(authCtx)) {
                    throw ErrorContext.iaef((String)"Cannot use connection %s", (Object)connection.name, (Object[])new Object[0]);
                }
                sqlConnection = (AbstractSQLConnection)connection;
                for (SerializedDataset d : this.datasetsDAO.listUnsafe(targetProjectKey)) {
                    st3.addAlreadyTransmogrified(d.name);
                }
            }
            String[] chunks = StringUtils.split((String)catalogSelection.qualifiedName, (String)".");
            ConnectionsImportService.SQLTableImportCandidate mic = new ConnectionsImportService.SQLTableImportCandidate();
            mic.projectKey = targetProjectKey;
            mic.connectionName = sqlConnection.name;
            if (chunks.length == 2) {
                mic.schema = chunks[0];
                mic.table = chunks[1];
            } else if (chunks.length == 3) {
                mic.schema = chunks[1];
                mic.table = chunks[2];
            }
            mic.datasetName = st3.transmogrify(mic.table);
            ret.sqlImportCandidates.add(mic);
        }
        return ret;
    }

    public void registerAlationOpener_NT(String alationAPIToken) throws IOException, CodedException {
        block11: {
            GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            String alationURL = gs.alationSettings.alationURL;
            if (alationURL == null) {
                throw new IllegalArgumentException("No Alation URL");
            }
            String openerName = "Dataiku" + (String)(StringUtils.isBlank((String)gs.nodeName) ? "" : " - " + gs.nodeName);
            String encodedOpenerName = openerName.replace(" ", "%20");
            JsonObject integrationPost = new JsonObject();
            integrationPost.addProperty("endpoint", gs.studioExternalUrl + "/dip/api/connections/init-import-from-alation-open");
            integrationPost.addProperty("name", openerName);
            JsonArray sourceTypes = new JsonArray();
            for (String s : new String[]{"bigquery", "greenplum", "hive2", "mysql", "netezza", "oracle", "postgresql", "redshift", "snowflake", "sqlserver", "teradata", "vertica"}) {
                sourceTypes.add((JsonElement)new JsonPrimitive(s));
            }
            integrationPost.add("accept_data_source_types", (JsonElement)sourceTypes);
            JsonArray objectTypes = new JsonArray();
            objectTypes.add((JsonElement)new JsonPrimitive("table"));
            integrationPost.add("accept_object_types", (JsonElement)objectTypes);
            HttpPost post = new HttpPost(alationURL + "/integration/catalog_chooser/register_opener/");
            post.addHeader("Token", alationAPIToken);
            post.setEntity(JSON.toHttpEntity((Object)integrationPost));
            DefaultHttpClient client = new DefaultHttpClient();
            client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
            try {
                HttpDelete delete = new HttpDelete(alationURL + "/integration/catalog_chooser/register_opener/" + encodedOpenerName + "/");
                logger.info((Object)("Executing delete on " + String.valueOf(delete)));
                CloseableHttpResponse hresp = client.execute((HttpUriRequest)delete);
                EntityUtils.consume((HttpEntity)hresp.getEntity());
            }
            catch (Exception e) {
                logger.warn((Object)"Could not delete previous opener", (Throwable)e);
            }
            try {
                logger.info((Object)"Sending registration call");
                CloseableHttpResponse postResp = client.execute((HttpUriRequest)post);
                int code = postResp.getStatusLine().getStatusCode();
                if (code == 204) {
                    logger.info((Object)"Success");
                    break block11;
                }
                if (code == 200 || code == 201) {
                    String data = IOUtils.toString((InputStream)postResp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    logger.info((Object)("Success " + data));
                    break block11;
                }
                String data = IOUtils.toString((InputStream)postResp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                logger.error((Object)("Failed: " + code + ": " + data));
                throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_ALATION_REGISTRATION_FAILED, "Registration call failed (HTTP status " + code + ", response:  " + data);
            }
            catch (IOException e) {
                throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_ALATION_REGISTRATION_FAILED, "Registration call failed", (Throwable)e);
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
    }

    public String registerNewOpenRequest(AlationOpenRequest openRequest) {
        logger.info((Object)("Starting Alation import-from-open with data: " + JSON.json((Object)openRequest)));
        String requestId = SecretKeyGenerator.generate((int)24);
        this.pendingOpenRequests.put(requestId, openRequest);
        return requestId;
    }

    public AlationOpenRequest getEnrichedOpenRequest(AuthCtx authCtx, String alationOpenId) throws NotFoundException, IOException, DKUSecurityException {
        AlationOpenRequest openRequest = this.pendingOpenRequests.get(alationOpenId);
        if (openRequest == null) {
            throw new NotFoundException("Unknown Alation open key");
        }
        openRequest = (AlationOpenRequest)JSON.deepCopy((Object)openRequest);
        logger.info((Object)("Open request is " + JSON.json((Object)openRequest)));
        if ("hive2".equals(openRequest.catalogSelection.dataSource.type)) {
            String[] chunks = StringUtils.split((String)openRequest.catalogSelection.qualifiedName, (String)".");
            String database = chunks[0];
            String table = chunks[1];
            openRequest.workflowType = AlationOpenRequest.AlationOpenWorkflowType.HIVE;
            for (String projectKey : this.projectsService.listKeys()) {
                if (!this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                AlationOpenRequest.TargetProject tp = new AlationOpenRequest.TargetProject();
                tp.projectKey = projectKey;
                tp.name = this.projectsService.getMandatoryUnsafe((String)projectKey).name;
                openRequest.possibleTargetProjects.add(tp);
                for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                    SQLUtils.SQLTable tableRef;
                    if (!DatasetInspector.canHiveTable(sd) || (tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(Dataset.fromSerialized(sd))).getSchemaNullIfBlank() == null || !tableRef.getSchemaNullIfBlank().equals(database) || tableRef.getTable() == null || !tableRef.getTable().equals(table)) continue;
                    AlationOpenRequest.ExistingDatasetInfo edi = new AlationOpenRequest.ExistingDatasetInfo();
                    edi.projectKey = projectKey;
                    edi.projectName = tp.name;
                    edi.datasetName = sd.name;
                    edi.datasetType = sd.type;
                    openRequest.existingDatasets.add(edi);
                }
            }
        } else {
            openRequest.workflowType = AlationOpenRequest.AlationOpenWorkflowType.SQL;
            DSSConnection connection = null;
            for (DSSConnection conn : this.connectionsDAO.listUnsafe().values()) {
                if (conn.associatedAlationDatasource == null || !conn.associatedAlationDatasource.equals(openRequest.catalogSelection.dataSource.catalogUrl)) continue;
                connection = conn;
                break;
            }
            if (connection == null) {
                throw ErrorContext.iaef((String)"Could not find a DSS connection matching Alation source %s", (Object)openRequest.catalogSelection.dataSource.catalogUrl, (Object[])new Object[0]);
            }
            if (!(connection instanceof AbstractSQLConnection)) {
                throw ErrorContext.iaef((String)"Expected SQL connection type, got %s", (Object)connection.getType(), (Object[])new Object[0]);
            }
            if (!connection.isFreelyUsableBy(authCtx)) {
                throw ErrorContext.iaef((String)"Cannot use connection %s", (Object)connection.name, (Object[])new Object[0]);
            }
            DSSConnection sqlConnection = connection;
            String[] chunks = StringUtils.split((String)openRequest.catalogSelection.qualifiedName, (String)".");
            String schema = chunks[0];
            String table = chunks[1];
            for (String projectKey : this.projectsService.listKeys()) {
                if (!this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                AlationOpenRequest.TargetProject tp = new AlationOpenRequest.TargetProject();
                tp.projectKey = projectKey;
                tp.name = this.projectsService.getMandatoryUnsafe((String)projectKey).name;
                openRequest.possibleTargetProjects.add(tp);
                for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                    if (!sd.type.equals(sqlConnection.type)) continue;
                    AbstractSQLDatasetHandler.AbstractSQLConfig asc = sd.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
                    if (!"table".equals(asc.mode) || !table.equals(asc.table) || !schema.equals(asc.schema)) continue;
                    AlationOpenRequest.ExistingDatasetInfo edi = new AlationOpenRequest.ExistingDatasetInfo();
                    edi.projectKey = projectKey;
                    edi.projectName = tp.name;
                    edi.datasetName = sd.name;
                    edi.datasetType = sd.type;
                    openRequest.existingDatasets.add(edi);
                }
            }
        }
        return openRequest;
    }

    static class AlationCatalogSelection {
        String qualifiedName;
        AlationSemanticMetadata semanticMetadata;
        public AlationCatalogDataSource dataSource;

        AlationCatalogSelection() {
        }

        static class AlationCatalogDataSource {
            String catalogUrl;
            String type;

            AlationCatalogDataSource() {
            }
        }

        static class AlationSemanticMetadata {
            String description;
            String title;

            AlationSemanticMetadata() {
            }
        }
    }

    static class AlationOpenRequest {
        AlationOpenWorkflowType workflowType;
        AlationCatalogSelection catalogSelection;
        List<ExistingDatasetInfo> existingDatasets = new ArrayList<ExistingDatasetInfo>();
        List<TargetProject> possibleTargetProjects = new ArrayList<TargetProject>();

        AlationOpenRequest() {
        }

        static enum AlationOpenWorkflowType {
            SQL,
            HIVE;

        }

        static class TargetProject {
            String projectKey;
            String name;

            TargetProject() {
            }
        }

        static class ExistingDatasetInfo {
            String projectKey;
            String projectName;
            String datasetName;
            String datasetType;

            ExistingDatasetInfo() {
            }
        }
    }
}

