/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.discussions.DiscussionsCacheService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.InterestChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectsPermissionsChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.TimelineItemEvent;
import com.dataiku.dip.server.notifications.backend.UserChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceDeletedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.j2ts.annotations.UIModel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InterestsService {
    @Autowired
    private InterestsInternalDB dao;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private EnrichmentService enrichmentService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private IPermissionsService permService;
    @Autowired
    private DiscussionsCacheService discussionsCacheService;
    @Autowired
    private WorkspacesService workspacesService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.interest");

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init interests service");
        this.pubSub.subscribe("timeline-item", (DSSEventListener)new DSSEventListener<TimelineItemEvent>(){

            public void on(TimelineItemEvent evt) {
                if (!evt.item.action.isDeletion() && !ITaggingService.TaggableType.DATA_COLLECTION.equals((Object)evt.item.objectType)) {
                    InterestsService.this.addWatchIfNotExplicit_NT(evt.item.user, evt.item.objectType, evt.item.projectKey, evt.item.objectId, evt.item.workspaceKey);
                }
            }
        });
        this.pubSub.subscribe("object-change", (DSSEventListener)new DSSEventListener<TaggableObjectChangedEvent>(){

            public void on(TaggableObjectChangedEvent evt) {
                try {
                    if (evt.action == TaggableObjectChangedEvent.ActionType.PROJECT_DELETE) {
                        InterestsService.this.dao.deleteForProject(evt.projectKey);
                    } else if (evt.action == TaggableObjectChangedEvent.ActionType.RECIPE_RENAME) {
                        InterestsService.this.dao.changeObjectId(evt.objectType, evt.projectKey, evt.objectId, evt.newObjectId);
                    } else if (evt.action.isDeletion()) {
                        InterestsService.this.dao.deleteObject(evt.objectType, evt.projectKey, evt.objectId);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to delete/rename object from interests db", (Throwable)e);
                }
            }
        });
        this.pubSub.subscribe("workspace-deleted", (DSSEventListener)new DSSEventListener<WorkspaceDeletedEvent>(){

            public void on(WorkspaceDeletedEvent evt) {
                try {
                    InterestsService.this.dao.deleteForWorkspace(evt.workspaceKey);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to delete object from interests db", (Throwable)e);
                }
            }
        });
        this.pubSub.subscribe("workspace-item-changed", (DSSEventListener)new DSSEventListener<WorkspaceObjectChangedEvent>(){

            public void on(WorkspaceObjectChangedEvent evt) {
                try {
                    if (evt.action == WorkspaceObjectChangedEvent.ActionCategory.REMOVED || evt.action == WorkspaceObjectChangedEvent.ActionCategory.DELETED) {
                        InterestsService.this.dao.deleteObjectFromWorkspace(evt.objectType, evt.objectProjectKey, evt.objectId, evt.workspaceKey);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to delete object from interests db", (Throwable)e);
                }
            }
        });
        this.pubSub.subscribe("user-edited", (DSSEventListener)new DSSEventListener<UserChangedEvent>(){

            public void on(UserChangedEvent evt) {
                if (evt.action == UserChangedEvent.ActionType.DELETED) {
                    try {
                        InterestsService.this.dao.deleteUser(evt.getUserLogin());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to remove user from interests db", (Throwable)e);
                    }
                }
            }
        });
        this.pubSub.subscribe("project-permissions-changed", (DSSEventListener)new DSSEventListener<ProjectsPermissionsChangedEvent>(){

            public void on(ProjectsPermissionsChangedEvent evt) {
                HashMap<String, List<String>> changes = new HashMap<String, List<String>>();
                int count = 0;
                Map<String, Set<String>> projectKeysByUser = evt.diff.getProjectKeysByUser();
                for (String user : projectKeysByUser.keySet()) {
                    ArrayList<String> projectsWhereUserIsNotAnalystAnymore = new ArrayList<String>();
                    try (Transaction t = InterestsService.this.transactionService.beginRead();){
                        AuthCtx u = null;
                        try {
                            u = InterestsService.this.authCtxCreationService.createOrNull(user);
                        }
                        catch (Exception e) {
                            logger.errorV((Throwable)e, "Failed to create auth ctx for user %s", new Object[]{user});
                        }
                        for (String projectKey : projectKeysByUser.get(user)) {
                            boolean isStillAnalyst = false;
                            try {
                                if (u != null) {
                                    isStillAnalyst = InterestsService.this.permService.hasProjectPrivilege(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                                }
                            }
                            catch (Exception e) {
                                logger.errorV((Throwable)e, "Failed to get permission for user %s on project %s", new Object[]{user, projectKey});
                            }
                            if (isStillAnalyst) continue;
                            ++count;
                            projectsWhereUserIsNotAnalystAnymore.add(projectKey);
                        }
                    }
                    changes.put(user, projectsWhereUserIsNotAnalystAnymore);
                }
                if (!changes.isEmpty() && count > 0) {
                    logger.info((Object)("Deleting unauthorized interests: " + JSON.json(changes)));
                    try {
                        InterestsService.this.dao.deleteUnauthorized(changes);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to delete unauthorized interests", (Throwable)e);
                    }
                }
            }
        });
        logger.debug((Object)"Done init interests service");
    }

    public Map<String, Map<TaggableObjectsService.TaggableObjectRef, InterestsInternalDB.RawInterest>> getAllWatches() throws Exception {
        return this.dao.getAllWatches();
    }

    public Set<String> getEffectiveWatchingUsers_NT(ITaggingService.TaggableType objectType, String projectKey, String objectId, String ignoredUser, String workspaceKey) {
        try {
            if (ITaggingService.TaggableType.DATA_COLLECTION.equals((Object)objectType)) {
                return new HashSet<String>();
            }
            InterestsInternalDB.WatchersResponse wresp = this.dao.getEffectiveWatchingUsers(objectType, projectKey, objectId, workspaceKey);
            HashSet<String> users = new HashSet<String>(wresp.direct.size() + wresp.deep.size());
            users.addAll(wresp.direct);
            ArrayList<TaggableObjectsService.TaggableObjectRef> dashboardRefs = new ArrayList<TaggableObjectsService.TaggableObjectRef>();
            try (Transaction t = this.transactionService.beginRead();){
                for (String string : wresp.deep) {
                    if (users.contains(string)) continue;
                    try {
                        AuthCtx authCtx = this.authCtxCreationService.createOrNull(string);
                        if (authCtx == null || !this.permService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                        users.add(string);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to get user permissions", (Throwable)e);
                    }
                }
                if (objectType == ITaggingService.TaggableType.INSIGHT) {
                    if (StringUtils.isBlank((String)workspaceKey)) {
                        List<Dashboard> dashboards = this.dashboardsService.getDashboardsUsingInsight(projectKey, objectId);
                        for (Dashboard dashboard : dashboards) {
                            dashboardRefs.add(dashboard.getRef());
                        }
                    } else {
                        Workspace workspace = this.workspacesService.getRawWorkspaceUnsafe(workspaceKey);
                        for (Workspace.WorkspaceObject object : workspace.workspaceObjects) {
                            if (object.reference == null || object.reference.type != ITaggingService.TaggableType.DASHBOARD) continue;
                            dashboardRefs.add(object.reference);
                        }
                    }
                }
            }
            for (TaggableObjectsService.TaggableObjectRef dashboardRef : dashboardRefs) {
                logger.info((Object)("Add users watching dashboard: " + dashboardRef.id + " (" + dashboardRef.projectKey + "." + dashboardRef.workspaceKey + ")"));
                users.addAll(this.getEffectiveWatchingUsers_NT(ITaggingService.TaggableType.DASHBOARD, dashboardRef.projectKey, dashboardRef.id, ignoredUser, dashboardRef.workspaceKey));
            }
            HashSet<String> filteredUsers = new HashSet<String>(users.size());
            for (String string : users) {
                if (string.equals(ignoredUser)) continue;
                filteredUsers.add(string);
            }
            return filteredUsers;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get interested users for " + String.valueOf((Object)objectType) + " " + projectKey + "." + objectId), (Throwable)e);
            return new HashSet<String>();
        }
    }

    public InterestsInternalDB.Interest setWatch_NT(AuthCtx user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey, InterestsInternalDB.Watching watch) throws Exception {
        logger.info((Object)("Watch: " + String.valueOf(user) + " on " + String.valueOf((Object)objectType) + " " + projectKey + "." + objectId + "." + workspaceKey + ": " + String.valueOf((Object)watch)));
        this.dao.setWatch(user.getIdentifier(), objectType, projectKey, objectId, workspaceKey, watch);
        if (watch.enabled()) {
            InterestChangedEvent event = new InterestChangedEvent(user.getIdentifier(), objectType, projectKey, objectId, workspaceKey, true, false);
            try (Transaction t = this.transactionService.beginRead();){
                this.enrichmentService.enrich(event);
            }
            this.pubSub.publish(event);
        }
        return this.dao.getObjectAndUserInterest(user.getIdentifier(), objectType, projectKey, objectId, workspaceKey);
    }

    public InterestsInternalDB.Interest setStar_NT(AuthCtx user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey, boolean star) throws Exception {
        logger.info((Object)("Star: " + String.valueOf(user) + " on " + String.valueOf((Object)objectType) + " " + projectKey + "." + objectId + "." + workspaceKey + ": " + star));
        this.dao.setStar(user.getIdentifier(), objectType, projectKey, objectId, workspaceKey, star);
        if (star) {
            InterestChangedEvent event = new InterestChangedEvent(user.getIdentifier(), objectType, projectKey, objectId, workspaceKey, false, true);
            try (Transaction t = this.transactionService.beginRead();){
                this.enrichmentService.enrich(event);
            }
            this.pubSub.publish(event);
        }
        return this.dao.getObjectAndUserInterest(user.getIdentifier(), objectType, projectKey, objectId, workspaceKey);
    }

    public void setProjectFolderStar_NT(AuthCtx user, String projectFolderId, boolean star) throws Exception {
        logger.info((Object)("Star: " + String.valueOf(user) + " on folder " + projectFolderId + ": " + star));
        this.dao.setNonTaggableTypeStar(user.getIdentifier(), InterestsInternalDB.NonTaggableType.PROJECT_FOLDER, projectFolderId, star);
    }

    public void addWatchIfNotExplicit_NT(String user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey) {
        try {
            InterestsInternalDB.Watching watching = this.dao.getWatching(user, objectType, projectKey, objectId, workspaceKey);
            if (watching == InterestsInternalDB.Watching.INO) {
                this.dao.setWatch(user, objectType, projectKey, objectId, workspaceKey, InterestsInternalDB.Watching.SHALLOW);
                this.discussionsCacheService.watchChanged(user, projectKey, workspaceKey);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to add user interest", (Throwable)e);
        }
    }

    public ProjectFoldersInterestsResponse getProjectFoldersUserInterests(AuthCtx authCtx) {
        ProjectFoldersInterestsResponse ret = new ProjectFoldersInterestsResponse();
        try {
            ret.interests = this.dao.getUserInterestsForProjectFolders(authCtx.getIdentifier());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get user project folders interests", (Throwable)e);
        }
        return ret;
    }

    public InterestsResponse getUserInterests_NT(String user, int offset, TaggableObjectsService.TaggableObjectFilter filter, int limit, boolean starsOnly) {
        InterestsResponse ret = new InterestsResponse();
        try {
            ITaggingService.TaggableType type = filter != null ? filter.taggableType : null;
            String projectKey = filter != null ? filter.projectKey : null;
            String workspaceKey = filter != null ? filter.workspaceKey : null;
            List<InterestsInternalDB.TaggableObjectRefWithInterest> interests = this.dao.getUserInterests(user, limit, offset, type, projectKey, workspaceKey, starsOnly);
            ret.hasMoreResults = interests.size() == limit;
            ret.offset = offset;
            ret.interests = interests;
            ret.pageSize = limit;
            try (Transaction t = this.transactionService.beginRead();){
                for (InterestsInternalDB.TaggableObjectRefWithInterest interest : interests) {
                    this.enrichmentService.enrich(interest);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get user interests", (Throwable)e);
        }
        return ret;
    }

    public List<InterestsInternalDB.TaggableObjectRefWithInterest> getUserInterestsForProject_NT(String user, String projectKey) {
        try {
            return this.dao.getUserInterests(user, Integer.MAX_VALUE, 0, null, projectKey, null, false);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get user interests", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<InterestsInternalDB.TaggableObjectRefWithInterest> getUserInterestsForWorkspace_NT(String user, String workspaceKey) {
        try {
            return this.dao.getUserInterests(user, Integer.MAX_VALUE, 0, null, null, workspaceKey, false);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get user interests", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private String key(InterestsInternalDB.TaggableObjectRefWithInterest object) {
        return this.key(object.objectType, object.projectKey, object.objectId);
    }

    private String key(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        return String.valueOf((Object)objectType) + "$$$" + projectKey + "$$$" + objectId;
    }

    public void enrichListItems(String user, String projectKey, List<? extends TaggableObjectsService.TaggableListItem> heads) {
        if (heads == null || heads.isEmpty()) {
            return;
        }
        try {
            HashMap<String, InterestsInternalDB.TaggableObjectRefWithInterest> interestsMap = new HashMap<String, InterestsInternalDB.TaggableObjectRefWithInterest>();
            ITaggingService.TaggableType type = heads.get(0).getTaggableType();
            for (InterestsInternalDB.TaggableObjectRefWithInterest taggableObjectRefWithInterest : this.dao.getUserInterestsForProjectAndType(user, type, projectKey)) {
                interestsMap.put(this.key(taggableObjectRefWithInterest), taggableObjectRefWithInterest);
            }
            for (TaggableObjectsService.TaggableListItem taggableListItem : heads) {
                String key = this.key(taggableListItem.getTaggableType(), taggableListItem.projectKey, taggableListItem.id);
                if (!interestsMap.containsKey(key)) continue;
                taggableListItem.interest = (InterestsInternalDB.Interest)interestsMap.get(key);
            }
        }
        catch (Exception t) {
            logger.info((Object)"Failed to enrich with user interests", (Throwable)t);
        }
    }

    public void enrichHeads(String user, String projectKey, List<? extends TaggableObjectsService.TaggableListItem> heads) {
        if (heads == null || heads.isEmpty()) {
            return;
        }
        try {
            HashMap<String, InterestsInternalDB.TaggableObjectRefWithInterest> interestsMap = new HashMap<String, InterestsInternalDB.TaggableObjectRefWithInterest>();
            ITaggingService.TaggableType type = heads.get(0).getTaggableType();
            for (InterestsInternalDB.TaggableObjectRefWithInterest taggableObjectRefWithInterest : this.dao.getUserInterestsForProjectAndType(user, type, projectKey)) {
                interestsMap.put(this.key(taggableObjectRefWithInterest), taggableObjectRefWithInterest);
            }
            for (TaggableObjectsService.TaggableListItem taggableListItem : heads) {
                String key = this.key(taggableListItem.getTaggableType(), taggableListItem.projectKey, taggableListItem.id);
                if (!interestsMap.containsKey(key)) continue;
                taggableListItem.interest = (InterestsInternalDB.Interest)interestsMap.get(key);
            }
        }
        catch (Exception t) {
            logger.info((Object)"Failed to enrich with user interests", (Throwable)t);
        }
    }

    public void enrichSummaries(String user, String projectKey, List<? extends TaggableObjectsService.TaggableObjectSummary> summaries) {
        if (summaries == null || summaries.isEmpty()) {
            return;
        }
        try {
            HashMap<String, InterestsInternalDB.TaggableObjectRefWithInterest> interestsMap = new HashMap<String, InterestsInternalDB.TaggableObjectRefWithInterest>();
            ITaggingService.TaggableType type = summaries.get((int)0).object.getTaggableType();
            for (InterestsInternalDB.TaggableObjectRefWithInterest taggableObjectRefWithInterest : this.dao.getUserInterestsForProjectAndType(user, type, projectKey)) {
                interestsMap.put(this.key(taggableObjectRefWithInterest), taggableObjectRefWithInterest);
            }
            for (TaggableObjectsService.TaggableObjectSummary taggableObjectSummary : summaries) {
                String key = this.key(taggableObjectSummary.object.getTaggableType(), taggableObjectSummary.object.getProjectKey(), taggableObjectSummary.object.getId());
                if (!interestsMap.containsKey(key)) continue;
                taggableObjectSummary.interest = (InterestsInternalDB.Interest)interestsMap.get(key);
            }
        }
        catch (Exception t) {
            logger.info((Object)"Failed to enrich with user interests", (Throwable)t);
        }
    }

    public List<String> getUsersWithStar_NT(ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey) throws Exception {
        return this.dao.getUsersWithStar(objectType, projectKey, objectId, workspaceKey);
    }

    public TaggableObjectWithUserInterest getObjectAndUserInterest_NT(AuthCtx authCtx, TaggableObjectsService.TaggableObject object) throws Exception {
        TaggableObjectWithUserInterest ret = new TaggableObjectWithUserInterest();
        ret.object = object;
        ret.interest = this.dao.getObjectAndUserInterest(authCtx.getIdentifier(), object.getTaggableType(), object.getProjectKey(), object.getId(), null);
        return ret;
    }

    public InterestsInternalDB.Interest getObjectAndUserInterest_NT(AuthCtx authCtx, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey) throws SQLException {
        return this.dao.getObjectAndUserInterest(authCtx.getIdentifier(), objectType, projectKey, objectId, workspaceKey);
    }

    public InterestsInternalDB.Interest getObjectAndUserInterest_noFail(AuthCtx authCtx, TaggableObjectsService.TaggableObject object) throws Exception {
        try {
            return this.dao.getObjectAndUserInterest(authCtx.getIdentifier(), object.getTaggableType(), object.getProjectKey(), object.getId(), null);
        }
        catch (Exception e) {
            logger.info((Object)("Failed to get interests: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return null;
        }
    }

    public InterestsInternalDB.Interest getObjectAndUserInterest_noFail(AuthCtx authCtx, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey) throws Exception {
        try {
            return this.dao.getObjectAndUserInterest(authCtx.getIdentifier(), objectType, projectKey, objectId, workspaceKey);
        }
        catch (Exception e) {
            logger.info((Object)("Failed to get interests: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return null;
        }
    }

    public InterestsInternalDB.Interest getObjectAndUserInterest_noFail(AuthCtx authCtx, ITaggingService.TaggableType objectType, String projectKey, String objectId) throws Exception {
        return this.getObjectAndUserInterest_noFail(authCtx, objectType, projectKey, objectId, null);
    }

    @UIModel
    public static class ProjectFoldersInterestsResponse {
        public List<InterestsInternalDB.NonTaggableObjectWithInterest> interests = new ArrayList<InterestsInternalDB.NonTaggableObjectWithInterest>();
    }

    @UIModel
    public static class InterestsResponse {
        public List<InterestsInternalDB.TaggableObjectRefWithInterest> interests = new ArrayList<InterestsInternalDB.TaggableObjectRefWithInterest>();
        public boolean hasMoreResults;
        public int offset;
        public int pageSize;
    }

    public static class TaggableObjectWithUserInterest {
        TaggableObjectsService.TaggableObject object;
        InterestsInternalDB.Interest interest;
    }
}

