/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.springframework.stereotype.Service;

@Service
public class LockablePythonLogsService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.python.logs.service");

    public List<LogsService.LogDesc> listLogs(File logsDir) throws IOException {
        if (!logsDir.isDirectory()) {
            logger.info((Object)"logs dir does not exist");
            return new ArrayList<LogsService.LogDesc>();
        }
        return Files.find(logsDir.toPath(), 3, (filePath, fileAttr) -> fileAttr.isRegularFile() && !filePath.toString().endsWith(".lock"), new FileVisitOption[0]).map(path -> new LogsService.LogDesc(path.toFile(), logsDir)).collect(Collectors.toList());
    }

    public SmartLogTail getLog(File logFile) throws IOException {
        if (logFile.isFile()) {
            return DKUtils.smartTailFile((File)logFile, (int)500);
        }
        throw new IOException("Log file doesn't exist");
    }

    public void deleteLog(File logFile) throws IOException {
        if (logFile.isFile()) {
            if (DKUFileUtils.isLockFile((File)logFile)) {
                throw new IllegalArgumentException("Lock files can't be deleted");
            }
            if (DKUFileUtils.isFileLocked((File)logFile)) {
                throw new IllegalArgumentException("This log file can't be deleted while in use");
            }
        } else {
            throw new IOException("Log file doesn't exist");
        }
        DKUFileUtils.delete((File)logFile);
    }

    public void clearLogs(File logDir) throws IOException {
        if (logDir.isDirectory()) {
            ArrayList<String> lockedFiles = new ArrayList<String>();
            for (File file : DKUFileUtils.recursiveListFiles((File)logDir)) {
                if (DKUFileUtils.isLockFile((File)file)) continue;
                if (!DKUFileUtils.isFileLocked((File)file)) {
                    DKUFileUtils.delete((File)file);
                    continue;
                }
                String relativeFilePath = Paths.get(logDir.toURI()).relativize(Paths.get(file.toURI())).toString();
                lockedFiles.add(relativeFilePath);
            }
            if (!lockedFiles.isEmpty()) {
                throw new IllegalArgumentException("Some log files are being used and were not deleted: " + String.valueOf(lockedFiles));
            }
        } else {
            throw new IOException("Log directory doesn't exist");
        }
    }

    public void streamLog(File logFile, OutputStream os) throws IOException {
        block11: {
            if (logFile.isFile()) {
                logger.info((Object)("Start compressed stream from " + String.valueOf(logFile)));
                try (GZIPOutputStream zos = new GZIPOutputStream(os);
                     FileInputStream is = new FileInputStream(logFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                    break block11;
                }
            }
            throw new IOException("Log file doesn't exist");
        }
    }
}

