/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.projects;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.labeling.ImageViewSettings;
import com.dataiku.dip.meanings.MeaningsService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ProjectFeaturesUsageSaveEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.projects.ProjectFeaturesUsage;
import com.dataiku.dip.server.services.projects.ProjectFeaturesUsageDAO;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheBuilder;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheLoader;
import com.dataiku.dss.shadelib.com.google.common.cache.LoadingCache;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectFeaturesUsageService {
    private static final int SAVE_DEBOUNCE_MILLIS = 15000;
    @Autowired
    private MeaningsService meaningsService;
    @Autowired
    private ProjectFeaturesUsageDAO projectFeaturesUsageDAO;
    @Autowired
    private PubSubService pubSub;
    private List<String> geoMeanings = new ArrayList<String>();
    private final LoadingCache<String, ProjectFeaturesUsage> cache = CacheBuilder.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, ProjectFeaturesUsage>(){

        public ProjectFeaturesUsage load(String projectKey) throws IOException {
            return ProjectFeaturesUsageService.this.projectFeaturesUsageDAO.get(projectKey);
        }
    });
    private final ExecutorService workerThread = Executors.newScheduledThreadPool(0, new ThreadFactoryBuilder().setNameFormat("ProjectFeaturesUsageServiceWork-%d").build());
    private final Set<String> dirtyProjects = ConcurrentHashMap.newKeySet();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects.features.usage");

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init ProjectFeaturesUsageService");
        this.geoMeanings = this.meaningsService.listGeoMeanings().stream().map(shortMeaningInfo -> shortMeaningInfo.id).collect(Collectors.toList());
        this.pubSub.subscribe("project-features-usage-save", evt -> this.saveDirtyProjects());
    }

    public ProjectFeaturesUsage get(String projectKey) throws IOException {
        try {
            return (ProjectFeaturesUsage)this.cache.get((Object)projectKey);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    public void update(String projectKey, List<SerializedMemTableV2.Header> headers) {
        Stream<String> meanings = headers.stream().map(header -> header.selectedType != null && header.selectedType.name != null ? header.selectedType.name : "");
        this.update(projectKey, null, meanings.collect(Collectors.toSet()));
    }

    public void update(String projectKey, SerializedDataset dataset) {
        this.update(projectKey, dataset, null);
    }

    public void update(String projectKey, SerializedDataset dataset, Set<String> detectedMeanings) {
        Preconditions.checkNotNull((Object)projectKey);
        this.workerThread.submit(new UpdateCommand(projectKey, detectedMeanings, dataset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDirtyProjects() {
        logger.info((Object)"Saving features usage for dirty projects");
        Iterator<String> iterator = this.dirtyProjects.iterator();
        while (iterator.hasNext()) {
            String projectKey = iterator.next();
            try {
                logger.info((Object)("Saving features usage for project " + projectKey));
                ProjectFeaturesUsage lastKnownUsage = (ProjectFeaturesUsage)this.cache.get((Object)projectKey);
                this.projectFeaturesUsageDAO.save(lastKnownUsage);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to save features usage for project " + projectKey), (Throwable)e);
            }
            finally {
                iterator.remove();
            }
        }
    }

    private class UpdateCommand
    implements Runnable {
        private final String projectKey;
        private final Set<String> detectedMeanings;
        private final Schema schema;
        private final ImageViewSettings imageViewSettings;

        private UpdateCommand(String projectKey, Set<String> detectedMeanings, SerializedDataset dataset) {
            this.projectKey = projectKey;
            this.detectedMeanings = detectedMeanings;
            this.schema = dataset == null ? null : dataset.getSchema();
            this.imageViewSettings = dataset == null ? null : dataset.imageViewSettings;
        }

        @Override
        public void run() {
            ProjectFeaturesUsage existingUsage;
            try {
                existingUsage = (ProjectFeaturesUsage)ProjectFeaturesUsageService.this.cache.get((Object)this.projectKey);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to retrieve project features usage. Restarting from scratch.", (Throwable)e);
                existingUsage = new ProjectFeaturesUsage(this.projectKey);
            }
            ProjectFeaturesUsage updatedUsage = new ProjectFeaturesUsage(existingUsage);
            this.updateWithImageView(updatedUsage, this.imageViewSettings);
            this.updateWithSchema(updatedUsage, this.schema);
            if (this.detectedMeanings != null) {
                this.updateWithMeanings(updatedUsage, this.detectedMeanings);
            }
            if (!existingUsage.equals(updatedUsage)) {
                ProjectFeaturesUsageService.this.cache.put((Object)this.projectKey, (Object)updatedUsage);
                if (!ProjectFeaturesUsageService.this.dirtyProjects.contains(this.projectKey)) {
                    ProjectFeaturesUsageService.this.dirtyProjects.add(this.projectKey);
                    logger.info((Object)("Feature usages change detected for project " + this.projectKey + ", saving projects it in 15 seconds."));
                    ProjectFeaturesUsageService.this.pubSub.publishWithDebounce("project-features-usage-save", (DSSEvent)new ProjectFeaturesUsageSaveEvent(), 15000);
                }
            }
        }

        private void updateWithMeanings(ProjectFeaturesUsage usage, Set<String> meanings) {
            for (String meaning : meanings) {
                this.updateWithMeaning(usage, meaning);
            }
        }

        private void updateWithMeaning(ProjectFeaturesUsage usage, String meaning) {
            switch (meaning) {
                case "DateSource": 
                case "Date": 
                case "DateOnly": 
                case "DatetimeNoTz": {
                    usage.hasTimeData = true;
                    break;
                }
                case "FreeText": {
                    usage.hasNLData = true;
                    break;
                }
                default: {
                    usage.hasGeoData |= ProjectFeaturesUsageService.this.geoMeanings.contains(meaning);
                }
            }
        }

        private void updateWithImageView(ProjectFeaturesUsage usage, ImageViewSettings imageViewSettings) {
            usage.hasImageView = usage.hasImageView | (imageViewSettings != null && imageViewSettings.enabled);
        }

        private void updateWithSchema(ProjectFeaturesUsage usage, Schema schema) {
            for (SchemaColumn column : schema.getColumns()) {
                Type type = column.getType();
                usage.hasGeoData |= type.isGeo();
                usage.hasTimeData |= type.isTemporal();
                String meaning = column.getMeaning();
                if (meaning == null) continue;
                this.updateWithMeaning(usage, meaning);
            }
        }
    }
}

