/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PrepareSnowflakeUDFUtils {
    public static boolean canUseSnowflakeUDF(AbstractSQLConnection conn) {
        if (conn == null || conn.getParams() == null || conn.getDialect() == null) {
            return false;
        }
        if ("Snowflake".equals(conn.getDialect().getId()) && conn.getParams() instanceof SnowflakeConnection.Params) {
            SnowflakeConnection.Params sfParams = (SnowflakeConnection.Params)conn.getParams();
            return sfParams.useJavaUDF;
        }
        return false;
    }

    public static void fillPrePostQueriesForUDF(AbstractSQLConnection connRaw, ShakerSQLTranslator.TranslatorResult translatorResult, List<String> preQueries, List<String> postQueries) {
        SnowflakeConnection conn = (SnowflakeConnection)connRaw;
        String stage = conn.params.javaUDFStage;
        if (StringUtils.isBlank((String)stage)) {
            throw new IllegalArgumentException("Cannot use Java functions in Snowflake: you must specify a writable stage");
        }
        UUID uuid = UUID.randomUUID();
        String runPathInStage = PathUtils.makeLeadingNoTrailing((String)(StringUtils.defaultIfBlank((String)conn.params.javaUDFPathInStage, (String)"") + "/shaker-run-" + uuid.toString()));
        List puts = translatorResult.snowflakeUDFResources.stream().map(res -> String.format("PUT file://%s @%s%s%s AUTO_COMPRESS=false SOURCE_COMPRESSION=NONE; \n", res.file, stage, runPathInStage, res.targetPath)).collect(Collectors.toList());
        ArrayList removes = Lists.newArrayList();
        if (!translatorResult.snowflakeUDFResources.isEmpty()) {
            removes.add(String.format("REMOVE @%s%s;\n", stage, runPathInStage));
        }
        ArrayList<String> creates = new ArrayList<String>();
        ArrayList<String> deletes = new ArrayList<String>();
        for (SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef func : translatorResult.snowflakeUDFs) {
            String imports = func.imports.stream().map(res -> String.format("'@%s%s/%s'", stage, runPathInStage, res)).collect(Collectors.joining(","));
            creates.add(String.format("CREATE FUNCTION %s (%s) returns %s LANGUAGE JAVA RUNTIME_VERSION = '17' IMPORTS = (%s) HANDLER='%s';\n", func.name, func.inputDeclaration, func.outputType, imports, func.handler));
            deletes.add(String.format("DROP FUNCTION %s (%s)", func.name, func.typesDeclaration));
        }
        preQueries.addAll(puts);
        preQueries.addAll(creates);
        postQueries.addAll(deletes);
        postQueries.addAll(removes);
    }
}

