/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.shaker.processors.geo.Geocoder;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.StatusLine;
import com.dataiku.dss.shadelib.org.apache.http.client.ClientProtocolException;
import com.dataiku.dss.shadelib.org.apache.http.client.HttpClient;
import com.dataiku.dss.shadelib.org.apache.http.client.ResponseHandler;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class GeocoderMapQuest
extends Geocoder {
    HttpClient client;
    long lastCall = 0L;

    @Override
    protected int getLimit() {
        return 20;
    }

    private GeocoderMapQuest() {
    }

    public static GeocoderMapQuest getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Geocoder.Coord> callAPI(LinkedHashSet<String> queries) throws URISyntaxException, ClientProtocolException, IOException {
        List<Geocoder.Coord> res;
        if (this.client == null) {
            DefaultHttpClient defaultClient = new DefaultHttpClient();
            defaultClient.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
            this.client = defaultClient;
        }
        logger.info((Object)("MapQuest geocoding API call for a batch of " + queries.size() + " queries."));
        try {
            this.apiKey = URLDecoder.decode(this.apiKey, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            logger.error((Object)"failed to unescape MapQuest key");
            return null;
        }
        String maxResults = "1";
        URI uri = null;
        URIBuilder builder = new URIBuilder();
        builder.setScheme("http").setHost("open.mapquestapi.com").setPath("/geocoding/v1/batch").addParameter("key", this.apiKey).addParameter("outFormat", "json").addParameter("maxResults", maxResults);
        for (String q : queries) {
            builder.addParameter("location", q);
        }
        uri = builder.build();
        HttpGet httpget = new HttpGet(uri);
        ResponseHandler<MapQuestBatchResponse> rh = new ResponseHandler<MapQuestBatchResponse>(){

            public MapQuestBatchResponse handleResponse(HttpResponse response) {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    Geocoder.logger.error((Object)("MapQuest API error: " + statusLine.getStatusCode() + ": " + statusLine.getReasonPhrase()));
                    return null;
                }
                if (entity == null) {
                    Geocoder.logger.error((Object)"MapQuest API error : empty response");
                    return null;
                }
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                Charset charset = contentType.getCharset();
                String read = null;
                try {
                    InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);
                    read = IOUtils.toString((Reader)reader);
                }
                catch (Exception e) {
                    Geocoder.logger.error((Object)"MapQuest API error : could not read response");
                    return null;
                }
                Gson gson = new Gson();
                return (MapQuestBatchResponse)gson.fromJson(read, MapQuestBatchResponse.class);
            }
        };
        MapQuestBatchResponse response = null;
        long now = System.currentTimeMillis();
        if (now - this.lastCall <= 500L) {
            logger.info((Object)"waiting to avoid throttling ...");
            DKUtils.unsafeSleep((long)500L);
        }
        this.lastCall = now;
        try {
            response = (MapQuestBatchResponse)this.client.execute((HttpUriRequest)httpget, (ResponseHandler)rh);
            res = response.getList();
            this.fillCache(queries, res);
        }
        finally {
            httpget.releaseConnection();
        }
        return res;
    }

    private static class SingletonHolder {
        private static final GeocoderMapQuest instance = new GeocoderMapQuest();

        private SingletonHolder() {
        }
    }

    public static class MapQuestBatchResponse {
        MapQuestResponse[] results;
        Info info;

        public String toString() {
            return JSON.json((Object)this);
        }

        public List<Geocoder.Coord> getList() {
            ArrayList<Geocoder.Coord> res = new ArrayList<Geocoder.Coord>();
            if (this.results != null) {
                for (MapQuestResponse r : this.results) {
                    if (r.locations != null && r.locations.length != 0) {
                        double lat = r.locations[0].latLng.lat;
                        double lng = r.locations[0].latLng.lng;
                        Geocoder.Granularity g = null;
                        switch (r.locations[0].geocodeQuality) {
                            case "POINT": 
                            case "ADDRESS": 
                            case "INTERSECTION": {
                                g = Geocoder.Granularity.POINT;
                                break;
                            }
                            case "STREET": {
                                g = Geocoder.Granularity.STREET;
                                break;
                            }
                            case "CITY": 
                            case "COUNTY": {
                                g = Geocoder.Granularity.CITY;
                                break;
                            }
                            case "STATE": 
                            case "COUNTRY": {
                                g = Geocoder.Granularity.COUNTRY;
                            }
                        }
                        res.add(new Geocoder.Coord(lat, lng, g));
                        continue;
                    }
                    res.add(new Geocoder.Coord());
                }
            }
            return res;
        }

        public static class MapQuestResponse {
            MapQuestLocation[] locations;

            public static class MapQuestLocation {
                LatitudeLongitude latLng;
                String geocodeQuality;

                public static class LatitudeLongitude {
                    double lng;
                    double lat;
                }
            }
        }

        public static class Info {
            int statuscode;
        }
    }
}

