/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.processors.udf.AbstractPythonUDF;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorMeta;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorsService;
import com.dataiku.dip.shaker.processors.udf.CustomJythonStepParams;
import com.dataiku.dip.shaker.processors.udf.ImpersonablePythonUDFKernel;
import com.dataiku.dip.shaker.processors.udf.LoadedJythonProcessor;
import com.dataiku.dip.shaker.processors.udf.MetaWithRemoteCodeEnv;
import com.dataiku.dip.shaker.processors.udf.PythonUDFModeHandler;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class CustomJythonStepProcessor
extends AbstractPythonUDF
implements ProcessorWithResourceFiles,
ProcessorWithResolvedParams {
    protected final LoadedJythonProcessor loaded;
    protected final CustomJythonStepParams params;
    private File codeFile;
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.plugins.shaker.jython");

    public CustomJythonStepProcessor(CustomJythonProcessorMeta meta, LoadedJythonProcessor loaded, CustomJythonStepParams params, PythonUDFModeHandler modeHandler) {
        super(meta, true, false, loaded.desc.useKernel, params.sourceColumnsPattern, params.sourceColumnsList, loaded.desc.vectorize, params.vectorSize, params.variablesDefinition, "process", modeHandler);
        this.loaded = loaded;
        this.params = params;
    }

    @Override
    public String getPythonSourceCode() throws IOException {
        return FileUtils.readFileToString((File)this.codeFile, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public String getCodeEnvName(MetaWithRemoteCodeEnv meta, String projectKey) throws IOException {
        return this.params.getCodeEnvName(meta, projectKey);
    }

    @Override
    public void initInterpreter(PythonInterpreter interpreter) {
        PyDictionary paramsDict;
        if (this.params.resolvedConfig != null) {
            paramsDict = new PyDictionary();
            for (Map.Entry<String, Object> v : this.params.resolvedConfig.entrySet()) {
                paramsDict.put((Object)v.getKey(), v.getValue());
            }
            interpreter.set("params", (PyObject)paramsDict);
        }
        if (this.params.pluginConfig != null) {
            paramsDict = new PyDictionary();
            for (Map.Entry<String, Object> v : this.params.pluginConfig.entrySet()) {
                paramsDict.put((Object)v.getKey(), v.getValue());
            }
            interpreter.set("plugin_params", (PyObject)paramsDict);
        }
    }

    @Override
    public void initKernel(ImpersonablePythonUDFKernel.PythonCommand command) {
        if (this.params.resolvedConfig != null) {
            command.params = JSON.toJsonObject(this.params.resolvedConfig);
            command.pluginParams = JSON.toJsonObject(this.params.pluginConfig);
        }
    }

    @Override
    public Map<String, File> gatherRequirements() {
        HashMap<String, File> requirements = new HashMap<String, File>();
        CustomJythonProcessorsService service = (CustomJythonProcessorsService)SpringUtils.getBean(CustomJythonProcessorsService.class);
        requirements.put("dku.custom-jython-step." + this.loaded.getType() + ".code", service.getCodeFile(this.loaded.getType()));
        return requirements;
    }

    @Override
    public void setRequiredFiles(Map<String, File> requiredFiles) {
        this.codeFile = requiredFiles.get("dku.custom-jython-step." + this.loaded.getType() + ".code");
    }

    @Override
    public void resolve(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        PluginSettingsResolver.ResolvedSettings expandedSettings = new PluginSettingsResolver(authCtx, projectKey).getPluginSettings(this.loaded.getParams(), JSON.toJsonObject(this.params.customConfig), this.loaded.getOwnerPluginId());
        this.params.resolvedConfig = (Map)JSON.parse((String)JSON.json((Object)expandedSettings.config), (TypeToken)new TypeToken<Map<String, Object>>(){});
        this.params.pluginConfig = (Map)JSON.parse((String)JSON.json((Object)expandedSettings.pluginConfig), (TypeToken)new TypeToken<Map<String, Object>>(){});
    }

    @Override
    protected void enrichPythonLibsForLocalExecution(Map<String, String> pythonLibs) {
        assert (pythonLibs != null);
        CustomJythonProcessorsService service = (CustomJythonProcessorsService)SpringUtils.getBean(CustomJythonProcessorsService.class);
        pythonLibs.put("plugin-python-lib", service.getLibFolder(this.loaded.getType()));
    }
}

