/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.ProcessorWithSingleCopyAdditionalInputs;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datalayer.ColumnDeletionSensitiveProcessor;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datalayer.memimpl.MemTableSISOWrapper;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.model.ShakerSamplingUtils;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.MemTableProcessor;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.ProcessorLibraryDesc;
import com.dataiku.dip.shaker.server.ScriptExecutionProgress;
import com.dataiku.dip.shaker.server.StreamedAdditionalInputAccessor;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class MemScriptRunner {
    private Dataset inputDS;
    private boolean isForPreview;
    private StreamingEndpoint inputSE;
    private final String projectKey;
    private final SerializedShakerScript script;
    private final String requestedSampleId;
    private TableWithReport twr;
    private final ScriptExecutionProgress progress = new ScriptExecutionProgress();
    private final WarningsContext warningsContext = new WarningsContext();
    private final StreamedAdditionalInputAccessor asr;
    private final SampleBuilder sampleBuilder;
    private final AuthCtx user;
    private final Params appParams;
    private long processedMaxMemory;
    private boolean inMemory;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private TranslationService translationService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.shaker.runner");

    public MemScriptRunner(SerializedShakerScript dataView, Dataset inputDS, String requestedSampleId, SampleBuilder sampleBuilder, AuthCtx user, boolean isForPreview, boolean inMemory) {
        this(dataView, inputDS, requestedSampleId, sampleBuilder, user, isForPreview);
        this.inMemory = inMemory;
    }

    public MemScriptRunner(SerializedShakerScript dataView, Dataset inputDS, String requestedSampleId, SampleBuilder sampleBuilder, AuthCtx user, boolean isForPreview) {
        this.script = dataView;
        this.inputDS = inputDS;
        this.isForPreview = isForPreview;
        this.projectKey = dataView.getProjectKey(inputDS);
        this.requestedSampleId = requestedSampleId;
        this.sampleBuilder = sampleBuilder;
        this.user = user;
        SpringUtils.getInstance().autowire((Object)this);
        this.asr = new StreamedAdditionalInputAccessor(user, this.projectKey, this.datasetsDAO);
        this.appParams = DKUApp.getParams();
    }

    public MemScriptRunner(SerializedShakerScript dataView, StreamingEndpoint inputSE, String requestedSampleId, SampleBuilder sampleBuilder, AuthCtx user) {
        this.script = dataView;
        this.inputSE = inputSE;
        this.projectKey = inputSE.getProjectKey();
        this.requestedSampleId = requestedSampleId;
        this.sampleBuilder = sampleBuilder;
        this.user = user;
        SpringUtils.getInstance().autowire((Object)this);
        this.asr = new StreamedAdditionalInputAccessor(user, this.projectKey, this.datasetsDAO);
        this.appParams = DKUApp.getParams();
    }

    public String getRequiredSampleId() throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (this.requestedSampleId != null) {
            return this.requestedSampleId;
        }
        try (FutureProgress.AutocloseableFutureProgressState checking = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("MEM_SCRIPT_RUNNER.LABEL.CHECKING_SAMPLE_READY", "Checking if sample is ready", new Object[0]));){
            SerializedShakerScript.ShakerExplorationSampleSettings resolved = this.getResolvedSampleSettings();
            String currentSampleId = this.computeSampleId(resolved);
            logger.debug((Object)("Computed required sample id=" + currentSampleId));
            String string = currentSampleId;
            return string;
        }
    }

    private SerializedShakerScript.ShakerExplorationSampleSettings getResolvedSampleSettings() throws IOException {
        long sampleMaxMemory = this.script.explorationSampling.selection.maxStoredBytes;
        this.processedMaxMemory = this.script.maxProcessedMemTableBytes;
        logger.traceV("Script settings sampleMax=%d processedMax=%d", new Object[]{sampleMaxMemory, this.processedMaxMemory});
        try (Transaction t = this.transactionService.beginRead();){
            assert (this.script.contextProjectKey != null);
            SerializedProject.LimitsSettings projectLimits = this.projectsDAO.getMandatoryUnsafe((String)this.script.contextProjectKey).settings.limitsSettings;
            SerializedProject.LimitsSettings globalLimits = this.generalSettingsDAO.getUnsafe().limits;
            long sampleMaxMemoryHard = -1L;
            if (globalLimits.memSampleBytes.hard > -1L && projectLimits.memSampleBytes.hard > -1L) {
                sampleMaxMemoryHard = Math.min(globalLimits.memSampleBytes.hard, projectLimits.memSampleBytes.hard);
            } else if (globalLimits.memSampleBytes.hard > -1L) {
                sampleMaxMemoryHard = globalLimits.memSampleBytes.hard;
            } else if (projectLimits.memSampleBytes.hard > -1L) {
                sampleMaxMemoryHard = projectLimits.memSampleBytes.hard;
            }
            if (sampleMaxMemoryHard > -1L && sampleMaxMemory > -1L) {
                sampleMaxMemory = Math.min(sampleMaxMemory, sampleMaxMemoryHard);
            } else if (sampleMaxMemoryHard > -1L) {
                sampleMaxMemory = sampleMaxMemoryHard;
            }
            long processedMaxMemoryHard = -1L;
            if (globalLimits.shakerMemTableBytes.hard > -1L && projectLimits.shakerMemTableBytes.hard > -1L) {
                processedMaxMemoryHard = Math.min(globalLimits.shakerMemTableBytes.hard, projectLimits.shakerMemTableBytes.hard);
            } else if (globalLimits.shakerMemTableBytes.hard > -1L) {
                processedMaxMemoryHard = globalLimits.shakerMemTableBytes.hard;
            } else if (projectLimits.shakerMemTableBytes.hard > -1L) {
                processedMaxMemoryHard = projectLimits.shakerMemTableBytes.hard;
            }
            if (processedMaxMemoryHard > -1L && this.processedMaxMemory > -1L) {
                this.processedMaxMemory = Math.min(this.processedMaxMemory, processedMaxMemoryHard);
            } else if (processedMaxMemoryHard > -1L) {
                this.processedMaxMemory = processedMaxMemoryHard;
            }
        }
        logger.traceV("Processing with sampleMax=%d processedMax=%d", new Object[]{sampleMaxMemory, this.processedMaxMemory});
        SerializedShakerScript.ShakerExplorationSampleSettings resolved = (SerializedShakerScript.ShakerExplorationSampleSettings)JSON.deepCopy((Object)this.script.explorationSampling);
        resolved.selection.maxStoredBytes = sampleMaxMemory;
        return resolved;
    }

    public TableWithReport run() throws Exception {
        this.twr = new TableWithReport();
        if (this.inMemory && this.inputDS != null) {
            logger.info((Object)("Getting sample in memory id=" + this.requestedSampleId));
            this.twr = this.buildSampleInMemory_DANGEROUS();
        } else {
            this.twr = this.getOrBuildSampleOnDisk();
        }
        FutureProgress.updateState((double)3.0);
        try (DSSMetrics.TimeCtx mc = DSSMetrics.timeCtx((String)"dku.shaker.scriptrunner.steps.process");
             FutureProgress.AutocloseableFutureProgressState shaking = FutureProgress.pushAutoCloseableState((String)"Running steps", (double)this.script.steps.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            shaking.important = true;
            this.twr.scriptChange = this.twr.table.createMemTableChange();
            this.twr.table.increaseImpactDepth();
            this.twr.rootError = new StepExceptionState();
            try {
                for (int i = 0; i < this.script.steps.size(); ++i) {
                    StepExceptionState se = new StepExceptionState();
                    this.twr.rootError.children.add(se);
                    shaking.increment(1.0);
                    ScriptStep step = this.script.steps.get(i);
                    this.initAndRunGenericStep(i, step, this.twr.scriptChange, se, this.processedMaxMemory);
                }
            }
            catch (AfterPreviewException e) {
                this.twr.isPreviewMode = true;
                logger.info((Object)"Stopped before end (preview)");
            }
            catch (StepRunException e) {
                logger.warn((Object)"Fatal error while running script", (Throwable)e);
                Throwable underlying = e.getCause();
                throw new ApplicativeException("STEP_RUN_EXCEPTION", "Error while running a script step", ExceptionUtils.getMessageWithCauses((Throwable)underlying), (Object)this.twr.rootError);
            }
            this.twr.table.getAndResetChanges(this.twr.scriptChange);
            this.twr.table.decDepth();
        }
        if (!this.twr.table.changeTracking) {
            this.twr.table.compact();
        }
        FutureProgress.updateState((double)4.0);
        this.twr.warnings = this.warningsContext.getOutput();
        if (this.twr.warnings != null && this.twr.warnings.totalCount > 0) {
            logger.info((Object)("Encountered " + this.twr.warnings.totalCount + " warnings"));
        }
        return this.twr;
    }

    private TableWithReport buildSampleInMemory_DANGEROUS() throws Exception {
        logger.info((Object)"Computing in memory only");
        FutureProgress.updateState((double)1.0);
        SerializedShakerScript.ShakerExplorationSampleSettings resolved = this.getResolvedSampleSettings();
        String usedSampleId = ShakerSamplingUtils.computeSampleId(this.user, this.inputDS, resolved);
        logger.info((Object)("Will build sample: " + usedSampleId));
        FutureProgress.updateState((double)2.0);
        try (FutureProgress.AutocloseableFutureProgressState building = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("MEM_SCRIPT_RUNNER.LABEL.COMPUTING_SAMPLE", "Computing sample", new Object[0]));){
            SampleBuilder.Sample sample = SampleBuilder.computeSample(this.inputDS, usedSampleId, resolved.selection, this.warningsContext, this.user, this.isForPreview);
            this.twr.table = sample.data;
            this.twr.usedSample = sample.meta;
        }
        this.twr.initialRows = this.twr.table.nrows();
        this.twr.initialCols = this.twr.table.ncols();
        logger.info((Object)("Reading sample done, read " + this.twr.table.nrows() + " rows: " + this.twr.table.getStats()));
        return this.twr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableWithReport getOrBuildSampleOnDisk() throws Exception {
        AutoCloseableLock lock;
        String name = this.inputDS != null ? this.inputDS.getFullName() : this.inputSE.getFullId();
        SerializedShakerScript.ShakerExplorationSampleSettings resolved = this.getResolvedSampleSettings();
        try (FutureProgress.AutocloseableFutureProgressState waiting = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("MEM_SCRIPT_RUNNER.LABEL.WAITING_OTHER_SAMPLE", "Waiting for other sample computation", new Object[0]));){
            String lockName = SampleBuilder.getComputeSampleLockName(name);
            lock = NamedLock.acquireInterruptibly((String)lockName);
        }
        try {
            SampleBuilder.SampleMeta sampleToRead;
            if (this.requestedSampleId != null) {
                logger.info((Object)("Getting sample id=" + this.requestedSampleId));
                sampleToRead = this.getSampleMeta(this.requestedSampleId);
            } else {
                try (FutureProgress.AutocloseableFutureProgressState checking = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("MEM_SCRIPT_RUNNER.LABEL.CHECKING_SAMPLE_READY", "Checking if sample is ready", new Object[0]));){
                    String currentSampleId = this.computeSampleId(resolved);
                    logger.trace(() -> "Computed required sample id=" + currentSampleId);
                    sampleToRead = this.getSampleMeta(currentSampleId);
                }
            }
            FutureProgress.updateState((double)1.0);
            if (sampleToRead != null) {
                logger.info((Object)("Sample cache hit id=" + sampleToRead.id));
                if (sampleToRead.warnings != null) {
                    this.warningsContext.merge(sampleToRead.warnings);
                }
            } else {
                this.clearSamples();
                String usedSampleId = this.computeSampleId(resolved);
                logger.infoV("Sample cache miss, will build sample id=%s sampleMax=%d", new Object[]{usedSampleId, resolved.selection.maxStoredBytes});
                try (FutureProgress.AutocloseableFutureProgressState building = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("MEM_SCRIPT_RUNNER.LABEL.BUILDING_SAMPLE", "Building sample", new Object[0]));){
                    this.buildSample(resolved, usedSampleId);
                }
                sampleToRead = this.getSampleMeta(usedSampleId);
                this.twr.builtSample = true;
            }
            assert (sampleToRead != null);
            FutureProgress.updateState((double)2.0);
            logger.info((Object)("Opening sample " + sampleToRead.id + " fileSize=" + this.sampleFile(sampleToRead.id).length()));
            this.twr.usedSample = sampleToRead;
            try (DSSMetrics.TimeCtx mc = DSSMetrics.timeCtx((String)"dku.shaker.scriptrunner.sample.read");
                 FutureProgress.AutocloseableFutureProgressState reading = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("MEM_SCRIPT_RUNNER.LABEL.READING_SAMPLE", "Reading sample", new Object[0]));){
                this.twr.table = this.readSample(sampleToRead.id);
                this.twr.initialRows = this.twr.table.nrows();
                this.twr.initialCols = this.twr.table.ncols();
                logger.info((Object)("Reading sample done, read " + this.twr.table.nrows() + " rows: " + this.twr.table.getStats()));
            }
        }
        finally {
            lock.close();
        }
        return this.twr;
    }

    private File sampleFile(String sampleId) {
        if (this.inputDS != null) {
            return SampleBuilder.sampleFile(this.user, this.inputDS, sampleId, this.isForPreview);
        }
        return SampleBuilder.sampleFile(this.user, this.inputSE, sampleId);
    }

    private SampleBuilder.SampleMeta getSampleMeta(String sampleId) {
        if (this.inputDS != null) {
            return SampleBuilder.getSampleMeta(this.user, this.inputDS, sampleId, this.isForPreview);
        }
        return SampleBuilder.getSampleMeta(this.user, this.inputSE, sampleId);
    }

    private String computeSampleId(SerializedShakerScript.ShakerExplorationSampleSettings sampleSettings) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (this.inputDS != null) {
            return ShakerSamplingUtils.computeSampleId(this.user, this.inputDS, sampleSettings);
        }
        return ShakerSamplingUtils.computeSampleId(this.user, this.inputSE, sampleSettings);
    }

    private void clearSamples() throws IOException {
        if (this.inputDS != null) {
            SampleBuilder.clearSamplesForUser(this.user, this.inputDS, this.isForPreview);
        } else {
            SampleBuilder.clearSamplesForUser(this.user, this.inputSE);
        }
    }

    private void buildSample(SerializedShakerScript.ShakerExplorationSampleSettings resolved, String usedSampleId) throws Exception {
        if (this.inputDS != null) {
            this.sampleBuilder.buildSample(this.inputDS, usedSampleId, resolved.selection, this.warningsContext, this.user, this.isForPreview, this.requestedSampleId != null && this.requestedSampleId.equals("-1"));
        } else {
            this.sampleBuilder.buildSample(this.inputSE, usedSampleId, resolved.selection, this.warningsContext, this.user);
        }
    }

    private MemTable readSample(String sampleId) throws IOException {
        if (this.inputDS != null) {
            return SampleBuilder.readSample(this.user, this.inputDS, sampleId, this.isForPreview);
        }
        return SampleBuilder.readSample(this.user, this.inputSE, sampleId);
    }

    private void initAndRunProcessorStep(ProcessorScriptStep step, MemTable.MemTableChange curChange, StepExceptionState se, long maxMemoryUsed) throws Exception {
        try {
            this.initAndRunProcessorStep_(step, curChange, maxMemoryUsed);
        }
        catch (AfterPreviewException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to init/run step " + JSON.json((Object)step)), (Throwable)e);
            se.error = new SerializedError((Throwable)e, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
            throw new StepRunException(e);
        }
    }

    private void initAndRunProcessorStep_(ProcessorScriptStep step, MemTable.MemTableChange curChange, long maxMemoryUsed) throws Exception {
        InfoMessage warning;
        Processor baseProcessor;
        ProcessorMeta<?, ?> meta;
        MemTable.MemTableChange processorChange;
        block48: {
            Object rproc;
            processorChange = this.twr.table.createMemTableChange();
            if (step.disabled) {
                this.progress.beginningOfStep(step.name, this.twr.table.nrows());
                logger.info((Object)("NOT executing script step " + String.valueOf(step) + ": disabled"));
                this.progress.endOfStep(this.twr.table.nrowsNotDeleted());
                this.twr.table.increaseImpactDepth();
                this.twr.table.getAndResetChanges(processorChange);
                this.twr.table.decDepth();
                curChange.groupStepsChanges.add(processorChange);
                return;
            }
            if (step.preview && !this.twr.table.changeTracking) {
                this.twr.table.compact();
                this.twr.table.trackChanges();
            }
            logger.info((Object)("Executing script step: " + step.type));
            ShakerUtils.warnDeprecatedPythonVersion(this.warningsContext, this.projectKey, step);
            String processorNameForException = StringUtils.isBlank((String)step.name) ? step.type : step.name;
            this.progress.beginningOfStep(step.name, this.twr.table.nrows());
            this.twr.table.increaseImpactDepth();
            meta = BaseProcessorsFactory.getMeta(step);
            baseProcessor = BaseProcessorsFactory.build(step, BaseProcessorsFactory.PipelineContext.sharedPipelineContext());
            if (baseProcessor instanceof ProcessorWithResourceFiles) {
                rproc = (ProcessorWithResourceFiles)baseProcessor;
                rproc.setRequiredFiles(rproc.gatherRequirements());
            }
            if (baseProcessor instanceof ProcessorWithResolvedParams) {
                rproc = (ProcessorWithResolvedParams)baseProcessor;
                rproc.resolve(this.user, this.projectKey);
            }
            if (baseProcessor instanceof ProcessorWithSubProcess) {
                rproc = (ProcessorWithSubProcess)baseProcessor;
                rproc.spawn(this.user, this.projectKey, true, null);
            }
            if (baseProcessor instanceof MemTableProcessor) {
                try (FutureProgress.AutocloseableFutureProgressState processingState = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("MEM_SCRIPT_RUNNER.LABEL.PROCESSING_ROWS", "Processing rows", new Object[0]), (double)this.twr.table.rows.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.RECORDS);){
                    ((MemTableProcessor)baseProcessor).process(this.twr.table);
                }
            }
            if (baseProcessor instanceof SingleRowProcessor) {
                SingleRowProcessor srp = (SingleRowProcessor)baseProcessor;
                srp.setColumnFactory((ColumnFactory)this.twr.table);
                try {
                    srp.init();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to init " + JSON.json((Object)step)), (Throwable)e);
                    throw e;
                }
                this.initAdditionalInputs((Processor)srp);
                try (FutureProgress.AutocloseableFutureProgressState processingState = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("MEM_SCRIPT_RUNNER.LABEL.PROCESSING_ROWS", "Processing rows", new Object[0]), (double)this.twr.table.rows.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.RECORDS);){
                    int rec = 0;
                    long memoryUsed = 0L;
                    int rowsProcessed = 0;
                    for (MemRow row : this.twr.table.rows) {
                        if (rec++ % 1000 == 0) {
                            FutureProgress.updateState((double)rec);
                            FutureProgressState.checkInterrupt();
                        }
                        if (row.isDeleted()) continue;
                        srp.processRow((Row)row);
                        ++rowsProcessed;
                        if (maxMemoryUsed <= 0L || (memoryUsed += row.getMemoryUsed()) <= maxMemoryUsed) continue;
                        throw new MemTableAppendingOutput.MemTableSizeLimitReachedException(rowsProcessed, memoryUsed, processorNameForException);
                    }
                    srp.postProcess();
                    break block48;
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to processor rows " + JSON.json((Object)step)), (Throwable)e);
                    srp.cancel();
                    throw e;
                }
            }
            if (baseProcessor instanceof SingleInputSingleOutputRowProcessor) {
                SingleInputSingleOutputRowProcessor siso = (SingleInputSingleOutputRowProcessor)baseProcessor;
                MemTableSISOWrapper.MemoryAggregationOutput out = new MemTableSISOWrapper.MemoryAggregationOutput(processorNameForException);
                siso.setProcessorOutput((ProcessorOutput)out);
                out.setMaxMemoryUsed(maxMemoryUsed);
                siso.setFactories((ColumnFactory)this.twr.table, (RowFactory)this.twr.table);
                try {
                    siso.init();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to init " + JSON.json((Object)step)), (Throwable)e);
                    throw e;
                }
                this.initAdditionalInputs((Processor)siso);
                try (FutureProgress.AutocloseableFutureProgressState processingState = FutureProgress.pushAutoCloseableState((String)this.translationService.translate("MEM_SCRIPT_RUNNER.LABEL.PROCESSING_ROWS", "Processing rows", new Object[0]), (double)this.twr.table.rows.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.RECORDS);){
                    int rec = 0;
                    long memoryUsed = 0L;
                    int maxSize = Math.max(30000, this.twr.initialRows * 3);
                    for (MemRow r : this.twr.table.rows) {
                        if (rec++ % 1000 == 0) {
                            FutureProgress.updateState((double)rec);
                            FutureProgressState.checkInterrupt();
                        }
                        if (r.isDeleted()) continue;
                        int prevNbRows = out.rows.size();
                        siso.processRow((Row)r);
                        for (int k = prevNbRows; k < out.rows.size(); ++k) {
                            memoryUsed += ((MemRow)out.rows.get(k)).getMemoryUsed();
                        }
                        if (maxMemoryUsed > 0L && memoryUsed > maxMemoryUsed) {
                            throw new MemTableAppendingOutput.MemTableSizeLimitReachedException(rec, memoryUsed, processorNameForException);
                        }
                        if (out.rows.size() <= maxSize) continue;
                        break;
                    }
                    siso.postProcess();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to process rows " + JSON.json((Object)step)), (Throwable)e);
                    siso.cancel();
                    throw e;
                }
                this.twr.table.rows.clear();
                for (Row r : out.rows) {
                    this.twr.table.rows.add((MemRow)r);
                }
            } else {
                throw new Error("Don't know how to run processor for step type " + step.type + ": " + String.valueOf(baseProcessor.getClass()));
            }
        }
        this.progress.endOfStep(this.twr.table.nrowsNotDeleted());
        logger.info((Object)("Step done, time=" + this.progress.previousSteps.get((int)(this.progress.previousSteps.size() - 1)).timeMS + " rows=" + this.twr.table.nrows()));
        if (step.preview && this.script.previewMode == SerializedShakerScript.PreviewMode.IMPACTED_ONLY) {
            this.twr.table.getChangeNoModify(processorChange);
            this.twr.table.keepOnlyImpactedRows();
            logger.info((Object)("After keep only impacted rows, have" + this.twr.table.rows.size()));
            this.twr.table.resetImpacts();
        } else {
            this.twr.table.getAndResetChanges(processorChange);
        }
        this.twr.table.decDepth();
        this.twr.table.addAndResetMessages(processorChange);
        if (baseProcessor instanceof ColumnDeletionSensitiveProcessor && this.twr.table.hasAnyPreviouslyDeletedColumns() && (warning = ((ColumnDeletionSensitiveProcessor)baseProcessor).getDeletedColumnsWarningMessage()) != null) {
            processorChange.messages.add(warning);
        }
        this.addAdditionalInputsMessages(baseProcessor, processorChange);
        if (ProcessorLibraryDesc.disabledByAdmin(this.appParams, meta)) {
            processorChange.messages.add(InfoMessage.warning((InfoMessage.MessageCode)ScriptStep.StepCodes.WARN_SCRIPTSTEP_DISABLED_BY_ADMIN, (String)meta.getName()));
        }
        curChange.groupStepsChanges.add(processorChange);
        if (baseProcessor instanceof ProcessorWithRecordedReport) {
            processorChange.recordedReport = ((ProcessorWithRecordedReport)baseProcessor).getRecordedReport();
        }
        if (step.preview) {
            this.twr.previewRowsAdded = processorChange.createdRows;
            this.twr.previewRowsDeleted = processorChange.deletedRows;
            throw new AfterPreviewException();
        }
    }

    private void initAndRunGroupStep(GroupScriptStep group, MemTable.MemTableChange curChange, StepExceptionState se, long maxMemoryUsed) throws Exception {
        MemTable.MemTableChange groupChange = this.twr.table.createMemTableChange();
        if (group.disabled) {
            logger.info((Object)("NOT executing group script step " + String.valueOf(group) + ": disabled"));
            this.twr.table.increaseImpactDepth();
            this.twr.table.getAndResetChanges(groupChange);
            this.twr.table.decDepth();
            curChange.groupStepsChanges.add(groupChange);
            return;
        }
        if (group.preview && !this.twr.table.changeTracking) {
            this.twr.table.compact();
            this.twr.table.trackChanges();
        }
        logger.info((Object)("Executing script group with  " + group.steps.size() + " steps"));
        this.twr.table.increaseImpactDepth();
        for (ProcessorScriptStep pss : group.steps) {
            StepExceptionState subException = new StepExceptionState();
            se.children.add(subException);
            this.initAndRunProcessorStep(pss, groupChange, subException, maxMemoryUsed);
        }
        if (group.preview && this.script.previewMode == SerializedShakerScript.PreviewMode.IMPACTED_ONLY) {
            this.twr.table.getChangeNoModify(groupChange);
            this.twr.table.keepOnlyImpactedRows();
            this.twr.table.resetImpacts();
        } else {
            this.twr.table.getAndResetChanges(groupChange);
        }
        this.twr.table.decDepth();
        for (MemTable.MemTableChange stepChange : groupChange.groupStepsChanges) {
            groupChange.messages.addAll(stepChange.messages);
        }
        curChange.groupStepsChanges.add(groupChange);
        if (group.preview) {
            this.twr.previewRowsAdded = groupChange.createdRows;
            this.twr.previewRowsDeleted = groupChange.deletedRows;
            throw new AfterPreviewException();
        }
    }

    private void initAndRunGenericStep(int stepIdx, ScriptStep step, MemTable.MemTableChange curChange, StepExceptionState se, long maxMemoryUsed) throws Exception {
        logger.info((Object)("Executing script step " + stepIdx + ": " + String.valueOf((Object)step.metaType)));
        switch (step.metaType) {
            case GROUP: {
                assert (step instanceof GroupScriptStep);
                this.initAndRunGroupStep((GroupScriptStep)step, curChange, se, maxMemoryUsed);
                break;
            }
            case PROCESSOR: {
                assert (step instanceof ProcessorScriptStep);
                DSSMetrics.TimeCtx pc = DSSMetrics.timeCtx((String)("dku.shaker.scriptrunner.step." + ((ProcessorScriptStep)step).type + ".process"));
                try {
                    this.initAndRunProcessorStep((ProcessorScriptStep)step, curChange, se, maxMemoryUsed);
                    if (pc == null) break;
                }
                catch (Throwable throwable) {
                    if (pc != null) {
                        try {
                            pc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pc.close();
                break;
            }
        }
    }

    private void initAdditionalInputs(Processor processor) throws Exception {
        if (processor instanceof ProcessorWithSingleCopyAdditionalInputs) {
            Callable<Void> untransactioned;
            Object loader;
            ProcessorWithSingleCopyAdditionalInputs pwscai = (ProcessorWithSingleCopyAdditionalInputs)processor;
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            try (Transaction t = transactionService.beginRead();){
                loader = pwscai.buildLoader();
                untransactioned = loader.loadAdditionalInputs(this.asr);
            }
            untransactioned.call();
            pwscai.setAdditionalInputs(loader);
        }
    }

    private void addAdditionalInputsMessages(Processor processor, MemTable.MemTableChange processorChange) throws Exception {
        if (processor instanceof ProcessorWithSingleCopyAdditionalInputs) {
            InfoMessage unknownColumnInfoMessage;
            if (processorChange.messages == null) {
                processorChange.messages = new ArrayList<InfoMessage>();
            }
            if ((unknownColumnInfoMessage = this.asr.getColumnFactoryMessages()) != null) {
                processorChange.messages.add(this.asr.getColumnFactoryMessages());
            }
        }
    }

    public static class TableWithReport {
        public MemTable table;
        public boolean isPreviewMode;
        public int initialRows;
        public int initialCols;
        public int previewRowsAdded;
        public int previewRowsDeleted;
        public MemTable.MemTableChange scriptChange;
        public StepExceptionState rootError;
        public SampleBuilder.SampleMeta usedSample;
        public boolean builtSample;
        public WarningsContext.SerializedWarnings warnings;
        public String filtersSignature;
        public boolean[] filters;
        public List<FilterFacet> facets;
        public DataService.ShakerRecipeSchema newRecipeSchema;
    }

    public static class StepExceptionState {
        SerializedError error;
        List<StepExceptionState> children = new ArrayList<StepExceptionState>();
    }

    private static class AfterPreviewException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private AfterPreviewException() {
        }
    }

    public static class StepRunException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public StepRunException(Exception e) {
            super(e);
        }
    }
}

