/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.data.currency.CurrencyDataUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.datasets.elasticsearch.InteractiveSearchService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.ExpressionFixingService;
import com.dataiku.dip.expressions.GrokExpression;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.i18n.UserLocaleAware;
import com.dataiku.dip.labeling.ImageViewSettings;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.naming.ASCIITransliterator;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.pivot.backend.PivotTablesService;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.excel.ExcelChartService;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.pivot.frontend.model.FontFormatting;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.server.datasets.EditableDatasetService;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.projects.ProjectFeaturesUsageService;
import com.dataiku.dip.shaker.DateRelativeFilterHelper;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.analysis.CategoryClusterer;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.ChartSampleMetadataRequest;
import com.dataiku.dip.shaker.model.ChartsOnDatasetDataSpec;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.model.VerySimpleTable;
import com.dataiku.dip.shaker.processors.expr.CreateColumnWithGREL;
import com.dataiku.dip.shaker.processors.expr.PreviousRowsBuffer;
import com.dataiku.dip.shaker.processors.expr.TextSimplifier;
import com.dataiku.dip.shaker.processors.geo.GeoJSONUtils;
import com.dataiku.dip.shaker.processors.numbers.CurrencyConverterAlgorithm;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.InteractiveDataPreparationService;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.InteractiveExtractor;
import com.dataiku.dip.shaker.processors.udf.PythonParameter;
import com.dataiku.dip.shaker.processors.udf.PythonUDF;
import com.dataiku.dip.shaker.server.AICompletionService;
import com.dataiku.dip.shaker.server.ChartSampleMetaDataService;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.RefreshTableService;
import com.dataiku.dip.shaker.server.SampleMetadata;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.shaker.server.StepInitException;
import com.dataiku.dip.shaker.server.TableColoringService;
import com.dataiku.dip.shaker.services.SuggestionEngineService;
import com.dataiku.dip.shaker.services.smartdate.SmartDateService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInterval;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.udaf.UdafControlFunctionRegistry;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.locationtech.jts.io.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DataController
extends DIPInternalControllerBase {
    @Autowired
    private DataService service;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PivotTablesService tablesService;
    @Autowired
    private ChartSampleMetaDataService chartSampleMetaDataService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetMetricsStatusService datasetMetricsStatusService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private AchievementsService achievementService;
    @Autowired
    private ExcelChartService excelChartService;
    @Autowired
    private ExpressionFixingService expressionFixingService;
    @Autowired
    private EditableDatasetService editableDatasetService;
    @Autowired
    private TableColoringService tableColoringService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private InteractiveDataPreparationService interactiveDataPreparationService;
    @Autowired
    private InteractiveSearchService interactiveSearchService;
    @Autowired
    private AICompletionService aiCompletionService;
    @Autowired
    private ProjectFeaturesUsageService projectFeaturesUsageService;
    @Autowired
    private RefreshTableService refreshTableService;
    @Autowired
    private IPermissionsService permissionsService;
    private static final DKULogger logger;

    public static FuturePayload buildFuturePayload(Dataset dataset) {
        FuturePayload fp = new FuturePayload();
        fp.action = "refresh_sample";
        fp.targets.add(DSSFuturePayloadUtils.forDataset(dataset).withPart("sample"));
        fp.displayName = "Refreshing table";
        return fp;
    }

    public static FuturePayload buildFuturePayload(StreamingEndpoint streamingEndpoint) {
        FuturePayload fp = new FuturePayload();
        fp.action = "refresh_sample";
        fp.targets.add(DSSFuturePayloadUtils.forStreamingEndpoint(streamingEndpoint).withPart("sample"));
        fp.displayName = "Refreshing table";
        return fp;
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/refresh-table"})
    public void refreshTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data, @RequestParam(value="allowCache", required=false, defaultValue="false") boolean allowCache, @RequestParam(value="filters", required=false, defaultValue="") String filters, @RequestParam(value="requestedSampleId") String requestedSampleId, @RequestParam(value="nbCols", required=false) Integer nbCols, @RequestParam(value="isForPreview", required=false, defaultValue="false") boolean isForPreview) throws Exception {
        RefreshTableService.RefreshTableFutureThread ft;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)contextProjectKey)) {
                this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            } else {
                this.projectsService.checkPermissionRegardlessOfContext(user, projectKey, ITaggingService.TaggableType.DATASET, datasetName, SerializedProject.ReaderAuthorization.Mode.READ);
            }
            Dataset ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
            this.permissionsService.checkUserDefinedCustomSqlFilters(user, ds, sss.explorationSampling.selection);
            ft = this.refreshTableService.getRefreshTableFuture(user, ds, sss, allowCache, nbCols, isForPreview, (FilterRequest)JSON.parse((String)filters, FilterRequest.class), requestedSampleId);
        }
        DataController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<SerializedMemTableV2>>(){}));
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/refresh-capture"})
    public void refreshCapture(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String streamingEndpointId, @RequestParam String data, @RequestParam(value="allowCache", required=false, defaultValue="false") boolean allowCache, @RequestParam(value="filters", required=false, defaultValue="") String filters, @RequestParam(value="requestedSampleId") String requestedSampleId) throws Exception {
        RefreshCaptureFutureThread ft;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
            ft = new RefreshCaptureFutureThread(user, se, (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class), allowCache);
            SpringUtils.getInstance().autowire((Object)ft);
            assert (ft.sss != null);
            assert (ft.sss.origin != null);
            ShakerUtils.checkScriptCodePermission(user, ft.sss);
            ft.requestedSampleId = requestedSampleId;
            ft.frequest = (FilterRequest)JSON.parse((String)filters, FilterRequest.class);
        }
        DataController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<SerializedMemTableV2>>(){}));
    }

    @AuditedCall(value={"msgType", "dataset-editable-read", "projectKey", "${projectKey}", "datasetName", "${dataset}"})
    @RequestMapping(value={"/api/datasets/editable/get"})
    public void getEditableDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dataset) throws Exception {
        EditableDatasetService.EditableDatasetGetResult res;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, dataset);
            Dataset ds = this.datasetAccessService.getMandatory(loc);
            this.editableDatasetService.checkEditable(ds);
            res = this.editableDatasetService.get(ds);
        }
        DataController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/get-table-chunk"})
    public void getTableChunk(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data, @RequestParam String requestedSampleId, @RequestParam int firstRow, @RequestParam int nbRows, @RequestParam int firstCol, @RequestParam int nbCols, @RequestParam String filters) throws Exception {
        Dataset ds;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)contextProjectKey)) {
                this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            } else {
                this.projectsService.checkPermissionRegardlessOfContext(user, projectKey, ITaggingService.TaggableType.DATASET, datasetName, SerializedProject.ReaderAuthorization.Mode.READ);
            }
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        MemScriptRunner.TableWithReport twr = this.service.get_NOTRANSACTION(ds, ss.deepCopy(), requestedSampleId, (FilterRequest)JSON.parse((String)filters, FilterRequest.class), true, user);
        SerializedTableChunk stc = new SerializedTableChunk(firstRow, nbRows, firstCol, nbCols);
        MemTable memTable = twr.table;
        synchronized (memTable) {
            stc.fill(twr.table, twr.filters, ss.coloring, ss.columnsSelection);
        }
        DataController.writeJSON((HttpServletResponse)resp, (Object)stc);
    }

    @AuditedCall(value={"msgType", "dataset-search", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "data", "${data}", "searchQuery", "${searchQuery}"})
    @RequestMapping(value={"/api/shaker/interactive-es-search"}, method={RequestMethod.POST})
    public void getElasticSearchDocumentFrom(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery) throws Exception {
        Dataset ds;
        DSSAuthCtx user;
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            SmartObjectRef objectRef = SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey);
            this.projectsService.failIfNoDashboardReadPermission(user, objectRef, contextProjectKey);
            assert (sss != null);
            assert (sss.origin != null);
            if (sss.coloring != null) {
                sss.coloring.scheme = ColoringDefinition.TableColoringScheme.FILL_ONLY;
            }
            ShakerUtils.checkScriptCodePermission(user, sss);
        }
        DataController.writeJSON((HttpServletResponse)resp, (Object)this.interactiveSearchService.startSearchFuture(user, ds, sss, searchQuery, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/get-grok-sample"})
    @ResponseBody
    public GrokExpression.SampleResponse getGrokExpressionSample(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam SerializedShakerScript data, @RequestParam String requestedSampleId, @RequestParam int firstRow, @RequestParam int nbRows, @RequestParam int firstCol, @RequestParam int nbCols, @RequestParam String grokExpression) throws Exception {
        GrokExpression grok;
        Dataset ds;
        AuthCtx user;
        GrokExpression.SampleResponse gesr = new GrokExpression.SampleResponse();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, data);
        }
        MemScriptRunner.TableWithReport twr = this.service.get_NOTRANSACTION(ds, data.deepCopy(), requestedSampleId, null, true, user);
        int returnedRows = Math.min(nbRows, twr.table.rows.size());
        int returnedCols = Math.min(nbCols, twr.table.columnsList.size());
        gesr.table = new SerializedTableChunk(firstRow, returnedRows, firstCol, returnedCols);
        gesr.captureOffsets = new ArrayList<List<GrokExpression.Offset>>();
        gesr.matchOffsets = new ArrayList<GrokExpression.Offset>();
        try {
            grok = new GrokExpression(grokExpression);
        }
        catch (IllegalArgumentException e) {
            throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, e.getMessage());
        }
        String[] stringArray = twr.table;
        synchronized (twr.table) {
            gesr.table.fill(twr.table, twr.filters, data.coloring, data.columnsSelection);
            // ** MonitorExit[var20_23] (shouldn't be in output)
            for (String text : gesr.table.content) {
                List<GrokExpression.Offset> capturedOffsets = grok.getCaptureOffsets(text);
                GrokExpression.Offset matchedOffsets = grok.getMatchOffset(text);
                gesr.captureOffsets.add(capturedOffsets);
                gesr.matchOffsets.add(matchedOffsets);
                if (!capturedOffsets.isEmpty() && !matchedOffsets.noMatch()) {
                    ++gesr.matchedLines;
                }
                ++gesr.processedLines;
            }
            return gesr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/get-capture-chunk"})
    public void getCaptureChunk(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String streamingEndpointId, @RequestParam String data, @RequestParam String requestedSampleId, @RequestParam int firstRow, @RequestParam int nbRows, @RequestParam int firstCol, @RequestParam int nbCols, @RequestParam String filters) throws Exception {
        StreamingEndpoint se;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        MemScriptRunner.TableWithReport twr = this.service.get_NOTRANSACTION(se, ss.deepCopy(), requestedSampleId, (FilterRequest)JSON.parse((String)filters, FilterRequest.class), true, user);
        SerializedTableChunk stc = new SerializedTableChunk(firstRow, nbRows, firstCol, nbCols);
        MemTable memTable = twr.table;
        synchronized (memTable) {
            stc.fill(twr.table, twr.filters, ss.coloring, ss.columnsSelection);
        }
        DataController.writeJSON((HttpServletResponse)resp, (Object)stc);
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/detailed-column-analysis"})
    public void detailedSingleColumnAnalysis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam(required=false) String datasetName, @RequestParam(required=false) String streamingEndpointId, @RequestParam String data, @RequestParam String column, @RequestParam int alphanumMaxResults, @RequestParam String requestedSampleId, @RequestParam String fullSamplePartitionId, @RequestParam(required=false, defaultValue="true") boolean withFullSampleStatistics, @RequestParam(required=false, defaultValue="false") boolean forceTimePeriodAnalysis) throws Exception {
        DataService.ColumnDetailedAnalysis detailedColumnAnalysis;
        AuthCtx user;
        Dataset ds = null;
        StreamingEndpoint se = null;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        ss.contextProjectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)datasetName)) {
                this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
                ds = this.datasetAccessService.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, datasetName));
            } else {
                this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
            }
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        if (ds != null) {
            detailedColumnAnalysis = this.service.getDetailedColumnAnalysis_NT(user, requestedSampleId, ds, ss, column, alphanumMaxResults, forceTimePeriodAnalysis);
            Partition partition = ds.getPartitioningSchema() != null && ds.getPartitioningSchema().isPartitioned() ? MetricsComputationService.makePartitionFromId(ds.getPartitioningSchema(), fullSamplePartitionId) : Partition.newNP();
            if (withFullSampleStatistics) {
                detailedColumnAnalysis.fullSampleAnalysis = this.metricsService.getDetailedColumnMetrics_NT(ds, column, partition, user);
            }
        } else {
            detailedColumnAnalysis = this.service.getDetailedColumnAnalysis_NT(user, requestedSampleId, se, ss, column, alphanumMaxResults, forceTimePeriodAnalysis);
        }
        DataController.writeJSON((HttpServletResponse)resp, (Object)detailedColumnAnalysis);
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/text-analysis"})
    public void getTextAnalysis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data, @RequestParam String column, @RequestParam String simplificationParameters, @RequestParam String requestedSampleId) throws Exception {
        Dataset ds;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        DataController.writeJSON((HttpServletResponse)resp, (Object)this.service.getTextAnalysis(user, requestedSampleId, ds, ss, column, (TextSimplifier.Parameter)((Object)JSON.parse((String)simplificationParameters, TextSimplifier.Parameter.class))));
    }

    @AuditedCall(value={"msgType", "dataset-list-topn-values", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/list-topn-values"})
    @ResponseBody
    public Map<String, List<String>> listTopNValues(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam SerializedShakerScript shakerScript, @RequestParam List<String> columns, @RequestParam int n, @RequestParam String requestedSampleId) throws Exception {
        Dataset ds;
        AuthCtx user;
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"Cannot list top N values with N < 0");
        Preconditions.checkArgument((n <= 99 ? 1 : 0) != 0, (Object)"Cannot list top N values with N > 99");
        shakerScript.contextProjectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            SmartObjectRef ref = SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey);
            this.projectsService.failIfNoDashboardReadPermission(user, ref, contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, shakerScript);
        }
        return this.service.getTopNDistinctValues_NT(user, StringUtils.defaultIfBlank((String)requestedSampleId, null), ds, shakerScript, columns, n);
    }

    @AuditedCall(value={"msgType", "dataset-list-distinct-values", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/list-distinct-values"})
    @ResponseBody
    public Collection<String> listDistinctValues(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam SerializedShakerScript shakerScript, @RequestParam List<String> columns, @RequestParam int maxValueCount, @RequestParam String requestedSampleId) throws Exception {
        Dataset ds;
        AuthCtx user;
        shakerScript.contextProjectKey = projectKey;
        Preconditions.checkArgument((maxValueCount <= 2000 ? 1 : 0) != 0, (Object)"Cannot list more than 2000 distinct values");
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            SmartObjectRef ref = SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey);
            this.projectsService.failIfNoDashboardReadPermission(user, ref, contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, shakerScript);
        }
        return this.service.getDistinctValues_NT(user, StringUtils.defaultIfBlank((String)requestedSampleId, null), ds, shakerScript, columns, maxValueCount);
    }

    @AuditedCall(value={"msgType", "dataset-auto-detect-categories-for-image-view", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/auto-detect-categories-for-image-view"})
    public void autoDetectCategoriesForImageView(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String imageViewSettings) throws Exception {
        SerializedShakerScript script;
        Dataset dataset;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            script = this.exploresService.getUnsafe((String)projectKey, (String)datasetName).script;
            ShakerUtils.checkScriptCodePermission(user, script);
        }
        ImageViewSettings actualSettings = (ImageViewSettings)JSON.parse((String)imageViewSettings, ImageViewSettings.class);
        this.checkImageViewSettings(actualSettings);
        DataController.writeJSON((HttpServletResponse)resp, this.service.autoDetectCategoriesFromAnnotations(user, dataset, script, actualSettings.annotationParams.annotationColumn, DataService.CategoryBasedAnnotationType.valueOf(actualSettings.annotationParams.annotationType.name())));
    }

    private void checkImageViewSettings(ImageViewSettings imageViewSettings) {
        if (imageViewSettings == null) {
            throw new IllegalArgumentException("Image view settings must be defined to detect classes");
        }
        if (imageViewSettings.annotationParams == null || !imageViewSettings.annotationParams.enabled) {
            throw new IllegalArgumentException("Annotations must be enabled to detect classes");
        }
        if (imageViewSettings.annotationParams.annotationType == null) {
            throw new IllegalArgumentException("Annotation type must be defined to detect classes");
        }
        if (imageViewSettings.annotationParams.annotationColumn == null) {
            throw new IllegalArgumentException("Annotation column must be defined to detect classes");
        }
    }

    @AuditedCall(value={"msgType", "dataset-auto-detect-categories", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "annotationColumn", "${annotationColumn}", "annotationType", "${annotationType}"})
    @RequestMapping(value={"/api/shaker/auto-detect-categories"})
    public void autoDetectCategoriesFromAnnotations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String annotationColumn, @RequestParam DataService.CategoryBasedAnnotationType annotationType) throws Exception {
        SerializedShakerScript script;
        Dataset dataset;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            script = this.exploresService.getUnsafe((String)projectKey, (String)datasetName).script;
            ShakerUtils.checkScriptCodePermission(user, script);
        }
        DataController.writeJSON((HttpServletResponse)resp, this.service.autoDetectCategoriesFromAnnotations(user, dataset, script, annotationColumn, annotationType));
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/multi-column-analysis"})
    public void getColumnsData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam(required=false) String datasetName, @RequestParam(required=false) String streamingEndpointId, @RequestParam String data, @RequestParam(value="columns[]", required=true) String[] columns, @RequestParam(value="compute", required=true) String compute, @RequestParam(value="requestedSampleId") String requestedSampleId, @RequestParam(value="histogram", required=false, defaultValue="1") Integer histogram) throws Exception {
        AuthCtx user;
        if (StringUtils.isBlank((String)datasetName) && StringUtils.isBlank((String)streamingEndpointId)) {
            throw new IllegalArgumentException("A dataset or a streaming endpoint is needed");
        }
        Dataset ds = null;
        StreamingEndpoint se = null;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)datasetName)) {
                this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
                ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            } else {
                this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
            }
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        if (ds != null) {
            DataController.writeJSON((HttpServletResponse)resp, this.service.startMultiColumnAnalysis(user, requestedSampleId, ds, ss, columns, compute, histogram));
        } else {
            DataController.writeJSON((HttpServletResponse)resp, this.service.startMultiColumnAnalysis(user, requestedSampleId, se, ss, columns, compute, histogram));
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/multi-column-full-analysis"})
    public void getColumnsFullData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, String projectKey, String datasetName, String data, @RequestParam(value="columns[]", required=true) String[] columns, @RequestParam(required=false) String fullSamplePartitionId) throws Exception {
        Dataset ds;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        Partition partition = ds.getPartitioningSchema() != null && ds.getPartitioningSchema().isPartitioned() ? MetricsComputationService.makePartitionFromId(ds.getPartitioningSchema(), fullSamplePartitionId) : Partition.newNP();
        DataController.writeJSON((HttpServletResponse)resp, this.metricsService.getMultiColumnMetrics_NT(ds, columns, partition, user));
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/get-clusters"})
    public void getClusters(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, String datasetName, String data, @RequestParam(value="column", required=true) String column, @RequestParam(value="requestedSampleId") String requestedSampleId, @RequestParam(value="setBased", required=true) boolean setBased, @RequestParam(value="radius", required=true) float radius, @RequestParam(value="timeOut", required=true) int timeOut, @RequestParam(value="blockSize", required=true) int blockSize) throws Exception {
        Dataset ds;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        MemTable table = this.service.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        CategoryClusterer clusterer = new CategoryClusterer(setBased, radius, timeOut, blockSize);
        clusterer.clusterize(table, column);
        DataController.writeJSON((HttpServletResponse)resp, (Object)clusterer.getClusters());
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/smart-extractor"})
    @ResponseBody
    public FutureResponse<InteractiveExtractor.ExtractorResponse> smartExtractor(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, final @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam SerializedShakerScript data, final @RequestParam String column, @RequestParam(required=false, defaultValue="") FilterRequest filters, @RequestParam String requestedSampleId, final @RequestParam List<InteractiveExtractor.Selection> selections, final @RequestParam List<String> excluded, final @RequestParam String customRegex, final @RequestParam(required=false, defaultValue="false") boolean onColumnNames, final @RequestParam(required=false, defaultValue="") String firstString) throws Exception {
        Dataset ds;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, data);
        }
        final MemScriptRunner.TableWithReport twr = this.service.get_NOTRANSACTION(ds, data.deepCopy(), requestedSampleId, filters, true, user);
        SimpleFutureThread<InteractiveExtractor.ExtractorResponse> futureThread = new SimpleFutureThread<InteractiveExtractor.ExtractorResponse>(user){

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"Smart Extractor", (String)("Smart Extractor " + projectKey));
            }

            @Override
            protected InteractiveExtractor.ExtractorResponse compute() throws Exception {
                return DataController.this.interactiveDataPreparationService.generateSmartPattern(twr, column, onColumnNames, selections, excluded, customRegex, firstString);
            }
        };
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<InteractiveExtractor.ExtractorResponse>>(){});
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/smart-date-guess"})
    public void smartDateGuess(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, String datasetName, String data, @RequestParam(value="column", required=true) String column, @RequestParam(value="requestedSampleId") String requestedSampleId) throws Exception {
        Dataset ds;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        MemTable table = this.service.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        SmartDateService sds = new SmartDateService();
        SmartDateService.GuessResponse ret = sds.guess(table, column);
        DataController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/smart-date-validate"})
    public void smartDateValidate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, String datasetName, String data, @RequestParam(value="column", required=true) String column, @RequestParam(value="format", required=true) String format, @RequestParam(value="requestedSampleId") String requestedSampleId) throws Exception {
        Dataset ds;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        MemTable table = this.service.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        SmartDateService sds = new SmartDateService();
        SmartDateService.GuessFormat gf = sds.validate(table, column, format, 1);
        DataController.writeJSON((HttpServletResponse)resp, (Object)gf);
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/suggestion-preview"})
    public void suggestionPreview(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data, @RequestParam(value="column", required=true) String column, @RequestParam(value="regex", required=true) String regex, @RequestParam(value="requestedSampleId") String requestedSampleId) throws Exception {
        Dataset ds;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDatasetReadUseAccess(user, new AnyLoc(projectKey, datasetName), contextProjectKey);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        MemTable table = this.service.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        SuggestionEngineService ses = new SuggestionEngineService();
        SuggestionEngineService.SuggestionPreview preview = ses.validate(table, column, regex);
        DataController.writeJSON((HttpServletResponse)resp, (Object)preview);
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${datasetProjectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/fix-expression"})
    public void fixExpression(HttpServletRequest req, HttpServletResponse resp, String projectKey, String datasetProjectKey, String datasetName, String data, String expression, String fixName, String requestedSampleId, @RequestParam(required=false, defaultValue="-1") int stepId, @RequestParam(required=false, defaultValue="-1") int subStepId, @RequestParam(required=false, defaultValue="-1") int stepDepth, @RequestParam(required=false, defaultValue="false") boolean copyScriptFromExplore, @RequestParam(required=false, defaultValue="false") boolean useUDAFRegistry) throws Exception {
        Dataset ds;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ds = this.datasetAccessService.getMandatory(datasetProjectKey, datasetName);
            if (copyScriptFromExplore) {
                ss = this.exploresService.get((String)datasetProjectKey, (String)datasetName).script;
                ss.contextProjectKey = projectKey;
                ss.origin = SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
            }
            ShakerUtils.checkScriptCodePermission(this.authService.getMandatoryUser(req), ss);
        }
        if (stepId != 1 && subStepId != -1 && stepDepth != -1) {
            this.shortenStepsListTo(ss.steps, stepId, subStepId, stepDepth);
        }
        MemTable table = this.service.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
        String fixedExpression = this.expressionFixingService.fixExpression(expression, fixName, projectKey, table, useUDAFRegistry ? UdafControlFunctionRegistry.getInstance() : GrelControlFunctionRegistry.getInstance());
        DataController.writeJSON((HttpServletResponse)resp, (Object)fixedExpression);
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${datasetProjectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/validate-expression"})
    @ResponseBody
    public FutureResponse<ValidateExpressionResponse> validateExpression(HttpServletRequest req, HttpServletResponse resp, String projectKey, String datasetProjectKey, String datasetName, String data, String expression, String requestedSampleId, int stepId, int subStepId, int stepDepth, boolean avoidRepeatingFormulaInError) throws Exception {
        StepParams stepParams;
        ScriptStep step;
        Dataset ds;
        DSSAuthCtx user;
        SerializedShakerScript sss = data == null ? null : (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ds = this.datasetAccessService.getMandatory(datasetProjectKey, datasetName);
            if (sss == null) {
                SerializedShakerScript exploreScript = this.exploresService.getUnsafe((String)projectKey, (String)ds.getSmartName((String)projectKey)).script;
                sss = exploreScript.deepCopy();
                sss.contextProjectKey = projectKey;
            }
            ShakerUtils.checkScriptCodePermission(user, sss);
        }
        requestedSampleId = StringUtils.isEmpty((String)requestedSampleId) ? null : requestedSampleId;
        String outputColumn = null;
        if (!sss.steps.isEmpty() && (step = this.shortenStepsListTo(sss.steps, stepId, subStepId, stepDepth)) instanceof ProcessorScriptStep && (stepParams = ((ProcessorScriptStep)step).params) instanceof CreateColumnWithGREL.Parameter) {
            outputColumn = ((CreateColumnWithGREL.Parameter)stepParams).column;
        }
        ValidateAndPreviewGrelExpressionFutureThread futureThread = new ValidateAndPreviewGrelExpressionFutureThread(user, projectKey, ds, sss, expression, requestedSampleId, avoidRepeatingFormulaInError, outputColumn);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<ValidateExpressionResponse>>(){});
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/preview-column"})
    @ResponseBody
    public FutureResponse<PreviewColumnResponse> previewColumn(HttpServletRequest req, HttpServletResponse resp, String projectKey, String datasetName, String columnName) throws Exception {
        SerializedShakerScript exploreScript;
        Dataset dataset;
        DSSAuthCtx user;
        AnyLoc datasetFullId = AnyLoc.resolveSmart(projectKey, datasetName);
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatory(datasetFullId.getProjectKey(), datasetFullId.getId());
            exploreScript = this.exploresService.getUnsafe((String)projectKey, (String)datasetFullId.getSmartName((String)projectKey)).script;
        }
        SerializedShakerScript script = exploreScript.deepCopy();
        script.contextProjectKey = projectKey;
        script.steps.clear();
        PreviewColumnFutureThread futureThread = new PreviewColumnFutureThread(user, dataset, script, columnName);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<PreviewColumnResponse>>(){});
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/shaker/convert-to-ascii"})
    @ResponseBody
    public JSON.StringList convertToAscii(HttpServletRequest req, HttpServletResponse resp, String inputs, boolean lowercase, boolean replaceNonAlphanumByUnderscore) throws Exception {
        JSON.StringList sl = (JSON.StringList)JSON.parse((String)inputs, JSON.StringList.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        JSON.StringList output = new JSON.StringList();
        for (String i : sl) {
            if (replaceNonAlphanumByUnderscore) {
                output.add((Object)ASCIITransliterator.transliterateToASCIIAlphanumAndUnderscore(i, lowercase, "na"));
                continue;
            }
            output.add((Object)ASCIITransliterator.transliterateToASCII(i, lowercase));
        }
        return output;
    }

    @AuditedCall(value={"msgType", "dataset-read-data-sample", "projectKey", "${datasetProjectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/shaker/validate-udf"})
    public void validateUdf(HttpServletRequest req, HttpServletResponse resp, String projectKey, String datasetProjectKey, String datasetName, String data, String udf, String requestedSampleId, int stepId, int subStepId, int stepDepth) throws Exception {
        Dataset ds;
        AuthCtx user;
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        ValidateExpressionResponse vgr = new ValidateExpressionResponse();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (!user.isSafeCodeAllowed()) {
                throw new SecurityException("You do not have the required permission to run code");
            }
            ds = this.datasetAccessService.getMandatory(datasetProjectKey, datasetName);
            ShakerUtils.checkScriptCodePermission(this.authService.getMandatoryUser(req), ss);
        }
        try {
            ScriptStep lastStep = this.shortenStepsListTo(ss.steps, stepId, subStepId, stepDepth);
            if (!(lastStep instanceof ProcessorScriptStep)) {
                throw new IllegalArgumentException("Cannot validate python udf: step not a processor");
            }
            ProcessorScriptStep processorStep = (ProcessorScriptStep)lastStep;
            if (!processorStep.type.equals(PythonUDF.META.getName())) {
                throw new IllegalArgumentException("Cannot validate python: step not a python udf");
            }
            VariablesContext vc = this.variablesService.getForProject(projectKey);
            MemTable table = this.service.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)ss.deepCopy(), (String)requestedSampleId, null, (boolean)true, (AuthCtx)user).table;
            MemTable.MemTableChange change = table.createMemTableChange();
            PythonParameter params = (PythonParameter)processorStep.params;
            if (params.useKernel) {
                user.failIfNoSafeCode("You do not have the required permission to run code");
            } else {
                user.failIfNoUnsafeCode("You do not have the required permission to run code");
            }
            params.pythonSourceCode = udf;
            params = (PythonParameter)PythonUDF.META.expandParams(params, vc);
            params.column = "Sample output";
            PythonUDF processor = PythonUDF.META.build(params);
            processor.setCf(table);
            processor.setProcessorOutput((ProcessorOutput)new MemTableAppendingOutput(table));
            processor.spawn(user, projectKey, true, null);
            try {
                processor.init();
                int found = 0;
                for (int i = 0; i < table.nrows(); ++i) {
                    processor.processRow(table.rows.get(i));
                    if (found++ == 10) break;
                }
                processor.postProcess();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to test the processor", (Throwable)e);
                processor.cancel();
            }
            ArrayList inputColumns = Lists.newArrayList();
            for (Column column : table.columns()) {
                inputColumns.add(column.getName());
            }
            VerySimpleTable vst = new VerySimpleTable(inputColumns);
            for (int rowIdx = change.rowsBefore; rowIdx < table.nrows(); ++rowIdx) {
                VerySimpleTable.Row outRow = vst.newRow();
                MemRow row = table.rows.get(rowIdx);
                for (Column column : table.columns()) {
                    outRow.with(row.get(column));
                }
            }
            vgr.ok = true;
            vgr.table = vst;
        }
        catch (Exception e) {
            String exceptionMessage = e.getMessage();
            logger.info((Object)("Validate Python UDF failed (" + exceptionMessage + ")"), (Throwable)e);
            vgr.ok = false;
            vgr.message = exceptionMessage;
        }
        DataController.writeJSON((HttpServletResponse)resp, (Object)vgr);
    }

    @RequestMapping(value={"/api/shaker/ai-completion"})
    @ResponseBody
    public FutureResponse<AICompletionService.AICompletionFrontendResponse> aiComplete(HttpServletRequest req, HttpServletResponse resp, String projectKey, String datasetName, String data, String query, String requestedSampleId, @RequestParam(required=false) String previousRequestId) throws Exception {
        Dataset ds;
        DSSAuthCtx user;
        SerializedShakerScript sss = data == null ? null : (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            if (sss == null) {
                SerializedShakerScript exploreScript = this.exploresService.getUnsafe((String)projectKey, (String)ds.getSmartName((String)projectKey)).script;
                sss = exploreScript.deepCopy();
                sss.contextProjectKey = projectKey;
            }
            ShakerUtils.checkScriptCodePermission(user, sss);
        }
        requestedSampleId = StringUtils.isEmpty((String)requestedSampleId) ? null : requestedSampleId;
        return this.aiCompletionService.startCompletion(user, projectKey, ds, sss, query, requestedSampleId, previousRequestId);
    }

    private <T extends ScriptStep> ScriptStep shortenStepsListTo(List<T> steps, int stepId, int subStepId, int stepDepth) {
        for (ScriptStep step : steps) {
            step.preview = false;
        }
        ScriptStep step = (ScriptStep)steps.get(stepId);
        while (steps.size() > stepId) {
            steps.remove(steps.size() - 1);
        }
        if (stepDepth == 1) {
            steps.add(step);
            GroupScriptStep groupStep = (GroupScriptStep)step;
            return this.shortenStepsListTo(groupStep.steps, subStepId, -1, 0);
        }
        return step;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/shaker/randomize-colors"})
    public void randomizeColors(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.tableColoringService.randomizeColors();
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/shaker/compute-relative-date-interval"})
    public void computeRelativeDateInterval(HttpServletRequest req, HttpServletResponse resp, @RequestParam RelativeDateIntervalParams params) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        ReadableInterval bounds = DateRelativeFilterHelper.computeInterval(params.part, params.option, (ReadableInstant)DateTime.now());
        RelativeDateInterval result = new RelativeDateInterval(DKUDateUtils.isoFormatUTC((long)bounds.getStartMillis()), DKUDateUtils.isoFormatUTC((long)bounds.getEndMillis()));
        DataController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditInline
    @UserLocaleAware
    @RequestMapping(value={"/api/shaker/charts/get-columns-summary"}, method={RequestMethod.POST})
    public void getColumnsSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dataSpec) throws Exception {
        ChartsOnDatasetDataSpec spec = (ChartsOnDatasetDataSpec)JSON.parse((String)dataSpec, ChartsOnDatasetDataSpec.class);
        try {
            AbstractSQLConnection connection;
            Dataset dataset;
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.failIfNoDashboardReadPermission(authCtx, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, spec.datasetProjectKey, spec.datasetName, projectKey), projectKey);
                dataset = this.datasetAccessService.getMandatory(spec.datasetProjectKey, spec.datasetName);
                connection = DatasetInspector.isSQLAbleAndSQLTable(authCtx, dataset) ? DatasetInspector.getDSSConnectionForSQLAbleDatasetOrHive(authCtx, dataset) : null;
                if (spec.copyScriptFromExplore) {
                    spec.script = this.exploresService.get((String)projectKey, (String)spec.datasetName).script;
                    spec.script.contextProjectKey = projectKey;
                    spec.script.origin = SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
                }
                spec.script.contextProjectKey = projectKey;
                ShakerUtils.checkScriptCodePermission(authCtx, spec.script);
            }
            DataController.writeJSON((HttpServletResponse)resp, (Object)this.tablesService.getColumnSummary_NT(authCtx, dataset, connection, spec));
            this.auditTrailService.generic("dataset-charts-read").with("projectKey", spec.datasetProjectKey).with("datasetName", spec.datasetName).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("dataset-charts-read", (Throwable)e).with("projectKey", spec.datasetProjectKey).with("datasetName", spec.datasetName).emit();
            throw e;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"api/shaker/convert-to-geojson"}, method={RequestMethod.POST})
    public void convertToGeoJSON(HttpServletRequest req, HttpServletResponse resp, @RequestParam String cellGeometry) throws IOException, ParseException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        String geoJson = GeoJSONUtils.convertSupportedFormatsToGeoJSON(cellGeometry);
        DataController.writeJSON((HttpServletResponse)resp, (Object)geoJson);
    }

    @AuditInline
    @RequestMapping(value={"/api/shaker/charts/metadata"}, method={RequestMethod.POST})
    public void getChartsMetaData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String chartsData) throws Exception {
        List specs = (List)JSON.parse((String)chartsData, (TypeToken)new TypeToken<ArrayList<ChartSampleMetadataRequest>>(){});
        ArrayList<SampleMetadata> result = new ArrayList<SampleMetadata>();
        HashMap<Pair, Dataset> cachedDataset = new HashMap<Pair, Dataset>();
        HashMap<Pair, MemTable> cachedMemtable = new HashMap<Pair, MemTable>();
        try {
            AuthCtx user;
            try (Transaction t = this.transactionService.beginRead();){
                user = this.authService.getMandatoryUser(req);
            }
            for (int i = 0; i < specs.size(); ++i) {
                ChartSampleMetadataRequest chartData = (ChartSampleMetadataRequest)specs.get(i);
                ChartsOnDatasetDataSpec spec = chartData.dataSpec;
                NDC.push((String)("pivot-" + projectKey + "/" + spec.datasetName));
                try {
                    if (!spec.engineType.equals((Object)SerializedShakerScript.ChartsEngine.LINO)) {
                        SampleMetadata sampleMetadata = new SampleMetadata();
                        sampleMetadata.sampleIsWholeDataset = true;
                        result.add(sampleMetadata);
                    } else {
                        Pair pair = new Pair((Object)spec.datasetProjectKey, (Object)spec.datasetName);
                        try (Transaction t = this.transactionService.beginRead();){
                            if (!cachedDataset.containsKey(pair)) {
                                this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, spec.datasetProjectKey, spec.datasetName, projectKey), projectKey);
                                SerializedDataset sds = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(spec.datasetProjectKey, spec.datasetName);
                                cachedDataset.put(pair, Dataset.fromSerializedUnsafe(sds));
                            }
                            if (spec.copyScriptFromExplore) {
                                spec.script = this.exploresService.get((String)projectKey, (String)spec.datasetName).script;
                                spec.script.origin = SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
                            }
                            spec.script.contextProjectKey = projectKey;
                            ShakerUtils.checkScriptCodePermission(user, spec.script);
                        }
                        if (StringUtils.isNotBlank((String)chartData.sampleId)) {
                            result.add(this.chartSampleMetaDataService.getChartSampleMetaData_NT((Dataset)cachedDataset.get(pair), spec, chartData.sampleId));
                        } else {
                            if (!cachedMemtable.containsKey(pair)) {
                                cachedMemtable.put(pair, this.service.get_NOTRANSACTION((Dataset)((Dataset)cachedDataset.get((Object)pair)), (SerializedShakerScript)spec.script, null, null, (boolean)true, (AuthCtx)user).table);
                            }
                            result.add(this.chartSampleMetaDataService.getChartSampleMetaData_NT(user, (Dataset)cachedDataset.get(pair), spec, (MemTable)cachedMemtable.get(pair)));
                        }
                    }
                    this.auditTrailService.generic("dataset-charts-read-metadata").with("projectKey", projectKey).with("datasetName", spec.datasetName).with("chartNumber", (Number)i).emit();
                    continue;
                }
                catch (Exception e) {
                    this.auditTrailService.failure("dataset-charts-read-metadata", (Throwable)e).with("projectKey", projectKey).with("datasetName", spec.datasetName).with("chartNumber", (Number)i).emit();
                    throw e;
                }
                finally {
                    NDC.pop();
                }
            }
            this.auditTrailService.generic("dataset-charts-read-metadata").with("projectKey", projectKey).emit();
            DataController.writeJSON((HttpServletResponse)resp, result);
        }
        catch (Exception e) {
            this.auditTrailService.failure("dataset-charts-read-metadata", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
        finally {
            cachedDataset.clear();
            cachedMemtable.clear();
        }
    }

    @AuditInline
    @UserLocaleAware
    @RequestMapping(value={"/api/shaker/charts/get-pivot-response"})
    public void getPivotResponse(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dataSpec, @RequestParam String request, String requestedSampleId) throws Exception {
        ChartsOnDatasetDataSpec spec = (ChartsOnDatasetDataSpec)JSON.parse((String)dataSpec, ChartsOnDatasetDataSpec.class);
        NDC.push((String)("pivot-" + projectKey + "/" + spec.datasetName));
        try {
            AbstractSQLConnection connection;
            Dataset ds;
            AuthCtx user;
            PivotTableRequest preq = (PivotTableRequest)JSON.parse((String)request, PivotTableRequest.class);
            try (Transaction t = this.transactionService.beginRead();){
                user = this.authService.getMandatoryUser(req);
                this.projectsService.failIfNoDashboardReadPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, spec.datasetProjectKey, spec.datasetName, projectKey), projectKey);
                SerializedDataset sds = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(spec.datasetProjectKey, spec.datasetName);
                ds = Dataset.fromSerializedUnsafe(sds);
                connection = DatasetInspector.isSQLAbleAndSQLTable(user, ds) ? DatasetInspector.getDSSConnectionForSQLAbleDatasetOrHive(user, ds) : null;
                if (spec.copyScriptFromExplore) {
                    spec.script = this.exploresService.get((String)projectKey, (String)spec.datasetName).script;
                    spec.script.origin = SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
                }
                spec.script.contextProjectKey = projectKey;
                ShakerUtils.checkScriptCodePermission(user, spec.script);
                DatasetSelection selectionToCheck = spec.copySelectionFromScript ? spec.script.explorationSampling.selection : spec.sampleSettings.selection;
                this.permissionsService.checkUserDefinedCustomSqlFilters(user, ds, selectionToCheck);
            }
            DataController.writeJSONNoNaN((HttpServletResponse)resp, this.tablesService.getResponse_NT(user, ds, connection, requestedSampleId, spec, preq));
            this.auditTrailService.generic("dataset-charts-read").with("projectKey", spec.datasetProjectKey).with("datasetName", spec.datasetName).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("dataset-charts-read", (Throwable)e).with("projectKey", spec.datasetProjectKey).with("datasetName", spec.datasetName).emit();
            throw e;
        }
        finally {
            NDC.pop();
        }
    }

    private void checkDataExportEnabled() throws Exception {
        Params params = ApplicationConfigurator.getParams();
        if (params.getBoolParam("dku.exports.disableAllDataExports", false) || params.getBoolParam("dku.exports.disableAllExports", false)) {
            throw new UnauthorizedException("Data exports have been forbidden by your administrator", "dataset-export-forbidden");
        }
    }

    @AuditedCall(value={"msgType", "chart-excel-export"})
    @RequestMapping(value={"/api/shaker/charts/excel-export"})
    public void exportToExcel(HttpServletRequest req, HttpServletResponse resp, String chartDef, String pivotResponse, @RequestParam(required=false, defaultValue="-1") int animationFrameIdx, @RequestParam(required=false) String colorMaps) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        this.checkDataExportEnabled();
        ChartDef parsedUIChartDef = (ChartDef)JSON.parse((String)chartDef, ChartDef.class);
        PivotTableTensorResponse parsedPivotResponse = (PivotTableTensorResponse)JSON.parse((String)pivotResponse, PivotTableTensorResponse.class);
        ObjectMapper objectMapper = new ObjectMapper();
        List parsedColorMap = colorMaps != null ? (List)objectMapper.readValue(colorMaps, (TypeReference)new TypeReference<List<FontFormatting>>(){}) : null;
        String id = this.excelChartService.createExcelChart(parsedUIChartDef, parsedPivotResponse, animationFrameIdx, parsedColorMap);
        HashMap<String, String> out = new HashMap<String, String>();
        out.put("id", id);
        DataController.writeJSON((HttpServletResponse)resp, out);
    }

    @AuditedCall(value={"msgType", "chart-excel-export"})
    @RequestMapping(value={"/api/shaker/charts/excel-download"})
    public void downloadExcel(HttpServletRequest req, HttpServletResponse resp, String id) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        this.excelChartService.handleDownloadRequest(id, resp);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/shaker/get-last-known-currency-rate-date"})
    public void getLastKnownCurrencyRateDate(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        DataController.writeJSON((HttpServletResponse)resp, (Object)CurrencyConverterAlgorithm.getInstance((File)CurrencyDataUtils.getStandardResourceFile()).getCurrenciesData().getLastKnownRateDate());
    }

    static {
        DKUtils.forceInit(PivotTableRequest.class);
        DKUtils.forceInit(PivotTableResponse.class);
        logger = DKULogger.getLogger((String)"dku.shaker.controller");
    }

    class RefreshCaptureFutureThread
    extends FutureThread<SerializedMemTableV2> {
        final StreamingEndpoint streamingEndpoint;
        String requestedSampleId;
        final SerializedShakerScript sss;
        FilterRequest frequest;
        boolean allowCache;
        private final FuturePayload futurePayload;
        SerializedMemTableV2 result;

        public RefreshCaptureFutureThread(DSSAuthCtx owner, StreamingEndpoint streamingEndpoint, SerializedShakerScript sss, boolean allowCache) {
            super(owner);
            this.result = new SerializedMemTableV2();
            this.streamingEndpoint = streamingEndpoint;
            this.sss = sss;
            this.allowCache = allowCache;
            this.futurePayload = DataController.buildFuturePayload(streamingEndpoint);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public SerializedMemTableV2 getResult() {
            return this.result;
        }

        public double getDangerosity() {
            return 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws Exception {
            NDC.push((String)("refresh-table: " + this.streamingEndpoint.getProjectKey() + "-" + this.streamingEndpoint.getId()));
            try {
                if (this.sss.steps.size() >= 20) {
                    DataController.this.achievementService.win(this.owner, AchievementsService.AchievementId.NOT_QUITE_PARKINSON);
                } else if (this.sss.steps.size() >= 5) {
                    DataController.this.achievementService.win(this.owner, AchievementsService.AchievementId.APPRENTICE_BARTENDER);
                }
                long before = System.currentTimeMillis();
                MemScriptRunner.TableWithReport twr = DataController.this.service.get_NOTRANSACTION(this.streamingEndpoint, this.sss.deepCopy(), this.requestedSampleId, this.frequest, this.allowCache, (AuthCtx)this.owner);
                MemTable memTable = twr.table;
                synchronized (memTable) {
                    this.result.fill(twr, this.sss, 64, 32);
                }
                long after = System.currentTimeMillis();
                if (after - before > 60000L) {
                    DataController.this.achievementService.win(this.owner, AchievementsService.AchievementId.SLOW_SHAKE_3);
                } else if (after - before > 25000L) {
                    DataController.this.achievementService.win(this.owner, AchievementsService.AchievementId.SLOW_SHAKE_2);
                } else if (after - before > 10000L) {
                    DataController.this.achievementService.win(this.owner, AchievementsService.AchievementId.SLOW_SHAKE_1);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get table data", (Throwable)e);
                throw e;
            }
            finally {
                NDC.pop();
            }
        }
    }

    class ValidateAndPreviewGrelExpressionFutureThread
    extends SimpleFutureThread<ValidateExpressionResponse> {
        private final String projectKey;
        private final Dataset dataset;
        private final String requestedSampleId;
        private final SerializedShakerScript sss;
        private final String expression;
        private final boolean avoidRepeatingFormulaInError;
        private final String outputColumn;

        public ValidateAndPreviewGrelExpressionFutureThread(DSSAuthCtx owner, String projectKey, Dataset dataset, SerializedShakerScript sss, String expression, String requestedSampleId, boolean avoidRepeatingFormulaInError, String outputColumn) {
            super((AuthCtx)owner);
            this.projectKey = projectKey;
            this.dataset = dataset;
            this.requestedSampleId = requestedSampleId;
            this.sss = sss;
            this.expression = expression;
            this.avoidRepeatingFormulaInError = avoidRepeatingFormulaInError;
            this.outputColumn = outputColumn;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"validate_and_preview_grel_expression", (String)"Validate and preview expression");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ValidateExpressionResponse compute() throws Exception {
            ValidateExpressionResponse vgr = new ValidateExpressionResponse();
            NDC.push((String)("grel-preview: " + this.dataset.getProjectKey() + "-" + this.dataset.getName()));
            logger.info((Object)("Starting validation of expression " + this.expression));
            try {
                VariablesContext vc = DataController.this.variablesService.getForProject(this.projectKey);
                String expandedExpression = vc.expand(this.expression);
                Expression expr = new Expression(expandedExpression, null, null, null, this.avoidRepeatingFormulaInError);
                MemTable table = DataController.this.service.get_NOTRANSACTION((Dataset)this.dataset, (SerializedShakerScript)this.sss, (String)this.requestedSampleId, null, (boolean)true, (AuthCtx)this.owner).table;
                expr.setColumnFactory(table);
                expr.setVariablesContext(vc);
                ArrayList<String> inputColumns = new ArrayList<String>(expr.getVariables());
                inputColumns.add(0, "Sample output");
                ArrayList<String> sampleColumns = new ArrayList<String>(inputColumns);
                if (this.outputColumn != null && this.dataset.getSchema().getColumns().stream().noneMatch(c2 -> c2.getName().equals(this.outputColumn))) {
                    sampleColumns.remove(this.outputColumn);
                }
                VerySimpleTable vst = new VerySimpleTable(sampleColumns);
                PreviousRowsBuffer previousRowsBuffer = new PreviousRowsBuffer(expr);
                for (int i = 0; i < table.nrows() && i < 10; ++i) {
                    MemRow tableRow = table.rows.get(i);
                    Object out = expr.evaluate(tableRow, previousRowsBuffer.getPreviousRows());
                    if (ExpressionUtils.isError(out)) {
                        out = "ERROR: " + String.valueOf(out);
                    }
                    VerySimpleTable.Row outRow = vst.newRow();
                    String outValue = out == null ? null : (out instanceof LocalDateTime ? out.toString().replace('T', ' ') : out.toString());
                    outRow.with(outValue);
                    for (int colIdx = 1; colIdx < sampleColumns.size(); ++colIdx) {
                        String columnName = (String)sampleColumns.get(colIdx);
                        String value = tableRow.get(table.column(columnName));
                        outRow.with(value);
                    }
                    if (!previousRowsBuffer.needBuffering()) continue;
                    previousRowsBuffer.addRow(tableRow, table, this.outputColumn, out);
                }
                vgr.displayConcatMessage = expr.hasPlusWithNotNumeric();
                vgr.displayNumvalMessage = !vgr.displayConcatMessage && expr.hasArithmeticOperatorWithNotNumeric();
                vgr.ok = true;
                vgr.table = vst;
            }
            catch (StepInitException e) {
                logger.info((Object)"Validate GREL failed", (Throwable)e);
                vgr.ok = false;
                vgr.message = e.getCause().getMessage();
            }
            catch (Exception e) {
                logger.info((Object)"Validate GREL failed", (Throwable)e);
                vgr.ok = false;
                vgr.message = e.getMessage();
            }
            finally {
                NDC.pop();
            }
            return vgr;
        }
    }

    class PreviewColumnFutureThread
    extends SimpleFutureThread<PreviewColumnResponse> {
        private final Dataset dataset;
        private final SerializedShakerScript sss;
        private final String columnName;

        public PreviewColumnFutureThread(DSSAuthCtx owner, Dataset dataset, SerializedShakerScript sss, String columnName) {
            super((AuthCtx)owner);
            this.dataset = dataset;
            this.sss = sss;
            this.columnName = columnName;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"preview_column", (String)"Preview column");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PreviewColumnResponse compute() throws Exception {
            PreviewColumnResponse response = new PreviewColumnResponse();
            NDC.push((String)("preview-column: " + this.dataset.getProjectKey() + "-" + this.dataset.getName() + "-" + this.columnName));
            try {
                MemTable table = DataController.this.service.get_NOTRANSACTION((Dataset)this.dataset, (SerializedShakerScript)this.sss, null, null, (boolean)true, (AuthCtx)this.owner).table;
                List<String> inputColumns = Collections.singletonList(this.columnName);
                VerySimpleTable vst = new VerySimpleTable(inputColumns);
                int rowCount = table.nrows();
                for (int i = 0; i < rowCount && i < 10; ++i) {
                    String value = table.rows.get(i).get(this.columnName);
                    vst.newRow().with(value);
                }
                response.ok = true;
                response.table = vst;
            }
            catch (Exception e) {
                logger.info((Object)"Preview column failed", (Throwable)e);
                response.ok = false;
                response.message = e.getMessage();
            }
            finally {
                NDC.pop();
            }
            return response;
        }
    }

    static class ValidateExpressionResponse {
        boolean ok;
        String message;
        VerySimpleTable table;
        boolean displayConcatMessage;
        boolean displayNumvalMessage;

        ValidateExpressionResponse() {
        }
    }

    public static class RelativeDateIntervalParams {
        public ChartFilter.DateFilterPart part;
        public ChartFilter.DateRelativeOption option;
        public int offset;
    }

    public static class RelativeDateInterval {
        public String start;
        public String end;

        public RelativeDateInterval(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }

    static class PreviewColumnResponse {
        boolean ok;
        String message;
        VerySimpleTable table;

        PreviewColumnResponse() {
        }
    }

    static class Value {
        String in;
        String out;

        Value() {
        }
    }
}

