/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.HiveLikeSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class ImpalaSQLDialect
extends HiveLikeSQLDialect {
    @Override
    public boolean supportsResultSetMetadataOnPreparedStatement(String sql) {
        return true;
    }

    @Override
    public String alterQueryForResultSetMetadataOnPreparedStatement(String sql) {
        return "SELECT * FROM (\n" + sql + "\n) _subquery_ LIMIT 0";
    }

    @Override
    public ResultSetMetaData getResultSetMetadataOnPreparedStatement(final PreparedStatement stmt) throws Exception {
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    stmt.cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        });){
            if (!stmt.execute()) {
                ResultSetMetaData resultSetMetaData = null;
                return resultSetMetaData;
            }
            ResultSetMetaData resultSetMetaData = stmt.getResultSet().getMetaData();
            return resultSetMetaData;
        }
    }

    @Override
    public String quoteDate(String str) {
        return "CAST(" + this.quoteString(str) + " AS TIMESTAMP)";
    }

    @Override
    public void initOperators() {
        super.initOperators();
        this.removeOperator(QueryUtils.OperatorType.MD5);
        this.removeOperator(QueryUtils.OperatorType.REGEXP_SUBSTR);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, "CONCAT", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                StringBuilder sb = new StringBuilder("CONCAT (");
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    String value = this.toSQLNoBrackets(args[i]);
                    if (ImpalaSQLDialect.this.isStringType(args[i])) {
                        sb.append(value);
                        continue;
                    }
                    sb.append(" CAST( ").append(value).append(" AS STRING)");
                }
                return sb.append(")").toString();
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.AGG_CONCAT, "group_concat", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String column = this.toSQLNoBrackets(args[0]);
                QueryAst.ConstExpr separatorExpr = (QueryAst.ConstExpr)args[1];
                String separator = (String)separatorExpr.value;
                if (separator == null) {
                    return "group_concat(CAST(" + column + " AS string), '')";
                }
                return "group_concat(CAST(" + column + " AS string), " + this.toSQLNoBrackets(separatorExpr) + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                if (percentile == 0.5) {
                    return "appx_median(" + column + ")";
                }
                return "percentile_approx(" + column + "," + percentile + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "REGEXP_LIKE(" + input + ", " + regex + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type requestedType;
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                if (args[0].outputType != null && args[0].outputType.dssType != Type.STRING) {
                    input = "CAST(" + (String)input + " AS STRING)";
                }
                if ((requestedType = this.getParamAs(args[1], Type.class)).isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = ImpalaSQLDialect.this.toDateFormat(jodaFormat, true);
                    if (requestedType == Type.DATEONLY) {
                        return "CAST(TO_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "') AS DATE)";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "TO_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "')";
                    }
                    String converted = "TO_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "')";
                    if (StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return converted;
                    }
                    return "TO_UTC_TIMESTAMP(" + converted + ", '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRY_PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    return ImpalaSQLDialect.this.getOperator(QueryUtils.OperatorType.PARSE).apply(args);
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = ImpalaSQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType.isTimestamp() && StringUtils.isNotBlank((String)timezoneId) && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        input = "FROM_UTC_TIMESTAMP(" + (String)input + ", '" + timezoneId + "')";
                    }
                    return "FROM_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " != " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String oneIsNull = null;
                if (!aIsConst && !bIsConst) {
                    oneIsNull = a2 + " IS NULL AND " + b2 + " IS NOT NULL OR " + a2 + " IS NOT NULL AND " + b2 + " IS NULL";
                } else if (!aIsConst) {
                    oneIsNull = a2 + " IS NULL";
                } else if (!bIsConst) {
                    oneIsNull = b2 + " IS NULL";
                }
                if (oneIsNull != null) {
                    ret = ret + " OR " + oneIsNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " > " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " < " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " >= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " <= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.EQ, "=", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " = " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String bothNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNull = a2 + " IS NULL AND " + b2 + " IS NULL";
                }
                if (bothNull != null) {
                    ret = ret + " OR " + bothNull;
                }
                return ret;
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.COSH, "COSH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SINH, "SINH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TANH, "TANH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.DEGREES, "DEGREES", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.RADIANS, "RADIANS", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 128;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return true;
    }

    @Override
    public boolean canStddevAsAnalyticalFunctions() {
        return false;
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        return abilities;
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    protected String monthDiffExpression(String start, String end) {
        String yyyyMMDiff = this.datePartDiffExpression(start, end, DatePart.YEAR) + " * 12 + " + this.datePartDiffExpression(start, end, DatePart.MONTH_OF_YEAR);
        String clippedStart = "concat('2000-01-', from_unixtime(" + this.datePartExpression(start, DatePart.SECOND_FROM_EPOCH) + ", 'dd HH:mm:ss'))";
        String clippedEnd = "concat('2000-01-', from_unixtime(" + this.datePartExpression(end, DatePart.SECOND_FROM_EPOCH) + ", 'dd HH:mm:ss'))";
        return "(" + yyyyMMDiff + ") + (CASE WHEN " + end + " > " + start + " THEN CASE WHEN " + clippedEnd + " < " + clippedStart + " THEN -1 ELSE 0 END ELSE CASE WHEN " + clippedEnd + " > " + clippedStart + " THEN 1 ELSE 0 END END)";
    }

    @Override
    protected String temporalTrunc(String inputDateExpression, DateRounding rounding, boolean isDateOnly) {
        String secondFromEpoch = this.temporalPartExpression(inputDateExpression, DatePart.SECOND_FROM_EPOCH);
        switch (rounding) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case WEEK: {
                return "DATE_TRUNC('" + rounding.name() + "', " + inputDateExpression + ")";
            }
            case QUARTER: {
                String yearPartStr = "CAST(" + this.temporalPartExpression(inputDateExpression, DatePart.YEAR) + " AS " + this.typeNameForCastAsString() + ")";
                String truncatedMonthNumber = "(CEIL(" + this.temporalPartExpression(inputDateExpression, DatePart.MONTH_OF_YEAR) + "/3)-1)*3+1";
                String monthZeroPrefix = "CASE WHEN (" + truncatedMonthNumber + " < 10) THEN '0' ELSE '' END";
                String truncatedMonthStr = "CAST(" + truncatedMonthNumber + " AS " + this.typeNameForCastAsString() + ")";
                String concatenated = "CONCAT(" + yearPartStr + ",'-'," + monthZeroPrefix + "," + truncatedMonthStr + ",'-01 00:00:00 Z')";
                return "TO_TIMESTAMP(" + concatenated + ", 'yyyy-MM-dd HH:mm:ss Z')";
            }
        }
        throw new UnsupportedOperation("Date truncation is not implemented for '" + String.valueOf(rounding) + "'");
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        switch (part.type) {
            case YEAR: 
            case YEAROFERA: {
                return part.shortened ? "yy" : "yyyy";
            }
            case WEEK: 
            case WEEKYEAR: {
                throw new IllegalArgumentException("Formatting to week is not available");
            }
            case MONTH: {
                if (part.numeric && part.text.length() == 1) {
                    return "M";
                }
                if (part.numeric && part.text.length() == 2) {
                    return "MM";
                }
                if (part.shortened) {
                    return "MMM";
                }
                if (forParsing) {
                    return "MMMM";
                }
                throw new IllegalArgumentException("Formatting to full month name is not available");
            }
            case DAY: {
                if (part.text.length() == 1) {
                    return "d";
                }
                return "dd";
            }
            case DAYOFYEAR: {
                throw new IllegalArgumentException("Formatting to day of year is not available");
            }
            case DAYOFWEEK: {
                throw new IllegalArgumentException("Formatting to day of week is not available");
            }
            case HOUR: {
                if (part.text.length() == 1) {
                    return "H";
                }
                return "HH";
            }
            case HALFDAY: 
            case HOUROFHALFDAY: {
                throw new IllegalArgumentException("Formatting to halfday hour is not available");
            }
            case MINUTE: {
                if (part.text.length() == 1) {
                    return "m";
                }
                return "mm";
            }
            case SECOND: {
                if (part.text.length() == 1) {
                    return "s";
                }
                return "ss";
            }
            case MILLISECOND: {
                return "SSS";
            }
            case TIMEZONE: {
                throw new IllegalArgumentException("No timezone in impala formats");
            }
            case TEXT: {
                return part.text;
            }
        }
        return part.text;
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE) {
            return SQLCapability.nok("Impala date formatting does not support timezones");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.HALFDAY) {
            return SQLCapability.nok("Impala date formatting does not support AM/PM");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.HOUROFHALFDAY) {
            return SQLCapability.nok("Impala date formatting does not support AM/PM hour");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            return SQLCapability.nok("Impala date formatting does not support clock hour");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFYEAR) {
            return SQLCapability.nok("Impala date formatting does not support day of year");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK) {
            return SQLCapability.nok("Impala date formatting does not support day of week");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.WEEK || part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR) {
            return SQLCapability.nok("Impala date formatting does not support week and week-year");
        }
        if (!(forParsing || part.type != DKUDateUtils.FormatPatternPartType.MONTH || part.numeric || part.shortened)) {
            return SQLCapability.nok("Impala cannot format to full month name");
        }
        return SQLCapability.ok();
    }

    @Override
    public SQLCapability canFormatDate(String jodaFormat, boolean forParsing) {
        DKUDateUtils.FormatPattern jodaPattern = DKUDateUtils.parsePattern((String)jodaFormat, (boolean)forParsing);
        for (DKUDateUtils.FormatPatternPart part : jodaPattern) {
            SQLCapability capability = this.canFormatDatePart(part, forParsing);
            if (capability.capable) continue;
            return capability;
        }
        if (forParsing) {
            if (jodaPattern.hasAll(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.WEEK, DKUDateUtils.FormatPatternPartType.DAYOFWEEK, DKUDateUtils.FormatPatternPartType.WEEKYEAR})) {
                return SQLCapability.ok();
            }
            if (jodaPattern.hasAll(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.DAY, DKUDateUtils.FormatPatternPartType.MONTH}) && jodaPattern.hasAny(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.YEAR, DKUDateUtils.FormatPatternPartType.YEAROFERA})) {
                return SQLCapability.ok();
            }
            if (jodaPattern.hasAll(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.DAYOFYEAR}) && jodaPattern.hasAny(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.YEAR, DKUDateUtils.FormatPatternPartType.YEAROFERA})) {
                return SQLCapability.ok();
            }
            return SQLCapability.nok("Format doesn't define the day unambiguously. One of {dayOfWeek, week, weekYear}, {day, month, year} or {dayOfYear, year} is needed");
        }
        return SQLCapability.ok();
    }

    @Override
    protected String trunc(String x) {
        return this.cast(super.trunc(x), Type.DOUBLE, Type.BIGINT, -1);
    }

    @Override
    public String getId() {
        return "Impala";
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLDialect.MaterializedTemporaryTableWriter(){

            @Override
            public String generateCreateTemp(SQLDialect.UpsertSpec spec) {
                ArrayList<String> columns = new ArrayList<String>();
                ArrayList partitioningColumns = new ArrayList();
                PartitioningScheme scheme = spec.targetDataset.getPartitioningSchema();
                if (scheme != null) {
                    partitioningColumns.addAll(scheme.getDimensionNames());
                }
                for (SchemaColumn sc : spec.targetDataset.getSchema().getColumns()) {
                    if (partitioningColumns.contains(sc.getName())) continue;
                    columns.add(sc.getName());
                }
                return String.format("CREATE TABLE %s AS SELECT %s FROM %s LIMIT 0", ImpalaSQLDialect.this.getQuotedTableFullName(spec.temp), columns.stream().map(c2 -> ImpalaSQLDialect.this.quoteIdentifier((String)c2)).collect(Collectors.joining(", ")), ImpalaSQLDialect.this.getQuotedTableFullName(spec.target));
            }

            @Override
            public String generateTruncateReal(SQLDialect.UpsertSpec spec, PartitioningScheme partitioningScheme) {
                return null;
            }

            @Override
            public String generateCopy(SQLDialect.UpsertSpec spec) {
                PartitioningScheme scheme = spec.targetDataset.getPartitioningSchema();
                if (scheme != null && scheme.isPartitioned()) {
                    ArrayList<String> columns = new ArrayList<String>();
                    ArrayList<String> partitionClauses = new ArrayList<String>();
                    for (String column : scheme.getDimensionNames()) {
                        partitionClauses.add(String.format("%s='$DKU_DST_%s'", ImpalaSQLDialect.this.quoteIdentifier(column), column));
                    }
                    for (SchemaColumn sc : spec.targetDataset.getSchema().getColumns()) {
                        if (scheme.getDimensionNames().contains(sc.getName())) continue;
                        columns.add(ImpalaSQLDialect.this.quoteIdentifier(sc.getName()));
                    }
                    return String.format("INSERT OVERWRITE %s PARTITION (%s) SELECT %s FROM %s", ImpalaSQLDialect.this.getQuotedTableFullName(spec.target), partitionClauses.stream().collect(Collectors.joining(", ")), columns.stream().collect(Collectors.joining(", ")), ImpalaSQLDialect.this.getQuotedTableFullName(spec.temp));
                }
                return String.format("INSERT OVERWRITE %s SELECT * FROM %s", ImpalaSQLDialect.this.getQuotedTableFullName(spec.target), ImpalaSQLDialect.this.getQuotedTableFullName(spec.temp));
            }

            @Override
            public String generateDropTemp(SQLDialect.UpsertSpec spec) {
                return String.format("DROP TABLE IF EXISTS %s", ImpalaSQLDialect.this.getQuotedTableFullName(spec.temp));
            }
        };
    }
}

