/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class JsonUtils {
    public static JsonArray getArrayDefault(JsonObject obj, String name) {
        if (obj.has(name)) {
            return obj.get(name).getAsJsonArray();
        }
        return new JsonArray();
    }

    public static String getStringMemberOrNull(JsonObject jsonObj, String member) {
        if (!jsonObj.has(member)) {
            return null;
        }
        JsonElement m = jsonObj.get(member);
        if (m.isJsonNull()) {
            return null;
        }
        return m.getAsString();
    }

    public static String getStringMemberOrEmpty(JsonObject jsonObj, String member) {
        String sm = JsonUtils.getStringMemberOrNull(jsonObj, member);
        return sm == null ? "" : sm;
    }

    public static JsonElement getOrNull(JsonElement jsonObj, Object ... path) {
        JsonElement cur = jsonObj;
        for (Object obj : path) {
            if (obj instanceof Integer) {
                int arrayIdx = (Integer)obj;
                if (((JsonArray)cur).size() > arrayIdx) {
                    cur = ((JsonArray)cur).get(arrayIdx);
                    continue;
                }
                return null;
            }
            if (!(obj instanceof String)) continue;
            String sobj = (String)obj;
            if (((JsonObject)cur).has(sobj)) {
                cur = ((JsonObject)cur).get(sobj);
                continue;
            }
            return null;
        }
        return cur;
    }

    public static JsonObject getOrEmptyObj(JsonObject jsonObj, Object ... path) {
        JsonElement elt = JsonUtils.getOrNull((JsonElement)jsonObj, path);
        if (elt == null) {
            return new JsonObject();
        }
        if (elt instanceof JsonObject) {
            return (JsonObject)elt;
        }
        throw new IllegalArgumentException("Item at path " + JSON.json((Object)path) + " is not an object but " + String.valueOf(elt));
    }

    public static JsonArray getOrEmptyArr(JsonObject jsonObj, Object ... path) {
        JsonElement elt = JsonUtils.getOrNull((JsonElement)jsonObj, path);
        if (elt == null) {
            return new JsonArray();
        }
        if (elt instanceof JsonArray) {
            return (JsonArray)elt;
        }
        throw new IllegalArgumentException("Item at path " + JSON.json((Object)path) + " is not an array but " + String.valueOf(elt));
    }

    public static String getOrNullStr(JsonObject jsonObj, Object ... path) {
        JsonElement elt = JsonUtils.getOrNull((JsonElement)jsonObj, path);
        if (elt == null) {
            return null;
        }
        if (elt instanceof JsonPrimitive) {
            return ((JsonPrimitive)elt).getAsString();
        }
        return elt.getAsString();
    }

    public static boolean getAsBoolean(JsonObject jsonObj, boolean defaultValue, Object ... path) {
        JsonElement elt = JsonUtils.getOrNull((JsonElement)jsonObj, path);
        if (elt == null) {
            return defaultValue;
        }
        if (elt instanceof JsonPrimitive) {
            return ((JsonPrimitive)elt).getAsBoolean();
        }
        return elt.getAsBoolean();
    }

    public static Map<String, String> toStrMap(JsonObject jsonObj) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry e : jsonObj.entrySet()) {
            JsonElement m = (JsonElement)e.getValue();
            if (m.isJsonNull()) {
                ret.put((String)e.getKey(), null);
                continue;
            }
            ret.put((String)e.getKey(), m.getAsString());
        }
        return ret;
    }

    public static Object stringToValue(String s) {
        block13: {
            if (s == null || "null".equalsIgnoreCase(s)) {
                return JSONObject.NULL;
            }
            if ("true".equalsIgnoreCase(s)) {
                return true;
            }
            if ("false".equalsIgnoreCase(s)) {
                return false;
            }
            if ("".equals(s)) {
                return s;
            }
            char b = s.charAt(0);
            if (Character.isDigit(b) || b == '.' || b == '-' || b == '+') {
                if (s.indexOf(46) >= 0 || s.indexOf(101) >= 0 || s.indexOf(69) >= 0) {
                    try {
                        Double d = Double.parseDouble(s);
                        if (!d.isInfinite() && !d.isNaN()) {
                            return d;
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        return s;
                    }
                }
                try {
                    Long l = Long.parseLong(s);
                    if (s.equals(l.toString())) {
                        if (l == (long)l.intValue()) {
                            return l.intValue();
                        }
                        return l;
                    }
                }
                catch (Exception e) {
                    return s;
                }
            }
        }
        return s;
    }

    public static void addFieldIfNotNull(JsonObject jsonObject, String key, String value) {
        if (value != null) {
            jsonObject.addProperty(key, value);
        }
    }

    public static JsonArray appendIntoJsonArray(@Nullable JsonArray target, @Nullable JsonArray source) {
        if (source == null) {
            return target;
        }
        if (target == null) {
            target = new JsonArray();
        }
        target.addAll(source);
        return target;
    }
}

