/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.DockerExecUtils;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.AbstractWebAppLocalProcessKernel;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractWebAppDockerKernel
extends AbstractWebAppLocalProcessKernel
implements WebAppBackendKernel {
    protected final ContainerExecRuntimeConfig containerConfig;
    protected final String executionId;
    protected final String containerJobId;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.abstract");

    public AbstractWebAppDockerKernel(WebApp webApp, ContainerExecRuntimeConfig containerConfig, AuthCtx authCtx, JsonObject userVariables, WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, File workingDir, APITicketService.Ticket ticket, DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        super(webApp, authCtx, workingDir, mainLog, smartLogTailBuilder, userVariables, launchInfo, securityInfo, ticket);
        this.containerConfig = containerConfig;
        this.executionId = webApp.type + "-" + launchInfo.backendId;
        this.containerJobId = "dku_webapp-" + webApp.id + "-" + this.executionId;
    }

    @Override
    protected String getLogPrefix() {
        return "[docker] ";
    }

    @Override
    protected boolean impersonate() {
        return false;
    }

    @Override
    public WebAppBackendKernel.MainKernelProcess prepareRun(WebAppBackendInstance futureProgressAggregation, ExposedEndpointConsumer.ExposedEndpoint expectedExposedEndpoint) throws Exception {
        Object command = this.makeCommand();
        String envVersion = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getEnvVersionToUseForContainerImageLookup(this.launchInfo.envName, this.getEnvLang(), this.webApp.projectKey);
        CodeEnvModel.EnvFullRef env = new CodeEnvModel.EnvFullRef(this.getEnvLang(), this.launchInfo.envName, envVersion);
        RemoteRunsRegistry.add(this.executionId, this.authCtx, this.webApp.projectKey, this.workingDir.getPath(), this.workingDir.getPath(), this.getExecutionType(), JSON.json((Object)command), "", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(env));
        String imageId = ContainerExecImagesHelper.getImageTagToUse(this.containerConfig.dockerHost, this.containerConfig.baseImage, ContainerExecUtils.BaseImageType.EXEC, this.getEnvLang(), this.launchInfo.envName, envVersion);
        imageId = ContainerExecImagesHelper.withRepositoryURL(this.containerConfig, imageId);
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = false;
        envResource.cwd = this.workingDir.getAbsolutePath();
        EnvironmentStash envStash = this.getEnvironmentForRemoteKernel();
        if (this.userVariables != null) {
            envStash.customVariables = (Map)JSON.parse((JsonElement)this.userVariables, (TypeToken)new TypeToken<Map<String, Object>>(){});
        }
        if (this.launchInfo.pluginId != null) {
            envStash.env.put("DKU_PLUGIN_ID", this.launchInfo.pluginId);
            WebAppBackend.putResourceFolderEnvironmentVariable(envStash.env, "/home/dataiku/plugin/resource");
        }
        if (this.launchInfo.config != null) {
            envStash.env.put("DKU_CUSTOM_WEBAPP_CONFIG", JSON.json((Object)this.launchInfo.config));
        }
        if (this.launchInfo.pluginConfig != null) {
            envStash.env.put("DKU_PLUGIN_CONFIG", JSON.pretty((Object)this.launchInfo.pluginConfig));
        }
        envStash.copyToRemoteRunEnvDef(envResource, false, false, false);
        envResource.jobId = this.executionId;
        RemoteRunsRegistry.get((String)this.executionId).envResource = envResource;
        logger.infoV("Executing webapp on Docker with config=%s, using image '%s', container '%s'", new Object[]{this.containerConfig.name, imageId, this.containerJobId});
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(this.workingDir);
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        List<String> dockerRunCommand = DockerExecUtils.getDockerRunCommand(this.authCtx, this.getExecutionType(), this.webApp.projectKey, null, null, this.containerConfig, "--name", this.containerJobId, "-e", "DKU_API_TICKET");
        dockerRunCommand.addAll(DockerExecUtils.getEnvironmentCommandFlags(this.containerConfig));
        dockerRunCommand.add(imageId);
        dockerRunCommand.add(this.executionId);
        pb.command(dockerRunCommand);
        ContainerExecUtils.enrichDockerEnv(this.containerConfig, pb.environment());
        return new WebAppBackendKernel.DockerMainKernelProcess(pb, this.outputConsumer, 10000);
    }

    protected abstract CodeEnvModel.EnvLang getEnvLang();

    protected abstract RemoteRunsRegistry.ExecutionType getExecutionType();

    protected abstract Object makeCommand() throws Exception;

    private EnvironmentStash getEnvironmentForRemoteKernel() {
        EnvironmentStash envStash = new EnvironmentStash();
        envStash.fillDefault();
        envStash.fillCommunicationVars();
        envStash.apiTicket = this.ticket.getSecret();
        envStash.projectKey = this.webApp.projectKey;
        if (StringUtils.isNotBlank((String)this.launchInfo.envName)) {
            envStash.env.put("DKU_CODE_ENV_NAME", this.launchInfo.envName);
        }
        return envStash;
    }

    @Override
    public void kill() {
        try {
            super.kill();
        }
        finally {
            this.tryKillContainer();
        }
    }

    protected void tryKillContainer() {
        logger.info((Object)"Killing container by docker command");
        HashMap env = Maps.newHashMap();
        ContainerExecUtils.enrichDockerEnv(this.containerConfig, env);
        ContainerExecUtils.killDockerContainer(this.containerJobId, true, env, logger);
    }

    public static Exposables.Exposable cleanupKernel(WebApp webApp, WebAppLaunchInfo launchInfo, ContainerExecRuntimeConfig containerConfig2, File workingDir, DKUtils.RotatingLoggingSubscription mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        return new Exposables.DockerExposable(){

            @Override
            public int getContainerizedPort() {
                return 10000;
            }

            @Override
            public void alterCommandLine(List<List<Pattern>> removed, List<SimpleKeyValue> modified, List<List<String>> added) {
            }
        };
    }
}

