/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.ast;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePartial;
import com.google.refine.expr.ArgsEvaluable;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.functions.aggregations.AggregatedFunction;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import java.util.Date;
import java.util.Properties;

public class OperatorCallExpr
extends ArgsEvaluable {
    private final DKUFormulaUtils formulaUtils = new DKUFormulaUtils();
    public final String _op;

    public OperatorCallExpr(Evaluable[] args, String op) {
        this._args = args;
        this._op = op;
    }

    @Override
    public Object evaluate(Properties bindings) {
        Object[] args = new Object[this._args.length];
        if ("&&".equals(this._op)) {
            for (int i = 0; i < this._args.length; ++i) {
                Object v = this._args[i].evaluate(bindings);
                if (ExpressionUtils.isError(v)) {
                    return v;
                }
                if (ExpressionUtils.isTrueish(v)) continue;
                return false;
            }
            return true;
        }
        if ("||".equals(this._op)) {
            for (int i = 0; i < this._args.length; ++i) {
                Object v = this._args[i].evaluate(bindings);
                if (ExpressionUtils.isError(v)) {
                    return v;
                }
                if (!ExpressionUtils.isTrueish(v)) continue;
                return true;
            }
            return false;
        }
        if ("!".equals(this._op)) {
            Object v = this._args[0].evaluate(bindings);
            if (ExpressionUtils.isError(v)) {
                return v;
            }
            return !ExpressionUtils.isTrueish(v);
        }
        for (int i = 0; i < this._args.length; ++i) {
            Object v = this._args[i].evaluate(bindings);
            if (ExpressionUtils.isError(v)) {
                return v;
            }
            args[i] = v;
        }
        if (args.length == 2) {
            String a1;
            if (args[0] != null && args[1] != null) {
                if (this.isIntegral(args[0]) && this.isIntegral(args[1])) {
                    long n1 = ((Number)args[0]).longValue();
                    long n2 = ((Number)args[1]).longValue();
                    if ("+".equals(this._op)) {
                        return n1 + n2;
                    }
                    if ("-".equals(this._op)) {
                        return n1 - n2;
                    }
                    if ("*".equals(this._op)) {
                        return n1 * n2;
                    }
                    if ("/".equals(this._op)) {
                        return (double)n1 / (double)n2;
                    }
                    if ("//".equals(this._op)) {
                        return n1 / n2;
                    }
                    if ("%".equals(this._op)) {
                        return n1 % n2;
                    }
                    if (">".equals(this._op)) {
                        return n1 > n2;
                    }
                    if (">=".equals(this._op)) {
                        return n1 >= n2;
                    }
                    if ("<".equals(this._op)) {
                        return n1 < n2;
                    }
                    if ("<=".equals(this._op)) {
                        return n1 <= n2;
                    }
                    if ("==".equals(this._op)) {
                        return n1 == n2;
                    }
                    if ("!=".equals(this._op)) {
                        return n1 != n2;
                    }
                } else if (args[0] instanceof Number && args[1] instanceof Number) {
                    double n1 = ((Number)args[0]).doubleValue();
                    double n2 = ((Number)args[1]).doubleValue();
                    if ("+".equals(this._op)) {
                        return n1 + n2;
                    }
                    if ("-".equals(this._op)) {
                        return n1 - n2;
                    }
                    if ("*".equals(this._op)) {
                        return n1 * n2;
                    }
                    if ("/".equals(this._op)) {
                        return n1 / n2;
                    }
                    if ("//".equals(this._op)) {
                        return n1 / n2;
                    }
                    if ("%".equals(this._op)) {
                        return n1 % n2;
                    }
                    if (">".equals(this._op)) {
                        return n1 > n2;
                    }
                    if (">=".equals(this._op)) {
                        return n1 >= n2;
                    }
                    if ("<".equals(this._op)) {
                        return n1 < n2;
                    }
                    if ("<=".equals(this._op)) {
                        return n1 <= n2;
                    }
                    if ("==".equals(this._op)) {
                        return n1 == n2;
                    }
                    if ("!=".equals(this._op)) {
                        return n1 != n2;
                    }
                } else {
                    if (args[0] instanceof LocalDate && args[1] instanceof LocalDate) {
                        return this.compareDateOnly((LocalDate)args[0], (LocalDate)args[1]);
                    }
                    if (args[0] instanceof String && args[1] instanceof LocalDate) {
                        LocalDate args0 = this.formulaUtils.asDateOnly(args[0]);
                        return this.compareDateOnly(args0, (LocalDate)args[1]);
                    }
                    if (args[0] instanceof LocalDate && args[1] instanceof String) {
                        LocalDate args1 = this.formulaUtils.asDateOnly(args[1]);
                        return this.compareDateOnly((LocalDate)args[0], args1);
                    }
                    if (args[0] instanceof LocalDateTime && args[1] instanceof LocalDateTime) {
                        return this.compareDatetimeNoTz((LocalDateTime)args[0], (LocalDateTime)args[1]);
                    }
                    if (args[0] instanceof String && args[1] instanceof LocalDateTime) {
                        LocalDateTime args0 = this.formulaUtils.asDatetimeNoTz(args[0]);
                        return this.compareDatetimeNoTz(args0, (LocalDateTime)args[1]);
                    }
                    if (args[0] instanceof LocalDateTime && args[1] instanceof String) {
                        LocalDateTime args1 = this.formulaUtils.asDatetimeNoTz(args[1]);
                        return this.compareDatetimeNoTz((LocalDateTime)args[0], args1);
                    }
                    if (args[0] instanceof Date && args[1] instanceof Date) {
                        return this.compareDate((Date)args[0], (Date)args[1]);
                    }
                    if (args[0] instanceof DateTime && args[1] instanceof DateTime) {
                        return this.compareDateTime((DateTime)args[0], (DateTime)args[1]);
                    }
                    if (args[0] instanceof Date && args[1] instanceof DateTime) {
                        return this.compareDateAndDateTime((Date)args[0], (DateTime)args[1]);
                    }
                    if (args[0] instanceof DateTime && args[1] instanceof Date) {
                        return this.compareDateAndDateTime((DateTime)args[0], (Date)args[1]);
                    }
                    if (args[0] instanceof String && args[1] instanceof String) {
                        String s1 = (String)args[0];
                        String s2 = (String)args[1];
                        if (">".equals(this._op)) {
                            return s1.compareTo(s2) > 0;
                        }
                        if (">=".equals(this._op)) {
                            return s1.compareTo(s2) >= 0;
                        }
                        if ("<".equals(this._op)) {
                            return s1.compareTo(s2) < 0;
                        }
                        if ("<=".equals(this._op)) {
                            return s1.compareTo(s2) <= 0;
                        }
                        if ("==".equals(this._op)) {
                            return s1.equals(s2);
                        }
                        if ("!=".equals(this._op)) {
                            return !s1.equals(s2);
                        }
                    } else if (args[0] instanceof AggregatedFunction || args[1] instanceof AggregatedFunction) {
                        return new AggregatedFunction(){};
                    }
                }
                if ("+".equals(this._op)) {
                    return args[0].toString() + args[1].toString();
                }
            }
            if ("==".equals(this._op)) {
                if (args[0] != null) {
                    String a0 = args[0].toString();
                    a1 = args[1] == null ? null : args[1].toString();
                    return a0.equals(a1);
                }
                return args[1] == null;
            }
            if ("!=".equals(this._op)) {
                if (args[0] != null) {
                    String a0 = args[0].toString();
                    a1 = args[1] == null ? null : args[1].toString();
                    return !a0.equals(a1);
                }
                return args[1] != null;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Evaluable ev : this._args) {
            if (sb.length() > 0) {
                sb.append(' ');
                sb.append(this._op);
                sb.append(' ');
            }
            sb.append(ev.toString());
        }
        return sb.toString();
    }

    private boolean isIntegral(Object n) {
        return n instanceof Long || n instanceof Integer;
    }

    private Boolean compareDateTime(DateTime d1, DateTime d2) {
        if (">".equals(this._op)) {
            return d1.compareTo((ReadableInstant)d2) > 0;
        }
        if (">=".equals(this._op)) {
            return d1.compareTo((ReadableInstant)d2) >= 0;
        }
        if ("<".equals(this._op)) {
            return d1.compareTo((ReadableInstant)d2) < 0;
        }
        if ("<=".equals(this._op)) {
            return d1.compareTo((ReadableInstant)d2) <= 0;
        }
        if ("==".equals(this._op)) {
            return d1.equals((Object)d2);
        }
        if ("!=".equals(this._op)) {
            return !d1.equals((Object)d2);
        }
        return null;
    }

    private Boolean compareDateOnly(LocalDate d1, LocalDate d2) {
        if (">".equals(this._op)) {
            return d1.compareTo((ReadablePartial)d2) > 0;
        }
        if (">=".equals(this._op)) {
            return d1.compareTo((ReadablePartial)d2) >= 0;
        }
        if ("<".equals(this._op)) {
            return d1.compareTo((ReadablePartial)d2) < 0;
        }
        if ("<=".equals(this._op)) {
            return d1.compareTo((ReadablePartial)d2) <= 0;
        }
        if ("==".equals(this._op)) {
            return d1.equals((Object)d2);
        }
        if ("!=".equals(this._op)) {
            return !d1.equals((Object)d2);
        }
        return null;
    }

    private Boolean compareDatetimeNoTz(LocalDateTime d1, LocalDateTime d2) {
        if (">".equals(this._op)) {
            return d1.compareTo((ReadablePartial)d2) > 0;
        }
        if (">=".equals(this._op)) {
            return d1.compareTo((ReadablePartial)d2) >= 0;
        }
        if ("<".equals(this._op)) {
            return d1.compareTo((ReadablePartial)d2) < 0;
        }
        if ("<=".equals(this._op)) {
            return d1.compareTo((ReadablePartial)d2) <= 0;
        }
        if ("==".equals(this._op)) {
            return d1.equals((Object)d2);
        }
        if ("!=".equals(this._op)) {
            return !d1.equals((Object)d2);
        }
        return null;
    }

    private Boolean compareDate(Date d1, Date d2) {
        if (">".equals(this._op)) {
            return d1.compareTo(d2) > 0;
        }
        if (">=".equals(this._op)) {
            return d1.compareTo(d2) >= 0;
        }
        if ("<".equals(this._op)) {
            return d1.compareTo(d2) < 0;
        }
        if ("<=".equals(this._op)) {
            return d1.compareTo(d2) <= 0;
        }
        if ("==".equals(this._op)) {
            return d1.equals(d2);
        }
        if ("!=".equals(this._op)) {
            return !d1.equals(d2);
        }
        return null;
    }

    private Boolean compareDateAndDateTime(DateTime d1, Date d2) {
        return this.compareDate(d1.toDate(), d2);
    }

    private Boolean compareDateAndDateTime(Date d1, DateTime d2) {
        return this.compareDate(d1, d2.toDate());
    }
}

