/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntimeManager;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.CodeStudiosController;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/code-studios"})
public class PublicAPICodeStudioObjectsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    @Autowired
    private CodeStudioRuntimeManager codeStudioRuntimeManager;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ProjectsService projectsService;

    private CodeStudioObject getCodeStudioAndCheckPerm(String projectKey, String codeStudioId, AuthCtx authCtx, Privileges.ProjectLevelPrivilegeType privilegeType) throws DKUSecurityException, IOException, UnauthorizedException {
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{privilegeType});
        CodeStudioObject codeStudio = this.codeStudioObjectsService.getOrNullUnsafe(projectKey, codeStudioId);
        if (codeStudio == null) {
            throw new NotFoundException("Code studio '" + codeStudioId + "' in '" + projectKey + "' doesn't exist");
        }
        if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioId)) {
            throw new UnauthorizedException("Not owner of the code studio", "code-studio-read");
        }
        return codeStudio;
    }

    @AuditedCall(value={"msgType", "code-studios-list-heads", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CodeStudioObject.ListItem> listHeads(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List list = this.codeStudioObjectsService.listHeads(authCtx, projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "code-studio-get", "projectKey", "${projectKey}", "codeStudioId", "${codeStudioId}"})
    @RequestMapping(value={"/{codeStudioId}"}, method={RequestMethod.GET})
    @ResponseBody
    public CodeStudioObject get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            CodeStudioObject codeStudio;
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            CodeStudioObject codeStudioObject = codeStudio = this.getCodeStudioAndCheckPerm(projectKey, codeStudioId, authCtx, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            return codeStudioObject;
        }
    }

    @AuditedCall(value={"msgType", "code-studio-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    @ResponseBody
    public CodeStudiosController.CodeStudioObjectCreateResponse create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx;
        CodeStudioCreationInfo creationInfo = (CodeStudioCreationInfo)this.getRequestBodyAs(req, CodeStudioCreationInfo.class);
        this.require(creationInfo.name != null, "Required field 'name' is missing.");
        this.require(creationInfo.templateId != null, "Required field 'templateId' is missing.");
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, creationInfo.templateId, Privileges.CodeStudioTemplatePrivilegeType.USE)) {
                throw new UnauthorizedException("User is not allowed to use template " + creationInfo.templateId, "code-studio-template-use");
            }
            if (StringUtils.isBlank((String)authCtx.getAssociatedDSSUser())) {
                throw new UnsupportedOperationException("Cannot create code studios with global API keys, use a personal API key");
            }
        }
        CodeStudiosController.CodeStudioObjectCreateResponse ret = new CodeStudiosController.CodeStudioObjectCreateResponse();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            CodeStudioObject codeStudioObject = this.codeStudioObjectsService.createNoSave(authCtx, projectKey, null, creationInfo.name, creationInfo.templateId);
            ret.codeStudio = this.codeStudioObjectsService.save(codeStudioObject, true);
            t.commitV("Created code studio %s (%s.%s)", new Object[]{codeStudioObject.name, codeStudioObject.projectKey, codeStudioObject.id});
            this.auditTrailService.generic("code-studio-create").with("projectKey", projectKey).with("codeStudioId", codeStudioObject.id).emit();
        }
        this.codeStudioObjectsService.postCreate_NT(authCtx, ret.codeStudio, ret.messages);
        return ret;
    }

    @AuditedCall(value={"msgType", "code-change-owner", "projectKey", "${projectKey}", "codeStudioId", "${codeStudioId}"})
    @RequestMapping(value={"/{codeStudioId}/change-owner"}, method={RequestMethod.POST})
    @ResponseBody
    public CodeStudioObject changeOwner(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioId, @RequestParam String newOwner) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            CodeStudioObject codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioId);
            if (!StringUtils.equals((String)codeStudio.getOwner(), (String)authCtx.getAssociatedDSSUser())) {
                this.permissionsService.checkAdmin(authCtx, "You need to be either admin or owner of the Code Studio to change its owner.");
            }
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            CodeStudioObject codeStudioObject = this.codeStudioObjectsService.changeOwner(authCtx, projectKey, codeStudioId, newOwner);
            t.commit(String.format("Changed owner of Code Studio %s.%s", projectKey, codeStudioId));
            CodeStudioObject codeStudioObject2 = codeStudioObject;
            return codeStudioObject2;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-delete", "projectKey", "${projectKey}", "codeStudioId", "${codeStudioId}"})
    @RequestMapping(value={"/{codeStudioId}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioId) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            codeStudio = this.getCodeStudioAndCheckPerm(projectKey, codeStudioId, authCtx, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            this.codeStudioObjectsService.delete(authCtx, projectKey, codeStudioId);
            t.commit("Deleted code studio " + codeStudio.name + " (" + codeStudioId + ") in " + projectKey);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-stop", "projectKey", "${projectKey}", "codeStudioId", "${codeStudioId}"})
    @RequestMapping(value={"/{codeStudioId}/stop"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<CodeStudioRuntime.CodeStudioUIState> stop(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            CodeStudioObject codeStudio = this.getCodeStudioAndCheckPerm(projectKey, codeStudioId, authCtx, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            FutureResponse futureResponse = this.codeStudioRuntimeManager.stop(authCtx, codeStudio);
            return futureResponse;
        }
    }

    @AuditedCall(value={"msgType", "code-studio-restart", "projectKey", "${projectKey}", "codeStudioId", "${codeStudioId}"})
    @RequestMapping(value={"/{codeStudioId}/restart"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<CodeStudioRuntimeManager.CodeStudioStartStopResult> restart(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            CodeStudioObject codeStudio = this.getCodeStudioAndCheckPerm(projectKey, codeStudioId, authCtx, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            FutureResponse futureResponse = this.codeStudioRuntimeManager.restart(authCtx, codeStudio);
            return futureResponse;
        }
    }

    @AuditedCall(value={"msgType", "code-studio-backend", "projectKey", "${projectKey}", "codeStudioId", "${codeStudioId}"})
    @RequestMapping(value={"/{codeStudioId}/status"}, method={RequestMethod.GET})
    @ResponseBody
    public CodeStudioRuntime.CodeStudioUIState backendState(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioId) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            codeStudio = this.getCodeStudioAndCheckPerm(projectKey, codeStudioId, authCtx, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.codeStudioRuntimeManager.getState(authCtx, codeStudio);
    }

    @AuditedCall(value={"msgType", "code-studio-backend", "projectKey", "${projectKey}", "codeStudioId", "${codeStudioId}"})
    @RequestMapping(value={"/{codeStudioId}/conflicts/{zone:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public CodeStudioRuntimeManager.CheckConflictsResponse getConflicts(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioId, @PathVariable String zone) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            codeStudio = this.getCodeStudioAndCheckPerm(projectKey, codeStudioId, authCtx, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.codeStudioRuntimeManager.checkConflictsFromCodeStudio(authCtx, codeStudio, (List)Lists.newArrayList((Object[])new String[]{zone}));
    }

    @AuditedCall(value={"msgType", "code-studio-backend", "projectKey", "${projectKey}", "codeStudioId", "${codeStudioId}"})
    @RequestMapping(value={"/{codeStudioId}/pull/{zone:.+}"}, method={RequestMethod.GET})
    public void pull(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioId, @PathVariable String zone) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            codeStudio = this.getCodeStudioAndCheckPerm(projectKey, codeStudioId, authCtx, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        this.codeStudioRuntimeManager.pullBundleFromCodeStudio(authCtx, zone, codeStudio, true);
    }

    @AuditedCall(value={"msgType", "code-studio-backend", "projectKey", "${projectKey}", "codeStudioId", "${codeStudioId}"})
    @RequestMapping(value={"/{codeStudioId}/push/{zone:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public CodeStudioRuntimeManager.PushedToCodeStudioSummary push(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioId, @PathVariable String zone) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            codeStudio = this.getCodeStudioAndCheckPerm(projectKey, codeStudioId, authCtx, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.codeStudioRuntimeManager.pushBundleToCodeStudio(authCtx, zone, codeStudio);
    }

    public static class CodeStudioCreationInfo {
        public String name;
        public String templateId;
    }
}

