/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ObjectCompleteMetadata;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeMeta;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipeMeta;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeMeta;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pig.PigRecipeMeta;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeMeta;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.r.RRecipeMeta;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeMeta;
import com.dataiku.dip.dataflow.exec.sort.SortRecipeMeta;
import com.dataiku.dip.dataflow.exec.sort.SortRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeMeta;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLScriptRecipeMeta;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeMeta;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeMeta;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeMeta;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeMeta;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.recipes.code.python.PythonRecipeMeta;
import com.dataiku.dip.recipes.code.spark.PySparkRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeMeta;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.export.ExportRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/recipes"})
public class PublicAPIRecipesController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoreDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private RecipeSchemaService recipeSchemaService;
    @Autowired
    private FlowGraphService flowGraphService;
    private final Set<String> unaryMainOutputRecipes;
    private final Set<String> unaryMainInputRecipes = Sets.newHashSet();
    private final Set<String> codeRecipeTypes;
    private final Map<String, Class<?>> jsonPayloadClass;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.recipe");

    public PublicAPIRecipesController() {
        this.unaryMainInputRecipes.add(GroupingRecipeMeta.META.getType());
        this.unaryMainInputRecipes.add(DistinctRecipeMeta.META.getType());
        this.unaryMainInputRecipes.add(WindowRecipeMeta.META.getType());
        this.unaryMainInputRecipes.add(SyncRecipeMeta.META.getType());
        this.unaryMainInputRecipes.add(SplitRecipeMeta.META.getType());
        this.unaryMainInputRecipes.add(TopNRecipeMeta.META.getType());
        this.unaryMainInputRecipes.add(SortRecipeMeta.META.getType());
        this.unaryMainInputRecipes.add(PivotRecipeMeta.META.getType());
        this.unaryMainInputRecipes.add(SamplingRecipeMeta.META.getType());
        this.unaryMainOutputRecipes = Sets.newHashSet((Object[])new String[]{""});
        this.unaryMainOutputRecipes.add(AutoFeatureGenerationRecipeMeta.META.getType());
        this.unaryMainOutputRecipes.add(GroupingRecipeMeta.META.getType());
        this.unaryMainOutputRecipes.add(DistinctRecipeMeta.META.getType());
        this.unaryMainOutputRecipes.add(WindowRecipeMeta.META.getType());
        this.unaryMainOutputRecipes.add(SyncRecipeMeta.META.getType());
        this.unaryMainOutputRecipes.add("shaker");
        this.unaryMainOutputRecipes.add(ExportRecipeMeta.META.getType());
        this.unaryMainOutputRecipes.add(VStackRecipeMeta.META.getType());
        this.unaryMainOutputRecipes.add(SamplingRecipeMeta.META.getType());
        this.unaryMainOutputRecipes.add(SQLQueryRecipeMeta.META.getType());
        this.jsonPayloadClass = Maps.newHashMap();
        this.jsonPayloadClass.put(AutoFeatureGenerationRecipeMeta.META.getType(), AutoFeatureGenerationRecipePayloadParams.class);
        this.jsonPayloadClass.put(GroupingRecipeMeta.META.getType(), GroupingRecipePayloadParams.class);
        this.jsonPayloadClass.put(DistinctRecipeMeta.META.getType(), DistinctRecipePayloadParams.class);
        this.jsonPayloadClass.put(WindowRecipeMeta.META.getType(), WindowRecipePayloadParams.class);
        this.jsonPayloadClass.put(JoinRecipeMeta.META.getType(), JoinRecipePayloadParams.class);
        this.jsonPayloadClass.put(SplitRecipeMeta.META.getType(), SplitRecipePayloadParams.class);
        this.jsonPayloadClass.put(TopNRecipeMeta.META.getType(), TopNRecipePayloadParams.class);
        this.jsonPayloadClass.put(SortRecipeMeta.META.getType(), SortRecipePayloadParams.class);
        this.jsonPayloadClass.put(PivotRecipeMeta.META.getType(), PivotRecipePayloadParams.class);
        this.jsonPayloadClass.put(VStackRecipeMeta.META.getType(), VStackRecipePayloadParams.class);
        this.codeRecipeTypes = Sets.newHashSet();
        this.codeRecipeTypes.add(PythonRecipeMeta.META.getType());
        this.codeRecipeTypes.add(RRecipeMeta.META.getType());
        this.codeRecipeTypes.add(PySparkRecipeMeta.META.getType());
        this.codeRecipeTypes.add(SparkRRecipeMeta.META.getType());
        this.codeRecipeTypes.add(SparkSQLQueryRecipeMeta.META.getType());
        this.codeRecipeTypes.add(SQLQueryRecipeMeta.META.getType());
        this.codeRecipeTypes.add(SQLScriptRecipeMeta.META.getType());
        this.codeRecipeTypes.add(ImpalaRecipeMeta.META.getType());
        this.codeRecipeTypes.add(HiveRecipeMeta.META.getType());
        this.codeRecipeTypes.add(PigRecipeMeta.META.getType());
    }

    @AuditedCall(value={"msgType", "recipes-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        List recipes;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            recipes = this.recipesDAO.listUnsafe(projectKey);
        }
        PublicAPIRecipesController.writeJSON((HttpServletResponse)resp, (Object)recipes);
    }

    @AuditedCall(value={"msgType", "recipe-get", "projectKey", "${projectKey}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/{recipeName:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeName) throws Exception {
        SerializedRecipe.SerializedRecipeAndPayload recipeAndPayload = new SerializedRecipe.SerializedRecipeAndPayload();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            recipeAndPayload.recipe = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(projectKey, recipeName);
            recipeAndPayload.payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
        }
        PublicAPIRecipesController.writeJSON((HttpServletResponse)resp, (Object)recipeAndPayload);
    }

    @AuditedCall(value={"msgType", "recipe-get", "projectKey", "${projectKey}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/{recipeName:.+}/status"}, method={RequestMethod.GET})
    public void getStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeName) throws Exception {
        RecipeStatus status;
        String payloadData;
        AuthCtx authCtx = null;
        SerializedRecipe sr = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sr = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, recipeName);
            payloadData = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
        }
        RecipeStatusComputer computer = RecipeRegistry.getMeta((SerializedRecipe)sr).buildStatusComputer(sr, payloadData);
        if (computer == null) {
            throw new IllegalArgumentException("Recipes of type " + sr.type + " do not have a computable status");
        }
        logger.infoV("Computing status of recipe %s.%s", new Object[]{sr.projectKey, sr.name});
        try {
            status = computer.getFullStatus_NT(authCtx, "");
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to compute recipe status", e);
            status = new RecipeStatus.BasicRecipeStatus();
            status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute recipe status: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Send visual recipe status: " + JSON.json((Object)status)));
        }
        status.allMessagesForFrontend = status.gatherAllMessages();
        status.allMessagesForFrontend.summarize();
        PublicAPIRecipesController.writeJSON((HttpServletResponse)resp, (Object)status);
    }

    @AuditedCall(value={"msgType", "recipe-get", "projectKey", "${projectKey}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/{recipeName:.+}/schema-update"}, method={RequestMethod.GET})
    public void getSchemaUpdate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeName, @RequestParam(value="recipeUpdateOptions", required=false) String recipeUpdateOptionsStr) throws Exception {
        AuthCtx authCtx = null;
        JsonObject recipeUpdateOptions = StringUtils.isNotBlank((String)recipeUpdateOptionsStr) ? (JsonObject)JSON.parse((String)recipeUpdateOptionsStr, JsonObject.class) : null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPIRecipesController.writeJSON((HttpServletResponse)resp, (Object)this.recipeSchemaService.checkRecipe(authCtx, projectKey, recipeName, true, recipeUpdateOptions));
    }

    @AuditedCall(value={"msgType", "dataset-save-schema", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{recipeName:.+}/actions/updateOutputSchema"})
    public void saveRecipeOutputSchema(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        Callable delayedUpdateResult;
        OutputSchemaUpdate update = (OutputSchemaUpdate)this.getRequestBodyAs(req, OutputSchemaUpdate.class);
        AnyLoc loc = AnyLoc.resolveSmart((String)projectKey, (String)update.computableId);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            delayedUpdateResult = this.recipeSchemaService.updateComputableOutputSchemaForRecipe(t.getUser(), projectKey, FlowComputable.FCType.valueOf((String)update.computableType), loc, update.newSchema, update.dropAndRecreate, update.synchronizeMetastore, null);
            t.commit("Updated schema of " + loc.getFullName() + " from recipe in project " + projectKey);
        }
        PublicAPIRecipesController.writeJSON((HttpServletResponse)resp, delayedUpdateResult.call());
    }

    @AuditedCall(value={"msgType", "recipe-get-meta", "projectKey", "${projectKey}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/{recipeName}/metadata"}, method={RequestMethod.GET})
    public void getMetadata(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeName) throws Exception {
        SerializedRecipe recipe;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, recipeName);
        }
        ObjectCompleteMetadata ocm = new ObjectCompleteMetadata();
        ocm.checklists = recipe.checklists;
        ocm.description = recipe.description;
        ocm.tags = Sets.newHashSet((Iterable)recipe.tags);
        ocm.custom = recipe.customMeta;
        PublicAPIRecipesController.writeJSON((HttpServletResponse)resp, (Object)ocm);
    }

    @AuditedCall(value={"msgType", "recipe-save-meta", "projectKey", "${projectKey}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/{recipeName}/metadata"}, method={RequestMethod.PUT})
    public void putMetadata(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeName) throws Exception {
        ObjectCompleteMetadata ocm = (ObjectCompleteMetadata)this.getRequestBodyAs(req, ObjectCompleteMetadata.class);
        this.require(ocm.checklists != null, "checklists are missing");
        this.require(ocm.tags != null, "tags are missing");
        this.require(ocm.custom != null, "custom metadata are missing");
        String fullName = projectKey + "." + recipeName;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, recipeName);
            String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
            recipe.checklists = ocm.checklists;
            recipe.description = ocm.description;
            recipe.tags = Lists.newArrayList((Iterable)ocm.tags);
            recipe.customMeta = ocm.custom;
            this.recipeSaveService.save(projectKey, recipe, payload);
            t.commit("Updated metadata for " + fullName);
        }
        this.flowGraphService.invalidateCache(projectKey);
        this.writeMessage(resp, "Updated metadata %s", new Object[]{fullName});
    }

    @AuditedCall(value={"msgType", "recipe-save", "projectKey", "${projectKey}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/{recipeName:.+}"}, method={RequestMethod.PUT})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeName) throws Exception {
        SerializedRecipe.SerializedRecipeAndPayload recipeAndPayload = (SerializedRecipe.SerializedRecipeAndPayload)this.getRequestBodyAs(req, SerializedRecipe.SerializedRecipeAndPayload.class);
        this.require(recipeAndPayload.recipe != null, "Required field 'recipe' is missing.");
        if (RecipeRegistry.getMeta((String)recipeAndPayload.recipe.type).hasJsonPayload()) {
            this.require(recipeAndPayload.payload != null, "Required field 'payload' is missing.");
        }
        this.require(StringUtils.isNotBlank((String)recipeAndPayload.recipe.projectKey), "Required field 'recipe.projectKey' is missing.");
        this.require(StringUtils.isNotBlank((String)recipeAndPayload.recipe.name), "Required field 'recipe.name' is missing.");
        this.require(StringUtils.isNotBlank((String)recipeAndPayload.recipe.type), "Required field 'recipe.type' is missing.");
        this.require(recipeAndPayload.recipe.projectKey.equals(projectKey), "Recipe projectKey does not match the requested URL");
        this.require(recipeAndPayload.recipe.name.equals(recipeName), "Recipe name does not match the requested URL (renaming forbidden)");
        String fullName = projectKey + "." + recipeName;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, recipeName);
            String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
            this.checkChanges(fullName, recipe, payload, recipeAndPayload.recipe, recipeAndPayload.payload);
            this.recipeSaveService.save(projectKey, recipeAndPayload.recipe, recipeAndPayload.payload);
            t.commit("Updated recipe " + fullName);
        }
        this.flowGraphService.invalidateCache(projectKey);
        this.writeMessage(resp, "Updated recipe %s", new Object[]{fullName});
    }

    private void checkChanges(String fullName, SerializedRecipe oldRecipe, String oldPayload, SerializedRecipe newRecipe, String newPayload) {
        if (!oldRecipe.type.equals(newRecipe.type)) {
            throw new IllegalArgumentException("Cannot change type of recipe " + fullName + " from " + oldRecipe.type + " to " + newRecipe.type);
        }
        HashMap inputArities = Maps.newHashMap();
        HashMap outputArities = Maps.newHashMap();
        for (Map.Entry input : newRecipe.getInputsUnsafe().entrySet()) {
            inputArities.put((String)input.getKey(), ((SerializedRecipe.InputRole)input.getValue()).items.size());
        }
        for (Map.Entry output : newRecipe.getOutputsUnsafe().entrySet()) {
            outputArities.put((String)output.getKey(), ((SerializedRecipe.OutputRole)output.getValue()).items.size());
        }
        if (this.unaryMainInputRecipes.contains(newRecipe.type)) {
            if (inputArities.size() > 1) {
                throw new IllegalArgumentException("Cannot set multiple input roles on recipe " + fullName + " of type " + newRecipe.type);
            }
            if (inputArities.size() == 1) {
                if (!inputArities.containsKey("main")) {
                    throw new IllegalArgumentException("Cannot set input roles other than 'main' on recipe " + fullName + " of type " + newRecipe.type);
                }
                if ((Integer)inputArities.get("main") > 1) {
                    throw new IllegalArgumentException("Cannot set multiple inputs on recipe " + fullName + " of type " + newRecipe.type);
                }
            }
        }
        if (this.unaryMainOutputRecipes.contains(newRecipe.type)) {
            if (outputArities.size() > 1) {
                throw new IllegalArgumentException("Cannot set multiple output roles on recipe " + fullName + " of type " + newRecipe.type);
            }
            if (outputArities.size() == 1) {
                if (!outputArities.containsKey("main")) {
                    throw new IllegalArgumentException("Cannot set output roles other than 'main' on recipe " + fullName + " of type " + newRecipe.type);
                }
                if ((Integer)outputArities.get("main") > 1) {
                    throw new IllegalArgumentException("Cannot set multiple outputs on recipe " + fullName + " of type " + newRecipe.type);
                }
            }
        }
        if (this.jsonPayloadClass.containsKey(newRecipe.type)) {
            try {
                Object parsed = JSON.parse((String)newPayload, this.jsonPayloadClass.get(newRecipe.type));
                if (parsed == null) {
                    throw new IllegalArgumentException("Cannot set empty payload on recipe " + fullName + " of type " + newRecipe.type);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot set unparseable payload on recipe " + fullName + " of type " + newRecipe.type, ex);
            }
        }
    }

    @AuditedCall(value={"msgType", "recipe-delete", "projectKey", "${projectKey}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/{recipeName:.+}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeName) throws Exception {
        String fullName = projectKey + "." + recipeName;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.recipesDAO.getMandatoryUnsafe(projectKey, recipeName);
            this.recipeSaveService.delete(projectKey, recipeName);
            t.commit("Deleted recipe " + fullName);
        }
        this.flowGraphService.invalidateCache(projectKey);
        this.writeMessage(resp, "Deleted recipe %s", new Object[]{fullName});
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx;
        boolean rawCreation;
        RecipeCreationInfo creationInfo;
        block32: {
            creationInfo = (RecipeCreationInfo)this.getRequestBodyAs(req, RecipeCreationInfo.class);
            this.require(StringUtils.isNotBlank((String)creationInfo.recipePrototype.type), "Required field 'recipe.type' is missing.");
            rawCreation = creationInfo.creationSettings.has("rawCreation");
            if (creationInfo.recipePrototype.name == null) {
                List outputs = creationInfo.recipePrototype.getFlatOutputs();
                if (outputs.isEmpty()) {
                    throw new IllegalArgumentException("Recipe name not provided and no output given, cannot auto-assign name");
                }
                creationInfo.recipePrototype.name = "compute_" + ((SerializedRecipe.RecipeOutput)outputs.get((int)0)).ref;
            }
            authCtx = this.authService.getTicketOrKey_NT(req);
            try (Transaction t = this.transactionService.beginRead();){
                String connectionId;
                SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings datasetCreationSettings;
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
                if (rawCreation) break block32;
                for (Object input : creationInfo.recipePrototype.getFlatInputs()) {
                    if (StringUtils.isBlank((String)((SerializedRecipe.RecipeInput)input).ref)) {
                        throw ErrorContext.iae((String)"Unnamed input");
                    }
                    AnyLoc loc = AnyLoc.resolveSmart((String)projectKey, (String)((SerializedRecipe.RecipeInput)input).ref);
                    Object object = this.find(loc);
                    if (object != null) continue;
                    throw ErrorContext.iaef((String)"Input %s not found in context of project %s, cannot be used", (Object)((SerializedRecipe.RecipeInput)input).ref, (Object[])new Object[]{projectKey});
                }
                int outputsToCreate = 0;
                for (SerializedRecipe.RecipeOutput output : creationInfo.recipePrototype.getFlatOutputs()) {
                    if (StringUtils.isBlank((String)output.ref)) {
                        throw ErrorContext.iae((String)"Unnamed output");
                    }
                    AnyLoc loc = AnyLoc.resolveSmart((String)projectKey, (String)output.ref);
                    Object object = this.find(loc);
                    if (object != null) continue;
                    ++outputsToCreate;
                }
                if (outputsToCreate > 1) {
                    throw ErrorContext.iaef((String)"Only one dataset output can be created (would need %d)", (Object)outputsToCreate, (Object[])new Object[0]);
                }
                if (outputsToCreate != 1) break block32;
                try {
                    datasetCreationSettings = (SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings)JSON.parse((JsonElement)creationInfo.creationSettings, SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings.class);
                }
                catch (Exception e) {
                    throw ErrorContext.iae((String)"The params in the creationInfo are missing, cannot create output dataset", (Exception)e);
                }
                if (!datasetCreationSettings.createOutputDataset && !datasetCreationSettings.createOutputFolder) {
                    throw ErrorContext.iae((String)"Need to create output dataset or folder, but creationInfo params are suppressing it");
                }
                if (datasetCreationSettings.createOutputDataset) {
                    if (datasetCreationSettings.outputDatasetSettings == null || StringUtils.isBlank((String)datasetCreationSettings.outputDatasetSettings.connectionId)) {
                        throw ErrorContext.iae((String)"Need to create output dataset, need a connection to create it in");
                    }
                    connectionId = datasetCreationSettings.outputDatasetSettings.connectionId;
                } else if (datasetCreationSettings.createOutputFolder) {
                    if (datasetCreationSettings.outputFolderSettings == null || StringUtils.isBlank((String)datasetCreationSettings.outputFolderSettings.connectionId)) {
                        throw ErrorContext.iae((String)"Need to create output folder, need a connection to create it in");
                    }
                    connectionId = datasetCreationSettings.outputFolderSettings.connectionId;
                } else {
                    throw new Error("unreachable");
                }
                DSSConnection connection = this.connectionsDAO.getConnection(authCtx, connectionId);
                if (connection == null) {
                    throw ErrorContext.iaef((String)"Connection %s not found", (Object)datasetCreationSettings.outputDatasetSettings.connectionId, (Object[])new Object[0]);
                }
            }
        }
        RecipeMeta meta = RecipeRegistry.getMeta((String)creationInfo.recipePrototype.type);
        GenericRecipeCreator creator = (GenericRecipeCreator)meta.buildCreator(authCtx);
        assert (creator != null);
        if (rawCreation) {
            SerializedRecipe recipe = (SerializedRecipe)JSON.deepCopy((Object)creationInfo.recipePrototype);
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                logger.info((Object)("Performing raw creation of recipe of type: " + meta.getType()));
                recipe.projectKey = projectKey;
                recipe.name = this.recipeSaveService.transmogrifyName(recipe.projectKey, recipe.name);
                String rawPayload = creationInfo.creationSettings.has("rawPayload") ? creationInfo.creationSettings.get("rawPayload").getAsString() : null;
                SerializedRecipe savedRecipe = this.recipeSaveService.create(projectKey, recipe, rawPayload);
                savedRecipe.name = recipe.name;
                String targetZone = creationInfo.creationSettings.has("zone") ? creationInfo.creationSettings.get("zone").getAsString() : null;
                creator.assignZone(savedRecipe, targetZone);
                t.commitV("Created %s recipe: %s", new Object[]{recipe.type, recipe.getFullId()});
                creationInfo.recipePrototype.name = savedRecipe.name;
            }
        } else {
            creationInfo.recipePrototype.name = creator.create_NT((SerializedRecipe)creationInfo.recipePrototype, (JsonObject)creationInfo.creationSettings).id;
        }
        this.flowGraphService.invalidateCache(projectKey);
        this.auditTrailService.generic("recipe-create").with("projectKey", projectKey).with("recipeName", creationInfo.recipePrototype.name).with("type", creationInfo.recipePrototype.type).emit();
        PublicAPIRecipesController.writeJSON((HttpServletResponse)resp, (Object)new RecipeCreated(creationInfo.recipePrototype.name));
    }

    private Object find(AnyLoc loc) throws IOException {
        SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc);
        if (dataset != null) {
            return dataset;
        }
        StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNullUnsafe(loc);
        if (se != null) {
            return se;
        }
        ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getOrNullUnsafe(loc);
        if (folder != null) {
            return folder;
        }
        SavedModel model = (SavedModel)this.savedModelsDAO.getOrNullUnsafe(loc);
        if (model != null) {
            return model;
        }
        ModelEvaluationStore mes = (ModelEvaluationStore)this.modelEvaluationStoreDAO.getOrNullUnsafe(loc);
        if (mes != null) {
            return mes;
        }
        return null;
    }

    static class OutputSchemaUpdate {
        String computableType;
        String computableId;
        Schema newSchema;
        boolean dropAndRecreate;
        boolean synchronizeMetastore;

        OutputSchemaUpdate() {
        }
    }

    public static class RecipeCreationInfo {
        public SerializedRecipe recipePrototype;
        public JsonObject creationSettings = new JsonObject();
    }

    public static class RecipeCreated {
        public String name;

        RecipeCreated(String name) {
            this.name = name;
        }
    }
}

