/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLDialectsRegistry;
import com.dataiku.dip.sql.queries.ExprDeserializer;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SQLGenerationService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/sql-generation"})
public class PublicAPISQLGenerationController
extends PublicAPIControllerBase {
    @Autowired
    TransactionService transactionService;
    @Autowired
    SQLGenerationService sqlGenerationService;
    @Autowired
    MetaAuthService authService;
    private static Logger logger;

    @AuditNotNeeded
    @RequestMapping(value={"/dialects"})
    public void listDialects(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        SQLGenerationService.Dialects ret = new SQLGenerationService.Dialects((Collection)SQLDialectsRegistry.listAvailable());
        PublicAPISQLGenerationController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/expr"})
    public void generate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String ast, @RequestParam(required=false) String dialect, @RequestParam(required=false) String connection) throws IOException, DKUSecurityException {
        SQLGenerationService.SQLTranslationResult ret;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Got object to translate: " + ast));
        }
        QueryAst.Expr expr = (QueryAst.Expr)JSON.parse((String)ast, QueryAst.Expr.class);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Parsed AST: " + String.valueOf(JSON.toJsonObject((Object)expr))));
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
            SQLDialect sqlDialect = this.sqlGenerationService.getDialect(dialect, connection);
            ret = this.sqlGenerationService.generateSQL(expr, sqlDialect);
        }
        PublicAPISQLGenerationController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    static {
        DKUtils.forceInit(ExprDeserializer.class);
        logger = Logger.getLogger((String)"dku.publicapi.sqlgeneration");
    }
}

