/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.models.filter;

import com.dataiku.scoring.models.filter.FilterUiConditionChecker;
import com.dataiku.scoring.models.filter.SimpleFilterDesc;
import com.dataiku.scoring.pipelines.overrides.OverridesOutcomeComputer;
import com.dataiku.scoring.util.RawObservation;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SimpleFilterDescChecker
implements OverridesOutcomeComputer.OverrideFilter<RawObservation> {
    private final Function<RawObservation, Boolean> matchesInternal;

    @Override
    public Boolean matches(RawObservation obs) {
        return this.matchesInternal.apply(obs);
    }

    public SimpleFilterDescChecker(SimpleFilterDesc filter) {
        this.matchesInternal = SimpleFilterDescChecker.getMatchesMethod(filter.uiData);
    }

    private static Function<RawObservation, Boolean> getMatchesMethod(SimpleFilterDesc.FilterUiData uiData) {
        List conditionCheckers = uiData.conditions.stream().map(FilterUiConditionChecker::new).collect(Collectors.toList());
        if (Objects.equals(uiData.mode, "&&")) {
            return obs -> conditionCheckers.stream().allMatch(c -> c.matches((RawObservation)obs));
        }
        if (Objects.equals(uiData.mode, "||")) {
            return obs -> conditionCheckers.stream().anyMatch(c -> c.matches((RawObservation)obs));
        }
        throw new UnsupportedOperationException("mode not supported: " + uiData.mode);
    }
}

