/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.Row;
import io.trino.jdbc.$internal.client.RowField;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Row {
    private final io.trino.jdbc.$internal.client.Row row;

    Row(io.trino.jdbc.$internal.client.Row row) {
        this.row = Objects.requireNonNull(row, "row is null");
    }

    public List<io.trino.jdbc.RowField> getFields() {
        List<RowField> fields = this.row.getFields();
        ImmutableList.Builder results = ImmutableList.builderWithExpectedSize(fields.size());
        for (RowField field : fields) {
            results.add(new io.trino.jdbc.RowField(field));
        }
        return results.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row other = (Row)o;
        return Objects.equals(this.row, other.row);
    }

    public int hashCode() {
        return this.row.hashCode();
    }

    public String toString() {
        return this.row.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderWithExpectedSize(int fields) {
        return new Builder(fields);
    }

    public static final class Builder {
        private final Row.Builder builder;

        private Builder() {
            this.builder = io.trino.jdbc.$internal.client.Row.builder();
        }

        private Builder(int fields) {
            this.builder = io.trino.jdbc.$internal.client.Row.builderWithExpectedSize(fields);
        }

        public Builder addField(String name, @.Nullable Object value) {
            this.builder.addField(name, value);
            return this;
        }

        public Builder addUnnamedField(@.Nullable Object value) {
            this.builder.addUnnamedField(value);
            return this;
        }

        Builder addField(Optional<String> name, @.Nullable Object value) {
            Objects.requireNonNull(name, "name is null");
            if (name.isPresent()) {
                return this.addField(name.get(), value);
            }
            return this.addUnnamedField(value);
        }

        public Row build() {
            return new Row(this.builder.build());
        }
    }
}

