/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.shaker.processors.time.ical.IntervalTree;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class BinnerAlgorithm {
    private final DoubleMeaning dm = new DoubleMeaning();
    private final DecimalFormat df = new DecimalFormat("#.#########");
    private final Parameter params;
    private IntervalTree<Interval, Double> it;

    public BinnerAlgorithm(Parameter params) {
        this.params = params;
        if (params.mode == Mode.CUSTOM) {
            this.it = IntervalTree.build(params.bins);
        }
        if (!params.useDecimalSeparatorFromLocale) {
            DecimalFormatSymbols dfs = this.df.getDecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.df.setDecimalFormatSymbols(dfs);
        }
    }

    public String bin(String stringValue) {
        Interval bin;
        double val = this.dm.doubleValue(stringValue);
        if (Double.isNaN(val)) {
            bin = new Interval(null, null);
        } else if (this.params.mode == Mode.WIDTH) {
            if (this.params.useMin && val < this.params.min) {
                bin = new Interval(null, this.params.min);
            } else if (this.params.useMax && val >= this.params.max) {
                bin = new Interval(this.params.max, null);
            } else {
                double offset = this.params.useMin ? this.params.min : 0.0;
                double width = this.params.width;
                double inf = offset + Math.floor((val - offset) / width) * width;
                double sup = inf + width;
                if (this.params.useMin && inf < this.params.min) {
                    inf = this.params.min;
                }
                if (this.params.useMax && sup > this.params.max) {
                    sup = this.params.max;
                }
                bin = new Interval(inf, sup);
            }
        } else {
            bin = new Interval(null, null);
            this.it.search(val, i -> {
                bin.inf = i.inf;
                bin.sup = i.sup;
                bin.name = i.name;
            });
        }
        return bin.getName(this.df);
    }

    public static class Parameter
    implements Serializable {
        private static final long serialVersionUID = -1L;
        public Mode mode = Mode.WIDTH;
        public double width = 1.0;
        public boolean useMin;
        public boolean useMax;
        public double min;
        public double max;
        public List<Interval> bins = new ArrayList<Interval>();
        public boolean useDecimalSeparatorFromLocale = false;
    }

    public static enum Mode {
        WIDTH,
        CUSTOM;

    }

    public static class Interval
    implements IntervalTree.Range<Interval, Double>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public Double inf;
        public Double sup;
        public String name;

        public Interval(Double inf, Double sup, String name) {
            this.inf = inf;
            this.sup = sup;
            this.name = name;
        }

        public Interval(Double inf, Double sup) {
            this.inf = inf;
            this.sup = sup;
        }

        public String getName(DecimalFormat df) {
            if (this.name != null && !this.name.isEmpty()) {
                return this.name;
            }
            if (this.inf == null && this.sup == null) {
                return "";
            }
            if (this.inf == null) {
                return "< " + df.format(this.sup);
            }
            if (this.sup == null) {
                return ">= " + df.format(this.inf);
            }
            return df.format(this.inf) + " : " + df.format(this.sup);
        }

        @Override
        public int compareLowerBoundToRange(Interval other) {
            if (this.inf == null) {
                return -1;
            }
            if (other.inf == null) {
                return 1;
            }
            return Double.compare(this.inf, other.inf);
        }

        @Override
        public int compareUpperBoundToRange(Interval other) {
            if (this.sup == null) {
                return 1;
            }
            if (other.sup == null) {
                return -1;
            }
            return Double.compare(this.sup, other.sup);
        }

        @Override
        public int compareLowerBoundToScalar(Double value) {
            if (this.inf == null) {
                return -1;
            }
            return Double.compare(this.inf, value);
        }

        @Override
        public int compareUpperBoundToScalar(Double value) {
            if (this.sup == null) {
                return 1;
            }
            return Double.compare(this.sup, value);
        }
    }
}

