/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractDoubleMeaning;
import com.dataiku.dip.utils.FastSafePatternMatcher;
import java.util.regex.Pattern;

public class Longitude
extends AbstractDoubleMeaning {
    private static final Pattern REMOVE_END = Pattern.compile("\u00b0?[WE]?$");
    private static final FastSafePatternMatcher FAST_LONGITUDE_MATCHER = new FastSafePatternMatcher("[\\x00-\\x20]*[+-]?(((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))))[\\x00-\\x20]*[\u00b0]?[EW]?");
    private static final FastSafePatternMatcher INT_MILLI_MATCHER = new FastSafePatternMatcher("[\\x00-\\x20]*[+-]([0-9]{6})");

    public static double convert(String s) {
        int n;
        double out;
        if (INT_MILLI_MATCHER.matches(s) && (out = (double)(n = Integer.parseInt(s.replace("+", ""))) / 1000.0) <= 180.0 && out >= -180.0) {
            return out;
        }
        if (FAST_LONGITUDE_MATCHER.matches(s)) {
            boolean negative = false;
            if (s.endsWith("W")) {
                negative = true;
            }
            try {
                double d = Double.parseDouble(REMOVE_END.matcher(s).replaceAll(""));
                if (d >= -180.0 && d <= 180.0) {
                    return negative ? -d : d;
                }
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    @Override
    public double detects(String val) {
        if (val == null) {
            return 0.0;
        }
        if (INT_MILLI_MATCHER.matches(val)) {
            int n = Integer.parseInt(val.replace("+", ""));
            double out = (double)n / 1000.0;
            if (out <= 180.0 && out >= -180.0) {
                return 0.6;
            }
        } else if (FAST_LONGITUDE_MATCHER.matches(val)) {
            try {
                double d = Double.parseDouble(REMOVE_END.matcher(val).replaceAll(""));
                if (d >= -180.0 && d <= 180.0) {
                    if (val.endsWith("W") || val.endsWith("E")) {
                        return 0.9;
                    }
                    if (val.contains("\u00b0")) {
                        return 0.6;
                    }
                    if (val.contains(".")) {
                        return 0.15;
                    }
                    return 0.01;
                }
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    public double doubleValue(String v) {
        if (v == null) {
            return Double.NaN;
        }
        return Longitude.convert(v);
    }
}

