/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.semiimpl;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SemiKnownColumnFactory
implements ColumnFactory {
    private List<SemiKnownColumn> list = new ArrayList<SemiKnownColumn>();
    private Map<String, SemiKnownColumn> map = new LinkedHashMap<String, SemiKnownColumn>();

    public synchronized Column column(String name) {
        SemiKnownColumn c = this.map.get(name);
        if (c == null) {
            c = new SemiKnownColumn();
            c.name = name;
            this.list.add(c);
            this.map.put(name, c);
        }
        return c;
    }

    public synchronized Column column(String name, Processor.ProcessorRole role) {
        return this.column(name);
    }

    public synchronized Column getColumn(String name) {
        return this.map.get(name);
    }

    public synchronized SemiKnownColumn columnAfter(String before, String after) {
        SemiKnownColumn c = this.map.get(after);
        if (c == null) {
            c = new SemiKnownColumn();
            c.name = after;
            SemiKnownColumn beforeCD = this.map.get(before);
            if (beforeCD != null) {
                int index = this.list.indexOf((Object)beforeCD);
                this.list.add(index + 1, c);
            } else {
                this.list.add(c);
            }
            this.map.put(after, c);
        }
        return c;
    }

    public synchronized SemiKnownColumn columnAfter(String before, String after, Processor.ProcessorRole role) {
        return this.columnAfter(before, after);
    }

    public Column columnBefore(String after, String newCol) {
        if (after == null) {
            return this.column(newCol);
        }
        SemiKnownColumn c = this.map.get(newCol);
        if (c == null) {
            c = new SemiKnownColumn();
            c.name = newCol;
            SemiKnownColumn afterCD = this.map.get(after);
            if (afterCD != null) {
                int index = this.list.indexOf((Object)afterCD);
                this.list.add(index, c);
            } else {
                this.list.add(c);
            }
            this.map.put(newCol, c);
        }
        return c;
    }

    public Column columnBefore(String after, String newCol, Processor.ProcessorRole role) {
        return this.columnBefore(after, newCol);
    }

    public Column getColumnAfter(String current) {
        int index;
        SemiKnownColumn beforeCD = this.map.get(current);
        if (beforeCD != null && (index = this.list.indexOf((Object)beforeCD)) + 1 < this.list.size()) {
            return this.list.get(index + 1);
        }
        return null;
    }

    public synchronized void moveAtStart(String name) {
        SemiKnownColumn column = this.map.remove(name);
        if (column != null) {
            LinkedHashMap<String, SemiKnownColumn> copy = new LinkedHashMap<String, SemiKnownColumn>(this.map);
            this.map.clear();
            this.map.put(name, column);
            this.map.putAll(copy);
        }
    }

    public synchronized void moveAtEnd(String name) {
        SemiKnownColumn column = this.map.remove(name);
        if (column != null) {
            LinkedHashMap<String, SemiKnownColumn> copy = new LinkedHashMap<String, SemiKnownColumn>(this.map);
            this.map.clear();
            this.map.putAll(copy);
            this.map.put(name, column);
        }
    }

    public synchronized void moveBefore(String after, String name) {
        SemiKnownColumn column;
        if (this.map.containsKey(after) && (column = this.map.remove(name)) != null) {
            LinkedHashMap<String, SemiKnownColumn> copy = new LinkedHashMap<String, SemiKnownColumn>(this.map);
            this.map.clear();
            for (Map.Entry entry : copy.entrySet()) {
                if (((String)entry.getKey()).equals(after)) {
                    this.map.put(name, column);
                }
                this.map.put((String)entry.getKey(), (SemiKnownColumn)((Object)entry.getValue()));
            }
        }
    }

    public synchronized void moveAfter(String before, String name) {
        SemiKnownColumn column;
        if (this.map.containsKey(before) && (column = this.map.remove(name)) != null) {
            LinkedHashMap<String, SemiKnownColumn> copy = new LinkedHashMap<String, SemiKnownColumn>(this.map);
            this.map.clear();
            for (Map.Entry entry : copy.entrySet()) {
                this.map.put((String)entry.getKey(), (SemiKnownColumn)((Object)entry.getValue()));
                if (!((String)entry.getKey()).equals(before)) continue;
                this.map.put(name, column);
            }
        }
    }

    public synchronized void deleteColumn(String name) {
    }

    synchronized void renameColumn(SemiKnownColumn sc, String newName) {
        this.map.remove(sc.getName());
        sc.name = newName;
        this.map.put(newName, sc);
    }

    public synchronized Iterable<Column> columns() {
        ArrayList<Column> l = new ArrayList<Column>();
        l.addAll(this.list);
        return l;
    }

    private class SemiKnownColumn
    extends Column {
        private String name;

        private SemiKnownColumn() {
        }

        public String getName() {
            return this.name;
        }

        public SemiKnownColumn setName(String name) {
            SemiKnownColumnFactory.this.renameColumn(this, name);
            return this;
        }

        public String toString() {
            return "[SKC:" + this.name + "]";
        }
    }
}

