/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.StructuredPojo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.BackfillErrorCode;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.PartitionValueList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform.BackfillErrorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BackfillError
implements Serializable,
Cloneable,
StructuredPojo {
    private String code;
    private List<PartitionValueList> partitions;

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public BackfillError withCode(String code) {
        this.setCode(code);
        return this;
    }

    public BackfillError withCode(BackfillErrorCode code) {
        this.code = code.toString();
        return this;
    }

    public List<PartitionValueList> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Collection<PartitionValueList> partitions) {
        if (partitions == null) {
            this.partitions = null;
            return;
        }
        this.partitions = new ArrayList<PartitionValueList>(partitions);
    }

    public BackfillError withPartitions(PartitionValueList ... partitions) {
        if (this.partitions == null) {
            this.setPartitions(new ArrayList<PartitionValueList>(partitions.length));
        }
        for (PartitionValueList ele : partitions) {
            this.partitions.add(ele);
        }
        return this;
    }

    public BackfillError withPartitions(Collection<PartitionValueList> partitions) {
        this.setPartitions(partitions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCode() != null) {
            sb.append("Code: ").append(this.getCode()).append(",");
        }
        if (this.getPartitions() != null) {
            sb.append("Partitions: ").append(this.getPartitions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackfillError)) {
            return false;
        }
        BackfillError other = (BackfillError)obj;
        if (other.getCode() == null ^ this.getCode() == null) {
            return false;
        }
        if (other.getCode() != null && !other.getCode().equals(this.getCode())) {
            return false;
        }
        if (other.getPartitions() == null ^ this.getPartitions() == null) {
            return false;
        }
        return other.getPartitions() == null || other.getPartitions().equals(this.getPartitions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCode() == null ? 0 : this.getCode().hashCode());
        hashCode = 31 * hashCode + (this.getPartitions() == null ? 0 : this.getPartitions().hashCode());
        return hashCode;
    }

    public BackfillError clone() {
        try {
            return (BackfillError)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackfillErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

