/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.server;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.util.jcleanstack.StackUnicizer;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;

@UIModel
public class APIError
extends SerializedError {
    @Nullable
    public Integer httpStatusCode;
    @Nullable
    public Map<String, String> headers;

    public APIError() {
    }

    public APIError(String type, String message) {
        this.errorType = type;
        this.message = message;
        this.detailedMessage = message;
    }

    public APIError(String type, String message, int httpStatusCode) {
        this(type, message);
        this.httpStatusCode = httpStatusCode;
    }

    public APIError(Throwable t, boolean storeStack, boolean storeForeignStack, boolean storeLogTail) {
        super(t, storeStack, storeForeignStack, storeLogTail);
        if (t instanceof APIErrorException && ((APIErrorException)t).error instanceof APIError) {
            this.httpStatusCode = ((APIError)((APIErrorException)t).error).httpStatusCode;
        }
    }

    public APIError(Throwable t, boolean storeStack) {
        this(t, storeStack, true, true);
    }

    public APIError(Throwable t) {
        this(t, true, true, true);
    }

    public void unicizeStack() {
        StackUnicizer.unicizeStackTrace(this.stackTrace);
    }

    @Override
    public APIError withCode(InfoMessage.MessageCode code) {
        this.code = code.getCode();
        this.title = code.getCodeTitle();
        this.fixability = code.getFixability();
        return this;
    }

    public static class APIErrorException
    extends SerializedErrorException {
        private static final long serialVersionUID = 1L;

        public APIErrorException(APIError error) {
            super(error);
        }
    }

    public static class SerializedErrorException
    extends IOException {
        private static final long serialVersionUID = 1L;
        public SerializedError error;

        public SerializedErrorException(SerializedError error) {
            super(error.detailedMessage != null ? error.detailedMessage : error.message);
            this.error = error;
        }
    }
}

