/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.SessionsDAO;
import com.dataiku.dip.dao.UserSession;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FileBasedSessionsDAO2
implements SessionsDAO,
Closeable {
    private static final String EXPIRING_USER_SESSION_FOR = "Expiring user session for ";
    private static final RelFile SESSION_FILE_PATH = RelFile.fromPath("run/user-sessions.json");
    private final ConcurrentHashMap<String, UserSession> accessTokenToSession = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, UserSession> identityTokenToSession = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> userToAccessTokens = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> userToIdentityTokens = new ConcurrentHashMap();
    private final MetricRegistry metricSet;
    private final Timer flushToDiskTimer;
    private final Thread maintenanceThread;
    private volatile boolean flushNeededForRefresh = false;
    private volatile boolean flushNeededForChange = false;
    private boolean stopped = false;
    private final NativeFS dataDirFs;
    private final SessionManagerConfig sessionManagerConfig;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sessions.files2");

    public FileBasedSessionsDAO2() throws IOException {
        this(SessionManagerConfig.DEFAULT);
    }

    public FileBasedSessionsDAO2(SessionManagerConfig sessionManagerConfig) throws IOException {
        this.sessionManagerConfig = sessionManagerConfig;
        this.dataDirFs = NativeFS.from(DKUApp.getBaseFolderF()).atomicWrite(true).build();
        this.metricSet = new MetricRegistry();
        this.metricSet.gauge("count", () -> this.accessTokenToSession::size);
        this.flushToDiskTimer = this.metricSet.timer("flushToDisk");
        this.maintenanceThread = new Thread(this::runBackgroundPeriodicMaintenance, "session-mgmt-maintenance");
        this.loadFromDisk();
        this.maintenanceThread.start();
    }

    @Override
    public void addSession(String userLogin, UserSession session) throws IOException {
        session.user = userLogin;
        if (session.user == null || session.identityToken == null || session.accessToken == null) {
            logger.error((Object)"Cannot persist a session with null user, identityToken or accessToken");
        }
        boolean forceSingleSessionPerUser = this.sessionManagerConfig.getForceSingleSessionPerUser();
        this.addSession(forceSingleSessionPerUser, session);
    }

    @Override
    public MetricSet getMetrics() {
        return this.metricSet;
    }

    @Override
    public void removeExistingSessionsForUser(String userLogin) {
        UserSession session;
        if (userLogin == null) {
            return;
        }
        ArrayList<UserSession> sessionsToRemove = new ArrayList<UserSession>();
        for (String accessToken : this.userToAccessTokens.getOrDefault(userLogin, Set.of())) {
            session = this.accessTokenToSession.get(accessToken);
            if (session == null) continue;
            sessionsToRemove.add(session);
        }
        for (String identityToken : this.userToIdentityTokens.getOrDefault(userLogin, Set.of())) {
            session = this.identityTokenToSession.get(identityToken);
            if (session == null) continue;
            sessionsToRemove.add(session);
        }
        sessionsToRemove.forEach(this::removeSession);
    }

    @Override
    public void removeSession(String accessToken) throws IOException {
        UserSession session = this.accessTokenToSession.get(accessToken);
        if (session != null) {
            this.removeSession(session);
        }
    }

    @Override
    public UserSession getUserLoginWithSession(String accessToken) throws IOException {
        UserSession us = this.accessTokenToSession.get(accessToken);
        if (us != null) {
            us.refreshed = System.currentTimeMillis();
            this.flushNeededForRefresh = true;
        }
        return us;
    }

    @Override
    public UserSession getUserLoginWithIdentity(String identityToken) throws IOException {
        UserSession us = this.identityTokenToSession.get(identityToken);
        if (us != null) {
            us.refreshed = System.currentTimeMillis();
            this.flushNeededForRefresh = true;
        }
        return us;
    }

    private synchronized void removeSession(UserSession session) {
        this.accessTokenToSession.remove(session.accessToken);
        this.identityTokenToSession.remove(session.identityToken);
        if (session.user != null) {
            ((Set)this.userToAccessTokens.getOrDefault(session.user, new HashSet())).remove(session.accessToken);
            ((Set)this.userToIdentityTokens.getOrDefault(session.user, new HashSet())).remove(session.identityToken);
        }
        this.flushNeededForChange = true;
    }

    private synchronized void addSession(boolean forceSingleSessionPerUser, UserSession session) {
        if (forceSingleSessionPerUser) {
            this.removeExistingSessionsForUser(session.user);
        }
        this.accessTokenToSession.put(session.accessToken, session);
        this.identityTokenToSession.put(session.identityToken, session);
        if (session.user != null) {
            this.userToIdentityTokens.computeIfAbsent(session.user, k -> new HashSet()).add(session.identityToken);
            this.userToAccessTokens.computeIfAbsent(session.user, k -> new HashSet()).add(session.accessToken);
        }
        this.flushNeededForChange = true;
    }

    private synchronized void clearAll() {
        this.accessTokenToSession.clear();
        this.identityTokenToSession.clear();
        this.userToAccessTokens.clear();
        this.userToIdentityTokens.clear();
        this.flushNeededForChange = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void flushToDiskIfNeeded(boolean force) throws IOException {
        SessionsFile sessionFileData;
        Timer.Context tctx;
        boolean persistOnDisk = this.sessionManagerConfig.getPersistOnDisk();
        boolean isIdleTimeoutEnabled = this.sessionManagerConfig.getSessionsMaxIdleTimeMinutes() > 0L;
        FileBasedSessionsDAO2 fileBasedSessionsDAO2 = this;
        synchronized (fileBasedSessionsDAO2) {
            if (!persistOnDisk) {
                return;
            }
            if (!(force || isIdleTimeoutEnabled && this.flushNeededForRefresh || this.flushNeededForChange)) {
                return;
            }
            this.flushNeededForRefresh = false;
            this.flushNeededForChange = false;
            tctx = this.flushToDiskTimer.time();
            sessionFileData = new SessionsFile();
            sessionFileData.tokens = new ArrayList<UserSession>(this.accessTokenToSession.size());
            for (UserSession s : this.accessTokenToSession.values()) {
                sessionFileData.tokens.add(s.copy());
            }
        }
        logger.debug((Object)("Flushing " + sessionFileData.tokens.size() + " sessions to disk"));
        try (RelFileOutputStream os = this.dataDirFs.writeStream(SESSION_FILE_PATH);){
            JSON.json((Object)sessionFileData, (OutputStream)((Object)os));
        }
        tctx.close();
    }

    private void loadFromDisk() throws IOException {
        SessionsFile sessionFileData;
        this.clearAll();
        if (!this.sessionManagerConfig.getPersistOnDisk()) {
            return;
        }
        try {
            sessionFileData = this.dataDirFs.readObjectDefault(SESSION_FILE_PATH, SessionsFile.class);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load sessions from disk", (Throwable)e);
            sessionFileData = new SessionsFile();
        }
        if (sessionFileData.tokens != null) {
            for (UserSession session : sessionFileData.tokens) {
                this.addSession(session.user, session);
            }
        }
    }

    protected long getNow() {
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    void cleanupExpired() throws IOException {
        long now = this.getNow();
        long sessionsMaxTotalTimeMinutes = this.sessionManagerConfig.getSessionsMaxTotalTimeMinutes();
        long sessionsMaxIdleTimeMinutes = this.sessionManagerConfig.getSessionsMaxIdleTimeMinutes();
        ArrayList<UserSession> expiredSessions = new ArrayList<UserSession>();
        for (UserSession s : this.accessTokenToSession.values()) {
            if (sessionsMaxTotalTimeMinutes > 0L && s.granted + sessionsMaxTotalTimeMinutes * 60L * 1000L < now) {
                this.sessionManagerConfig.onSessionExpired(s.user, ExpirationType.GRANT_EXPIRED);
                logger.info((Object)(EXPIRING_USER_SESSION_FOR + s.user + " (" + String.valueOf((Object)ExpirationType.GRANT_EXPIRED) + ")"));
                expiredSessions.add(s);
                continue;
            }
            if (sessionsMaxIdleTimeMinutes <= 0L || s.refreshed + sessionsMaxIdleTimeMinutes * 60L * 1000L >= now) continue;
            this.sessionManagerConfig.onSessionExpired(s.user, ExpirationType.REFRESH_EXPIRED);
            logger.info((Object)(EXPIRING_USER_SESSION_FOR + s.user + " (" + String.valueOf((Object)ExpirationType.REFRESH_EXPIRED) + ")"));
            expiredSessions.add(s);
        }
        expiredSessions.forEach(this::removeSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runBackgroundPeriodicMaintenance() {
        logger.info((Object)"Background maintenance thread started");
        try {
            while (true) {
                try {
                    while (true) {
                        this.cleanupExpired();
                        this.flushToDiskIfNeeded(false);
                        long flushPeriodSeconds = Math.max(this.sessionManagerConfig.getFlushPeriodSeconds(), 1L);
                        FileBasedSessionsDAO2 fileBasedSessionsDAO2 = this;
                        synchronized (fileBasedSessionsDAO2) {
                            if (this.stopped) {
                                return;
                            }
                            this.wait(flushPeriodSeconds * 1000L);
                            if (this.stopped) {
                                return;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to run periodic maintenance", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        finally {
            logger.info((Object)"Background maintenance thread stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        logger.info((Object)"Shutting down session manager...");
        FileBasedSessionsDAO2 fileBasedSessionsDAO2 = this;
        synchronized (fileBasedSessionsDAO2) {
            this.stopped = true;
            this.notifyAll();
        }
        try {
            this.maintenanceThread.join(1000L);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Failed to stop background thread", (Throwable)e);
        }
        if (this.maintenanceThread.isAlive()) {
            logger.error((Object)"Background thread is still running");
        }
        try {
            this.cleanupExpired();
            this.flushToDiskIfNeeded(false);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to flush sessions to disk during shutdown", (Throwable)e);
        }
    }

    public static interface SessionManagerConfig {
        public static final SessionManagerConfig DEFAULT = new DefaultSessionManagerConfig();

        public void onSessionExpired(String var1, ExpirationType var2);

        public long getSessionsMaxIdleTimeMinutes() throws IOException;

        public long getSessionsMaxTotalTimeMinutes() throws IOException;

        public boolean getForceSingleSessionPerUser() throws IOException;

        public boolean getPersistOnDisk() throws IOException;

        public long getFlushPeriodSeconds() throws IOException;
    }

    public static class SessionsFile {
        public List<UserSession> tokens = new ArrayList<UserSession>();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ExpirationType {
        FORCED_BY_TOKEN{

            public String toString() {
                return "forced by token";
            }
        }
        ,
        REFRESH_EXPIRED{

            public String toString() {
                return "refresh expired";
            }
        }
        ,
        GRANT_EXPIRED{

            public String toString() {
                return "grant expired";
            }
        }
        ,
        FORCE_SINGLE_SESSION{

            public String toString() {
                return "force single session";
            }
        };

    }

    public static class DefaultSessionManagerConfig
    implements SessionManagerConfig {
        @Override
        public void onSessionExpired(String user, ExpirationType expirationType) {
        }

        @Override
        public long getSessionsMaxIdleTimeMinutes() {
            return 0L;
        }

        @Override
        public long getSessionsMaxTotalTimeMinutes() {
            return 0L;
        }

        @Override
        public boolean getForceSingleSessionPerUser() {
            return false;
        }

        @Override
        public boolean getPersistOnDisk() {
            return true;
        }

        @Override
        public long getFlushPeriodSeconds() {
            return 60L;
        }
    }
}

