/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.dataiku.dip.io.SocketBlockLinkInvalidLengthException;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.CloseShieldInputStream;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.NullInputStream;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelib.reactor.core.Disposable;
import com.dataiku.dss.shadelib.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelib.reactor.core.publisher.FluxSink;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class JavaBlockLink
implements AutoCloseable {
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private ByteBuffer readIntBuffer = ByteBuffer.allocate(4);
    private ByteBuffer writeIntBuffer;
    private ReadableByteChannel inputChannel;
    private WritableByteChannel outputChannel;
    private AsyncJavaLink asyncLink;
    private static final int MAX_JSON_SAMPLE_LOG_LENGTH = 120;
    private static final Logger logger = Logger.getLogger((String)"dku.block.link");

    public JavaBlockLink() throws IOException {
        this.readIntBuffer.order(ByteOrder.BIG_ENDIAN);
        this.writeIntBuffer = ByteBuffer.allocate(4);
        this.writeIntBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
        if (socket == null) {
            this.inputStream = null;
            this.outputStream = null;
            this.inputChannel = null;
            this.outputChannel = null;
        } else {
            this.inputStream = socket.getInputStream();
            this.outputStream = socket.getOutputStream();
            this.inputChannel = Channels.newChannel(this.inputStream);
            this.outputChannel = Channels.newChannel(this.outputStream);
        }
    }

    public boolean hasSocket() {
        return this.socket != null;
    }

    public synchronized boolean isAlive() {
        return this.socket != null && (this.asyncLink == null || !this.asyncLink.closed);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void sendRequest(Object command) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException("The connection has not been established");
        }
        String commandData = JSON.json((Object)command);
        byte[] commandBytes = commandData.getBytes(StandardCharsets.UTF_8);
        this.sendInt(commandBytes.length);
        this.sendBytes(commandBytes);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Sent\n" + commandData));
        }
    }

    public void sendStringRequest(String commandData) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException("The connection has not been established");
        }
        byte[] commandBytes = commandData.getBytes(StandardCharsets.UTF_8);
        this.sendInt(commandBytes.length);
        this.sendBytes(commandBytes);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Sent\n" + commandData));
        }
    }

    public void sendNullCommand() throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException("The connection has not been established");
        }
        this.sendInt(0);
        logger.trace((Object)"Sent null command");
    }

    public void receiveNullCommand() throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException("The connection has not been established");
        }
        int blockLength = this.receiveInt();
        if (blockLength != 0) {
            throw new IllegalStateException("Got a non-null command");
        }
        logger.trace((Object)"Got null command");
    }

    public <TResp> TResp receiveResponse(Class<? extends TResp> clazz) throws IOException {
        return (TResp)JSON.parse((String)this.receiveStringResponse(), clazz);
    }

    public String receiveStringResponse(int maxExpectedLength) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException("The connection has not been established");
        }
        int blockLength = this.receiveInt();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received " + blockLength + " bytes"));
        }
        if (maxExpectedLength >= 0 && blockLength > maxExpectedLength) {
            throw new SocketBlockLinkInvalidLengthException("An unexpected block length has been received: " + blockLength + " > " + maxExpectedLength);
        }
        byte[] blockData = this.receiveBytes(blockLength);
        String blockString = new String(blockData, StandardCharsets.UTF_8);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received\n" + blockString));
        }
        return blockString;
    }

    public String receiveStringResponse() throws IOException {
        return this.receiveStringResponse(-1);
    }

    public synchronized AsyncJavaLink getAsyncLink() {
        if (this.asyncLink == null) {
            this.asyncLink = new AsyncJavaLink(90, 5);
        }
        return this.asyncLink;
    }

    public <TResp> TResp receiveJsonResponse(Class<? extends TResp> clazz) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException("The connection has not been established");
        }
        int blockLength = this.receiveInt();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received " + blockLength + " bytes"));
        }
        if (blockLength == 0) {
            return null;
        }
        byte[] blockData = this.receiveBytes(blockLength);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received json:\n" + new String(blockData, StandardCharsets.UTF_8)));
        }
        return (TResp)JSON.parse((InputStream)new ByteArrayInputStream(blockData), clazz);
    }

    public <TResp> TResp receiveJsonResponse(TypeToken<? extends TResp> clazz) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException("The connection has not been established");
        }
        int blockLength = this.receiveInt();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received " + blockLength + " bytes"));
        }
        if (blockLength == 0) {
            return null;
        }
        byte[] blockData = this.receiveBytes(blockLength);
        return (TResp)JSON.parse((InputStream)new ByteArrayInputStream(blockData), clazz);
    }

    public void sendStream(InputStream stream, int maxChunkSize) throws IOException {
        byte[] block = new byte[maxChunkSize];
        int read = stream.read(block);
        while (read >= 0) {
            if (read == 0) {
                logger.info((Object)"Empty read from stream");
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Sending " + read + " bytes"));
                }
                this.sendInt(read);
                this.sendBytes(block, read);
            }
            read = stream.read(block);
        }
        this.sendInt(0);
        this.flush();
    }

    public WrappedSocketBlockLinkOutputStream sendStreamAsync(int maxChunkSize) {
        return new WrappedSocketBlockLinkOutputStream(this, maxChunkSize);
    }

    public InputStream receiveStream() {
        return new SequenceInputStream(new ReceiverInputStreamEnumerator()){

            @Override
            public int read() throws IOException {
                try {
                    return super.read();
                }
                catch (WrappedIOException e) {
                    throw e.unwrap();
                }
            }

            @Override
            public int read(byte[] b) throws IOException {
                try {
                    return super.read(b);
                }
                catch (WrappedIOException e) {
                    throw e.unwrap();
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    return super.read(b, off, len);
                }
                catch (WrappedIOException e) {
                    throw e.unwrap();
                }
            }

            @Override
            public void close() throws IOException {
                ByteStreams.exhaust((InputStream)this);
                super.close();
            }
        };
    }

    public void receiveStream(OutputStream stream, int maxChunkSize) throws IOException {
        int blockLength;
        do {
            int chunkRead;
            blockLength = this.receiveInt();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Received " + blockLength + " bytes"));
            }
            int chunkLength = Math.min(blockLength, maxChunkSize);
            byte[] blockData = new byte[chunkLength];
            for (int read = 0; read < blockLength; read += chunkRead) {
                try {
                    chunkRead = this.inputStream.read(blockData, 0, Math.min(chunkLength, blockLength - read));
                }
                catch (IOException e) {
                    throw new ReceiveFromSocketIOException("Failed to read from socket block link", e);
                }
                if (chunkRead < 0) {
                    throw new EOFException("Unexpected end of stream while reading block (" + read + " read)");
                }
                try {
                    stream.write(blockData, 0, chunkRead);
                    continue;
                }
                catch (IOException e) {
                    throw new ReceiveToStreamIOException("Failed to write", e);
                }
            }
        } while (blockLength > 0);
    }

    @Override
    public void close() throws IOException {
        if (this.asyncLink != null) {
            this.asyncLink.close();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
                logger.info((Object)"Closed socket");
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close socket", (Throwable)e);
                throw e;
            }
        }
    }

    private void sendInt(int x) throws IOException {
        this.writeIntBuffer.clear();
        this.writeIntBuffer.putInt(x);
        this.writeIntBuffer.flip();
        while (this.writeIntBuffer.hasRemaining()) {
            this.outputChannel.write(this.writeIntBuffer);
        }
    }

    private void sendBytes(byte[] x) throws IOException {
        this.sendBytes(x, x.length);
    }

    private void sendBytes(byte[] x, int length) throws IOException {
        this.outputStream.write(x, 0, length);
    }

    private void sendBytes(byte[] x, int length, int offset) throws IOException {
        this.outputStream.write(x, offset, length);
    }

    private int receiveInt() throws IOException {
        this.readIntBuffer.clear();
        while (this.readIntBuffer.hasRemaining()) {
            logger.trace((Object)"Read an int");
            int read = this.inputChannel.read(this.readIntBuffer);
            if (read >= 0) continue;
            throw new EOFException();
        }
        this.readIntBuffer.flip();
        return this.readIntBuffer.getInt();
    }

    private byte[] receiveBytes(int length) throws IOException {
        if (length < 0) {
            throw new SocketBlockLinkInvalidLengthException("Wire protocol received a block length of " + length);
        }
        byte[] x = new byte[length];
        IOUtils.readFully((InputStream)this.inputStream, (byte[])x);
        return x;
    }

    protected <TResp> SocketBlockLinkInteraction<TResp> newInteraction() {
        return new SocketBlockLinkInteraction(this);
    }

    public class AsyncJavaLink {
        private final ExecutorService executor = Executors.newFixedThreadPool(2);
        private final LinkedBlockingQueue<Action<?>> actionsQueue = new LinkedBlockingQueue();
        private final Map<String, ActiveRequest<?>> pendingRequests = new ConcurrentHashMap();
        private final int keepAliveInternalSeconds;
        private boolean closed = false;

        private AsyncJavaLink(int readTimeoutSeconds, int keepAliveInternalSeconds) {
            this.keepAliveInternalSeconds = keepAliveInternalSeconds;
            try {
                JavaBlockLink.this.socket.setSoTimeout(readTimeoutSeconds * 1000);
            }
            catch (SocketException e) {
                throw new RuntimeException("Could not set TCP timeout", e);
            }
            this.executor.submit(new RequestSender());
            this.executor.submit(new ResponseReceiver());
        }

        private <T> T receive(Class<T> clazz) throws IOException {
            T resp = JavaBlockLink.this.receiveJsonResponse(clazz);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("RECV " + JSON.json(resp)));
            }
            return resp;
        }

        private void send(Object obj) throws IOException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("SEND " + JSON.json((Object)obj)));
            }
            JavaBlockLink.this.sendRequest(obj);
        }

        private RequestFailedException error(String e) {
            logger.error((Object)e);
            return new RequestFailedException(e);
        }

        private synchronized void clean(Exception reason) {
            this.closed = true;
            logger.info((Object)"Cleaning started");
            this.executor.shutdownNow();
            String requestFailedMessage = "AsyncLink shutdown" + (String)(reason != null ? ": " + ExceptionUtils.getMessageWithCauses((Throwable)reason) : "");
            for (ActiveRequest<?> request : this.pendingRequests.values()) {
                request.sink.error((Throwable)new RequestFailedException(requestFailedMessage));
            }
            this.pendingRequests.clear();
            logger.info((Object)"Cleaning done");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            AsyncJavaLink asyncJavaLink = this;
            synchronized (asyncJavaLink) {
                if (this.closed) {
                    logger.info((Object)"Closing AsyncLink was already requested");
                    return;
                }
                this.closed = true;
            }
            logger.info((Object)"Closing AsyncLink");
            try {
                this.actionsQueue.put(new Action(ActionMessageType.STOP));
                this.executor.shutdown();
                if (!this.executor.awaitTermination(DKUApp.getParams().getIntParam("dku.async.link.termination.timeout", Integer.valueOf(60)), TimeUnit.SECONDS)) {
                    logger.error((Object)"Time out when waiting for sender and receiver threads to complete");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.info((Object)"Interrupted while closing AsyncLink", (Throwable)e);
            }
            finally {
                this.clean(null);
            }
            logger.info((Object)"AsyncLink is closed");
        }

        public <ResponseType> ResponseType request(Object request, Class<ResponseType> responsePayloadType) {
            return (ResponseType)this.asyncStreamRequest(request, responsePayloadType).blockLast();
        }

        public <ResponseType> Flux<ResponseType> asyncStreamRequest(Object request, Class<ResponseType> responsePayloadType) {
            return Flux.push(sink -> {
                ActiveRequest req = new ActiveRequest();
                req.id = UUID.randomUUID().toString();
                req.requestPayload = request;
                req.responsePayloadType = responsePayloadType;
                req.sink = sink;
                boolean added = false;
                AsyncJavaLink asyncJavaLink = this;
                synchronized (asyncJavaLink) {
                    if (!this.closed && !this.executor.isShutdown()) {
                        added = true;
                        this.pendingRequests.put(req.id, req);
                    }
                }
                if (added) {
                    sink.onCancel(() -> {
                        try {
                            this.actionsQueue.put(new Action(ActionMessageType.CANCEL, req));
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            logger.error((Object)("Interrupted while <Cancel " + req.id + "> was put in queue"), (Throwable)e);
                        }
                    });
                    try {
                        this.actionsQueue.put(new Action(ActionMessageType.START, req));
                    }
                    catch (InterruptedException e) {
                        AsyncJavaLink asyncJavaLink2 = this;
                        synchronized (asyncJavaLink2) {
                            this.pendingRequests.remove(req.id);
                        }
                        sink.error((Throwable)new RuntimeException("Interrupted while <Start " + req.id + "> was put in queue", e));
                    }
                } else {
                    sink.error((Throwable)new RequestFailedException("AsyncLink is closed"));
                }
            });
        }

        public <PythonResponseType, JavaResponseType> CompletableFuture<JavaResponseType> asyncSendRequest(Object requestPayload, Class<PythonResponseType> pythonResponseType, ExceptionUtils.ThrowingFunction<PythonResponseType, JavaResponseType, Exception> pythonToJavaResponseMapper, Function<? super Throwable, ? extends Throwable> errorMapper) {
            logger.debug((Object)("Sampled request before sending it to the Python link: " + JSON.safeSampleJson((Object)requestPayload, (int)120)));
            return this.asyncStreamRequest(requestPayload, pythonResponseType).last().handle((pythonResponse, synchronousSink) -> {
                logger.debug((Object)("Python response sample: " + JSON.safeSampleJson((Object)pythonResponse, (int)120)));
                try {
                    synchronousSink.next(pythonToJavaResponseMapper.apply(pythonResponse));
                }
                catch (Exception e) {
                    synchronousSink.error((Throwable)e);
                }
            }).onErrorMap(errorMapper).toFuture();
        }

        public <PythonResponseType, JavaResponseType> CompletableFuture<JavaResponseType> asyncSendRequest(Object requestPayload, Class<PythonResponseType> pythonResponseType, ExceptionUtils.ThrowingFunction<PythonResponseType, JavaResponseType, Exception> pythonToJavaResponseMapper) {
            return this.asyncSendRequest(requestPayload, pythonResponseType, pythonToJavaResponseMapper, e -> e);
        }

        public <PythonResponseType> CompletableFuture<PythonResponseType> asyncSendRequest(Object requestPayload, Class<PythonResponseType> pythonResponseType, Function<? super Throwable, ? extends Throwable> errorMapper) {
            return this.asyncSendRequest(requestPayload, pythonResponseType, resp -> resp, AsyncJavaLink.wrapWithLogging(errorMapper));
        }

        private static Function<? super Throwable, ? extends Throwable> wrapWithLogging(Function<? super Throwable, ? extends Throwable> mapper) {
            return e -> {
                Throwable mappedException = (Throwable)mapper.apply((Throwable)e);
                logger.info((Object)String.format("Mapped '%s' exception to '%s' exception.", e.getClass(), mappedException.getClass()));
                return mappedException;
            };
        }

        public <ChunkType> CompletableFuture<Integer> asyncStreamRequest(Object requestPayload, Class<ChunkType> chunkTypeClass, ExceptionUtils.ThrowingRunnable<Exception> onStreamStarted, ExceptionUtils.ThrowingConsumer<ChunkType, Exception> chunkConsumer, ExceptionUtils.ThrowingRunnable<Exception> onStreamCompleted) {
            logger.debug((Object)("Sampled stream request payload: " + JSON.safeSampleJson((Object)requestPayload, (int)120)));
            CompletableFuture<Integer> streamFuture = new CompletableFuture<Integer>();
            AtomicInteger nChunks = new AtomicInteger();
            Disposable execRequest = this.asyncStreamRequest(requestPayload, chunkTypeClass).doOnSubscribe(sub -> {
                try {
                    onStreamStarted.run();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while starting the stream", (Throwable)e);
                    streamFuture.completeExceptionally(e);
                }
            }).doOnNext(chunk -> {
                nChunks.incrementAndGet();
                try {
                    chunkConsumer.accept(chunk);
                }
                catch (Exception e) {
                    logger.error((Object)"Error while processing the stream", (Throwable)e);
                    streamFuture.completeExceptionally(e);
                }
            }).doOnError(streamFuture::completeExceptionally).doOnComplete(() -> {
                try {
                    onStreamCompleted.run();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while completing the stream", (Throwable)e);
                    streamFuture.completeExceptionally(e);
                }
            }).doFinally(signal -> streamFuture.complete(nChunks.get())).subscribe();
            streamFuture.whenCompleteAsync((result, error) -> execRequest.dispose());
            return streamFuture;
        }

        private class RequestSender
        implements Runnable {
            private RequestSender() {
            }

            @Override
            public void run() {
                logger.info((Object)"Sender started");
                try {
                    while (true) {
                        Action<?> action;
                        if ((action = AsyncJavaLink.this.actionsQueue.poll(AsyncJavaLink.this.keepAliveInternalSeconds, TimeUnit.SECONDS)) == null) {
                            ActionMessage ping = new ActionMessage();
                            ping.action = ActionMessageType.PING;
                            AsyncJavaLink.this.send(ping);
                            continue;
                        }
                        ActionMessage message = new ActionMessage();
                        message.action = action.type;
                        if (action.type == ActionMessageType.STOP) {
                            logger.info((Object)"Graceful shutdown requested, sender stops now");
                            AsyncJavaLink.this.send(message);
                            break;
                        }
                        message.requestId = action.request.id;
                        AsyncJavaLink.this.send(message);
                        if (action.type != ActionMessageType.START) continue;
                        AsyncJavaLink.this.send(action.request.requestPayload);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error processing action", (Throwable)e);
                    AsyncJavaLink.this.clean(e);
                }
                logger.info((Object)"Sender completed");
            }
        }

        private class ResponseReceiver
        implements Runnable {
            private ResponseReceiver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.info((Object)"Receiver started");
                try {
                    while (true) {
                        StateMessage message = AsyncJavaLink.this.receive(StateMessage.class);
                        if (message.state == null) {
                            throw AsyncJavaLink.this.error("Message state cannot be null");
                        }
                        if (message.state == StateMessageType.ALIVE) continue;
                        if (message.state == StateMessageType.STOPPED) {
                            logger.info((Object)"Graceful shutdown requested, receiver stops now");
                            AsyncJavaLink.this.clean(null);
                            break;
                        }
                        if (StringUtils.isBlank((CharSequence)message.requestId)) {
                            throw AsyncJavaLink.this.error("requestId cannot be null");
                        }
                        ActiveRequest<?> request = AsyncJavaLink.this.pendingRequests.get(message.requestId);
                        if (request == null) {
                            logger.warn((Object)("No pending request with id " + message.requestId));
                            if (message.state != StateMessageType.FAILED && message.state != StateMessageType.RUNNING) continue;
                            AsyncJavaLink.this.receive(JsonElement.class);
                            continue;
                        }
                        switch (message.state) {
                            case RUNNING: {
                                request.sink.next(AsyncJavaLink.this.receive(request.responsePayloadType));
                                break;
                            }
                            case SUCCEEDED: {
                                request.sink.complete();
                            }
                            case CANCELLED: {
                                AsyncJavaLink asyncJavaLink = AsyncJavaLink.this;
                                synchronized (asyncJavaLink) {
                                    AsyncJavaLink.this.pendingRequests.remove(request.id);
                                    break;
                                }
                            }
                            case FAILED: {
                                ExceptionFromLink error = AsyncJavaLink.this.receive(ExceptionFromLink.class);
                                request.sink.error((Throwable)new RequestFailedException(error));
                                AsyncJavaLink asyncJavaLink = AsyncJavaLink.this;
                                synchronized (asyncJavaLink) {
                                    AsyncJavaLink.this.pendingRequests.remove(request.id);
                                    break;
                                }
                            }
                            default: {
                                throw AsyncJavaLink.this.error("Unhandled state " + String.valueOf((Object)message.state));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error receiving message", (Throwable)e);
                    AsyncJavaLink.this.clean(e);
                }
                logger.info((Object)"Receiver completed");
            }
        }
    }

    public static class WrappedSocketBlockLinkOutputStream
    extends OutputStream {
        private final JavaBlockLink link;
        private final int maxChunkSize;
        private boolean sentClose;
        private boolean gotErrorOnSend;

        WrappedSocketBlockLinkOutputStream(JavaBlockLink link, int maxChunkSize) {
            this.link = link;
            this.maxChunkSize = maxChunkSize;
            this.sentClose = false;
            this.gotErrorOnSend = false;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            for (int p = 0; p < len; p += this.maxChunkSize) {
                int s = p;
                int e = Math.min(len, p + this.maxChunkSize);
                int l = e - s;
                try {
                    this.link.sendInt(l);
                    this.link.sendBytes(b, l, off + s);
                    continue;
                }
                catch (IOException ex) {
                    this.gotErrorOnSend = true;
                    throw ex;
                }
            }
        }

        @Override
        public void flush() throws IOException {
            this.link.flush();
        }

        @Override
        public void close() throws IOException {
            if (!this.sentClose && !this.gotErrorOnSend) {
                this.sentClose = true;
                this.link.sendInt(0);
                this.link.flush();
            }
        }
    }

    private class ReceiverInputStreamEnumerator
    implements Enumeration<InputStream> {
        private boolean done = false;

        private ReceiverInputStreamEnumerator() {
        }

        @Override
        public boolean hasMoreElements() {
            return !this.done;
        }

        @Override
        public InputStream nextElement() {
            int blockSize;
            try {
                blockSize = JavaBlockLink.this.receiveInt();
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
            if (blockSize == 0) {
                this.done = true;
                return new NullInputStream();
            }
            CloseShieldInputStream notClosingInputStream = new CloseShieldInputStream(JavaBlockLink.this.inputStream);
            return ByteStreams.limit((InputStream)notClosingInputStream, (long)blockSize);
        }
    }

    public static class ReceiveFromSocketIOException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ReceiveFromSocketIOException(String message, IOException e) {
            super(message, e);
        }
    }

    public static class ReceiveToStreamIOException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ReceiveToStreamIOException(String message, IOException e) {
            super(message, e);
        }
    }

    private static class Action<ResponseType> {
        ActiveRequest<ResponseType> request;
        ActionMessageType type;

        public Action(ActionMessageType type) {
            this.type = type;
        }

        public Action(ActionMessageType type, ActiveRequest<ResponseType> request) {
            this.type = type;
            this.request = request;
        }
    }

    static class StateMessage
    extends Message {
        StateMessageType state;

        StateMessage() {
        }
    }

    static class ActionMessage
    extends Message {
        ActionMessageType action;

        ActionMessage() {
        }
    }

    private static abstract class Message {
        @Nullable
        String requestId;

        private Message() {
        }
    }

    static enum StateMessageType {
        RUNNING,
        FAILED,
        SUCCEEDED,
        STOPPED,
        CANCELLED,
        ALIVE;

    }

    static enum ActionMessageType {
        START,
        CANCEL,
        STOP,
        PING;

    }

    private static class ActiveRequest<ResponseType> {
        Class<ResponseType> responsePayloadType;
        FluxSink<ResponseType> sink;
        String id;
        Object requestPayload;

        private ActiveRequest() {
        }
    }

    public static class RequestFailedException
    extends RuntimeException {
        public String pythonExceptionPath;

        public RequestFailedException(String message) {
            super(message);
        }

        public RequestFailedException(ExceptionFromLink message) {
            super(message.message);
            this.pythonExceptionPath = message.pythonExceptionPath;
        }
    }

    public static class ExceptionFromLink {
        String pythonExceptionPath;
        String message;
    }

    private static class WrappedIOException
    extends RuntimeException {
        public WrappedIOException(IOException cause) {
            super(cause);
        }

        public IOException unwrap() {
            return (IOException)this.getCause();
        }
    }
}

