/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.security.UrlRedactionUtils;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditTransformer;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.CallTracingAspectBase;
import com.dataiku.dip.server.controllers.DkuJsonForSpring;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.util.HashMap;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=2)
public class AuditedCallAspect {
    @Autowired
    private AuditTrailService auditTrailService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.internal.audit.aspect");

    @Around(value="execution(* *(..)) && @annotation(auditedcall)", argNames="pjp,auditedcall")
    public Object doCall(ProceedingJoinPoint pjp, AuditedCall auditedCall) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        String[] parameterNames = signature.getParameterNames();
        Object[] parameterValues = pjp.getArgs();
        final HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < parameterNames.length; ++i) {
            map.put(parameterNames[i], parameterValues[i]);
        }
        StrSubstitutor substitutor = new StrSubstitutor(new StrLookup(){

            public String lookup(String s) {
                Object value = map.get(s);
                if (value == null) {
                    return "null";
                }
                String strValue = this.getStringRepresentation(value);
                if (CallTracingAspectBase.SENSITIVE_FIELD.matcher(s).find()) {
                    return "***";
                }
                if (CallTracingAspectBase.SENSITIVE_URL_FIELDS.matcher(s).find()) {
                    return UrlRedactionUtils.sanitizeHttpUrls(strValue);
                }
                return strValue;
            }

            private String getStringRepresentation(Object object) {
                if (DkuJsonForSpring.isJsonifiable(object.getClass())) {
                    try {
                        return JSON.json((Object)object);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
                return object.toString();
            }
        });
        Throwable thrown = null;
        try {
            Object ret;
            Object object = ret = pjp.proceed();
            return object;
        }
        catch (Throwable t) {
            thrown = t;
            throw t;
        }
        finally {
            AuditObj obj = new AuditObj("generic");
            for (int i = 0; i < auditedCall.value().length; i += 2) {
                String key = auditedCall.value()[i];
                String bval = auditedCall.value()[i + 1];
                String eval = substitutor.replace(bval);
                obj.with(key, eval);
            }
            if (!auditedCall.transformer().equals(AuditTransformer.NoopTransformer.class)) {
                AuditTransformer t = auditedCall.transformer().newInstance();
                t.transform(obj);
            }
            if (thrown != null) {
                obj.with("errorType", thrown.getClass().getCanonicalName()).with("errorMsg", ExceptionUtils.getMessageWithCauses((Throwable)thrown));
                this.auditTrailService.emit(obj);
            } else {
                this.auditTrailService.emit(obj);
            }
        }
    }
}

