/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.hive.executor;

import com.dataiku.hproxy.model.hive.ExecutionResults;
import com.dataiku.hproxy.sandbox.hive.SerdeAccessUtils;
import com.dataiku.hproxy.sandbox.hive.executor.HiveExecutorImpl;
import com.dataiku.hproxy.sandbox.hive.executor.IResultFetcher;
import com.dataiku.hproxy.server.hive.executor.WrappedHiveException;
import com.dataiku.hproxy.server.utils.FakeArrayList;
import com.dataiku.hproxy.utils.ExceptionThrower;
import com.dataiku.hproxy.utils.Reflector;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class ResultFetcher
implements IResultFetcher {
    private static final long fetchPackSize = 5000L;
    private static final long skipPackSize = 30000L;
    private FetchTask fetchTask;
    private Object serde;
    private SerdeAccessUtils serdeAccessUtils;
    private Driver driver;
    private int lastReturnedRowIndex = 0;
    private HiveConf hiveConf;
    private HiveExecutorImpl executor;
    private static Logger logger = Logger.getLogger(ResultFetcher.class);

    public ResultFetcher(HiveExecutorImpl executor) {
        logger.info((Object)"Create a new fetcher");
        this.executor = executor;
        this.serde = executor.getSerde();
        this.driver = executor.getDriver();
        this.hiveConf = executor.getConf();
        FetchWork work = (FetchWork)executor.getFetchTask().getWork();
        this.fetchTask = (FetchTask)TaskFactory.get((Serializable)work, (HiveConf)this.hiveConf, (Task[])new Task[0]);
        this.fetchTask.initialize(this.hiveConf, this.driver.getPlan(), null);
    }

    @Override
    public synchronized int getCurrentRowIndex() {
        return this.lastReturnedRowIndex;
    }

    private void resetLimit() {
        try {
            Reflector r = new Reflector(this.getClass().getClassLoader());
            FetchOperator fop = (FetchOperator)r.getAttribute((Object)this.fetchTask, "fetch");
            Operator nxt = (Operator)r.getAttribute((Object)fop, "operator");
            this.resetLimit((Operator<? extends OperatorDesc>)nxt, 1);
        }
        catch (Exception e) {
            logger.error((Object)"Error while trying to find LimitOperator");
        }
    }

    private void resetLimit(Operator<? extends OperatorDesc> op, int indent) {
        List l;
        if (op instanceof LimitOperator) {
            try {
                Field f = op.getClass().getDeclaredField("currCount");
                f.setAccessible(true);
                int beforeValue = (Integer)f.get(op);
                f.set(op, 0);
                int newValue = (Integer)f.get(op);
                if (beforeValue != newValue) {
                    logger.debug((Object)("Reset internal LimitOperator (" + beforeValue + " => " + newValue + ")"));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to reset LimitOperator", (Throwable)e);
            }
        }
        if ((l = op.getChildOperators()) != null) {
            for (Operator o : l) {
                this.resetLimit((Operator<? extends OperatorDesc>)o, indent + 1);
            }
        }
    }

    @Override
    public synchronized void skip(long n) {
        if (n == 0L) {
            return;
        }
        logger.info((Object)("Try to skip up to " + n + " rows starting at " + this.lastReturnedRowIndex));
        try {
            long remainder;
            FakeArrayList data = new FakeArrayList();
            int skipped = 0;
            long fastPasses = n / 30000L;
            this.fetchTask.setMaxRows(30000);
            int i = 0;
            while ((long)i < fastPasses) {
                this.resetLimit();
                this.reflectedFetch(this.fetchTask, (List<String>)data);
                if (data.size() == 0) break;
                skipped += data.size();
                data.clear();
                ++i;
            }
            if ((remainder = n - fastPasses * 30000L) > 0L) {
                this.fetchTask.setMaxRows((int)remainder);
                this.resetLimit();
                this.reflectedFetch(this.fetchTask, (List<String>)data);
                skipped += data.size();
                data.clear();
            }
            this.lastReturnedRowIndex += skipped;
            logger.info((Object)("Skipped " + skipped + " rows"));
        }
        catch (Throwable t) {
            throw new WrappedHiveException(t.getMessage(), t);
        }
    }

    private void reflectedFetch(FetchTask fetchTask, List<String> lst) {
        Reflector r = new Reflector(fetchTask.getClass().getClassLoader());
        try {
            r.call((Object)fetchTask, "fetch", new Object[]{lst});
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            logger.error((Object)"Cannot call FetchTask.fetch() using reflection. Incompatible Hive version?");
        }
        catch (InvocationTargetException e) {
            ExceptionThrower.uncheckedThrow((Throwable)e.getCause());
        }
    }

    @Override
    public synchronized ExecutionResults fetch(long n) {
        logger.info((Object)("Try to fetch up to " + n + " rows starting from row " + this.lastReturnedRowIndex));
        try {
            long remainder;
            ExecutionResults res = new ExecutionResults();
            res.columns = this.executor.getSchema();
            res.firstRowOffset = this.lastReturnedRowIndex;
            long fastPasses = n / 5000L;
            this.fetchTask.setMaxRows(5000);
            ArrayList<String> rawRows = new ArrayList<String>();
            int i = 0;
            while ((long)i < fastPasses) {
                int before = rawRows.size();
                this.resetLimit();
                this.reflectedFetch(this.fetchTask, rawRows);
                int after = rawRows.size();
                if (after == before) break;
                ++i;
            }
            if ((remainder = n - fastPasses * 5000L) > 0L) {
                this.fetchTask.setMaxRows((int)remainder);
                this.resetLimit();
                this.reflectedFetch(this.fetchTask, rawRows);
            }
            this.lastReturnedRowIndex += rawRows.size();
            logger.info((Object)("Fetched " + rawRows.size() + " rows"));
            StructObjectInspector soi = (StructObjectInspector)this.serdeAccessUtils.getObjectInspector(this.serde);
            List fieldRefs = soi.getAllStructFieldRefs();
            for (String rawRow : rawRows) {
                String[] row = new String[fieldRefs.size()];
                Object rowObj = this.serdeAccessUtils.deserialize(this.serde, (Writable)new BytesWritable(rawRow.getBytes()));
                for (int i2 = 0; i2 < fieldRefs.size(); ++i2) {
                    StructField fieldRef = (StructField)fieldRefs.get(i2);
                    ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                    row[i2] = ResultFetcher.convertLazyToJava(soi.getStructFieldData(rowObj, fieldRef), fieldOI);
                }
                res.rows.add(row);
            }
            return res;
        }
        catch (Throwable t) {
            throw new WrappedHiveException(t.getMessage(), t);
        }
    }

    private static synchronized String convertLazyToJava(Object o, ObjectInspector oi) {
        Object obj = ObjectInspectorUtils.copyToStandardObject((Object)o, (ObjectInspector)oi, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
        if (obj == null) {
            return null;
        }
        if (oi.getTypeName().equals("binary")) {
            return new String((byte[])obj, StandardCharsets.UTF_8);
        }
        if (oi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return SerDeUtils.getJSONString((Object)o, (ObjectInspector)oi);
        }
        return obj.toString();
    }

    @Override
    public synchronized void close() {
        try {
            this.fetchTask.clearFetch();
        }
        catch (HiveException e) {
            throw new WrappedHiveException(e.getMessage(), (Throwable)e);
        }
    }
}

