/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.notifications;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.utils.Either;
import freemarker.template.SimpleDate;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class NotificationContextUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.notifications.notification-context-utils");

    public static SimpleDate parseDate(String dateAsString) {
        try {
            Either<OffsetDateTime, LocalDate> parsedDate = DateUtils.parseDate(dateAsString);
            return parsedDate.isLeft() ? new SimpleDate(Date.from(parsedDate.getLeft().toInstant()), 3) : new SimpleDate(Date.from(parsedDate.getRight().atStartOfDay().toInstant(ZoneOffset.UTC)), 2);
        }
        catch (DateTimeParseException e) {
            logger.error((Object)"Couldn't parse date.", (Throwable)e);
            return null;
        }
    }
}

