/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.roles.audit;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.enriched.EnrichedDeletedArtifact;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.roles.assignments.criteria.Criterion;
import com.dataiku.gh.core.models.roles.permissions.ArtifactPermissionsItem;
import com.dataiku.gh.core.models.roles.permissions.BlueprintPermissions;
import com.dataiku.gh.core.models.roles.permissions.FieldPermissionsItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RolesAndPermissionsAudit {
    public final AuditConfiguration auditConfiguration;
    public final RolesAssignmentsAudit rolesAssignmentsAudit;
    public final PermissionsAudit permissionsAudit;
    public AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx;
    public final Map<String, ByUserAudit> byUserAuditMap = new HashMap<String, ByUserAudit>();

    private RolesAndPermissionsAudit(AuditConfiguration auditConfiguration, RolesAssignmentsAudit rolesAssignmentsAudit) {
        this.auditConfiguration = auditConfiguration;
        this.rolesAssignmentsAudit = rolesAssignmentsAudit;
        this.permissionsAudit = new PermissionsAudit(auditConfiguration);
    }

    public static RolesAndPermissionsAudit buildAtBlueprintLevel(AuditConfiguration auditConfiguration, EnrichedBlueprint enrichedBlueprint) {
        return new RolesAndPermissionsAudit(auditConfiguration, RolesAssignmentsAudit.buildAtBlueprintLevel(auditConfiguration, enrichedBlueprint));
    }

    public static RolesAndPermissionsAudit buildAtBlueprintVersionLevel(AuditConfiguration auditConfiguration, EnrichedBlueprintVersion enrichedBlueprintVersion) {
        return new RolesAndPermissionsAudit(auditConfiguration, RolesAssignmentsAudit.buildAtBlueprintVersionLevel(auditConfiguration, enrichedBlueprintVersion));
    }

    public static RolesAndPermissionsAudit buildAtArtifactExistingLevel(AuditConfiguration auditConfiguration, EnrichedArtifact enrichedArtifact) {
        return new RolesAndPermissionsAudit(auditConfiguration, RolesAssignmentsAudit.buildAtArtifactExistingLevel(auditConfiguration, enrichedArtifact));
    }

    public static RolesAndPermissionsAudit buildAtArtifactDeletedLevel(AuditConfiguration auditConfiguration, EnrichedDeletedArtifact enrichedDeletedArtifact) {
        return new RolesAndPermissionsAudit(auditConfiguration, RolesAssignmentsAudit.buildAtArtifactDeletedLevel(auditConfiguration, enrichedDeletedArtifact));
    }

    public ByUserAudit byUserAudit(String login) {
        return this.byUserAuditMap.computeIfAbsent(login, __ -> new ByUserAudit(this.auditConfiguration, RolesAssignmentsAudit.buildFromExisting(this.rolesAssignmentsAudit)));
    }

    public static class AuditConfiguration {
        public final boolean withComputationShortcuts;

        private AuditConfiguration(boolean withComputationShortcuts) {
            this.withComputationShortcuts = withComputationShortcuts;
        }

        public static AuditConfiguration buildWithShortcuts() {
            return new AuditConfiguration(true);
        }

        public static AuditConfiguration buildWithNoShortcuts() {
            return new AuditConfiguration(false);
        }

        public boolean shouldBreak() {
            return this.withComputationShortcuts;
        }

        public boolean shouldBreak(boolean breakCondition) {
            return this.withComputationShortcuts && breakCondition;
        }
    }

    public static class RolesAssignmentsAudit {
        public final AuditConfiguration auditConfiguration;
        public final RoleAssignmentComputationLevel roleAssignmentComputationLevel;
        public final boolean blueprintExists;
        @Nullable
        public final String blueprintId;
        @Nullable
        public final BlueprintVersionId blueprintVersionId;
        @Nullable
        public final String artifactId;
        public final BlueprintsInheritanceLookupAudit blueprintsInheritanceLookupAudit;
        public final ArtifactsInheritanceLookupAudit artifactsInheritanceLookupAudit;
        public final Map<String, RolesAssignmentsAudit> rolesAssignmentsBlueprintInheritanceAudits = new HashMap<String, RolesAssignmentsAudit>();
        public final Map<String, RolesAssignmentsAudit> rolesAssignmentsArtifactInheritanceAudits = new HashMap<String, RolesAssignmentsAudit>();
        public final Map<String, RoleAssignmentAudit> roleAssignmentAudits = new HashMap<String, RoleAssignmentAudit>();

        private RolesAssignmentsAudit(AuditConfiguration auditConfiguration, RoleAssignmentComputationLevel roleAssignmentComputationLevel, boolean blueprintExists, @Nullable String blueprintId, @Nullable BlueprintVersionId blueprintVersionId, @Nullable String artifactId) {
            this.auditConfiguration = auditConfiguration;
            this.roleAssignmentComputationLevel = roleAssignmentComputationLevel;
            this.blueprintExists = blueprintExists;
            this.blueprintId = blueprintId;
            this.blueprintVersionId = blueprintVersionId;
            this.artifactId = artifactId;
            this.blueprintsInheritanceLookupAudit = new BlueprintsInheritanceLookupAudit(auditConfiguration);
            this.artifactsInheritanceLookupAudit = new ArtifactsInheritanceLookupAudit(auditConfiguration);
        }

        public static RolesAssignmentsAudit buildFromExisting(RolesAssignmentsAudit rolesAssignmentsAudit) {
            return new RolesAssignmentsAudit(rolesAssignmentsAudit.auditConfiguration, rolesAssignmentsAudit.roleAssignmentComputationLevel, rolesAssignmentsAudit.blueprintExists, rolesAssignmentsAudit.blueprintId, rolesAssignmentsAudit.blueprintVersionId, rolesAssignmentsAudit.artifactId);
        }

        public RolesAssignmentsAudit addBlueprintInheritance(String blueprintId) {
            RolesAssignmentsAudit rolesAssignmentsBlueprintInheritanceAudit = RolesAssignmentsAudit.buildAtBlueprintLevel(this.auditConfiguration, blueprintId);
            this.rolesAssignmentsBlueprintInheritanceAudits.put(blueprintId, rolesAssignmentsBlueprintInheritanceAudit);
            return rolesAssignmentsBlueprintInheritanceAudit;
        }

        public RolesAssignmentsAudit addArtifactInheritance(String artifactId) {
            RolesAssignmentsAudit rolesAssignmentsArtifactInheritanceAudit = RolesAssignmentsAudit.buildAtArtifactExistingLevel(this.auditConfiguration, artifactId);
            this.rolesAssignmentsArtifactInheritanceAudits.put(artifactId, rolesAssignmentsArtifactInheritanceAudit);
            return rolesAssignmentsArtifactInheritanceAudit;
        }

        public RoleAssignmentAudit addRoleAssignmentAudit(String roleId) {
            return this.roleAssignmentAudits.computeIfAbsent(roleId, id -> new RoleAssignmentAudit(this.auditConfiguration));
        }

        public static RolesAssignmentsAudit buildAtBlueprintLevel(AuditConfiguration auditConfiguration, EnrichedBlueprint enrichedBlueprint) {
            return RolesAssignmentsAudit.buildAtBlueprintLevel(auditConfiguration, enrichedBlueprint.blueprint.id);
        }

        public static RolesAssignmentsAudit buildAtBlueprintLevel(AuditConfiguration auditConfiguration, String blueprintId) {
            return new RolesAssignmentsAudit(auditConfiguration, RoleAssignmentComputationLevel.BLUEPRINT, true, blueprintId, null, null);
        }

        public static RolesAssignmentsAudit buildAtBlueprintVersionLevel(AuditConfiguration auditConfiguration, EnrichedBlueprintVersion enrichedBlueprintVersion) {
            return RolesAssignmentsAudit.buildAtBlueprintVersionLevel(auditConfiguration, enrichedBlueprintVersion.blueprintVersion.id);
        }

        public static RolesAssignmentsAudit buildAtBlueprintVersionLevel(AuditConfiguration auditConfiguration, BlueprintVersionId blueprintVersionId) {
            return new RolesAssignmentsAudit(auditConfiguration, RoleAssignmentComputationLevel.BLUEPRINT_VERSION, true, blueprintVersionId.blueprintId, blueprintVersionId, null);
        }

        public static RolesAssignmentsAudit buildAtArtifactExistingLevel(AuditConfiguration auditConfiguration, String artifactId) {
            return new RolesAssignmentsAudit(auditConfiguration, RoleAssignmentComputationLevel.ARTIFACT_EXISTING, true, null, null, artifactId);
        }

        public static RolesAssignmentsAudit buildAtArtifactExistingLevel(AuditConfiguration auditConfiguration, EnrichedArtifact enrichedArtifact) {
            return new RolesAssignmentsAudit(auditConfiguration, RoleAssignmentComputationLevel.ARTIFACT_EXISTING, true, enrichedArtifact.blueprint.id, enrichedArtifact.blueprintVersion.id, enrichedArtifact.artifact.id);
        }

        public static RolesAssignmentsAudit buildAtArtifactDeletedLevel(AuditConfiguration auditConfiguration, EnrichedDeletedArtifact enrichedDeletedArtifact) {
            return new RolesAssignmentsAudit(auditConfiguration, RoleAssignmentComputationLevel.ARTIFACT_DELETED, enrichedDeletedArtifact.currentEnrichedBlueprint != null, enrichedDeletedArtifact.lastKnownEnrichedArtifact.blueprint.id, enrichedDeletedArtifact.lastKnownEnrichedArtifact.blueprintVersion.id, enrichedDeletedArtifact.lastKnownEnrichedArtifact.artifact.id);
        }
    }

    public static class PermissionsAudit {
        public final AuditConfiguration auditConfiguration;
        public BlueprintPermissionsUsed usedBlueprintPermissionsType;
        public BlueprintPermissions usedBlueprintPermissions;
        public final ArtifactPermissionsAudit artifactPermissionsAudit;
        public final Map<String, FieldPermissionAudit> fieldPermissionAuditMap = new HashMap<String, FieldPermissionAudit>();

        private PermissionsAudit(AuditConfiguration auditConfiguration) {
            this.auditConfiguration = auditConfiguration;
            this.artifactPermissionsAudit = new ArtifactPermissionsAudit(auditConfiguration);
        }

        public void declareUsedDefaultPermissions() {
            this.usedBlueprintPermissionsType = BlueprintPermissionsUsed.DEFAULT;
        }

        public void declareUsedBPPermissions() {
            this.usedBlueprintPermissionsType = BlueprintPermissionsUsed.CONFIGURED;
        }

        public FieldPermissionAudit addFieldPermissionAudit(String fieldId) {
            return this.fieldPermissionAuditMap.computeIfAbsent(fieldId, id -> new FieldPermissionAudit(this.auditConfiguration));
        }
    }

    public static class ByUserAudit {
        public final AuditConfiguration auditConfiguration;
        public final RolesAssignmentsAudit rolesAssignmentsAudit;
        public final PermissionsAudit permissionsAudit;
        public AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx;

        public ByUserAudit(AuditConfiguration auditConfiguration, RolesAssignmentsAudit rolesAssignmentsAudit) {
            this.auditConfiguration = auditConfiguration;
            this.rolesAssignmentsAudit = rolesAssignmentsAudit;
            this.permissionsAudit = new PermissionsAudit(auditConfiguration);
        }
    }

    public static enum BlueprintPermissionsUsed {
        CONFIGURED,
        DEFAULT;

    }

    public static enum UserMatchType {
        USER,
        GROUP,
        GLOBAL_API_KEY,
        NOT_EXISTING_FIELD;

    }

    public static enum RoleAssignmentRuleStatus {
        VALID,
        NOT_VALID;

    }

    public static enum RoleAssignmentStatus {
        ROLE_ALREADY_ASSIGNED,
        ASSIGNED,
        NOT_ASSIGNED;

    }

    public static enum RoleAssignmentComputationLevel {
        BLUEPRINT,
        BLUEPRINT_VERSION,
        ARTIFACT_EXISTING,
        ARTIFACT_DELETED;

    }

    public static class RoleDefaultPermissionReason
    extends PermissionReason {
        public static final String TYPE = "role-default";
        public String roleId;

        private RoleDefaultPermissionReason() {
        }

        public static RolePermissionReason build(String roleId) {
            RolePermissionReason reason = new RolePermissionReason();
            reason.roleId = roleId;
            return reason;
        }
    }

    public static class RolePermissionReason
    extends PermissionReason {
        public static final String TYPE = "role";
        public String roleId;

        private RolePermissionReason() {
        }

        public static RolePermissionReason build(String roleId) {
            RolePermissionReason reason = new RolePermissionReason();
            reason.roleId = roleId;
            return reason;
        }
    }

    public static class EveryoneFieldDefaultPermissionReason
    extends PermissionReason {
        public static final String TYPE = "everyone-field-default";
        public static final EveryoneFieldDefaultPermissionReason INSTANCE = new EveryoneFieldDefaultPermissionReason();

        private EveryoneFieldDefaultPermissionReason() {
        }
    }

    public static class EveryonePermissionReason
    extends PermissionReason {
        public static final String TYPE = "everyone";
        public static final EveryonePermissionReason INSTANCE = new EveryonePermissionReason();

        private EveryonePermissionReason() {
        }
    }

    @PolyJSON(value={@Mapping(value=EveryonePermissionReason.class, type="everyone"), @Mapping(value=EveryoneFieldDefaultPermissionReason.class, type="everyone-field-default"), @Mapping(value=RolePermissionReason.class, type="role"), @Mapping(value=RoleDefaultPermissionReason.class, type="role-default")})
    public static abstract class PermissionReason {
    }

    public static class FieldPermissionAudit {
        public final AuditConfiguration auditConfiguration;
        public boolean isGovernManager;
        public boolean isArtifactAdmin;
        public final List<PermissionReason> readReasons = new ArrayList<PermissionReason>();
        public final List<PermissionReason> writeReasons = new ArrayList<PermissionReason>();

        private FieldPermissionAudit(AuditConfiguration auditConfiguration) {
            this.auditConfiguration = auditConfiguration;
        }

        public void addEveryonePermissions(FieldPermissionsItem permissionsItem) {
            this.addReason(permissionsItem, EveryonePermissionReason.INSTANCE);
        }

        public void addEveryoneFieldDefaultPermissions(FieldPermissionsItem permissionsItem) {
            this.addReason(permissionsItem, EveryoneFieldDefaultPermissionReason.INSTANCE);
        }

        public void addRolePermissions(FieldPermissionsItem permissionsItem, String role) {
            this.addReason(permissionsItem, RolePermissionReason.build(role));
        }

        public void addRoleDefaultPermissions(FieldPermissionsItem permissionsItem, String role) {
            this.addReason(permissionsItem, RoleDefaultPermissionReason.build(role));
        }

        private void addReason(FieldPermissionsItem permissionsItem, PermissionReason reason) {
            if (permissionsItem.hasReadPermission()) {
                this.readReasons.add(reason);
            }
            if (permissionsItem.hasWritePermission()) {
                this.writeReasons.add(reason);
            }
        }
    }

    public static class ArtifactPermissionsAudit {
        public final AuditConfiguration auditConfiguration;
        public boolean systemLocked;
        public boolean isGovernManager;
        public final List<PermissionReason> artifactReadReasons = new ArrayList<PermissionReason>();
        public final List<PermissionReason> artifactWriteReasons = new ArrayList<PermissionReason>();
        public final List<PermissionReason> artifactCreateReasons = new ArrayList<PermissionReason>();
        public final List<PermissionReason> artifactDeleteReasons = new ArrayList<PermissionReason>();
        public final List<PermissionReason> artifactAdminReasons = new ArrayList<PermissionReason>();

        private ArtifactPermissionsAudit(AuditConfiguration auditConfiguration) {
            this.auditConfiguration = auditConfiguration;
        }

        public void addEveryonePermissions(ArtifactPermissionsItem permissionsItem) {
            this.addReason(permissionsItem, EveryonePermissionReason.INSTANCE);
        }

        public void addRolePermissions(ArtifactPermissionsItem permissionsItem, String role) {
            this.addReason(permissionsItem, RolePermissionReason.build(role));
        }

        private void addReason(ArtifactPermissionsItem permissionsItem, PermissionReason reason) {
            if (permissionsItem.hasReadPermission()) {
                this.artifactReadReasons.add(reason);
            }
            if (permissionsItem.hasWritePermission()) {
                this.artifactWriteReasons.add(reason);
            }
            if (permissionsItem.hasCreatePermission()) {
                this.artifactCreateReasons.add(reason);
            }
            if (permissionsItem.hasDeletePermission()) {
                this.artifactDeleteReasons.add(reason);
            }
            if (permissionsItem.hasAdminPermission()) {
                this.artifactAdminReasons.add(reason);
            }
        }
    }

    public static class CriterionAudit {
        @Nullable
        public Object testedValue;
        public Criterion criterion;
        public boolean complies;

        private CriterionAudit() {
        }
    }

    public static class FieldUserMatchAudit {
        public String fieldId;
        public Object fieldValue;
        public UserMatchType type;
        public boolean match;

        private FieldUserMatchAudit() {
        }

        public void declareTypeNotExistingField() {
            this.type = UserMatchType.NOT_EXISTING_FIELD;
        }

        public void declareTypeUser() {
            this.type = UserMatchType.USER;
        }

        public void declareTypeGroup() {
            this.type = UserMatchType.GROUP;
        }

        public void declareTypeAPIKey() {
            this.type = UserMatchType.GLOBAL_API_KEY;
        }

        public void declareMatched() {
            this.match = true;
        }

        public void declareNotMatched() {
            this.match = false;
        }
    }

    public static class UserMatchAudit {
        public UserMatchType type;
        public String value;
        public boolean match;

        private UserMatchAudit() {
        }

        public void declareTypeUser(String user) {
            this.type = UserMatchType.USER;
            this.value = user;
        }

        public void declareTypeGroup(String group) {
            this.type = UserMatchType.GROUP;
            this.value = group;
        }

        public void declareTypeGlobalAPIKey(String apiKey) {
            this.type = UserMatchType.GLOBAL_API_KEY;
            this.value = apiKey;
        }

        public void declareMatched() {
            this.match = true;
        }

        public void declareNotMatched() {
            this.match = false;
        }
    }

    public static class RoleAssignmentRuleAudit {
        public final AuditConfiguration auditConfiguration;
        public final List<UserMatchAudit> userMatchAudits = new ArrayList<UserMatchAudit>();
        public final List<FieldUserMatchAudit> fieldUserMatchAudits = new ArrayList<FieldUserMatchAudit>();
        public boolean userMatch;
        public final List<CriterionAudit> criterionAudits = new ArrayList<CriterionAudit>();
        public RoleAssignmentRuleStatus ruleResult;

        private RoleAssignmentRuleAudit(AuditConfiguration auditConfiguration) {
            this.auditConfiguration = auditConfiguration;
        }

        public UserMatchAudit addUserMatchAudit() {
            UserMatchAudit userMatchAudit = new UserMatchAudit();
            this.userMatchAudits.add(userMatchAudit);
            return userMatchAudit;
        }

        public FieldUserMatchAudit addFieldUserMatchAudit(String fieldId, Object fieldValue) {
            FieldUserMatchAudit fieldUserMatchAudit = new FieldUserMatchAudit();
            fieldUserMatchAudit.fieldId = fieldId;
            fieldUserMatchAudit.fieldValue = fieldValue;
            this.fieldUserMatchAudits.add(fieldUserMatchAudit);
            return fieldUserMatchAudit;
        }

        public CriterionAudit addCriterionAudit(Criterion criterion) {
            CriterionAudit criterionAudit = new CriterionAudit();
            this.criterionAudits.add(criterionAudit);
            criterionAudit.criterion = criterion;
            return criterionAudit;
        }

        public void declareValid() {
            this.ruleResult = RoleAssignmentRuleStatus.VALID;
        }

        public void declareNotValid() {
            this.ruleResult = RoleAssignmentRuleStatus.NOT_VALID;
        }

        public void declareUserMatched() {
            this.userMatch = true;
        }

        public void declareUserNotMatched() {
            this.userMatch = false;
        }
    }

    public static class ArtifactInheritanceLookupAudit {
        public final AuditConfiguration auditConfiguration;
        public final String artifactId;
        public boolean inheritanceValidAndFound = false;

        private ArtifactInheritanceLookupAudit(AuditConfiguration auditConfiguration, String artifactId) {
            this.auditConfiguration = auditConfiguration;
            this.artifactId = artifactId;
        }
    }

    public static class ArtifactInheritanceLookupFieldAudit {
        public final AuditConfiguration auditConfiguration;
        public final String fieldId;
        @Nullable
        public FieldDefinition fieldDefinition;
        @Nullable
        public Object fieldValue;
        public List<String> resolvedArtifactIds = new ArrayList<String>();

        private ArtifactInheritanceLookupFieldAudit(AuditConfiguration auditConfiguration, String fieldId) {
            this.auditConfiguration = auditConfiguration;
            this.fieldId = fieldId;
        }
    }

    public static class ArtifactsInheritanceLookupAudit {
        public final AuditConfiguration auditConfiguration;
        public final Map<String, ArtifactInheritanceLookupFieldAudit> artifactInheritanceLookupFieldAudits = new HashMap<String, ArtifactInheritanceLookupFieldAudit>();
        public final Map<String, ArtifactInheritanceLookupAudit> artifactInheritanceLookupAudits = new HashMap<String, ArtifactInheritanceLookupAudit>();

        private ArtifactsInheritanceLookupAudit(AuditConfiguration auditConfiguration) {
            this.auditConfiguration = auditConfiguration;
        }

        public ArtifactInheritanceLookupFieldAudit addArtifactInheritanceLookupFieldAudit(String fieldId) {
            ArtifactInheritanceLookupFieldAudit fieldAudit = new ArtifactInheritanceLookupFieldAudit(this.auditConfiguration, fieldId);
            this.artifactInheritanceLookupFieldAudits.put(fieldId, fieldAudit);
            return fieldAudit;
        }

        public ArtifactInheritanceLookupAudit addArtifactInheritanceAudit(String artifactId) {
            ArtifactInheritanceLookupAudit artifactInheritanceAudit = new ArtifactInheritanceLookupAudit(this.auditConfiguration, artifactId);
            this.artifactInheritanceLookupAudits.put(artifactId, artifactInheritanceAudit);
            return artifactInheritanceAudit;
        }
    }

    public static class BlueprintInheritanceLookupAudit {
        public final AuditConfiguration auditConfiguration;
        public final String blueprintId;
        public boolean inheritanceValidAndFound = false;

        private BlueprintInheritanceLookupAudit(AuditConfiguration auditConfiguration, String blueprintId) {
            this.auditConfiguration = auditConfiguration;
            this.blueprintId = blueprintId;
        }
    }

    public static class BlueprintsInheritanceLookupAudit {
        public final AuditConfiguration auditConfiguration;
        public List<BlueprintInheritanceLookupAudit> blueprintInheritanceLookupAudits = new ArrayList<BlueprintInheritanceLookupAudit>();

        private BlueprintsInheritanceLookupAudit(AuditConfiguration auditConfiguration) {
            this.auditConfiguration = auditConfiguration;
        }

        public BlueprintInheritanceLookupAudit addBlueprintInheritanceLookupAudit(String blueprintId) {
            BlueprintInheritanceLookupAudit newBPAudit = new BlueprintInheritanceLookupAudit(this.auditConfiguration, blueprintId);
            this.blueprintInheritanceLookupAudits.add(newBPAudit);
            return newBPAudit;
        }
    }

    public static class RoleAssignmentAudit {
        public final AuditConfiguration auditConfiguration;
        public final List<RoleAssignmentRuleAudit> roleAssignmentRuleAudits = new ArrayList<RoleAssignmentRuleAudit>();
        public RoleAssignmentStatus roleAssignmentStatus;

        private RoleAssignmentAudit(AuditConfiguration auditConfiguration) {
            this.auditConfiguration = auditConfiguration;
        }

        public void declareRoleAlreadyAssigned() {
            this.roleAssignmentStatus = RoleAssignmentStatus.ROLE_ALREADY_ASSIGNED;
        }

        public void declareRoleAssigned() {
            this.roleAssignmentStatus = RoleAssignmentStatus.ASSIGNED;
        }

        public void declareRoleNotAssigned() {
            this.roleAssignmentStatus = RoleAssignmentStatus.NOT_ASSIGNED;
        }

        public RoleAssignmentRuleAudit addRoleAssignmentRuleAudit() {
            RoleAssignmentRuleAudit roleAssignmentRuleAudit = new RoleAssignmentRuleAudit(this.auditConfiguration);
            this.roleAssignmentRuleAudits.add(roleAssignmentRuleAudit);
            return roleAssignmentRuleAudit;
        }
    }
}

