/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IAdminBlueprintRoleAssignmentsService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIAdminBlueprintRoleAssignmentsController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IAdminBlueprintRoleAssignmentsService adminBlueprintRoleAssignmentsService;

    @AuditedCall(value={"msgType", "blueprint-role-assignments-list"})
    @RequestMapping(value={"/publicapi/admin/blueprint-role-assignments"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIAdminBlueprintRoleAssignmentsController.writeJSON((HttpServletResponse)resp, this.adminBlueprintRoleAssignmentsService.listBlueprintRoleAssignments(authCtx));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/blueprint-role-assignments"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_ROLE_ASSIGNMENTS_CREATE)
    public void create(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            BlueprintRoleAssignments blueprintRoleAssignments = (BlueprintRoleAssignments)this.getRequestBodyAs(req, BlueprintRoleAssignments.class);
            BlueprintRoleAssignments createdBlueprintRoleAssignments = this.adminBlueprintRoleAssignmentsService.createBlueprintRoleAssignments(authCtx, blueprintRoleAssignments);
            this.auditTrailService.generic("blueprint-role-assignments-create").with("blueprintId", createdBlueprintRoleAssignments.blueprintId).emit();
            PublicAPIAdminBlueprintRoleAssignmentsController.writeJSON((HttpServletResponse)resp, (Object)createdBlueprintRoleAssignments);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-role-assignments-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "blueprint-role-assignments-get", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint-role-assignments/{blueprintId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIAdminBlueprintRoleAssignmentsController.writeJSON((HttpServletResponse)resp, (Object)this.adminBlueprintRoleAssignmentsService.getBlueprintRoleAssignments(authCtx, blueprintId));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/blueprint-role-assignments/{blueprintId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_ROLE_ASSIGNMENTS_SAVE)
    public void save(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            BlueprintRoleAssignments blueprintRoleAssignments = (BlueprintRoleAssignments)this.getRequestBodyAs(req, BlueprintRoleAssignments.class);
            if (!StringUtils.equals((CharSequence)blueprintId, (CharSequence)blueprintRoleAssignments.blueprintId)) {
                throw new ValidationException("Blueprint IDs do not match: " + blueprintId + " , " + blueprintRoleAssignments.blueprintId);
            }
            BlueprintRoleAssignments savedBlueprintRoleAssignments = this.adminBlueprintRoleAssignmentsService.saveBlueprintRoleAssignments(authCtx, blueprintRoleAssignments);
            this.auditTrailService.generic("blueprint-role-assignments-save").with("blueprintId", savedBlueprintRoleAssignments.blueprintId).emit();
            PublicAPIAdminBlueprintRoleAssignmentsController.writeJSON((HttpServletResponse)resp, (Object)savedBlueprintRoleAssignments);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-role-assignments-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "blueprint-role-assignments-delete", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint-role-assignments/{blueprintId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.BLUEPRINT_ROLE_ASSIGNMENTS_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.adminBlueprintRoleAssignmentsService.deleteBlueprintRoleAssignments(authCtx, blueprintId);
        PublicAPIAdminBlueprintRoleAssignmentsController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

