/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceAction;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.IInputGovernanceSettingsVisitor;
import com.dataiku.gh.core.models.governance.InputGovernanceSettings;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.governance.IGovernancePermissionService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationDataService;
import com.dataiku.gh.core.services.governance.utils.GovernanceUtils;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.context.UserRolesCacheContext;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.validation.IAutomaticConfigurationValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class GovernancePermissionService
implements IGovernancePermissionService {
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IAutomaticConfigurationValidationService automaticConfigurationValidationService;
    @Autowired
    private IAutoGovernanceConfigurationDataService autoGovernanceConfigurationDataService;

    @Override
    @GHReadonlyTransaction
    public boolean hasAtLeastOneBPVWithCreatePermission(AuthCtx authCtx, String blueprintId) throws IOException {
        List<EnrichedBlueprintVersion> enrichedBlueprintVersionList = this.blueprintsDataService.listBlueprintVersionsByBlueprint(blueprintId);
        for (EnrichedBlueprintVersion governingEnrichedBlueprintVersion : enrichedBlueprintVersionList) {
            AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authCtx, governingEnrichedBlueprintVersion);
            if (!this.checkPermissionsService.hasArtifactCreatePermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @GHReadonlyTransaction
    public void checkUserCanModifyGovernanceConfiguration(AuthCtx authCtx, ArtifactAutoGovernanceConfiguration pushedConfiguration) throws IOException, DKUSecurityException {
        ArtifactAutoGovernanceConfiguration currentlyStoredConfiguration = this.autoGovernanceConfigurationDataService.getArtifactAutoGovernConfigurationOrNull(pushedConfiguration.artifactId);
        HashMap<String, AutoGovernanceConfiguration> blueprintIdAndCorrespondingAutoGovernConfigurationDiff = new HashMap<String, AutoGovernanceConfiguration>();
        if (pushedConfiguration instanceof ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration) {
            if (currentlyStoredConfiguration != null && !(currentlyStoredConfiguration instanceof ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)) throw new ValidationException("Pushed configuration is of type DSSProjectAutoGovernConfiguration while current configuration is of type DSSModelAutoGovernConfiguration");
            ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration pushedDssProjectConfiguration = (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)pushedConfiguration;
            ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration currentlyStoredProjectConfiguration = (ArtifactAutoGovernanceConfiguration.ProjectAutoGovernanceConfiguration)currentlyStoredConfiguration;
            if (currentlyStoredProjectConfiguration == null || !pushedDssProjectConfiguration.modelVersionsConfig.equals(currentlyStoredProjectConfiguration.modelVersionsConfig)) {
                blueprintIdAndCorrespondingAutoGovernConfigurationDiff.put(SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, pushedDssProjectConfiguration.modelVersionsConfig);
            }
            if (currentlyStoredProjectConfiguration == null || !pushedDssProjectConfiguration.modelsConfig.equals(currentlyStoredProjectConfiguration.modelsConfig)) {
                blueprintIdAndCorrespondingAutoGovernConfigurationDiff.put(SystemProvidedConstants.GOVERN_MODEL.blueprintId, pushedDssProjectConfiguration.modelsConfig);
            }
            if (currentlyStoredProjectConfiguration == null || !pushedDssProjectConfiguration.bundlesConfig.equals(currentlyStoredProjectConfiguration.bundlesConfig)) {
                blueprintIdAndCorrespondingAutoGovernConfigurationDiff.put(SystemProvidedConstants.GOVERN_BUNDLE.blueprintId, pushedDssProjectConfiguration.bundlesConfig);
            }
        } else if (pushedConfiguration instanceof ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration) {
            if (currentlyStoredConfiguration != null && !(currentlyStoredConfiguration instanceof ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)) throw new ValidationException("Pushed configuration is of type DSSModelAutoGovernConfiguration while current configuration is of type DSSProjectAutoGovernConfiguration");
            if (currentlyStoredConfiguration == null || !((ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)pushedConfiguration).modelVersionsConfig.equals(((ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)currentlyStoredConfiguration).modelVersionsConfig)) {
                blueprintIdAndCorrespondingAutoGovernConfigurationDiff.put(SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, ((ArtifactAutoGovernanceConfiguration.ModelAutoGovernanceConfiguration)pushedConfiguration).modelVersionsConfig);
            }
        }
        try (UserRolesCacheContext.ContextContainer ignored = UserRolesCacheContext.attachNewContext();){
            for (Map.Entry bpIdAndAGC : blueprintIdAndCorrespondingAutoGovernConfigurationDiff.entrySet()) {
                String blueprintId = (String)bpIdAndAGC.getKey();
                AutoGovernanceConfiguration autoGovernanceConfiguration = (AutoGovernanceConfiguration)bpIdAndAGC.getValue();
                if (autoGovernanceConfiguration.action == AutoGovernanceAction.GOVERN) {
                    this.automaticConfigurationValidationService.validateAutoGovernanceConfigurationBlueprintExists(autoGovernanceConfiguration);
                    EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(autoGovernanceConfiguration.blueprintVersionId);
                    AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authCtx, enrichedBlueprintVersion);
                    this.checkPermissionsService.checkArtifactCreatePermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, autoGovernanceConfiguration.blueprintVersionId.blueprintId);
                    continue;
                }
                if (autoGovernanceConfiguration.action != AutoGovernanceAction.DO_NOTHING || this.hasAtLeastOneBPVWithCreatePermission(authCtx, blueprintId)) continue;
                throw new UnauthorizedException("Permission denied: unable to disable AutoGovernance config for artifact: " + pushedConfiguration.artifactId + " at level: " + blueprintId, "autogovern-config-upsert-denied");
            }
            return;
        }
    }

    @Override
    @GHReadonlyTransaction
    public void validateArtifactAutoConfigPermission(final AuthCtx authCtx, InputGovernanceSettings inputGovernanceSettings, final EnrichedArtifact dataikuItemToGovern) throws DKUSecurityException, IOException, LimitsStatusComputer.LicenseLimitException {
        boolean isAdvancedLicense = this.licenseEnforcementService.isGovernBlueprintDesignerAllowed();
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, dataikuItemToGovern);
        this.checkPermissionsService.checkArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, dataikuItemToGovern.artifact.id);
        if (!isAdvancedLicense && !GovernanceUtils.artifactIsGovernableWithAdvancedLicense(dataikuItemToGovern.artifact)) {
            throw new LimitsStatusComputer.LicenseLimitException("Your license does not allow you to govern item `" + dataikuItemToGovern.artifact.id + "` with blueprint: " + String.valueOf(dataikuItemToGovern.blueprintVersion.id));
        }
        BlueprintVersionId bpvToCreate = GovernanceUtils.extractGoverningBlueprintVersion(inputGovernanceSettings);
        if (bpvToCreate != null) {
            EnrichedBlueprintVersion governingEnrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(bpvToCreate);
            AssignedRolesAndPermissionsCtx bpvAssignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authCtx, governingEnrichedBlueprintVersion);
            this.checkPermissionsService.checkArtifactCreatePermission_NoLicenseCheck(bpvAssignedRolesAndPermissionsCtx.effectivePermissionsItem, bpvToCreate.blueprintId);
        }
        inputGovernanceSettings.accept(new IInputGovernanceSettingsVisitor(){

            @Override
            public void visit(InputGovernanceSettings.ProjectSettings governanceSettings) {
                try {
                    if (governanceSettings.projectAutoGovernanceConfiguration != null) {
                        GovernancePermissionService.this.checkUserCanModifyGovernanceConfiguration(authCtx, governanceSettings.projectAutoGovernanceConfiguration);
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw new ValidationException("failed validating autoconfiguration permission for artifact: " + dataikuItemToGovern.artifact.id, e);
                }
            }

            @Override
            public void visit(InputGovernanceSettings.ExistingProjectSettings governanceSettings) {
                try {
                    if (governanceSettings.projectAutoGovernanceConfiguration != null) {
                        GovernancePermissionService.this.checkUserCanModifyGovernanceConfiguration(authCtx, governanceSettings.projectAutoGovernanceConfiguration);
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw new ValidationException("failed validating autoconfiguration permission for artifact: " + dataikuItemToGovern.artifact.id, e);
                }
            }

            @Override
            public void visit(InputGovernanceSettings.ModelSettings governanceSettings) {
                try {
                    if (governanceSettings.modelAutoGovernanceConfiguration != null) {
                        GovernancePermissionService.this.checkUserCanModifyGovernanceConfiguration(authCtx, governanceSettings.modelAutoGovernanceConfiguration);
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw new ValidationException("failed validating autoconfiguration permission for artifact: " + dataikuItemToGovern.artifact.id, e);
                }
            }
        });
    }
}

