/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation;

import com.dataiku.gh.core.models.roles.assignments.ArtifactRoleAssignments;
import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.services.validation.IRoleAssignmentsValidationService;
import com.dataiku.gh.core.services.validation.IUsersContainerValidationService;
import com.dataiku.gh.core.services.validation.validators.ArtifactRoleAssignmentValidator;
import com.dataiku.gh.core.services.validation.validators.BlueprintRoleAssignmentsValidator;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleAssignmentsValidationService
implements IRoleAssignmentsValidationService {
    @Autowired
    private IRoleDAO roleDAO;
    @Autowired
    private IBlueprintDAO blueprintDAO;
    @Autowired
    private IUsersContainerValidationService usersContainerValidationService;

    @Override
    public void validateBlueprintRoleAssignments(BlueprintRoleAssignments blueprintRoleAssignments) throws IOException {
        BlueprintRoleAssignmentsValidator blueprintRoleAssignmentsValidator = new BlueprintRoleAssignmentsValidator(blueprintRoleAssignments);
        blueprintRoleAssignments.accept(blueprintRoleAssignmentsValidator);
        blueprintRoleAssignmentsValidator.validateInheritedBlueprints(this.blueprintDAO, blueprintRoleAssignments.inheritBlueprintIds);
        blueprintRoleAssignmentsValidator.validateBlueprint(this.blueprintDAO);
        blueprintRoleAssignmentsValidator.validateRoles(this.roleDAO);
        this.usersContainerValidationService.validate(blueprintRoleAssignmentsValidator.usersContainersExtraction);
    }

    @Override
    public void validateArtifactRoleAssignments(ArtifactRoleAssignments artifactRoleAssignments) throws IOException {
        ArtifactRoleAssignmentValidator artifactRoleAssignmentValidator = new ArtifactRoleAssignmentValidator(artifactRoleAssignments);
        artifactRoleAssignments.accept(artifactRoleAssignmentValidator);
        artifactRoleAssignmentValidator.validateRoles(this.roleDAO);
        this.usersContainerValidationService.validate(artifactRoleAssignmentValidator.usersContainersExtraction);
    }
}

