/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.admin;

import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.storage.admin.IDBDumpDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.Constants;
import com.dataiku.gh.core.storage.sql.model.Q_historyRevisions;
import com.google.common.base.Joiner;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.SQLQuery;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Objects;

public class DBDumpDAO
extends AbstractPostgreSQLClient
implements IDBDumpDAO {
    @Override
    @GHReadonlyTransaction
    public void dumpDB(File targetFolder, boolean includeHistoryTables) throws IOException {
        block17: {
            try (OutputStream os = Files.newOutputStream(new File(targetFolder, "postgres-version.txt").toPath(), StandardOpenOption.CREATE_NEW);){
                String version = (String)this.querydslJdbcTemplate.queryForObject("SELECT version();", String.class);
                if (!StringUtils.isNotBlank((CharSequence)version)) break block17;
                try {
                    os.write(version.getBytes(StandardCharsets.UTF_8));
                    os.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        for (Constants.DBTableWithColumnInfo tableInfo : Constants.ALL_DB_TABLES) {
            if (Objects.equals(tableInfo.table, (Object)Q_historyRevisions.HistoryRevisions) || !includeHistoryTables && tableInfo.isHistoryTable()) continue;
            ArrayList<Object> selectPaths = new ArrayList<Object>();
            if (tableInfo.jsonColumn != null) {
                selectPaths.add(tableInfo.jsonColumn);
            }
            if (tableInfo.revisionJsonColumn != null) {
                selectPaths.add(tableInfo.revisionJsonColumn);
            }
            SQLQuery sqlQuery = (SQLQuery)this.sqlQueryFactory.select((Expression[])selectPaths.toArray(new Path[0])).from(tableInfo.table);
            try (OutputStream os = Files.newOutputStream(new File(targetFolder, tableInfo.table.getTableName() + ".txt").toPath(), StandardOpenOption.CREATE_NEW);){
                this.querydslJdbcTemplate.queryForStream(sqlQuery, (rs, rowNum) -> {
                    ArrayList<String> ret = new ArrayList<String>();
                    for (Path path : selectPaths) {
                        ret.add(rs.getString(ColumnMetadata.getName((Path)path)));
                    }
                    return ret;
                }).forEach(items -> {
                    try {
                        os.write((Joiner.on((String)"\t").join((Iterable)items) + "\n").getBytes(StandardCharsets.UTF_8));
                        os.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }
}

