/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.server.services.DiagnosticsService;
import com.dataiku.j2ts.annotations.UIModel;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DiagnosticsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private DiagnosticsService service;
    static DKULogger logger = DKULogger.getLogger((String)"dku.diagnostics");

    @AuditedCall(value={"msgType", "admin-diagnostics-run"})
    @RequestMapping(value={"/api/admin/diagnostics/run"})
    public void run(HttpServletRequest req, HttpServletResponse resp, String options) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
            DiagnosticsController.writeJSON((HttpServletResponse)resp, this.service.run(options, u));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/admin/diagnostics/get-latest-diagnosis"})
    public void getLatestDiagnosis(HttpServletRequest req, HttpServletResponse resp, String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            DiagnosisDesc dd = new DiagnosisDesc();
            File diagnosisFile = this.service.getLatestDiagnosisFile();
            if (diagnosisFile != null) {
                dd.exists = true;
                dd.size = diagnosisFile.length();
                dd.date = diagnosisFile.lastModified();
            }
            DiagnosticsController.writeJSON((HttpServletResponse)resp, (Object)dd);
        }
    }

    @AuditedCall(value={"msgType", "admin-diagnostics-downsload"})
    @RequestMapping(value={"/api/admin/diagnostics/get-results"})
    public void getResults(HttpServletRequest req, HttpServletResponse resp, String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdminNoXSRF(req);
        }
        File diagnosisFile = this.service.getLatestDiagnosisFile();
        if (diagnosisFile == null || !diagnosisFile.exists()) {
            resp.setStatus(404);
            resp.getWriter().write("diagnosis file not found");
        } else {
            try (FileInputStream is = new FileInputStream(diagnosisFile);){
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + diagnosisFile.getName() + "\"");
                IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
            }
        }
    }

    @UIModel
    static class DiagnosisDesc {
        boolean exists;
        long size;
        long date;

        DiagnosisDesc() {
        }
    }
}

