(function() {
    'use strict';

    const app = angular.module('dataiku', [
        'angular-blocks',
        'dataiku.constants',
        'dataiku.credentials',
        'dataiku.controllers',
        'dataiku.constants',
        'dataiku.services',
        'dataiku.logger',
        'dataiku.charts',

        'dataiku.common.func',
        'dataiku.common.nav',
        'dataiku.common.build',
        'dataiku.common.datastructures',
        'dataiku.common.lists',
        'dataiku.common.pictures',
        'dataiku.common.sampling',

        'dataiku.shaker',
        'dataiku.shaker.analyse',
        'dataiku.shaker.table',
        'dataiku.shaker.misc',
        'dataiku.shaker.library',

        'dataiku.export.services',

        'dataiku.directives.bootstrap',
        'dataiku.directives.dip',
        'dataiku.directives.styling',
        'dataiku.directives.widgets',
        'dataiku.directives.forms',
        'dataiku.directives.snippetEditor',
        'dataiku.directives.scope',
        'dataiku.widgets.futures',
        'dataiku.widgets.integrations',
        'dataiku.widgets.drawers',
        'dataiku.widgets.tageditfield',

        'dataiku.filters',

        'dataiku.meanings',

        'dataiku.taggableobjects',

        'dataiku.notebooks.sql',
        'dataiku.notebooks.search',
        'dataiku.rstudioserverembed',

        'dataiku.llm',
        'dataiku.promptstudios',
        'dataiku.agents',
        'dataiku.agenttools',
        'dataiku.agentdependencies',
        'dataiku.retrieval-augmented-llm',

        'dataiku.projects.settings',
        'dataiku.projects.actions',
        'dataiku.projects.directives',

        'dataiku.personal-home.directives',

        'dataiku.connections',

        'dataiku.datasets',
        'dataiku.datasets.custom',
        'dataiku.datasets.directives',
        'dataiku.datasets.foreign',
        'dataiku.datasets.partitioning',

        'dataiku.dashboards',
        'dataiku.dashboards.insights',

        'dataiku.webapps',
        'dataiku.report',

        'dataiku.admin.code-studios',
        'dataiku.code-studios',

        'dataiku.metrics.core',
        'dataiku.metrics.views',
        'dataiku.metrics.savedmodels.views',
        'dataiku.metrics.edit',

        'dataiku.flow.graph',
        'dataiku.flow.tools',
        'dataiku.flow.project',
        'dataiku.flow.runtime',

        'dataiku.recipes',
        'dataiku.recipes.customcode',
        'dataiku.directives.insights',
        'dataiku.directives.simple_report',
        'dataiku.filters',


        'dataiku.admin',
        'dataiku.admin.config',
        'dataiku.admin.codeenvs.common',
        'dataiku.admin.codeenvs.automation',
        'dataiku.admin.codeenvs.design',
        'dataiku.admin.security',
        'dataiku.admin.maintenance',
        'dataiku.admin.monitoring',
        'dataiku.admin.clusters',
        'dataiku.admin.alertMessageBanner',
        'dataiku.admin.globalApiKeyInput',
        'dataiku.admin.charts_dashboards',
        'dataiku.admin.stories_themes',

        'dataiku.plugins',
        'dataiku.plugindev',
        'dataiku.folder_edit',
        'dataiku.catalog',
        'dataiku.deployer',
        'dataiku.apideployer',
        'dataiku.projectdeployer',

        'dataiku.unified-monitoring',

        /* ML (shared between analysis, saved model and insight) */
        'dataiku.ml.core',
        'dataiku.ml.predicted',
        'dataiku.ml.report',
        'dataiku.ml.explainability',
        'dataiku.ml.hyperparameters',
        'dataiku.ml.gpuexecution',

        'dataiku.analysis.core',
        'dataiku.analysis.script',
        'dataiku.analysis.mlcore',

        'dataiku.savedmodels',
        'dataiku.modelevaluationstores',
        'dataiku.modelcomparisons',
        'dataiku.experimenttracking',
        'dataiku.managedfolder',
        'dataiku.retrievableknowledge',

        'dataiku.labeling',

        /* Streaming endpoints */
        'dataiku.streaming-endpoints',

        'dataiku.scenarios',
        'dataiku.continuous-activities',
        'dataiku.monitoring',
        'dataiku.runnables',

        'dataiku.lambda',

        'dataiku.collab.timeline',
        'dataiku.collab.discussions',
        'dataiku.collab.wikis',
        'dataiku.git',

        'dataiku.bundles.common',
        'dataiku.bundles.design',
        'dataiku.bundles.automation',

        'dkuSanitize',

        'dataiku.integrations.alation',

        'dataiku.ngXmigration',

        'dataiku.featurestore',

        /* Consumer workspaces */
        'dataiku.workspaces',

        /* Designer new filters */
        'dataiku.nestedFilters',

        /* Designer surveys */
        'dataiku.surveys',

        /* Designer Opals */
        'dataiku.opals',

        /* Designer auto feature generation */
        'dataiku.autoFeatureGeneration',

        /* Homepage */
        'dataiku.homepage',

        /* Designer AI assistants */
        'dataiku.aiExplanations',
        'dataiku.aiSqlGeneration',
        'dataiku.aiDatasetDescriptions',

        /* Schedule Scenario Modal */
        'dataiku.scheduleScenario',

        /* Homepage */
        'dataiku.homepage',

        /* Add dataset Workflow */
        'dataiku.addDatasetWorkflow',

        /* Processors */
        'dataiku.processors',

        /* Designer inbox */
        'dataiku.inbox',

        /* Widgets */
        'dataiku.widgets',

        /* Coloring */
        'dataiku.coloring',

        'dataiku.shared',

        /* Search notebooks */
        'dataiku.searchNotebooks',

        /* 3rd party */
        'ngRoute',
        'ngSanitize',
        'ui.sortable',
        'ui.tree',
        'ui.router',
        'ui.codemirror',
        'ui.keypress',
        'infinite-scroll',
        'platypus.utils',
        'ui-rangeSlider',
        'colorContrast',
        'LocalStorageModule',
        'monospaced.elastic',
        'checklist-model',
    '$strap',
    'pascalprecht.translate'
    ]);


    app.factory('dssInterceptor', function($location, $q, $rootScope, $httpParamSerializer) {
        return {
            'requestError': function(response) {
                const status = response.status;
                if (status == 401) {
                    /*Don't redirect to login on failed login :D */
                    if (response.config.url.indexOf("/api/login") >= 0) {
                        return $q.reject(response);
                    }
                    // It's not possible to inject $state here because of
                    // Uncaught Error: Circular dependency: $templateFactory <- $state <- $http <- $compile
                    // So we can't transition and have to refresh ...
                    if ($location.path() !== '/login/' && $location.path() !== '/login') {
                        $rootScope.$evalAsync('appConfig.loggedIn = false');
                        $location.url("/login/?redirectTo=" + $location.path() + "&search=" + $httpParamSerializer($location.search()));
                    } else {
                        return $q.reject(response);
                    }
                } else {
                    return $q.reject(response);
                }
            }
        };
    });

    // this doesn't redirect the children, it's just a shortcut to declare an abstract state for which all children are redirected with redirectState
    function redirectedAbstractState($stateProvider, fromState, url) {
        $stateProvider.state(fromState, {
            url,
            template: '<ui-view></ui-view>',
            abstract: true
        });
    }

    function redirectState($stateProvider, fromState, toState, fromUrl, passStateParams = false) {
        $stateProvider.state(fromState, {
            url: fromUrl,
            template: '<div ui-view></div>',
            controller: function($state, $stateParams, $timeout) {
                if ($state.current.name === fromState) {
                    // timeout() is needed so that the final state appears in the browser history
                    $timeout(() => $state.go(toState, passStateParams ? $stateParams : null, {location: 'replace'}));
                }
            }
        });
    }

    function declareRoutes($stateProvider,$urlRouterProvider, WorkspacesUIRouterStates, MLModelsUIRouterStates, InsightsUIRouterStates, GoToStateNameSuffixIfBase) {
        /* ************************* Top level routes ************************ */

        $stateProvider.state('root', {
            url: '/',
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home";
            }
        });
        $stateProvider.state('profile.ngx', {
            url: '/ngx-hello',
            template: '<ng2-downgrade-example></ng2-downgrade-example>'
        });
        $stateProvider.state('home', {
            url: '/home/',
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home";
            }
        });

        $stateProvider.state('wikis', {
            url: '/wikis/',
            params: {
                filterBy: undefined,
                standalone: true,
                row: 'wikis'
            },
            templateUrl: '/templates/wikis-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Wikis";
            }
        });

        $stateProvider.state('wikis.list', {
            url: 'list/',
            params: {
                filterBy: undefined,
                standalone: true,
                row: 'wikis'
            },
            templateUrl: '/templates/wikis-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Wikis";
            }
        });

        $stateProvider.state('home.expandedlist', {
            url: ':row/expandedlist',
            params: {
                filterBy: undefined
            },
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home expanded";
            }
        });

        $stateProvider.state('home.expandedmosaic', {
            url: ':row/expandedmosaic',
            params: {
                filterBy: undefined,
                standalone: undefined
            },
            templateUrl: '/templates/personal-home.html',
            controller: 'PersonalHomeController',
            pageTitle: () => {
                return "Home expanded mosaic";
            }
        });

        $stateProvider.state('project-list', {
            url: '/project-list/:folderId?forceDisplayMode',
            controller: 'ProjectsListController',
            templateUrl: '/templates/projects-list/projects-list.html',
            pageTitle: () => {
                return "Projects";
            }
        });

        $stateProvider.state('login', {
            url: '/login/?redirectTo&search',
            templateUrl: '/templates/login.html',
            controller: 'LoginController',
            pageTitle: () => {
                return "Login";
            }
        });

        $urlRouterProvider.when('/login', '/login/');

        $stateProvider.state('sso-error', {
            url: '/sso-error?error&errorDescription',
            templateUrl: '/templates/sso-error.html',
            controller: 'SSOErrorController',
            pageTitle: () => {
                return "SSO error";
            }
        });

        $stateProvider.state('logged-out', {
            url: '/logged-out',
            templateUrl: '/templates/logged-out.html',
            pageTitle: () => {
                return "Logged out";
            }
        });

        $stateProvider.state('feedback', {
            url: '/feedback/',
            templateUrl: '/templates/feedback.html'
        });

        $stateProvider.state("blackhole", {
            url: "/blackhole/"
        });

        $stateProvider.state('projects', {
            url: '/projects',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('dataquality', {
            url: '/data-quality',
            abstract: true,
            template: '<ng2-instance-data-quality-nav></ng2-instance-data-quality-nav><ui-view class="dss-page"></ui-view>',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME, "dataquality");
            }
        });

        $stateProvider.state('dataquality.current-status', {
            url: '/',
            template: '<ng2-instance-status-panel></ng2-instance-status-panel>',
            pageTitle: () => {
                return "Instance - Data Quality";
            }
        });

        const dataQualityTemplatesPageTitle = () => "Data Quality Templates";

        $stateProvider.state('dataquality.templates', {
            url: '/templates',
            abstract: true,
            template: '<ui-view></ui-view>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.list', {
            url: '/',
            template: '<ng2-data-quality-templates></ng2-data-quality-templates>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.template', {
            url: '/:templateId',
            template: '<ng2-data-quality-template-edit-view [template-id]="$state.params.templateId"></ng2-data-quality-template-edit-view>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.template.new-rule', {
            url: '/new-rule',
            template: '<ng2-new-rule-panel id="new-rule-panel"></ng2-new-rule-panel>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('dataquality.templates.template.rule', {
            url: '/:ruleId',
            template: '<ng2-rule-edit [can-edit]="addToScope.canEdit" [rule-id]="$root.$state.params.ruleId"></ng2-rule-edit>',
            pageTitle: dataQualityTemplatesPageTitle
        });

        $stateProvider.state('jambon', {
            url: '/admin/jambon/',
            templateUrl: '/templates/widgets/image-uploader-dialog.html'
        });

        /* ************************** Home v2  ********************** */

        // currently not really active - the old home takes over - but required for subroutes to work.
        $stateProvider.state('homeV2', {
            url: '/home',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
            controller: function(TopNav, $scope, $rootScope, $state) {
                TopNav.setLocation(TopNav.DSS_HOME);

                $scope.redirectForNoneProfile = $rootScope.appConfig.userProfile.profile === 'NONE' && $state.current.name !== 'homeV2.homepage';
                if ($scope.redirectForNoneProfile) {
                    $state.go('homeV2.homepage', null, {location: 'replace'});
                }
            }
        });

        $stateProvider.state('homeV2.homepage', {
            url: '/',
            templateUrl: '/templates/personal-home.html',
            pageTitle: () => {
                return "Home";
            }
        });

        $stateProvider.state('homeV2.projects', {
            url: '/projects/',
            template: '<ng2-projects-page [folder-id]="$root.$stateParams.folderId"></ng2-projects-page>',
            abstract: true,
        });

        $stateProvider.state('homeV2.projects.folder', {
            url: ':folderId',
            template: '',
            pageTitle: () => {
                return "Projects";
            }
        });

        $stateProvider.state('homeV2.applications', {
            url: '/applications',
            template: '<ng2-applications-page></ng2-applications-page>',
            pageTitle: () => {
                return "Applications"
            }
        });

        $stateProvider.state('homeV2.data-catalog', {
            url: '/data-catalog',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
        });

        $stateProvider.state('homeV2.data-catalog.home', {
            url: '/',
            template: '<ng2-data-catalog-page class="h100"></ng2-data-catalog-page>',
            pageTitle: () => {
                return "Data Catalog"
            }
        });

        $stateProvider.state('homeV2.data-catalog.data-collections', {
            url: '/data-collections',
            abstract: true,
            template: '<ng2-home-root class="h100"></ng2-home-root>'
        });

        $stateProvider.state('homeV2.data-catalog.data-collections.home', {
            url: '/',
            template: '<ng2-data-collections-page></ng2-data-collections-page>',
            pageTitle: () => "Data Collections"
        });

        $stateProvider.state('homeV2.data-catalog.data-collections.data-collection', {
            url: '/:dataCollectionId/',
            template: '<ng2-data-collection-page [id]="$root.$stateParams.dataCollectionId" [context-project-key]="undefined"></ng2-data-collection-page>',
            pageTitle: () => "Data Collections"
        });

        $stateProvider.state('homeV2.workspaces', {
            url: '/workspaces',
            template: '<ng2-workspaces-page></ng2-workspaces-page>',
            pageTitle: () => {
                return "Workspaces"
            }
        });

        $stateProvider.state('homeV2.data-catalog.database-explorer', {
            url: '/database-explorer?connectionName?schemaName?catalogName',
            template: `<ng2-database-explorer-page class="h100"></ng2-database-explorer-page>`,
            pageTitle: () => "Database explorer"
        });

        // must be placed after all other `homeV2.data-catalog.*` to prevent selectedTab to match with everything
        $stateProvider.state('homeV2.data-catalog.datasources', {
            url: '/:selectedTab',
            template: '<ng2-data-sources-page class="h100" [query-on-load]="$root.$stateParams.queryOnLoad" [preselected-item]="$root.$stateParams.preselectedItem"></ng2-data-sources>',
            params: {
                queryOnLoad: null, // optionally set the query after load
                preselectedItem: undefined // optionally select an item (if it's in the results of the first query)
            },
            pageTitle: () => {
                return "Datasets & Indexed Tables"
            }
        });

        /* ************************** Project Apps ********************** */

        $stateProvider.state('apps', {
            url: '/apps',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('apps.list', {
            url: '/',
            controller: 'AppsListController',
            templateUrl: '/templates/apps/apps-list.html',
            params: {
                preSetQuery: '' // optional: fill in the search field on load
            },
            pageTitle: () => {
                return "Applications";
            }
        });

        $stateProvider.state('apps.app', {
            url: '/:appId',
            templateUrl: '/templates/apps/app-page.html',
            pageTitle: () => {
                return "App";
            }
        });

        /* ************************** Project ********************** */

        $stateProvider.state('projects.project', {
            url: '/:projectKey',
            abstract: true,
            controller: 'ProjectBaseController',
            templateUrl: '/templates/projects/project.html'
        });

        $stateProvider.state('projects.project.project-standards-report', {
            url: '/project-standards-report',
            template: '<ng2-project-standards-report-page [project-key]="$root.$state.params.projectKey"></ng2-project-standards-report-page>',
            pageTitle: () => {
                return "Project Standards Report";
            }
        });

        $stateProvider.state('projects.project.home', {
            abstract: true,
            url: '',
            templateUrl: '/templates/projects/home/index.html',
            controller: 'ProjectHomeTabController',
        });

        $stateProvider.state('projects.project.home.summary', {
            url: '/?discussionId&testInstance',
            templateUrl: '/templates/projects/home/project-home.html',
            controller: 'ProjectHomeController',
            pageTitle: () => {
                return "Summary";
            }
        });

        $stateProvider.state('projects.project.home.regular', {
            url: '?discussionId&testInstance',
            controller: 'ContextualProjectHomeController',
        });

        $stateProvider.state('projects.project.home.setup', {
            url: '/setup',
            templateUrl : '/templates/projects/home/setup-home.html',
            pageTitle: () => {
                return "Project setup"
            }
        });

        $stateProvider.state('projects.project.home.activity', {
            url: '/activity/',
            templateUrl: '/templates/projects/home/activity.html',
            controller: 'ProjectHomeController',
            pageTitle: () => {
                return "Summary";
            }
        });

        $stateProvider.state('projects.project.home.status', {
            url: '/status',
            abstract: true,
            templateUrl: '/templates/projects/home/status.html',
            controller: 'ProjectMetricsController',
            pageTitle: () => {
                return " Summary";
            }
        });

        $stateProvider.state('projects.project.home.status.settings', {
            url: '/settings',
            templateUrl: '/templates/projects/home/status-settings.html'
        });

        $stateProvider.state('projects.project.home.status.metrics', {
            url: '',
            templateUrl: '/templates/projects/home/status-metrics.html'
        });

        $stateProvider.state('projects.project.home.status.checks', {
            url: '/checks',
            templateUrl: '/templates/projects/home/status-checks.html'
        });

        /* Temporary redirect state */

        $stateProvider.state('projects.project.settings.tmp', {
            url: '/',
            controller: 'ProjectSettingsTmpController',
        });

        $stateProvider.state('projects.project.variables', {
            url: '/variables/',
            templateUrl: '/templates/projects/variables/variables.html'
        });

        $stateProvider.state('projects.project.appdesigner', {
            url: '/app-designer/',
            templateUrl: '/templates/apps/app-designer.html',
            controller: "AppDesignerController",
            pageTitle: () => {
                return "Application designer";
            }
        });

        $stateProvider.state('projects.project.statisticsWorksheet', {
            url: '/statistics/worksheet/:worksheetId',
            template: '<ng2-eda-worksheet-redirection-page></ng2-eda-worksheet-redirection-page>'
        });

        $stateProvider.state('projects.project.settings', {
            url: '/settings/:selectedTab',
            templateUrl: '/templates/projects/settings/settings.html'
        });

        $stateProvider.state('projects.project.integrations', {
            url: '/settings/integrations',
            templateUrl: '/templates/projects/integrations/messaging-like-selection.html'
        });

        $stateProvider.state('projects.project.security', {
            url: '/security/:selectedTab',
            templateUrl: '/templates/projects/security/security.html'
        });

        $stateProvider.state('projects.project.libedition', {
            url: '/libedition',
            abstract: true,
            templateUrl: '/templates/plugins/development/lib-edition-project.html'
        });

        $stateProvider.state("projects.project.libedition.versioned", {
            url: '/versioned?initialPath',
            templateUrl: '/templates/plugins/development/lib-versioned-edition-project.html',
            controller: 'ProjectFolderVersionedEditionController',
            params: {
                initialPath: ''
            },
            pageTitle: () => "Library Editor"
        });

        $stateProvider.state("projects.project.libedition.history", {
            url: '/history',
            templateUrl: '/templates/plugins/development/lib-versioned-history-project.html',
            controller: 'ProjectFolderVersionedHistoryController',
            pageTitle: () => "Library Editor"
        });

        $stateProvider.state("projects.project.libedition.resources", {
            url: '/resources',
            templateUrl: '/templates/plugins/development/lib-resources-edition-project.html',
            controller: 'ProjectFolderResourcesEditionController',
            pageTitle: () => "Library Editor"
        });

        $stateProvider.state('projects.project.libedition.libpython', {
            url: '/libpython',
            redirectTo: 'projects.project.libedition.versioned'
        });

        $stateProvider.state('projects.project.libedition.localstatic', {
            url: '/localstatic',
            redirectTo: 'projects.project.libedition.versioned'
        });

        $stateProvider.state('projects.project.flow', {
            url: '/flow/?id&?zoneId',
            templateUrl: '/templates/flow-editor/flow-editor.html',
            pageTitle: () => {
                return "Flow";
            }
        });

        $stateProvider.state('projects.project.version-control', {
            url: '/version-control/?commitId?branch',
            templateUrl: '/templates/projects/git/project-git.html',
            controller: "ProjectVersionControlController",
            pageTitle: () => {
                return "Version control";
            }
        });

        $stateProvider.state('projects.project.version-control-merge', {
            url: '/version-control-merge/:mergeRequestId',
            templateUrl: '/templates/git/merge-request.html',
            controller: "GitMergeRequestController",
            pageTitle: () => "Merge request"
        });

        /* ************************** Dataset ********************** */

        $stateProvider.state('projects.project.datasets', {
            url: '/datasets',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.datasets.list', {
            url: '/',
            templateUrl: '/templates/datasets/list.html',
            controller: 'DatasetsListController',
            pageTitle: () => {
                return "Datasets";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset', {
            url: '/:datasetName?discussionId',
            abstract: true,
            controller: 'DatasetCommonController',
            templateUrl: '/templates/datasets/dataset.html'
        });

        $stateProvider.state('projects.project.datasets.dataset.settings', {
            url: '/settings/',
            templateUrl: '/templates/datasets/settings.html',
            controller: 'DatasetSettingsController',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Settings";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.history', {
            url: '/history/',
            templateUrl: '/templates/datasets/history.html',
            controller: 'DatasetHistoryController',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - History";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.statistics', {
            url: '/statistics',
            template: `<ng2-eda
                dataset-name="{{$state.params.datasetName}}"
                project-key="{{$state.params.projectKey}}"
                worksheet-id="{{$state.params.worksheetId}}"></ng2-eda>`,
            controller: 'DatasetStatisticsController',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.statistics.worksheet', {
            url: '/worksheet/:worksheetId',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        /* *********************** Data Quality ******************** */

        const dataQualityPageTitle = function(stateParams) {
            return stateParams.datasetName + " - Data quality";
        };

        $stateProvider.state('projects.project.datasets.dataset.data-quality', {
            url: '/data-quality',
            template: '<div block-api-error></div><div ui-view></div>',
            controller: 'DatasetDataQualityController',
            abstract: true
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view', {
            url: '',
            template: `<ng2-dataset-quality-tab-view
                ng-if="datasetFullInfo"
                class="dataset__data-quality-panel-container"
                [can-edit]="projectSummary.canWriteProjectContent"
                [can-publish-to-dashboards]="projectSummary.canWriteDashboards"
                [is-foreign]="false"
                [is-partitioned]="datasetFullInfo.partitioned"
                [context-project-key]="$stateParams.projectKey"
                [project-key]="$root.$state.params.projectKey"
                [dataset-name]="$root.$state.params.datasetName"
                [(data-steward)]="datasetFullInfo.dataSteward"
                [default-data-steward]="datasetFullInfo.defaultDataSteward"
                [last-build-time]="datasetFullInfo.lastBuild ? datasetFullInfo.lastBuild.buildEndTime : -1"
                [partitioning-scheme]="datasetFullInfo.dataset.partitioning"
                [is-input-dataset]="!datasetFullInfo.upstreamBuildable"
            ></ng2-dataset-quality-tab-view>
            `,
            abstract: true
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view.current-status', {
            url: '/current-status',
            template: `<ng2-current-values-panel
                [can-edit]="addToScope.canEdit"
                [can-publish-to-dashboards]="addToScope.canPublishToDashboards"
                [dataset-name]="addToScope.datasetName"
                [context-project-key]="addToScope.contextProjectKey"
                [project-key]="addToScope.projectKey"
                [is-foreign]="false"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [data-steward]="addToScope.dataSteward"
                (data-steward-change)="addToScope.dataStewardChange($event)"
                [default-data-steward]="addToScope.defaultDataSteward"
                [last-build-time]="addToScope.lastBuildTime"
                [is-input-dataset]="addToScope.isInputDataset"
            ></ng2-current-values-panel>`,
            pageTitle: dataQualityPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view.timeline', {
            url: '/timeline',
            template: `<ng2-timeline-panel
                [can-edit]="addToScope.canEdit"
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [is-foreign]="false"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
            ></ng2-timeline-panel>`,
            pageTitle: dataQualityPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.view.history', {
            url: '/history?ruleIds?status?startDate?endDate',
            template: `<ng2-rule-history
                [dataset-name]="$root.$state.params.datasetName"
                [project-key]="$root.$state.params.projectKey"
                [context-project-key]="$root.$state.params.projectKey"
                [rule-ids]="$root.$state.params.ruleIds"
                [status]="$root.$state.params.status"
                [start-date]="$root.$state.params.startDate"
                [end-date]="$root.$state.params.endDate"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [can-edit]="addToScope.canEdit"
            ></ng2-rule-history>`,
            pageTitle: dataQualityPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.edit', {
            url: '/edit',
            templateUrl: '/templates/datasets/data-quality-edit.html',
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.edit.new-rule', {
            url: '/new-rule',
            templateUrl: '/templates/datasets/data-quality-new-rule.html',
            params: {
                openTemplateModal: undefined
            },
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Data quality (new rule)";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.data-quality.edit.rule', {
            url: '/:ruleId',
            template: '<ng2-rule-edit [can-edit]="addToScope.canEdit" [rule-id]="$root.$state.params.ruleId" [project-key]="$root.$state.params.projectKey"></ng2-rule-edit>',
            pageTitle: dataQualityPageTitle
        });

        /* ************************** Metrics ********************** */

        const metricsPageTitle = function(stateParams) {
            return stateParams.datasetName + " - Metrics";
        };

        $stateProvider.state('projects.project.datasets.dataset.metrics', {
            url: '/metrics',
            template: `
            <div block-api-error></div>
            <div class= "h100" object-metrics metrics-partition-selection dataset-metrics-main>
                <div ng-if="datasetFullInfo" class="h100" ng-controller="DatasetMetricsController">
                    <ui-view class="h100"></ui-view>
                </div>
            </div>`,
            abstract: true
        });

        $stateProvider.state('projects.project.datasets.dataset.metrics.view', {
            url: '',
            template:`
                <div class="h100" ng-if="datasetFullInfo" ng-controller="DatasetMetricsController">
                    <div class="h100" display-metrics ng-show="views.selected === 'Last value' || views.selected === 'History'" can-compute="true" metrics-tab="true"></div>
                    <div class="h100" display-metrics-per-partition ng-show="views.selected === 'Partitions' || views.selected === 'Table'" can-compute="true" metrics-tab="true"></div>
                    <div class="h100" display-metrics-per-column ng-show="views.selected === 'Columns'" can-compute="true" metrics-tab="true"></div>
                </div>`,
            pageTitle: metricsPageTitle
        });

        $stateProvider.state('projects.project.datasets.dataset.metrics.edit', {
            url: '/edit',
            template:`
                <div class="h100 boxed-next-to-sidebar no-padding">
                    <div ng-if="datasetFullInfo" class="h100 oa">
                        <form class="dkuform-modal-horizontal dkuform-modal-wrapper h100" name="theform" edit-probes-settings metrics-tab="true" novalidate >
                        </form>
                    </div>
                </div>
                `,
            pageTitle: metricsPageTitle
        });

        /* ***************** Agent Hub ********************* */
        redirectedAbstractState($stateProvider, 'projects.project.dataikuanswers', '/answers');
        redirectState($stateProvider, "projects.project.dataikuanswers.list","projects.project.agenthub.list","/")

        $stateProvider.state("projects.project.agenthub", {
            url : '/agenthub',
            template: '<div ui-view></div>',
            abstract: true
        });

        $stateProvider.state("projects.project.agenthub.list", {
            url : '/',
            templateUrl: '/templates/agent-hub/list.html',
            controller: 'ChatUIsListController',
            pageTitle: () => {
                return "Agent Hub";
            }
        });

        /* ***************** Trace Explorer ********************* */

        $stateProvider.state('projects.project.traceexplorers', {
            url: '/traceexplorers',
            template: '<div ui-view></div>',
            abstract: true,
        });

        $stateProvider.state('projects.project.traceexplorers.list', {
            url: '/',
            templateUrl: '/templates/trace-explorer/list.html',
            controller: 'TraceExplorerWebAppsListController',
            pageTitle: () => {
                return 'Trace Explorer';
            },
        });

        /* ***************** Experiment tracking ********************* */

        $stateProvider.state('projects.project.experiment-tracking', {
            url: '/experiment-tracking',
            template: '<div ui-view></div>',
            controller: 'ExperimentTrackingController',
            reloadOnSearch: false,
            abstract: true
        });

        $stateProvider.state('projects.project.experiment-tracking.list', {
            url: '/list?viewAllExperiments',
            params: {
                viewAllExperiments: "false"
            },
            template: `<ng2-experiment-tracking></ng2-experiment-tracking>`,
            reloadOnSearch: false,
            pageTitle: function() {
                return " Experiment Tracking - Runs";
            }
        });

        $stateProvider.state('projects.project.experiment-tracking.runs-list', {
            url: '/list-runs?experimentIds&viewAllExperiments&viewAllRuns',
            params: {
                experimentIds: undefined,
                viewAllExperiments: undefined,
                viewAllRuns: undefined
            },
            template: `<ng2-experiment-tracking-runs-list></ng2-experiment-tracking-runs-list>`,
            reloadOnSearch: false,
            pageTitle: function() {
                return " Experiment Tracking - Runs";
            }
        });

        $stateProvider.state('projects.project.experiment-tracking.run-details', {
            url: '/run/:runId/details?experimentIds&viewAllExperiments&viewAllRuns',
            params: {
                experimentIds: undefined,
                viewAllExperiments: undefined,
                viewAllRuns: undefined
            },
            template: `<ng2-experiment-tracking-run></ng2-experiment-tracking-run>`,
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return " Experiment Tracking - Run";
            }
        });

        $stateProvider.state('projects.project.experiment-tracking.run-artifacts', {
            url: '/run/:runId/artifacts?experimentIds&viewAllExperiments&viewAllRuns&subfolder',
            params: {
                experimentIds: undefined,
                subfolder: undefined,
                viewAllExperiments: undefined,
                viewAllRuns: undefined
            },
            template: `<ng2-experiment-tracking-run></ng2-experiment-tracking-run>`,
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return " Experiment Tracking - Run";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.edit', {
            url: '/edit/',
            templateUrl: '/templates/datasets/edit-dataset.html',
            controller: 'DatasetEditController',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Edit";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.explore', {
            url: '/explore/',
            templateUrl: '/templates/datasets/explore.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Explore";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.status', {
            url: '/status',
            abstract: true,
            template: '<ui-view />'
        });

        $stateProvider.state('projects.project.datasets.dataset.status.settings', {
            url: '/settings/:selectedTab',
            params: { selectedTab: null },
            controller: function($state, $stateParams) {
                if ($stateParams.selectedTab === 'checks') {
                    $state.go('projects.project.datasets.dataset.data-quality.edit', $stateParams, {location: 'replace'})
                } else {
                    $state.go('projects.project.datasets.dataset.metrics.edit', $stateParams, {location: 'replace'})
                }
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.status.metrics', {
            url: '',
            controller: function($state, $stateParams) {
                $state.go('projects.project.datasets.dataset.metrics.view', $stateParams, {location: 'replace'})
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.status.checks', {
            url: '/checks',
            controller: function($state, $stateParams) {
                $state.go('projects.project.datasets.dataset.data-quality.view.current-status', $stateParams, {location: 'replace'})
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.visualize', {
            url: '/visualize/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/datasets/visualize.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Visualize";
            }
        });

        $stateProvider.state('projects.project.datasets.new_with_type', {
            url: '/new/:type?fromOdbSmartId?fromOdbItemPath?fromOdbItemDirectory?zoneId',
            abstract: true,
            templateUrl: '/templates/datasets/dataset.html',
            controller: 'DatasetNewController',
        });

        $stateProvider.state('projects.project.datasets.new_with_type.settings', {
            url: '/?prefillParams',
            templateUrl: '/templates/datasets/new-settings.html',
            controller: 'DatasetSettingsController',
            pageTitle: function(stateParams) {
                return "New " + stateParams.type + " dataset";
            }
        });

        $stateProvider.state('projects.project.datasets.dataset.search', {
            url: '/search/',
            templateUrl: '/templates/datasets/search.html',
            params: {
                queryString: null,
            },
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Search";
            }
        });

        /* ************************** Foreign view of datasets ********************** */

        $stateProvider.state('projects.project.foreigndatasets', {
            url: '/foreigndatasets',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset', {
            url: '/:datasetFullName',
            abstract: true,
            controller: 'ForeignDatasetCommonController',
            templateUrl: '/templates/foreigndatasets/dataset.html'
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.explore', {
            url: '/explore/',
            templateUrl: '/templates/foreigndatasets/explore.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetFullName + " - Explore";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.search', {
            url: '/search/',
            templateUrl: '/templates/foreigndatasets/search.html',
            params: {
                queryString: null,
            },
            pageTitle: function(stateParams) {
                return stateParams.datasetFullName + " - Search";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.visualize', {
            url: '/visualize/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/foreigndatasets/visualize.html',
            pageTitle: function(stateParams) {
                return stateParams.datasetFullName + " - Visualize";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.statistics', {
            url: '/statistics',
            template: `<ng2-eda
                dataset-name="{{$state.params.datasetFullName}}"
                project-key="{{$state.params.projectKey}}"
                worksheet-id="{{$state.params.worksheetId}}"></ng2-eda>`,
            controller: 'DatasetStatisticsController',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.statistics.worksheet', {
            url: '/worksheet/:worksheetId',
            reloadOnSearch: false,
            pageTitle: function(stateParams) {
                return stateParams.datasetName + " - Statistics";
            }
        });

        const dataQualityPageTitleForeign = function(stateParams) {
            return stateParams.datasetFullName + " - Data quality";
        };

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality', {
            url: '/data-quality',
            template: '<div block-api-error></div><div ui-view></div>',
            controller: 'DatasetDataQualityController',
            abstract: true
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view', {
            url: '',
            template: `<ng2-dataset-quality-tab-view
                ng-if="datasetLoc && datasetFullInfo"
                class="dataset__data-quality-panel-container"
                [can-edit]="false"
                [is-foreign]="true"
                [is-partitioned]="datasetFullInfo.partitioned"
                [context-project-key]="$stateParams.projectKey"
                [project-key]="datasetLoc.projectKey"
                [dataset-name]="datasetLoc.name"
                [data-steward]="datasetFullInfo.dataSteward"
                [default-data-steward]="datasetFullInfo.defaultDataSteward"
                [last-build-time]="datasetFullInfo.lastBuild.buildEndTime"
                [partitioning-scheme]="datasetFullInfo.dataset.partitioning"
                [is-input-dataset]="!datasetFullInfo.upstreamBuildable"
            ></ng2-dataset-quality-tab-view>`,
            abstract: true
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view.current-status', {
            url: '/current-status',
            template: `<ng2-current-values-panel
                [can-edit]="addToScope.canEdit"
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [is-foreign]="true"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [data-steward]="addToScope.dataSteward"
                [default-data-steward]="addToScope.defaultDataSteward"
                [last-build-time]="addToScope.lastBuildTime"
                [is-input-dataset]="addToScope.isInputDataset"
            ></ng2-current-values-panel>`,
            pageTitle: dataQualityPageTitleForeign
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view.timeline', {
            url: '/timeline',
            template: `<ng2-timeline-panel
                [can-edit]="addToScope.canEdit"
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [is-foreign]="true"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
            ></ng2-timeline-panel>`,
            pageTitle: dataQualityPageTitleForeign
        });

        $stateProvider.state('projects.project.foreigndatasets.dataset.data-quality.view.history', {
            url: '/history?ruleIds?status?startDate?endDate',
            template: `<ng2-rule-history
                [dataset-name]="addToScope.datasetName"
                [project-key]="addToScope.projectKey"
                [context-project-key]="addToScope.contextProjectKey"
                [project-key]="addToScope.projectKey"
                [rule-ids]="$root.$state.params.ruleIds"
                [status]="$root.$state.params.status"
                [start-date]="$root.$state.params.startDate"
                [end-date]="$root.$state.params.endDate"
                [is-partitioned]="addToScope.isPartitioned"
                [selected-partition-id]="addToScope.selectedPartitionId"
                [can-edit]="addToScope.canEdit"
            ></ng2-rule-history>`,
            pageTitle: dataQualityPageTitleForeign
        });

        /* ************************** Streaming enpdoints ********************** */

        $stateProvider.state('projects.project.streaming-endpoints', {
            url: '/streaming-endpoints',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.streaming-endpoints.list', {
            url: '/',
            templateUrl: '/templates/streaming-endpoints/list.html',
            controller: 'StreamingEndpointsListController',
            pageTitle: () => {
                return "Streaming endpoints";
            }
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint', {
            url: '/:streamingEndpointId?discussionId',
            abstract: true,
            controller: 'StreamingEndpointPageController',
            templateUrl: '/templates/streaming-endpoints/streaming-endpoint.html'
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint.settings', {
            url: '/settings/',
            templateUrl: '/templates/streaming-endpoints/settings.html',
            controller: 'StreamingEndpointSettingsController',
            pageTitle: function(stateParams) {
                return stateParams.streamingEndpointId + " - Settings";
            }
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint.history', {
            url: '/history/',
            templateUrl: '/templates/streaming-endpoints/history.html',
            controller: 'StreamingEndpointHistoryController',
            pageTitle: function(stateParams) {
                return stateParams.streamingEndpointId + " - History";
            }
        });

        $stateProvider.state('projects.project.streaming-endpoints.streaming-endpoint.explore', {
            url: '/explore/',
            templateUrl: '/templates/streaming-endpoints/explore.html',
            controller: 'StreamingEndpointExploreController',
            pageTitle: function(stateParams) {
                return stateParams.streamingEndpointId + " - Explore";
            }
        });

        /* ************************** Analysis ********************** */

        $stateProvider.state('projects.project.analyses', {
            url: '/analysis',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.list', {
            url: '/?datasetId',
            templateUrl: '/templates/analysis/list.html',
            controller: "AnalysesListController",
            pageTitle: () => {
                return " Analyses";
            }
        });

        $stateProvider.state('projects.project.analyses.analysis', {
            url: '/:analysisId?discussionId',
            abstract: true,
            templateUrl: '/templates/analysis/analysis.html',
            controller: "AnalysisCoreController",
            pageTitle: () => {
                return " Analysis";
            }
        });

        $stateProvider.state('projects.project.analyses.analysis.script', {
            url: '/script/',
            templateUrl: '/templates/analysis/script.html',
        });

        $stateProvider.state('projects.project.analyses.analysis.charts', {
            url: '/visualize/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/analysis/charts.html',
        });

        $stateProvider.state('projects.project.analyses.analysis.ml', {
            url: '/ml',
            abstract: true,
            template: '<div ui-view></div>'
        });

        // You never stay on this state except if no mltask
        $stateProvider.state('projects.project.analyses.analysis.ml.list', {
            url: '/',
            templateUrl: '/templates/analysis/mltasks.html',
            controller: "AnalysisMLTasksController"
        });

        /* ******************** Analysis/ML/Prediction **************** */

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask', {
            url: '/p/:mlTaskId',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list', {
            url: '/list',
            abstract: true,
            templateUrl: '/templates/analysis/prediction/models.html',
            controller: 'PMLTaskBaseController'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list.design', {
            url: '/design',
            templateUrl: '/templates/analysis/prediction/models-design.html',
            controller: function($scope, $state) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane) => {
                    $scope.uiState.settingsPane = pane;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.predmltask.list.design";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    const suffix = MLModelsUIRouterStates.getPredictionDesignTabPrefix($scope) + "-learning";
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, suffix, event);
                });

                if ($state.current.name === baseStateName) {
                    const deregister = $scope.$watch("mlTaskDesign", (nv, ov) => {
                        if (!nv) {
                            return;
                        }
                        // redirect to learning page when arriving on "design", need to have mlTaskDesign to know the backend type...
                        const prefix = MLModelsUIRouterStates.getPredictionDesignTabPrefix($scope);
                        $state.go(`.${prefix}-learning`, null, {location: 'replace'});
                        deregister();
                    });
                }
            }
        });


        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getPredictionMLTaskDesignUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.predmltask.list.design.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.list.results', {
            url: '/results',
            templateUrl: '/templates/analysis/prediction/models-results.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setViewMode = (pane) => {
                    $scope.uiState.viewMode = pane;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.predmltask.list.results";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "sessions", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".sessions", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getAllResultsUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.predmltask.list.results.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model', {
            url: '/:fullModelId',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model.predictedtable', {
            url: '/table/',
            templateUrl: '/templates/analysis/prediction/model/model-predicted-table.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model.predictedcharts', {
            url: '/charts/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/analysis/prediction/model/model-predicted-charts.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.predmltask.model.report', {
            url: '/report?exportMode?treatment',
            templateUrl: '/templates/analysis/prediction/model/model-report.html',
            controller: "MLBaseRouteReportController"
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getAllPredictionReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.predmltask.model.report.' + stateName,
                stateConfig
            )
        }

        /* ******************** Analysis/ML/Clustering **************** */

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask', {
            url: '/c/:mlTaskId',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list', {
            url: '/list',
            abstract: true,
            templateUrl: '/templates/analysis/models.html',
            controller: 'CMLTaskBaseController'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list.design', {
            url: '/design',
            templateUrl: '/templates/analysis/clustering/models-design.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane) => {
                    $scope.uiState.settingsPane = pane;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.clustmltask.list.design";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "clustering-learning", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".clustering-learning", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getClusteringDesignUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.clustmltask.list.design.' + stateName,
                stateConfig
            )
        }


        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.list.results', {
            url: '/results',
            templateUrl: '/templates/analysis/clustering/models-results.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setViewMode = (pane) => {
                    $scope.uiState.viewMode = pane;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.clustmltask.list.results";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "sessions", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".sessions", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getAllResultsUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.clustmltask.list.results.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model', {
            url: '/:fullModelId',
            abstract: true,
            template: '<div ui-view></div>'
        });
        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model.predictedtable', {
            url: '/table/',
            templateUrl: '/templates/analysis/clustering/model/c-model-predicted-table.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model.predictedcharts', {
            url: '/charts/{chartId:[0-9a-zA-Z]*}{separator:_{0,1}}{chartName}',
            templateUrl: '/templates/analysis/clustering/model/c-model-predicted-charts.html'
        });

        $stateProvider.state('projects.project.analyses.analysis.ml.clustmltask.model.report', {
            url: '/report',
            templateUrl: '/templates/analysis/clustering/model/c-model-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseStateName = "projects.project.analyses.analysis.ml.clustmltask.model.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "summary", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getClusteringReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.analyses.analysis.ml.clustmltask.model.report.' + stateName,
                stateConfig
            )
        }

        /* ************************** Saved Model (Flow) ********************** */

        $stateProvider.state('projects.project.savedmodels', {
            url: '/savedmodels',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.list', {
            url: '/',
            templateUrl: '/templates/savedmodels/list.html',
            controller: "SavedModelListController",
            pageTitle: () => {
                return " Saved Models"
            }
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel', {
            url: '/:smId?discussionId',
            abstract: true,
            controller: "SavedModelController",
            templateUrl: '/templates/savedmodels/savedmodel.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.settings', {
            url: '/settings/',
            controller: "SavedModelSettingsController",
            templateUrl: '/templates/savedmodels/settings.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.status', {
            url: '/status',
            templateUrl: '/templates/savedmodels/status.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.status.metrics', {
            url: '/metrics/',
            templateUrl: '/templates/savedmodels/status-metrics.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.status.checks', {
            url: '/checks/',
            templateUrl: '/templates/savedmodels/status-checks.html'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.versions', {
            url: '/versions/?redirectToActiveVersion',
            controller: "SavedModelVersionsController",
            templateUrl: '/templates/savedmodels/versions.html'
        });

        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.prediction', '.report', '/p/:fullModelId?exportMode?treatment');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.prediction.legacysummary', '^.report', '/tabular-summary');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.prediction.trailingslash', '^.report', '/');

        $stateProvider.state('projects.project.savedmodels.savedmodel.prediction.report', {
            url: '/report',
            templateUrl: '/templates/savedmodels/prediction-report.html',
            controller: "MLBaseRouteReportController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.prediction.predictedtable', {
            url: '/table',
            templateUrl: '/templates/savedmodels/prediction-saved-model-predicted-table.html'
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getAllPredictionReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.savedmodels.savedmodel.prediction.report.' + stateName,
                stateConfig
            )
        }

        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.clustering', '.report', '/c/:fullModelId');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.clustering.legacysummary', '^.report', '/summary');
        redirectState($stateProvider, 'projects.project.savedmodels.savedmodel.clustering.trailingslash', '^.report', '/');

        $stateProvider.state('projects.project.savedmodels.savedmodel.clustering.report', {
            url: '/report',
            templateUrl: '/templates/savedmodels/clustering-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseStateName = "projects.project.savedmodels.savedmodel.clustering.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "summary", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.clustering.predictedtable', {
            url: '/table',
            templateUrl: '/templates/savedmodels/clustering-saved-model-predicted-table.html'
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getClusteringReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.savedmodels.savedmodel.clustering.report.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.savedmodels.savedmodel.llmGeneric', {
            url: '/llm-generic',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.llmGeneric.report', {
            url: '/:fullModelId',
            templateUrl: '/templates/savedmodels/llm-generic-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseStateName = "projects.project.savedmodels.savedmodel.llmGeneric.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "summary", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getLlmReportUIRouterStates()) {
            $stateProvider.state(
                'projects.project.savedmodels.savedmodel.llmGeneric.report.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent', {
            url: '/agent/:fullModelId',
            abstract: true,
            controller: "AgentSavedModelController",
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.design', {
            url: '',
            templateUrl: '/templates/savedmodels/agents/agent-version-design.html',
            controller: "AgentSavedModelDesignController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.settings', {
            url: '/settings',
            templateUrl: '/templates/savedmodels/agents/agent-version-settings.html',
            controller: "AgentSavedModelSettingsController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.logs', {
            url: '/logs',
            templateUrl: '/templates/savedmodels/agents/agent-version-logs.html',
            controller: "AgentSavedModelLogsController"
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.agent.history', {
            url: '/history',
            controller: "AgentVersionHistoryController",
            templateUrl: '/templates/savedmodels/saved-model-git-log.html'
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.history', {
            url: '/history',
            controller: "AgentSavedModelHistoryController",
            templateUrl: '/templates/savedmodels/saved-model-git-log.html'
        });


        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm', {
            url: '/retrieval-augmented-llm/:fullModelId',
            abstract: true,
            controller: "RetrievalAugmentedLLMSavedModelController",
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.design', {
            url: '',
            templateUrl: '/templates/savedmodels/retrieval-augmented-llm/retrieval-augmented-llm-version-design.html',
            controller: "RetrievalAugmentedLLMSavedModelDesignController"
        });

        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.settings', {
            url: '/settings',
            templateUrl: '/templates/savedmodels/retrieval-augmented-llm/retrieval-augmented-llm-version-settings.html',
            controller: "RetrievalAugmentedLLMSavedModelSettingsController"
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.logs', {
            url: '/logs',
            templateUrl: '/templates/savedmodels/retrieval-augmented-llm/retrieval-augmented-llm-version-logs.html',
            controller: "RetrievalAugmentedLLMSavedModelLogsController"
        });
        $stateProvider.state('projects.project.savedmodels.savedmodel.retrievalaugmentedllm.history', {
            url: '/history',
            templateUrl: '/templates/savedmodels/saved-model-git-log.html',
            controller: "RetrievalAugmentedLLMSavedModelHistoryController"
        });

        /* ************************** GenAI Models and Agents ********************** */

        $stateProvider.state('projects.project.genai', {
            url: '/genai',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.genai.list', {
            url: '/',
            templateUrl: '/templates/genai/list.html',
            controller: "GenAIListController",
            pageTitle: () => {
                return " GenAI Models and Agents"
            }
        });

        /* **************************  Model Comparisons (Flow) ********************** */

        $stateProvider.state('projects.project.modelcomparisons', {
            url: '/modelcomparisons',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.modelcomparisons.list', {
            url: '/',
            templateUrl: '/templates/modelcomparisons/list.html',
            controller: "modelComparisonListController",
            pageTitle: () => {
                return " Model Comparisons"
            }
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison', {
            url: '/:modelComparisonId?discussionId',
            templateUrl: '/templates/modelcomparisons/modelcomparison.html',
            controller: "modelComparisonController"
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.summary', {
            url: '/summary',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.feature_importance', {
            url: '/feature_importance',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.decision_chart', {
            url: '/decision_chart',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.lift_chart', {
            url: '/lift_chart',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.calibration_curve', {
            url: '/calibration_curve',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.roc_curve', {
            url: '/roc_curve',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.pr_curve', {
            url: '/pr_curve',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.density_chart', {
            url: '/density_chart',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.scatter_plot', {
            url: '/scatter_plot',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.uplift_charts', {
            url: '/uplift_charts',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.features', {
            url: '/features',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });


        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.training_information', {
            url: '/training_information',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.algorithm', {
            url: '/algorithm',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.modelcomparisons.modelcomparison.ts_resampling', {
            url: '/timeseries_resampling',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        /* **************************  GenAI Comparisons (Flow) ********************** */

        $stateProvider.state('projects.project.genaicomparisons', {
            url: '/genaicomparisons',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.genaicomparisons.list', {
            url: '/',
            templateUrl: '/templates/modelcomparisons/list.html',
            controller: "modelComparisonListController",
            pageTitle: () => {
                return " GenAI Comparisons"
            }
        });

        $stateProvider.state('projects.project.genaicomparisons.genaicomparison', {
            url: '/:modelComparisonId?discussionId',
            templateUrl: '/templates/modelcomparisons/modelcomparison.html',
            controller: "modelComparisonController"
        });

        $stateProvider.state('projects.project.genaicomparisons.genaicomparison.summary', {
            url: '/summary',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        });

        $stateProvider.state('projects.project.genaicomparisons.genaicomparison.row_by_row_analysis', {
            url:'/row_by_row_analysis',
            controller: "modelComparisonCompositionController",
            templateUrl: '/templates/modelcomparisons/comparison-tab.html'
        })

        /* **************************  Model Evaluation Store (Flow) ********************** */

        $stateProvider.state('projects.project.modelevaluationstores', {
            url: '/modelevaluationstores',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.modelevaluationstores.list', {
            url: '/',
            templateUrl: '/templates/modelevaluationstores/list.html',
            controller: "ModelEvaluationStoreListController",
            pageTitle: () => {
                return " Model Evaluation Stores"
            }
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore', {
            url: '/:mesId?discussionId',
            abstract: true,
            controller: "ModelEvaluationStoreController",
            templateUrl: '/templates/modelevaluationstores/modelevaluationstore.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.evaluations', {
            url: '/evaluations/',
            controller: "ModelEvaluationStoreEvaluationsController",
            templateUrl: '/templates/modelevaluationstores/evaluations.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.evaluation', {
            url: '/evaluations/:evaluationId',
            abstract: true,
            controller: "ModelEvaluationStoreBaseEvaluationController",
            templateUrl: '/templates/modelevaluationstores/evaluation.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.evaluation.report', {
            url: '/report?driftReference',
            reloadOnSearch: false,
            templateUrl: '/templates/modelevaluationstores/evaluation-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseStateName = "projects.project.modelevaluationstores.modelevaluationstore.evaluation.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "tabular-summary", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".tabular-summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getModelevaluationsReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.modelevaluationstores.modelevaluationstore.evaluation.report.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.status', {
            url: '/status',
            templateUrl: '/templates/modelevaluationstores/status.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.status.metrics', {
            url: '/metrics/',
            templateUrl: '/templates/modelevaluationstores/status-metrics.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.status.checks', {
            url: '/checks/',
            templateUrl: '/templates/modelevaluationstores/status-checks.html'
        });

        $stateProvider.state('projects.project.modelevaluationstores.modelevaluationstore.settings', {
            url: '/settings/',
            controller: "ModelEvaluationStoreSettingsController",
            templateUrl: '/templates/modelevaluationstores/settings.html'
        });

        /* **************************  GenAI Evaluation Store (Flow) ********************** */

        $stateProvider.state('projects.project.genaievaluationstores', {
            url: '/genaievaluationstores',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.genaievaluationstores.list', {
            url: '/',
            templateUrl: '/templates/modelevaluationstores/list.html',
            controller: "ModelEvaluationStoreListController",
            pageTitle: () => {
                return " GenAI Evaluation Stores"
            }
        });

        $stateProvider.state('projects.project.genaievaluationstores.genaievaluationstore', {
            url: '/:mesId?discussionId',
            abstract: true,
            controller: "ModelEvaluationStoreController",
            templateUrl: '/templates/modelevaluationstores/genaievaluationstore.html'
        });

        $stateProvider.state('projects.project.genaievaluationstores.genaievaluationstore.evaluations', {
            url: '/evaluations/',
            controller: "ModelEvaluationStoreEvaluationsController",
            templateUrl: '/templates/modelevaluationstores/evaluations.html'
        });

        $stateProvider.state('projects.project.genaievaluationstores.genaievaluationstore.evaluation', {
            url: '/evaluations/:evaluationId',
            abstract: true,
            controller: "ModelEvaluationStoreBaseEvaluationController",
            templateUrl: '/templates/modelevaluationstores/evaluation.html'
        });

        $stateProvider.state('projects.project.genaievaluationstores.genaievaluationstore.evaluation.report', {
            url: '/report?driftReference',
            reloadOnSearch: false,
            templateUrl: '/templates/modelevaluationstores/evaluation-report.html',
            controller: function($scope, $state, $timeout) {
                $scope.uiState = $scope.uiState || {};
                $scope.setSettingsPane = (pane, skinId) => {
                    $scope.uiState.settingsPane = skinId ? pane + "-" + skinId : pane;
                    $scope.uiState.skinId = skinId;
                }

                const baseStateName = "projects.project.genaievaluationstores.genaievaluationstore.evaluation.report";
                $scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
                    GoToStateNameSuffixIfBase($state, toState, toParams, fromState, fromParams, baseStateName, "tabular-summary", event);
                });

                if ($state.current.name === baseStateName) {
                    $timeout(() => $state.go(".tabular-summary", null, {location: 'replace'}));
                }
            }
        });

        for (const {stateName, stateConfig} of MLModelsUIRouterStates.getModelevaluationsReportAndModelViewUIRouterStates()) {
            $stateProvider.state(
                'projects.project.genaievaluationstores.genaievaluationstore.evaluation.report.' + stateName,
                stateConfig
            )
        }

        $stateProvider.state('projects.project.genaievaluationstores.genaievaluationstore.status', {
            url: '/status',
            templateUrl: '/templates/modelevaluationstores/status.html'
        });

        $stateProvider.state('projects.project.genaievaluationstores.genaievaluationstore.status.metrics', {
            url: '/metrics/',
            templateUrl: '/templates/modelevaluationstores/status-metrics.html'
        });

        $stateProvider.state('projects.project.genaievaluationstores.genaievaluationstore.status.checks', {
            url: '/checks/',
            templateUrl: '/templates/modelevaluationstores/status-checks.html'
        });

        $stateProvider.state('projects.project.genaievaluationstores.genaievaluationstore.settings', {
            url: '/settings/',
            controller: "ModelEvaluationStoreSettingsController",
            templateUrl: '/templates/modelevaluationstores/settings.html'
        });

        /* ************************** Retrievable Knowledge (flow) ********************** */

        $stateProvider.state('projects.project.retrievableknowledges', {
            url: '/knowledge-bank',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.retrievableknowledges.list', {
            url: '/',
            templateUrl: '/templates/retrievable-knowledge/list.html',
            controller: "RetrievableKnowledgeListController",
            pageTitle: () => {
                return " Knowledge Banks"
            }
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge', {
            url: '/:retrievableKnowledgeId',
            abstract: true,
            controller: "RetrievableKnowledgeController",
            templateUrl: '/templates/retrievable-knowledge/retrievable-knowledge.html'
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge.search', {
            url: '/search/',
            controller: "RetrievableKnowledgeSearchController",
            templateUrl: '/templates/retrievable-knowledge/search.html',
            params: {
                searchQuery: '',
                initiateSearch: false
            }
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge.usage', {
            url: '/usage/',
            controller: "RetrievableKnowledgeUsageController",
            templateUrl: '/templates/retrievable-knowledge/usage.html'
        });

        $stateProvider.state('projects.project.retrievableknowledges.retrievableknowledge.settings', {
            url: '/settings/',
            controller: "RetrievableKnowledgeSettingsController",
            templateUrl: '/templates/retrievable-knowledge/settings.html'
        });

        /* ************************** Labeling Task (Flow) ********************** */
        $stateProvider.state('projects.project.labelingtasks', {
            url: '/labelingtasks',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.labelingtasks.list', {
            url: '/',
            controller: "LabelingTasksListController",
            templateUrl: '/templates/labelingtasks/list.html',
            pageTitle: () => {
                return "Labeling tasks";
            }
        });

        $stateProvider.state('projects.project.labelingtasks.labelingtask', {
            url: '/:labelingTaskId?discussionId&identifier',
            controller: "LabelingTaskController",
            templateUrl: '/templates/labelingtasks/labelingtask.html',
            pageTitle: () => {
                return "Labeling task";
            }
        });

        $stateProvider.state('projects.project.labelingtasks.labelingtask.annotate', {
            url: '/annotate/',
            controller: 'LabelingTaskAnnotateController'
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.review', {
            url: '/review/',
            controller: "LabelingTaskReviewController",
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.overview', {
            url: '/overview/',
            controller: "LabelingTaskOverviewController",
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.io', {
            url: '/io/',
            controller: "LabelingTaskIOController",
            templateUrl: '/templates/labelingtasks/labeling-task-io-tab.html'
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.settings', {
            url: '/settings/:selectedTab',
            controller: "LabelingTaskSettingsController",
        });
        $stateProvider.state('projects.project.labelingtasks.labelingtask.history', {
            url: '/history/',
            controller: 'LabelingTaskHistoryController',
            templateUrl: '/templates/labelingtasks/labeling-task-history.html',
        });


        /* ************************** Managed folder (Flow) ********************** */

        $stateProvider.state('projects.project.managedfolders', {
            url: '/managedfolder',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder', {
            url: '/:odbId?discussionId',
            abstract: true,
            controller: "ManagedFolderBaseController",
            templateUrl: '/templates/managedfolder/managedfolder.html'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.view', {
            url: '/view/',
            params: {
                preUploadedFiles: null,
            },
            controller: "ManagedFolderViewController",
            templateUrl: '/templates/managedfolder/view.html',
            pageTitle: () => {
                return " Folder";
            }
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.settings', {
            url: '/settings/',
            controller: "ManagedFolderSettingsController",
            templateUrl: '/templates/managedfolder/settings.html',
            pageTitle: () => {
                return " Folder";
            }
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status', {
            url: '/status',
            abstract: true,
            templateUrl: '/templates/managedfolder/status.html',
            controller: 'ManagedFolderStatusController',
            pageTitle: () => {
                return " Folder";
            }
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status.settings', {
            url: '/settings',
            templateUrl: '/templates/managedfolder/status-settings.html'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status.metrics', {
            url: '',
            templateUrl: '/templates/managedfolder/status-metrics.html'
        });

        $stateProvider.state('projects.project.managedfolders.managedfolder.status.checks', {
            url: '/checks',
            templateUrl: '/templates/managedfolder/status-checks.html'
        });

        /* ************************** Foreign view of managed folders ********************** */

        $stateProvider.state('projects.project.foreignmanagedfolders', {
            url: '/foreignmanagedfolder',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.foreignmanagedfolders.managedfolder', {
            url: '/:odbId?discussionId?sourceProjectKey',
            abstract: true,
            controller: "ManagedFolderBaseController",
            templateUrl: '/templates/foreignmanagedfolder/managedfolder.html'
        });
        $stateProvider.state('projects.project.foreignmanagedfolders.managedfolder.view', {
            url: '/view/',
            controller: "ManagedFolderViewController",
            templateUrl: '/templates/managedfolder/view.html',
            pageTitle: () => {
                return " Folder";
            }
        });
        /* ************************** Recipes ********************** */

        $stateProvider.state('projects.project.recipes', {
            url: '/recipes',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.recipes.list', {
            url: '/',
            templateUrl: '/templates/recipes/list.html',
            controller: 'RecipesListController',
            pageTitle: () => {
                return "Recipes";
            }
        });

        $stateProvider.state('projects.project.recipes.new', {
            url: '/new/:type/?prefill&input&output',
            templateUrl: '/templates/recipes/recipe-editor.html',
            controller: 'RecipeEditorController',
            pageTitle: function(stateParams) {
                return "New " + stateParams.type + " recipe";
            }
        });

        $stateProvider.state('projects.project.recipes.recipe', {
            url: '/:recipeName/?newlyCreated?discussionId',
            templateUrl: '/templates/recipes/recipe-editor.html',
            controller: 'RecipeEditorController',
            pageTitle: function(stateParams) {
                return stateParams.recipeName + " - Recipe";
            },
            params: { isAIGenerated: false }
        });

        /* ************************** Flow jobs / monitoring  ********************** */

        $stateProvider.state('projects.project.jobs', {
            url: '/jobs',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.jobs.list', {
            url: '/',
            templateUrl: '/templates/jobs/list.html',
            controller: 'FlowJobsBrowserController',
            pageTitle: () => {
                return "Jobs";
            }
        });

        $stateProvider.state('projects.project.jobs.job', {
            url: '/:jobId/?hideFlow',
            templateUrl: '/templates/jobs/job-status.html',
            pageTitle: function(stateParams) {
                return "Job " + stateParams.jobId + "";
            },
        });

        $stateProvider.state('projects.project.datasets.new', {
            url: '/new/?zoneId',
            templateUrl: '/templates/datasets/new-dataset.html',
            controller: function($scope, CreateModalFromTemplate, TopNav, GlobalProjectActions) {
                TopNav.setItem(null);
                TopNav.setLocation(TopNav.TOP_FLOW, "new-dataset", TopNav.TABS_NONE, null);
                $scope.newManagedDataset = function() {
                    CreateModalFromTemplate("/templates/flow-editor/new-managed-dataset.html",
                        $scope, "NewManagedDatasetController");
                };

                GlobalProjectActions.getAllDatasetsByTiles($scope).then(val => $scope.datasetTiles = val);
                GlobalProjectActions.getHighlightedDatasets($scope).then(val => $scope.highlightedDatasets = val);
                $scope.startDatasetCreation = GlobalProjectActions.startDatasetCreation;

                // similar to what's done for the new dataset menu. Instead of a submenu, we show a tile
                const pluginSections = {};
                // get connectors, grouped by ownerPluginId
                $scope.appConfig.customDatasets.forEach(function(x) {
                    let pluginSection = pluginSections[x.ownerPluginId];
                    if (pluginSection == null) {
                        pluginSection = {
                            pluginId: x.ownerPluginId,
                            items: []
                        };
                        pluginSections[x.ownerPluginId] = pluginSection;
                    }

                    pluginSection.items.push({
                        type: x.datasetType,
                        label: x.desc.meta != null && x.desc.meta.label != null ? x.desc.meta.label : x.ownerPluginId,
                        icon: x.desc.meta != null ? x.desc.meta.icon : null
                    });
                });
                // get fs providers, grouped by ownerPluginId
                $scope.appConfig.customFSProviders.forEach(function(x) {
                    let pluginSection = pluginSections[x.ownerPluginId];
                    if (pluginSection == null) {
                        pluginSection = {
                            pluginId: x.ownerPluginId,
                            items: []
                        };
                        pluginSections[x.ownerPluginId] = pluginSection;
                    }

                    pluginSection.items.push({
                        type: x.fsProviderType,
                        label: x.desc.meta != null && x.desc.meta.label != null ? x.desc.meta.label : x.ownerPluginId,
                        icon: x.desc.meta != null ? x.desc.meta.icon : null
                    });
                });
                // fetch plugin label for each ownerPluginId
                $scope.customConnectorPlugins = [];
                $.each(pluginSections, function(pluginId, pluginData) {
                    const plugin = Array.dkuFindFn($scope.appConfig.loadedPlugins, function(n) {
                        return n.id == pluginId
                    });
                    if (plugin == null || plugin.hideComponents) {
                        return;
                    }
                    pluginData.items.forEach(function(dtype) {
                        if (!dtype.icon) dtype.icon = plugin.icon;
                    });
                    $scope.customConnectorPlugins.push({
                        isSection: true,
                        id: "plugin_" + plugin.id,
                        icon: plugin.icon,
                        label: plugin.label || plugin.id,
                        connectors: pluginData.items,
                        plugin: plugin
                    });
                });
            },
            pageTitle: () => {
                return "New dataset";
            }
        });

        /* ************************** Notebooks (SQL and jupyter) ********************** */

        $stateProvider.state('projects.project.notebooks', {
            url: '/notebooks',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projects.project.notebooks.list', {
            url: '/?datasetId',
            templateUrl: '/templates/notebooks/list.html',
            controller: 'NotebooksController',
            pageTitle: () => {
                return "Notebooks";
            }
        });

        $stateProvider.state('projects.project.notebooks.jupyter_notebook', {
            url: '/jupyter/:notebookId/?discussionId&kernel_name',
            templateUrl: '/templates/notebooks/jupyter_notebook.html',
            controller: 'IPythonController',
            pageTitle: function(stateParams) {
                return stateParams.notebookId + " | Jupyter notebook";
            }
        });

        $stateProvider.state('projects.project.notebooks.jupyter_notebook_copied', {
            url: '/jupyter/:notebookId/copy/',
            templateUrl: '/templates/notebooks/jupyter_notebook.html',
            controller: function($scope, $stateParams, $sce) {
                $scope.$stateParams = $stateParams;
                $scope.notebookURL = $sce.getTrustedResourceUrl("/jupyter/notebooks/" + $stateParams.projectKey + "/" + $stateParams.notebookId + '/copy');
            },
            pageTitle: () => {
                return "Jupyter notebook";
            }
        });

        $stateProvider.state('projects.project.notebooks.sql_notebook', {
            url: '/sql/:notebookId/?discussionId',
            templateUrl: '/templates/notebooks/sql_notebook.html',
            controller: function ($rootScope, $scope, $controller) {
                if ($rootScope.featureFlagEnabled("newSQLNotebookEditor")) {
                    $controller('SQLNotebookControllerCM6', {$scope: $scope});
                } else {
                    $controller('SQLNotebookControllerCM5', {$scope: $scope});
                }
            },
            // The user-friendly name is not in the stateParams, so the controller overrides the title
            pageTitle: () => {
                return "SQL notebook";
            },
            params: { cellId: null }
        });

        $stateProvider.state('projects.project.notebooks.search_notebook', {
            url: '/search/:notebookId/?discussionId',
            templateUrl: '/templates/notebooks/search-notebook.html',
            controller: 'SearchNotebookController',
            // The user-friendly name is not in the stateParams, so the controller overrides the title
            pageTitle: () => {
                return "Search notebook";
            }
        });

        $stateProvider.state('projects.project.promptstudios', {
            url: '/prompt-studios',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projects.project.promptstudios.list', {
            url: '/',
            templateUrl: '/templates/promptstudios/list.html',
            controller: 'PromptStudiosListController',
            pageTitle: () => {
                return "Prompt Studios";
            }
        });

        $stateProvider.state('projects.project.promptstudios.promptstudio', {
            url: '/:promptStudioId',
            params: { promptId: null},
            templateUrl: '/templates/promptstudios/prompt-studio.html',
            controller: 'PromptStudioController'
        });

        $stateProvider.state('projects.project.promptstudios.promptstudio.prompt', {
            url: '/prompt/:promptId'
        });


        $stateProvider.state('projects.project.agenttools', {
            url: '/agent-tools',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projects.project.agenttools.list', {
            url: '/?createTool',
            templateUrl: '/templates/agent-tools/list.html',
            controller: 'AgentToolsListController',
            params: {
                createTool: { value: null }
            },
            pageTitle: () => {
                return "Agent Tools";
            }
        });

        $stateProvider.state('projects.project.agenttools.agenttool', {
            url: '/:agentToolId',
            templateUrl: '/templates/agent-tools/agent-tool.html',
            controller: 'AgentToolController'
        });


        /* ************************** RStudio Server ********************** */

        $stateProvider.state('projects.project.rstudioserver', {
            url: '/rstudio-server',
            abstract: true,
            template: "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.rstudioserver.embed', {
            url: '/',
            templateUrl: '/templates/rstudio-server/embed.html',
            controller: "RStudioServerEmbedController",
            pageTitle: () => {
                return "RStudio Server"
            }
        });

        /* ***************** Webapps ********************** */

        $stateProvider.state('projects.project.webapps', {
            url : "/webapps",
            abstract : true,
            template : "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.webapps.list', {
            url : "/",
            templateUrl: '/templates/webapps/list.html',
            controller: 'WebAppsListController',
            pageTitle: () => {
                return "Webapps";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp', {
            url : "/{webAppId}_{webAppName}?discussionId",
            templateUrl: '/templates/webapps/webapp.html',
            controller: 'WebAppCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.webapps.webapp.edit', {
            url : "/edit?{safe-mode}",
            templateUrl: '/templates/webapps/edit.html',
            pageTitle: () => {
                return "Webapp";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp.view', {
            url : "/view",
            templateUrl: '/templates/webapps/view.html',
            pageTitle: () => {
                return "Webapp";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp.history', {
            url : "/history",
            templateUrl: '/templates/webapps/history.html',
            controller : "WebAppHistoryController",
            pageTitle: () => {
                return "Webapp";
            }
        });

        $stateProvider.state('projects.project.webapps.webapp.logs', {
            url : "/logs",
            templateUrl: '/templates/webapps/logs.html',
            pageTitle: () => {
                return "Webapp";
            }
        });

        /* ***************** CodeStudios ********************** */

        $stateProvider.state('projects.project.code-studios', {
            url : "/code-studios",
            abstract : true,
            template : "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.code-studios.list', {
            url : "/",
            templateUrl: ' /templates/code-studios/list.html',
            controller: 'CodeStudiosListController',
            pageTitle: () => "Code Studios"
        });

        $stateProvider.state('projects.project.code-studios.code-studio', {
            url : "/{codeStudioObjectId}?discussionId",
            templateUrl: ' /templates/code-studios/code-studio.html',
            controller: 'CodeStudioCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.code-studios.code-studio.view', {
        url : "/view?zone&file",
            templateUrl: ' /templates/code-studios/view.html',
            controller: 'CodeStudioViewController'
        });

        $stateProvider.state('projects.project.code-studios.code-studio.actions', {
            url : "/actions",
            templateUrl: ' /templates/code-studios/actions.html',
            controller: 'CodeStudioActionsController'
        });

        $stateProvider.state('projects.project.code-studios.code-studio.logs', {
            url : "/logs",
            templateUrl: ' /templates/code-studios/logs.html',
            controller: 'CodeStudioLogsController',
            params: {
                tab: ''
            }
        });

        $stateProvider.state('projects.project.code-studios.code-studio.files', {
            url : "/files",
            templateUrl: ' /templates/code-studios/files.html',
            controller: 'CodeStudioFilesController'
        });


        /* ***************** Reports ********************** */

        $stateProvider.state('projects.project.reports', {
            url : "/report",
            abstract : true,
            template : "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.reports.list', {
            url : "/",
            templateUrl: '/templates/code-reports/list.html',
            controller: 'ReportsListController',
            pageTitle: () => {
                return "Report";
            }
        });

        $stateProvider.state('projects.project.reports.report', {
            url : "/{reportId}?discussionId",
            templateUrl: '/templates/code-reports/report.html',
            controller: 'ReportCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.reports.report.edit', {
            url : "/edit",
            templateUrl: '/templates/code-reports/edit.html',
            controller: 'ReportEditController',
            pageTitle: () => {
                return "Report";
            }
        });

        $stateProvider.state('projects.project.reports.report.view', {
            url : "/view",
            templateUrl: '/templates/code-reports/view.html',
            controller: 'ReportViewController',
            pageTitle: () => {
                return "Report";
            }
        });

        $stateProvider.state('projects.project.reports.report.history', {
            url : "/history",
            templateUrl: '/templates/code-reports/history.html',
            controller : "ReportHistoryController",
            pageTitle: () => {
                return "Report";
            }
        });

        /* ***************** Dashboards ********************** */

        $stateProvider.state('projects.project.dashboards', {
            url: "/dashboards",
            abstract: true,
            template: "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.dashboards.list', {
            url: "/",
            templateUrl: '/templates/dashboards/list.html',
            controller: 'DashboardsListController',
            pageTitle: () => {
                return "Dashboards";
            }
        });

        $stateProvider.state('projects.project.dashboards.dashboard', {
            // eslint-disable-next-line no-useless-escape
            url: "/{dashboardId:[0-9a-zA-Z]*}{separator:\_{0,1}}{dashboardName}?discussionId&{exportId:[a-zA-Z0-9]{10}}",
            templateUrl: '/templates/dashboards/dashboard.html',
            controller: 'DashboardCoreController',
            abstract: true
        });

        $stateProvider.state('projects.project.dashboards.dashboard.edit', {
            url: "/edit/:pageId",
            templateUrl: '/templates/dashboards/edit.html',
            controller: "DashboardEditController",
            pageTitle: () => {
                return "Dashboard";
            }
        });

        $stateProvider.state('projects.project.dashboards.dashboard.view', {
            // to avoid the tilde character to be doubled by angular-ui, we specify the type of the query params as any
            // https://github.com/angular-ui/ui-router/issues/3790
            url: "/view/:pageId?fullScreen&embedded&{filters:any}&{pageFilters:any}",
            reloadOnSearch: false, // Do not reload page on filters param change
            templateUrl: '/templates/dashboards/view.html',
            controller: function($scope, TopNav) {
                TopNav.setLocation(TopNav.TOP_DASHBOARD, 'dashboards', null, 'view');
                if ($scope.dashboard) {
                    TopNav.setPageTitle($scope.dashboard.name + " - Dashboard");
                }
            },
            pageTitle: () => {
                return "Dashboard";
            }
        });

        $stateProvider.state('projects.project.dashboards.insights', {
            url: "/insights",
            abstract: true,
            template: "<div ui-view></div>"
        });

        $stateProvider.state('projects.project.dashboards.insights.list', {
            url: "/",
            templateUrl: '/templates/dashboards/insights/list.html',
            controller: 'InsightsListController',
            pageTitle: () => {
                return "Insights";
            }
        });

        for (const state of InsightsUIRouterStates.getInsightUIRouterStates('projects.project.dashboards.insights')) {
            $stateProvider.state(state.stateName, state.stateConfig);
        }

        /* ************************** Bundles ********************** */

        // DSS Design node

        $stateProvider.state('projects.project.bundlesdesign', {
            url: '/bundles-design',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.bundlesdesign.list', {
            url: '/?showProgressModalFor&bundleId&bundleTab',
            templateUrl: '/templates/bundles/design/list.html',
            controller: "DesignBundlesListController",
            pageTitle: () => {
                return "Bundles export";
            }
        });

        $stateProvider.state('projects.project.bundlesdesign.new', {
            url: '/new/',
            templateUrl: '/templates/bundles/design/new.html',
            controller: "DesignBundlesNewController",
            pageTitle: () => {
                return "Create bundle";
            }
        });

        // DSS Automation node

        $stateProvider.state('projects.project.bundlesautomation', {
            url: '/bundles-automation',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.bundlesautomation.list', {
            url: '/',
            templateUrl: '/templates/bundles/automation/list.html',
            controller: "AutomationBundlesListController",
            pageTitle: () => {
                return "Bundles management";
            }
        });

        $stateProvider.state('projects.project.bundlesautomation.settings', {
            url: '/settings/',
            templateUrl: '/templates/bundles/automation/activation-settings.html',
            controller: "AutomationBundlesSettingsController",
            pageTitle: () => {
                return "Bundles settings";
            }
        });

        /* ************************** Mass import           ********************** */
        $stateProvider.state('projects.project.tablesimport', {
            url: '/import-tables?zoneId',
            templateUrl: '/templates/datasets/project-tables-import.html',
            controller: 'ProjectMassTableToDatasetController',
            params: {
                importData: null
            },
            pageTitle: () => {
                return "Import tables";
            }
        });

        $stateProvider.state('alationOpen', {
            url: '/alation-open/:alationOpenId',
            templateUrl: '/templates/datasets/alation-open.html',
            controller: "AlationOpenController",
            pageTitle: () => {
                return "Mass import";
            }
        });

        /* ************************** API Services (Lambda) ********************** */

        $stateProvider.state('projects.project.lambdaservices', {
            url: '/api-designer',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.lambdaservices.list', {
            url: '/',
            templateUrl: '/templates/lambda/list.html',
            controller: "LambdaServicesListController",
            pageTitle: () => {
                return "API Services";
            }
        });

        $stateProvider.state('projects.project.lambdaservices.service', {
            url: '/:serviceId?discussionId',
            abstract: true,
            controller: "LambdaServiceBaseController",
            templateUrl: '/templates/lambda/lambda-service.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.summary', {
            url: '/summary/',
            controller: "LambdaServiceSummaryController",
            templateUrl: '/templates/lambda/summary.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.endpoints', {
            url: '/endpoints/',
            controller: "LambdaServiceEndpointsController",
            templateUrl: '/templates/lambda/endpoints.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.config', {
            url: '/config/',
            controller: "LambdaServiceConfigController",
            templateUrl: '/templates/lambda/lambda-service-config.html'
        });

        $stateProvider.state('projects.project.lambdaservices.service.packages', {
            url: '/packages/',
            controller: "LambdaServicePackagesController",
            templateUrl: '/templates/lambda/packages.html'
        });

        /* ************************** Wiki ********************** */

        $stateProvider.state('projects.project.wiki', {
            url: '/wiki',
            controller: "WikiController",
            templateUrl: '/templates/wikis/wiki.html'
        });

        $stateProvider.state('projects.project.wiki.article', {
            url: '/:articleId/:articleName?fullScreen',
            abstract: true,
            controller: "ArticleController",
            params: {
                // When no articleName is given through the URL, the router will act as if it didn't exist
                // (aka having url:'/:articleId')
                articleName: {squash: true, value: null}
            },
            templateUrl: '/templates/wikis/article.html'
        });

        // templates for the 3 sub-routes for wiki are handled through ng-show and ng-if instead of ui-view because we need to keep the editor state when switching tabs
        // note that history template is kept at the top in order to trigger infinite-scroll directive when switching tabs
        $stateProvider.state('projects.project.wiki.article.view', {
            url: '?discussionId'
        });

        $stateProvider.state('projects.project.wiki.article.edit', {
            url: '/edit'
        });

        $stateProvider.state('projects.project.wiki.article.history', {
            url: '/history'
        });

        $stateProvider.state('projects.wikis', { //mjt placeholder for the page PC is writing
            url: '/wikis',
            templateUrl: '/templates/wikis/article-history.html'
        });

        /* ************************** Scenarios ********************** */

        $stateProvider.state('projects.project.scenarios', {
            url: '/scenarios',
            abstract: true,
            controller: "ScenarioCoreController",
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.scenarios.list', {
            url: '/',
            templateUrl: '/templates/scenarios/list.html',
            controller: "ScenariosListController",
            pageTitle: () => {
                return "Scenarios";
            }
        });

        $stateProvider.state('projects.project.scenarios.scenario', {
            url: '/:scenarioId?discussionId',
            templateUrl: '/templates/scenarios/scenario.html',
            controller: "ScenarioController",
            pageTitle: () => {
                return "Scenario";
            }
        });

        $stateProvider.state('projects.project.scenarios.scenario.settings', {
            url: '/settings',
            templateUrl: '/templates/scenarios/fragments/scenario-settings.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.runs', {
            url: '/runs',
            abstract: true,
            templateUrl: '/templates/scenarios/fragments/scenario-runs-timeline.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.runs.list', {
            url: '/list',
            templateUrl: '/templates/scenarios/fragments/scenario-runs.html'
        });
        // same as above, but go directly to a run
        $stateProvider.state('projects.project.scenarios.scenario.runs.list.run', {
            url: '/:runId',
            templateUrl: '/templates/scenarios/scenario.html',
            controller: "ScenarioRunController",
            pageTitle: () => {
                return "Scenario";
            }
        });

        $stateProvider.state('projects.project.scenarios.scenario.runs.timeline', {
            url: '/timeline',
            templateUrl: '/templates/scenarios/fragments/scenario-timeline.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.history', {
            url: '/history',
            controller: "ScenarioHistoryController",
            templateUrl: '/templates/scenarios/fragments/scenario-git-log.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.steps', {
            url: '/steps',
            templateUrl: '/templates/scenarios/fragments/scenario-steps.html'
        });

        $stateProvider.state('projects.project.scenarios.scenario.script', {
            url: '/script',
            templateUrl: '/templates/scenarios/fragments/scenario-script.html'
        });

        $stateProvider.state('projects.project.data-quality', {
            url: '/data-quality',
            abstract: true,
            template: `<ng2-project-quality-tab-view
                [can-edit]="projectSummary.canWriteProjectContent"
                [can-publish-to-dashboards]="projectSummary.canWriteDashboards"
            ></ng2-project-quality-tabview>`
        });

        $stateProvider.state('projects.project.data-quality.current-status', {
            url: '/current-status',
            template: `
                <ng2-current-status-panel
                    [project-key]="$root.$state.params.projectKey"
                    [can-edit]="addToScope.canEdit"
                    [can-publish-to-dashboards]="addToScope.canPublishToDashboards"
                >
                </ng2-current-status-panel>
            `
        });

        $stateProvider.state('projects.project.data-quality.timeline', {
            url: '/timeline',
            template: '<ng2-project-quality-timeline-panel [project-key]="$root.$state.params.projectKey"></ng2-project-quality-timeline-panel>'
        });

        $stateProvider.state('projects.project.automation', {
            url: '/automation',
            abstract: true,
            template: '<div ui-view></div>',
            controller: "ScenariosMonitoringController",
        });

        const projectMonitoringParams = {
            templateUrl: '/templates/scenarios/scenarios-monitoring.html',
            pageTitle: () => {
                return "Monitoring";
            },
        };

        $stateProvider.state('projects.project.automation.test-dashboard', {
            url: '/test-dashboard',
            ...projectMonitoringParams,
            params: {
                activeTab: 'testDashboard',
                scopeToDay: null
            }
        });

        const projectMonitoringStates = [
            { name: 'timeline', route:'timeline', url: '/timeline' },
            { name: 'outcomes', route:'outcomes', url: '' },
            { name: 'timeline', route:'timeline.scoped', url: '/:scopeToDay' },
            { name: 'outcomes', route:'outcomes.scoped', url: '/:scopeToDay' }
        ];

        projectMonitoringStates.forEach(state => {
            $stateProvider.state(`projects.project.automation.${state.route}`, {
                url: state.url,
                ...projectMonitoringParams,
                params: {
                    activeTab: state.name,
                    scenarioQuery: null
                }
            });
        });

        /* ************************** Continuous Activities ********************** */
        $stateProvider.state('projects.project.continuous-activities', {
            url: '/continuous-activities',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.continuous-activities.list', {
            url: '/',
            templateUrl: '/templates/continuous-activities/list.html',
            controller: "ContinuousActivitiesListController",
            pageTitle: () => {
                return "Continuous Activities";
            }
        });

        $stateProvider.state('projects.project.continuous-activities.continuous-activity', {
            url: '/:continuousActivityId',
            templateUrl: '/templates/continuous-activities/continuous-activity.html',
            controller: "ContinuousActivityController",
            pageTitle: () => {
                return "Continuous Activity";
            }
        });

        $stateProvider.state('projects.project.continuous-activities.continuous-activity.runs', {
            url: '/runs?runId&attemptId',
            templateUrl: '/templates/continuous-activities/runs.html'
        });

        /* ************************** Macros ********************** */

        $stateProvider.state('projects.project.runnables', {
            url: '/macros',
            abstract: true,
            controller: "RunnableCoreController",
            template: '<div ui-view></div>'
        });

        $stateProvider.state('projects.project.runnables.list', {
            url: '/',
            templateUrl: '/templates/macros/runnables.html',
            controller: "RunnablesListController",
            pageTitle: () => {
                return "Macros";
            }
        });

        /* ************************** Dataiku Workspaces ********************** */

        WorkspacesUIRouterStates.getWorkspacesUIRouterStates().forEach(uiRouterState => {
            $stateProvider.state(uiRouterState.stateName, uiRouterState.stateConfig);
        });

        /* ************************** User profile pages ********************** */

        $stateProvider.state('profile', {
            abstract: true,
            url: '/profile',
            template: '<div ui-view></div>'
        });

        $stateProvider.state('profile.my', {
            url: '/',
            abstract: true,
            templateUrl: '/templates/profile/index.html',
            controller: 'ProfileController'
        });

        /* Default */
        $stateProvider.state('profile.my.settings', {
            url: '',
            templateUrl: '/templates/profile/settings.html',
            pageTitle: () => {
                return "Profile settings";
            },
            controller: 'MyProfileAccountController',
            params: { scrollTo: undefined },
            data: {selectedTab: 'settings'}
        });

        $stateProvider.state('profile.my.achievements', {
            url: 'achievements/',
            templateUrl: '/templates/profile/achievements.html',
            pageTitle: () => {
                return "My profile";
            },
            controller: 'MyProfileAchievementsController',
            data: {selectedTab: 'achievements'}
        });

        $stateProvider.state('profile.my.exports', {
            url: 'exports/',
            templateUrl: '/templates/profile/exports.html',
            pageTitle: () => {
                return "My exports";
            },
            controller: 'MyProfileExportController',
            data: {selectedTab: 'exports'}
        });

        $stateProvider.state('profile.my.stars', {
            url: 'stars/',
            templateUrl: '/templates/profile/stars.html',
            pageTitle: () => {
                return "My stars";
            },
            controller: 'MyProfileStarsController',
            data: {selectedTab: 'stars'}
        });

        $stateProvider.state('profile.my.credentials', {
            url: 'credentials/',
            templateUrl: '/templates/profile/credentials.html',
            pageTitle: () => {
                return "Personal credentials";
            },
            controller: 'MyProfileConnectionCredentialsController',
            data: {selectedTab: 'credentials'}
        });


        $stateProvider.state('profile.my.apikeys', {
            url: 'apikeys/',
            templateUrl: '/templates/profile/personal-api-keys.html',
            pageTitle: () => {
                return "Personal API Keys";
            },
            controller: 'MyProfilePersonalAPIKeysController',
            data: {selectedTab: 'apikeys'}
        });

        $stateProvider.state('profile.my.account', {
            url: 'account/',
            templateUrl: '/templates/profile/account.html',
            pageTitle: () => {
                return "Account";
            },
            controller: 'MyProfileEditController',
            data: {selectedTab: 'account'}
        });

        $stateProvider.state('profile.my.files', {
            url: 'files/',
            templateUrl: '/templates/profile/files.html',
            pageTitle: () => {
                return "Files";
            },
            controller: 'MyFilesEditController',
            data: {selectedTab: 'files'}
        });

        $stateProvider.state('profile.my.notifications', {
            url: 'notifications/',
            templateUrl: '/templates/profile/notifications.html',
            pageTitle: () => {
                return "My notifications";
            },
            data: {selectedTab: 'notifications'}
        });

        $stateProvider.state('oauth2-callback', {
            url: '/oauth2-callback',
            pageTitle: () => {
                return "OAuth2 callback";
            },
            controller: 'OAuth2CallbackController'
        });

        $stateProvider.state('profile.user', {
            url: '/:userLogin/',
            abstract: true,
            templateUrl: '/templates/profile/index.html',
            controller: 'ProfileController'
        });

        $stateProvider.state('profile.user.view', {
            url: '',
            templateUrl: '/templates/profile/achievements.html',
            controller: 'MyProfileAchievementsController',
            pageTitle: () => {
                return "Profile";
            }
        });

        /* ************************** Plugins ********************** */

        $stateProvider.state('plugins', {
            url: '/plugins-explore',
            controller: 'PluginsExploreController',
            templateUrl: '/templates/plugins/index.html',
            pageTitle: () => {
                return 'Plugins';
            }
        });

        $stateProvider.state('plugins.store', {
            url: '/store/:pluginid',
            templateUrl: '/templates/plugins/store-list.html',
            controller: 'PluginsStoreController',
            pageTitle: () => {
                return 'Plugins store';
            }
        });

        $stateProvider.state('plugins.installed', {
            url: '/installed/',
            templateUrl: '/templates/plugins/installed-list.html',
            pageTitle: () => {
                return 'Installed plugins';
            }
        });

        $stateProvider.state('plugins.development', {
            url: '/development/',
            templateUrl: '/templates/plugins/development-list.html',
            pageTitle: () => {
                return 'Plugins Development';
            }
        });

        /* ************************** Plugin page ********************** */

        $stateProvider.state('plugin', {
            url: '/plugins/:pluginId?pluginVersion',
            controller: 'PluginController',
            abstract: true,
            templateUrl: '/templates/plugins/plugin-details/index.html'
        });

        $stateProvider.state('plugin.installation', {
            url: '/installation/',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: function($stateParams) {
                return 'Installing ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.update', {
            url: '/update/',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: function($stateParams) {
                return 'Updating ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.upload', {
            url: '/upload',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            params: { uploadedPluginFile: null },
            pageTitle: function($stateParams) {
                return 'Uploading ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.upload.update', {
            url: '/update/',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            params: { uploadedPluginFile: null },
            pageTitle: function($stateParams) {
                return 'Updating ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugin.installationfromgit', {
            url: '/install-from-git/?uri&checkout&path&pluginName',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: () => {
                return 'Installing from Git'
            }
        });

        $stateProvider.state('plugin.updatefromgit', {
            url: '/update-from-git/?uri&checkout&path&pluginName',
            controller: 'PluginInstallationController',
            templateUrl: '/templates/plugins/plugin-details/installation.html',
            pageTitle: () => {
                return 'Updating from Git'
            }
        });


        $stateProvider.state('plugin.summary', {
            url: '/summary/',
            templateUrl: '/templates/plugins/plugin-details/summary.html',
            controller: 'PluginSummaryController',
            pageTitle: function($stateParams) {
                return 'Plugin - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugin.settings', {
            url: '/settings/:selectedTab',
            templateUrl: '/templates/plugins/plugin-details/settings.html',
            controller: 'PluginSettingsController',
            pageTitle: function($stateParams) {
                return 'Plugin settings - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugin.usages', {
            url: '/usages/',
            templateUrl: '/templates/plugins/plugin-details/usages.html',
            controller: 'PluginUsagesController',
            pageTitle: function($stateParams) {
                return 'Plugin usages - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugindev', {
            url: '/plugins/development/:pluginId',
            abstract: true,
            templateUrl: '/templates/plugins/development/plugin-details/index.html',
            controller: 'PlugindevEditionController'
        });

        $stateProvider.state('plugindev.definition', {
            url: '/definition/',
            templateUrl: '/templates/plugins/development/plugin-details/definition.html',
            controller: 'PlugindevDefinitionController',
            pageTitle: function($stateParams) {
                return 'Plugin - ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugindev.settings', {
            url: '/settings/:selectedTab',
            templateUrl: '/templates/plugins/development/plugin-details/settings.html',
            controller: 'PluginSettingsController',
            pageTitle: function($stateParams) {
                return 'Plugin settings - ' + $stateParams.pluginId;
            }
        });

        $stateProvider.state('plugindev.usages', {
            url: '/usages/',
            templateUrl: '/templates/plugins/plugin-details/usages.html',
            controller: 'PluginUsagesController',
            pageTitle: function($stateParams) {
                return 'Plugin usages - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugindev.editor', {
            url: '/editor/',
            templateUrl: '/templates/plugins/development/plugin-details/editor.html',
            controller: 'PlugindevEditorController',
            // to pass a param without putting it into the url
            resolve: {
                filePath: function($stateParams){
                    return $stateParams.filePath;
                }
            },
            params: {
                filePath: null
            },
            pageTitle: function($stateParams) {
                return 'Plugin Editor - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state('plugindev.history', {
            url: '/development/history/',
            templateUrl: '/templates/plugins/development/plugin-details/history.html',
            controller: 'PlugindevHistoryController',
            pageTitle: function($stateParams) {
                return 'Plugin History - ' + $stateParams.pluginId ;
            }
        });

        $stateProvider.state("libedition", {
            url: '/libedition',
            abstract: true,
            templateUrl: '/templates/plugins/development/lib-edition.html',
            controller: 'TopLevelFolderEditionController'
        });

        $stateProvider.state('libedition.libpython', {
            url: '/libpython?initialPath',
            templateUrl: '/templates/plugins/development/lib-python-editor.html',
            params: {
                initialPath: ''
            },
        });

        $stateProvider.state('libedition.libr', {
            url: '/libr',
            templateUrl: '/templates/plugins/development/lib-r-editor.html'
        });

        $stateProvider.state('libedition.localstatic', {
            url: '/localstatic',
            templateUrl: '/templates/plugins/development/local-static-editor.html',
            controller: 'TopLevelLocalStaticEditorController'
        });

        /* ************************** Autogenerated Python Doc ********************** */
        $stateProvider.state('docportal', {
            url: '/docportal?scope&projectKey&packageName&moduleName&className',
            template: '<ng2-doc-portal-home-page' +
                ' [scope]="$state.params.scope"' +
                ' [project-key]="$state.params.projectKey"' +
                ' [package-name]="$state.params.packageName"' +
                ' [module-name]="$state.params.moduleName"' +
                ' [class-name]="$state.params.className"' +
                '></ng2-doc-portal-home-page>',
            pageTitle: () => "Documentation Portal",
            controller: function(TopNav, $stateParams) {
                TopNav.setLocation(TopNav.DSS_HOME, "docportal");
            }
        });

        /* ************************** Feature Store ********************** */
        $stateProvider.state('featurestore', {
            url: '/feature-store',
            template: '<ng2-feature-store></ng2-feature-store>',
            pageTitle: () => {
                return "Feature Store";
            }
        });

        $stateProvider.state('projects.project.featurestore', {
            url: '/feature-store?zoneId',
            template: '<ng2-feature-store project-key="{{$state.params.projectKey}}" [zone-id]="$state.params.zoneId"></ng2-feature-store>',
            pageTitle: () => {
                return "Feature Store";
            }
        });

        /* ************************** Catalog ********************** */

        $stateProvider.state("catalog", {
            url: '/search-dss-items',
            abstract: true,
            templateUrl: '/templates/catalog/index.html',
            controller: function(TopNav) {
                TopNav.setLocation("DSS_HOME", "catalog", "items", null);
            }
        });

        const catalogItems = {
            url: '/:hash',
            templateUrl: '/templates/catalog/search.html',
            controller: "CatalogItemsController",
            params: {
                scope: null,
                _type: null
            },
            pageTitle: () => {
                return "Search DSS Items";
            }
        };

        const catalogMeanings = {
            url: '/meanings/:hash',
            templateUrl: '/templates/catalog/search.html',
            controller: "CatalogMeaningsController",
            pageTitle: () => {
                return "Meanings";
            }
        };

        $stateProvider.state('meanings', {
            url: '/meanings',
            templateUrl: '/templates/meanings/index.html',
            controller: "CatalogMeaningsController",
            pageTitle: () => {
                return "Meanings";
            }
        });

        $stateProvider.state('projects.project.catalog', {
            url: '/search-dss-items',
            abstract: true,
            templateUrl: '/templates/catalog/index.html',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.TOP_FLOW, "datasets", TopNav.TABS_NONE, null);
                TopNav.setNoItem();
            }
        });

        $stateProvider.state("catalog.items", $.extend({}, catalogItems));
        $stateProvider.state("projects.project.catalog.items", $.extend({}, catalogItems, { url:catalogItems.url+'?zoneId' }));
        $stateProvider.state("projects.project.catalog.meanings", $.extend({}, catalogMeanings));

        /* ************************** DATA CATALOG ********************** */

        // --- Redirect legacy catalog to homepage v2
        redirectedAbstractState($stateProvider, 'oldcatalog', '/catalog');
        redirectState($stateProvider, "oldcatalog.connection-explorer", "homeV2.data-catalog.database-explorer", "/connection-explorer?connectionName?schemaName?catalogName", true);
        $stateProvider.state('oldcatalog.items', { // old catalog to the new search-dss page or data-catalog
            url: '/search/:hash',
            controller: function($state, $stateParams) {
                if($stateParams.hash.includes('scope=external') || $stateParams.hash.includes('_type=table')) {
                    $state.go('homeV2.data-catalog.datasources', { selectedTab: 'external-tables' }, { location: 'replace' });
                } else {
                    // scope=all isn't reachable in search-dss, so we replace it by dss.
                    const hash = $stateParams.hash.replace('scope=all', 'scope=dss');
                    $state.go('catalog.items', { hash }, { location: 'replace' });
                }
            }
        });

        // --- Redirect 2022 out-of-project catalog to homepage v2
        redirectedAbstractState($stateProvider, 'datacatalog', '/data-catalog');
        redirectState($stateProvider, 'datacatalog.home', 'homeV2.data-catalog.home', '/');
        redirectedAbstractState($stateProvider, 'datacatalog.datacollections', '/data-collections');
        redirectState($stateProvider, 'datacatalog.datacollections.home', 'homeV2.data-catalog.data-collections.home', '/');
        redirectState($stateProvider, 'datacatalog.datacollections.datacollection', 'homeV2.data-catalog.data-collections.data-collection', '/:dataCollectionId/', true);
        redirectState($stateProvider, 'datacatalog.database-explorer', 'homeV2.data-catalog.database-explorer', '/connection-explorer?connectionName?schemaName?catalogName', true);
        redirectState($stateProvider, 'datacatalog.datasources', 'homeV2.data-catalog.datasources', '/:selectedTab', true); // must be placed last in order to prevent /:selectedTab to match with other routes

        // in-project data-catalog

        $stateProvider.state("projects.project.datacatalog", {
            url: '/data-catalog?zoneId',
            abstract: true,
            template: '<ui-view class="db h100 page-background"></ui-view>',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.TOP_FLOW, "catalog");
            },
        });

        $stateProvider.state("projects.project.datacatalog.home", {
            url: '/',
            template: '<ng2-in-project-data-catalog-home-page class="h100" [context-project]="projectSummary"></ng2-in-project-data-catalog-home-page>',
            pageTitle: () => "Data Catalog",
            controller: function($scope, $rootScope, $stateParams) {
                // we provide a default name value while summary is loading to prevent the Angular component to think it's in the home page
                $scope.projectSummary = {
                    projectKey: $stateParams.projectKey,
                    name: $stateParams.projectKey,
                }
                const projectSummaryWatcherUnsubscribe = $rootScope.$watch('projectSummary', (nv) => {
                    if(nv) {
                        $scope.project = {
                            projectKey: $stateParams.projectKey,
                            name: nv.name,
                        }
                    }
                });
                $scope.$on('$destroy', projectSummaryWatcherUnsubscribe);
            }
        });

        $stateProvider.state("projects.project.datacatalog.datacollections", {
            url: '/data-collections',
            abstract: true,
            template: '<ui-view></ui-view>'
        });

        $stateProvider.state("projects.project.datacatalog.datacollections.home", {
            url: '/',
            template: '<ng2-in-project-data-collections-home-page class="h100"></ng2-in-project-data-collections-home-page>',
            pageTitle: () => "Data Catalog"
        });

        $stateProvider.state("projects.project.datacatalog.datacollections.datacollection", {
            url: '/:dataCollectionId/',
            template: '<ng2-data-collection-page class="db h100" [id]="$root.$stateParams.dataCollectionId" [context-project-key]="$root.$stateParams.projectKey"></ng2-data-collection-page>',
            pageTitle: () => "Data Catalog"
        });

        $stateProvider.state('projects.project.datacatalog.database-explorer', {
            url: '/database-explorer?connectionName?schemaName?catalogName',
            template: '<database-explorer is-in-project="true"></database-explorer>',
            controller: "DatabaseExplorerController",
            pageTitle: () => 'Database explorer'
        });

        redirectState($stateProvider, 'projects.project.datacatalog.connection-explorer', 'projects.project.datacatalog.database-explorer', '/connection-explorer?connectionName?schemaName?catalogName', true);

        // Data Catalog > Data Sources - keep last to no override other data-catalog/xxx routes
        $stateProvider.state('projects.project.datacatalog.datasources', {
            url: '/:selectedTab',
            template: '<ng2-in-project-data-sources-page class="db h100" [context-project-key]="$root.$stateParams.projectKey" [query-on-load]="$root.$stateParams.queryOnLoad" [preselected-item]="$root.$stateParams.preselectedItem"></ng2-in-project-data-sources-page>',
            params: {
                queryOnLoad: null, // optionally set the query after load
                preselectedItem: undefined // optionally select an item (if it's in the results of the first query)
            },
            pageTitle: () => "Datasets & Indexed Tables"
        });


        /* ************************** DATA LINEAGE ********************** */

        // --- Redirect from old data-lineage URLs (when it was inside Data catalog) to the new ones
        redirectedAbstractState($stateProvider, 'datacatalog.datalineage', '/data-lineage');
        redirectState($stateProvider, "datacatalog.datalineage.home", "datalineage.home", "/");
        redirectState($stateProvider, "datacatalog.datalineage.graph", "datalineage.graph", "/:contextProjectKey/:smartName/:columnName", true);
        redirectState($stateProvider, "datacatalog.datalineage.homeWithParams", "datalineage.homeWithParams", "/:contextProjectKey/:smartName/", true);
        redirectState($stateProvider, "datacatalog.datalineage.export", "datalineage.export", "/export/:contextProjectKey/:smartName/:columnName", true);


        // --- Current version
        $stateProvider.state('datalineage', {
            url: '/data-lineage',
            abstract: true,
            template: '<ui-view></ui-view>',
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME);
            },
        });

        $stateProvider.state("datalineage.export", {
            url: '/export/:contextProjectKey/:smartName/:columnName',
            template: `<ng2-data-lineage-home-page
                [context-project-key]="$stateParams.contextProjectKey"
                [smart-name]="$stateParams.smartName"
                [column-name]="$stateParams.columnName"
                [lineage-export]="true"
            ></ng2-data-lineage-home-page>`
        })

        const dataLineageHome = {
            url: '/',
            template: `<ng2-data-lineage-home-page></ng2-data-lineage-home-page>`,
            pageTitle: () => "Data Lineage"
        };
        $stateProvider.state("datalineage.home", {...dataLineageHome});

        const dataLineageHomeWithParams = {
            url: '/:contextProjectKey/:smartName/',
            template: `<ng2-data-lineage-home-page
                [context-project-key]="$stateParams.contextProjectKey"
                [smart-name]="$stateParams.smartName"
            ></ng2-data-lineage-home-page>`,
            pageTitle: () => "Data Lineage"
        };
        $stateProvider.state("datalineage.homeWithParams", {...dataLineageHomeWithParams});

        const dataLineageGraph = {
            url: '/:contextProjectKey/:smartName/:columnName',
            template: `<ng2-data-lineage-home-page
                [context-project-key]="$stateParams.contextProjectKey"
                [smart-name]="$stateParams.smartName"
                [column-name]="$stateParams.columnName"
            ></ng2-data-lineage-home-page>`,
            pageTitle: () => "Data Lineage"
        };
        $stateProvider.state("datalineage.graph", {...dataLineageGraph});


        /* ************************** EXTERNAL TABLES ********************** */
        $stateProvider.state("external-table", {
            url: '/external-table/:connection/:catalog/:schema/:table',
            abstract: true,
            templateUrl: '/templates/catalog/external-table/index.html',
            controller: "ExternalTableController"
        });

        $stateProvider.state("external-table.summary", {
            url: '',
            template: '<external-table-summary class="h100"></external-table-summary>'
        });

        $stateProvider.state("external-table.schema", {
            url: '/schema/?selectedColumn',
            controller: "ExternalTableSchemaController",
            templateUrl: '/templates/catalog/external-table/schema.html'
        });
        $stateProvider.state("external-table.sample", {
            url: '/sample/',
            templateUrl: '/templates/catalog/external-table/sample.html'
        });
        $stateProvider.state("external-table.items", {
            url: '/items/',
            templateUrl: '/templates/catalog/external-table/items.html'
        });

        /* ************************** INBOX ********************** */

        $stateProvider.state("inbox", {
            url: "/inbox",
            template: "<inbox></inbox>",
            abstract: true,
        });

        /* ************************** NOTIFICATION CENTER ********************** */

        $stateProvider.state("inbox.requests", {
            url: "/requests/",
            template: "<request-center></request-center>" ,
            pageTitle: () => {
                return "Inbox - Requests center";
            },
        });

        $stateProvider.state("inbox.requests.selected", {
            url: ":requestId",
            template: '<request></request>', // note: request requires to be included in the request-center component
            pageTitle: () => {
                return "Inbox - Requests center";
            },
        });

        /* ************************** CONVERSATION CENTER ********************** */

        $stateProvider.state("inbox.conversations", {
            url: '/conversations/',
            templateUrl: '/templates/catalog/inbox.html',
            controller: 'DiscussionsInboxController',
            pageTitle: () => {
                return "Inbox - Conversations center";
            }
        });

        /* ************************** Deployer ********************** */

        $stateProvider.state('deployer', {
            url: '/deployer/',
            controller: 'DeployerHomeController',
            templateUrl: '/templates/deployer/index.html',
            pageTitle: () => "Deployer"
        });

        /* ************************** Unified Monitoring ********************** */

        $stateProvider.state('unified-monitoring', {
            url: '/unified-monitoring',
            controller: 'UnifiedMonitoringController',
            abstract: true,
            templateUrl: '/templates/unified-monitoring/index.html'
        });

        $stateProvider.state('unified-monitoring.overview', {
            url: '/',
            template: `<ng2-unified-monitoring-overview-page></ng2-unified-monitoring-overview-page>`,
            pageTitle: () => "Unified Monitoring Overview"
        });

        $stateProvider.state('unified-monitoring.projects', {
            url: '/projects',
            template: `<ng2-unified-monitoring-projects-page></ng2-unified-monitoring-projects-page>`,
            pageTitle: () => "Unified Monitoring Projects"
        });

        $stateProvider.state('unified-monitoring.endpoints', {
            url: '/endpoints',
            template: `<ng2-unified-monitoring-endpoints-page></ng2-unified-monitoring-endpoints-page>`,
            pageTitle: () => "Unified Monitoring Endpoints"
        });

        $stateProvider.state('unified-monitoring.alerting', {
            url: '/alerting',
            template: `<ng2-unified-monitoring-alerting-page></ng2-unified-monitoring-alerting-page>`,
            pageTitle: () => "Unified Monitoring Alerting"
        });

        $stateProvider.state('unified-monitoring.settings', {
            url: '/settings',
            template: `<ng2-unified-monitoring-settings-page></ng2-unified-monitoring-settings-page>`,
            pageTitle: () => "Unified Monitoring Settings"
        });

        $stateProvider.state('unified-monitoring.logs', {
            url: '/logs',
            template: `<ng2-unified-monitoring-logs-page></ng2-unified-monitoring-logs-page>`,
            pageTitle: () => "Unified Monitoring Logs"
        });

        /* ************************** API Deployer ********************** */

        $stateProvider.state('apideployer', {
            url: '/api-deployer/',
            controller: 'APIDeployerController',
            abstract: true,
            templateUrl: '/templates/api-deployer/index.html'
        });


        $stateProvider.state('apideployer.deployments', {
            url: 'deployments',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('apideployer.deployments.dashboard', {
            url: '/',
            controller: 'APIDeployerDeploymentsDashboardController',
            templateUrl: '/templates/api-deployer/deployment-dashboard.html',
            pageTitle: () => {
                return 'Deployments';
            }
        });
        $stateProvider.state('apideployer.deployments.deployment', {
            url: '/:deploymentId',
            abstract: true,
            controller: 'APIDeployerDeploymentController',
            templateUrl: '/templates/api-deployer/deployment.html'
        });
        $stateProvider.state('apideployer.deployments.deployment.status', {
            url: '/',
            controller: 'APIDeployerDeploymentStatusController',
            templateUrl: '/templates/api-deployer/deployment-status.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.updates', {
            url: '/last-updates/',
            controller: 'APIDeployerDeploymentUpdatesController',
            templateUrl: '/templates/api-deployer/deployment-updates.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.logs', {
            url: '/logs',
            controller: 'APIDeployerDeploymentLogsController',
            templateUrl: '/templates/api-deployer/deployment-logs.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.history', {
            url: '/history/',
            controller: 'APIDeployerDeploymentHistoryController',
            templateUrl: '/templates/api-deployer/deployment-history.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('apideployer.deployments.deployment.settings', {
            url: '/settings/',
            controller: 'APIDeployerDeploymentSettingsController',
            templateUrl: '/templates/api-deployer/deployment-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });


        $stateProvider.state('apideployer.services', {
            url: 'services',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('apideployer.services.list', {
            url: '/',
            controller: 'APIDeployerServicesListController',
            templateUrl: '/templates/api-deployer/published-services-list.html',
            pageTitle: () => {
                return 'Published API services';
            }
        });
        $stateProvider.state('apideployer.services.service', {
            url: '/:serviceId',
            abstract: true,
            controller: 'APIDeployerServiceController',
            templateUrl: '/templates/api-deployer/published-service.html'
        });
        $stateProvider.state('apideployer.services.service.status', {
            url: '/?versions',
            controller: 'APIDeployerServiceStatusController',
            params: {
                versions: { array: true }
            },
            templateUrl: '/templates/api-deployer/published-service-status.html',
            pageTitle: function(stateParams) {
                return stateParams.serviceId + ' - Published API services';
            }
        });
        $stateProvider.state('apideployer.services.service.history', {
            url: '/history/',
            controller: 'APIDeployerServiceHistoryController',
            templateUrl: '/templates/api-deployer/published-service-history.html',
            pageTitle: function(stateParams) {
                return stateParams.serviceId + ' - Published API services';
            }
        });
        $stateProvider.state('apideployer.services.service.settings', {
            url: '/settings/',
            controller: 'APIDeployerServiceSettingsController',
            templateUrl: '/templates/api-deployer/published-service-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.serviceId + ' - Published API services';
            }
        });


        $stateProvider.state('apideployer.infras', {
            url: 'infras',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('apideployer.infras.list', {
            url: '/',
            controller: 'APIDeployerInfrasListController',
            templateUrl: '/templates/api-deployer/infras-list.html',
            pageTitle: () => {
                return 'API Infrastructures';
            }
        });
        $stateProvider.state('apideployer.infras.infra', {
            url: '/:infraId',
            controller: 'APIDeployerInfraController',
            abstract: true,
            templateUrl: '/templates/api-deployer/infra.html'
        });
        $stateProvider.state('apideployer.infras.infra.status', {
            url: '/',
            controller: 'APIDeployerInfraStatusController',
            templateUrl: '/templates/api-deployer/infra-status.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - API Infrastructures';
            }
        });
        $stateProvider.state('apideployer.infras.infra.history', {
            url: '/history/',
            controller: 'APIDeployerInfraHistoryController',
            templateUrl: '/templates/api-deployer/infra-history.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - API Infrastructures';
            }
        });
        $stateProvider.state('apideployer.infras.infra.settings', {
            url: '/settings/',
            controller: 'APIDeployerInfraSettingsController',
            templateUrl: '/templates/api-deployer/infra-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - API Infrastructures';
            }
        });

        /* ************************** Project Deployer ********************** */
        $stateProvider.state('projectdeployer', {
            url: '/project-deployer/',
            controller: 'ProjectDeployerController',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('projectdeployer.deployments', {
            url: 'deployments',
            abstract: true,
            controller: 'ProjectDeployerDeploymentsController',
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.deployments.dashboard', {
            url: '/',
            controller: 'ProjectDeployerDeploymentDashboardController',
            templateUrl: '/templates/project-deployer/deployment-dashboard.html',
            pageTitle: () => {
                return 'Deployments';
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment', {
            url: '/:deploymentId',
            abstract: true,
            controller: 'ProjectDeployerDeploymentController',
            templateUrl: '/templates/project-deployer/deployment.html'
        });
        $stateProvider.state('projectdeployer.deployments.deployment.status', {
            url: '/',
            controller: 'ProjectDeployerDeploymentStatusController',
            templateUrl: '/templates/project-deployer/deployment-status.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.settings', {
            url: '/settings/',
            controller: 'ProjectDeployerDeploymentSettingsController',
            templateUrl: '/templates/project-deployer/deployment-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.updates', {
            url: '/last-updates/',
            controller: 'ProjectDeployerDeploymentUpdatesController',
            templateUrl: '/templates/project-deployer/deployment-updates.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.logs', {
            url: '/logs/',
            controller: 'ProjectDeployerDeploymentLogsController',
            templateUrl: '/templates/project-deployer/deployment-logs.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments';
            }
        });
        $stateProvider.state('projectdeployer.deployments.deployment.history', {
            url: '/history/',
            controller: 'ProjectDeployerDeploymentHistoryController',
            templateUrl: '/templates/project-deployer/deployment-history.html',
            pageTitle: function(stateParams) {
                return stateParams.deploymentId + ' - Deployments'
            }
        });

        $stateProvider.state('projectdeployer.projects', {
            url: 'projects',
            abstract: true,
            controller: 'ProjectDeployerProjectsController',
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.projects.list', {
            url: '/',
            controller: 'ProjectDeployerProjectListController',
            templateUrl: '/templates/project-deployer/published-projects-list.html',
            pageTitle: () => {
                return 'Projects';
            },
            params: {
                selectedProjectKey: null // open specified project accordion table on load
            }
        });
        $stateProvider.state('projectdeployer.projects.project', {
            url: '/:publishedProjectKey',
            abstract: true,
            controller: 'ProjectDeployerProjectController',
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.projects.project.home', {
            url: '',
            abstract: true,
            templateUrl: '/templates/project-deployer/published-project.html'
        });
        $stateProvider.state('projectdeployer.projects.project.home.status', {
            url: '/',
            controller: 'ProjectDeployerProjectStatusController',
            templateUrl: '/templates/project-deployer/published-project-status.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.projects.project.home.settings', {
            url: '/settings/',
            controller: 'ProjectDeployerProjectSettingsController',
            templateUrl: '/templates/project-deployer/published-project-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.projects.project.home.history', {
            url: '/history/',
            controller: 'ProjectDeployerProjectHistoryController',
            templateUrl: '/templates/project-deployer/published-project-history.html',
            pageTitle: function(stateParams) {
                return stateParams.publishedProjectKey + ' - Published Projects';
            }
        });
        $stateProvider.state('projectdeployer.projects.project.bundle', {
            url: '/bundle/:bundleId',
            controller: 'ProjectDeployerBundleController',
            abstract: true,
            templateUrl: '/templates/project-deployer/published-bundle.html'
        });
        $stateProvider.state('projectdeployer.projects.project.bundle.status', {
            url: '/',
            controller: 'ProjectDeployerBundleStatusController',
            templateUrl: '/templates/project-deployer/published-bundle-status.html',
            pageTitle: function(stateParams) {
                return stateParams.bundleId + ' - Published Bundles';
            }
        });

        $stateProvider.state('projectdeployer.infras', {
            url: 'infras',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });
        $stateProvider.state('projectdeployer.infras.list', {
            url: '/',
            controller: 'ProjectDeployerInfrasListController',
            templateUrl: '/templates/project-deployer/infras-list.html',
            pageTitle: () => {
                return 'Infrastructures';
            }
        });
        $stateProvider.state('projectdeployer.infras.infra', {
            url: '/:infraId',
            controller: 'ProjectDeployerInfraController',
            abstract: true,
            templateUrl: '/templates/project-deployer/infra.html'
        });
        $stateProvider.state('projectdeployer.infras.infra.status', {
            url: '/',
            controller: 'ProjectDeployerInfraStatusController',
            templateUrl: '/templates/project-deployer/infra-status.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - Automation Node Infrastructures';
            }
        });
        $stateProvider.state('projectdeployer.infras.infra.settings', {
            url: '/settings/',
            controller: 'ProjectDeployerInfraSettingsController',
            templateUrl: '/templates/project-deployer/infra-settings.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - Automation Node Infrastructures';
            }
        });
        $stateProvider.state('projectdeployer.infras.infra.history', {
            url: '/history/',
            controller: 'ProjectDeployerInfraHistoryController',
            templateUrl: '/templates/project-deployer/infra-history.html',
            pageTitle: function(stateParams) {
                return stateParams.infraId + ' - Automation Node Infrastructures';
            }
        });

        /* ************************** Automation  ********************** */

        $stateProvider.state("automation", {
            url: '/automation',
            abstract: true,
            templateUrl: '/templates/scenarios/instance-monitoring.html',
            pageTitle: () => "Automation",
        });

        $stateProvider.state("automation.outcomes", {
            url: '/',
            templateUrl: '/templates/scenarios/outcomes-instance-view.html',
        });

        $stateProvider.state("automation.timeline", {
            url: '/timeline',
            templateUrl: '/templates/scenarios/timeline.html',
        });

        $stateProvider.state("automation.triggers", {
            url: '/triggers',
            templateUrl: '/templates/scenarios/triggers-instance-view.html',
        });

        $stateProvider.state("automation.reporters", {
            url: '/reporters',
            templateUrl: '/templates/scenarios/reporters-instance-view.html',
        });

        /* ************************** Administration ********************** */

        $stateProvider.state('admin', {
            url: '/admin/',
            abstract: true,
            templateUrl: '/templates/admin/index.html',
            controller: function(Breadcrumb) {
                Breadcrumb.set([{type: "admin"}]);
            }
        });

        $stateProvider.state('admin.home', {
            url: '',
            templateUrl: '/templates/admin/home.html',
            controller: "AdminLicensingController",
            pageTitle: () => {
                return "Administration";
            }
        });

        $stateProvider.state('admin.general', {
            url: 'general/',
            templateUrl: '/templates/admin/general/index.html',
            controller: "AdminGeneralSettingsController",
            params: {
                scrollTo: undefined,
            },
        });

        $stateProvider.state('admin.general.themes', {
            url: 'themes/',
            controller: "AdminThemeController" ,
            templateUrl: '/templates/admin/general/themes.html',
            pageTitle: () => {
                return "Themes";
            },
        });

        $stateProvider.state('admin.general.help', {
            url: 'help/',
            templateUrl: '/templates/admin/general/help.html',
            pageTitle: () => {
                return "Help";
            },
        });

        $stateProvider.state('admin.general.homepage', {
            url: 'homepage/',
            templateUrl: '/templates/admin/general/homepage.html',
            pageTitle: () => {
                return "Homepage";
            },
        });

        $stateProvider.state('admin.general.globaltags', {
            url: 'global-tags/',
            templateUrl: '/templates/admin/general/global-tags.html',
            pageTitle: () => {
                return "Global tag categories";
            },
        });

        $stateProvider.state('admin.general.type_badges', {
            url: 'type-badges/',
            templateUrl: '/templates/admin/general/type-badges.html',
            pageTitle: () => {
                return "Project AI Types";
            },
        });

        $stateProvider.state('admin.general.notifications', {
            url: 'notifications/',
            templateUrl: '/templates/admin/general/notifications.html',
            pageTitle: () => {
                return "Notifications";
            },
        });

        $stateProvider.state('admin.general.charts_dashboards', {
            url: 'charts-and-dashboards/',
            templateUrl: '/templates/admin/general/charts-and-dashboards.html',
            controller: 'ChartsAndDashboardsController',
            pageTitle: () => {
                return "Charts & Dashboards";
            },
        });

        $stateProvider.state('admin.general.stories_themes', {
            url: 'dataiku-stories-themes/',
            templateUrl: '/templates/admin/general/stories-themes.html',
            controller: 'StoriesThemesController',
            pageTitle: () => {
                return "Stories";
            },
        });

        $stateProvider.state('admin.general.engines', {
            url: 'engines/',
            templateUrl: '/templates/admin/general/engines.html',
            pageTitle: () => {
                return "Engines";
            },
        });

        $stateProvider.state('admin.general.variables', {
            url: 'variables/',
            controller: 'AdminVariablesController',
            templateUrl: '/templates/admin/general/variables.html',
            pageTitle: () => {
                return "Variables";
            },
        });

        $stateProvider.state('admin.general.hadoop', {
            url: 'hadoop/',
            templateUrl: '/templates/admin/general/hadoop.html',
            pageTitle: () => {
                return "Hadoop";
            },
        });

        $stateProvider.state('admin.general.hive', {
            url: 'hive/',
            templateUrl: '/templates/admin/general/hive.html',
            pageTitle: () => {
                return "Hive";
            },
        });

        $stateProvider.state('admin.general.impala', {
            url: 'impala/',
            templateUrl: '/templates/admin/general/impala.html',
            pageTitle: () => {
                return "Impala";
            },
        });

        $stateProvider.state('admin.general.spark', {
            url: 'spark/',
            templateUrl: '/templates/admin/general/spark.html',
            pageTitle: () => {
                return "Spark";
            },
        });

        $stateProvider.state('admin.general.metastores', {
            url: 'metastores/',
            templateUrl: '/templates/admin/general/metastores.html',
            pageTitle: () => {
                return "Metastore catalogs";
            },
        });


        $stateProvider.state('admin.general.containers', {
            url: 'containers/',
            templateUrl: '/templates/admin/general/containers.html',
            pageTitle: () => {
                return "Containers";
            },
        });

        $stateProvider.state('admin.general.security', {
            url: 'security/',
            templateUrl: '/templates/admin/general/security.html',
            pageTitle: () => {
                return "Security";
            },
        });

        $stateProvider.state('admin.general.security_other', {
            url: 'security-other/',
            controller: 'AdminOtherSecurityController',
            templateUrl: '/templates/admin/general/security-other.html',
            pageTitle: () => {
                return "Security";
            },
        });


        $stateProvider.state('admin.general.limits', {
            url: 'limits/',
            templateUrl: '/templates/admin/general/limits.html',
            pageTitle: () => {
                return "Resources control";
            },
        });

        $stateProvider.state('admin.general.git', {
            url: 'git/',
            templateUrl: '/templates/admin/general/git.html',
            pageTitle: () => {
                return "Git";
            },
        });

        $stateProvider.state('admin.general.deployer', {
            url: 'deployer/',
            templateUrl: '/templates/admin/general/deployer.html',
            pageTitle: () => {
                return "Deployer";
            },
        });

        $stateProvider.state('admin.general.govern', {
            url: 'govern/',
            templateUrl: '/templates/admin/general/govern.html',
            pageTitle: () => {
                return "Govern";
            },
        });

        $stateProvider.state('admin.general.audit', {
            url: 'audit/',
            templateUrl: '/templates/admin/general/audit.html',
            pageTitle: () => {
                return "Audit";
            },
        });

        $stateProvider.state('admin.general.eventserver', {
            url: 'eventserver/',
            templateUrl: '/templates/admin/general/eventserver.html',
            pageTitle: () => {
                return "Event Server";
            },
        });

        $stateProvider.state('admin.general.genai', {
            url: 'genai/',
            controller: 'AdminGenAIController',
            templateUrl: '/templates/admin/general/genai.html',
            pageTitle: () => {
                return "Generative AI";
            },
        });

        $stateProvider.state('admin.general.aiservices', {
            url: 'aiservices/',
            controller: "AdminAiServicesSettingsController",
            templateUrl: '/templates/admin/general/aiservices.html',
            pageTitle: () => {
                return "AI Services";
            },
        });

        $stateProvider.state('admin.general.access', {
            url: 'access/',
            templateUrl: '/templates/admin/general/access.html',
            pageTitle: () => {
                return "Access & requests";
            },
        });

        $stateProvider.state('admin.general.misc', {
            url: 'misc/',
            templateUrl: '/templates/admin/general/misc.html',
            pageTitle: () => {
                return "Misc";
            },
        });

        $stateProvider.state('admin.general.stories', {
            url: 'stories/',
            templateUrl: '/templates/admin/general/datastory.html',
            pageTitle: () => {
                return "Dataiku Stories";
            },
        });

        /********************
         * Admin / Code envs
         ********************/

        $stateProvider.state('admin.codeenvs-design', {
            url: 'code-envs/design',
            abstract: true,
            templateUrl: '/templates/admin/code-envs/design/index.html'
        });

        $stateProvider.state('admin.codeenvs-design.list', {
            url: '/',
            controller: "AdminCodeEnvsDesignListController",
            templateUrl: '/templates/admin/code-envs/design/list.html',
            pageTitle: () => { return "Code envs"; }
        });

        $stateProvider.state('admin.codeenvs-design.internal', {
            url: '/internal',
            templateUrl: '/templates/admin/code-envs/common/internal-code-envs.html',
            pageTitle: () => { return "Internal code envs"; },
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME, "administration");
            }
        });

        $stateProvider.state('admin.codeenvs-design.create', {
            url: '/:draftId',
            controller: "AdminCodeEnvsDesignCreateFromDraftController",
            templateUrl: '/templates/admin/code-envs/design/list.html',
            pageTitle: () => { return "Code env creation"; }
        });

        $stateProvider.state('admin.codeenvs-design.python-edit', {
            url: '/python/:envName/',
            controller: "AdminCodeEnvsDesignPythonEditController",
            templateUrl: '/templates/admin/code-envs/design/python-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (Python) - Code Envs"; }
        });

        $stateProvider.state('admin.codeenvs-design.r-edit', {
            url: '/r/:envName/',
            controller: "AdminCodeEnvsDesignREditController",
            templateUrl: '/templates/admin/code-envs/design/R-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (R) - Code Envs";  }
        });

        $stateProvider.state('admin.codeenvs-automation', {
            url: 'code-envs/automation',
            abstract: true,
            templateUrl: '/templates/admin/code-envs/automation/index.html'
        });

        $stateProvider.state('admin.codeenvs-automation.list', {
            url: '/',
            controller: "AdminCodeEnvsAutomationListController",
            templateUrl: '/templates/admin/code-envs/automation/list.html',
            pageTitle: () => { return "Code Envs"; }
        });

        $stateProvider.state('admin.codeenvs-automation.internal', {
            url: '/internal',
            templateUrl: '/templates/admin/code-envs/common/internal-code-envs.html',
            pageTitle: () => { return "Internal code envs"; },
            controller: function(TopNav) {
                TopNav.setLocation(TopNav.DSS_HOME, "administration");
            }
        });

        $stateProvider.state('admin.codeenvs-automation.python-edit', {
            url: '/python/:envName/',
            controller: "AdminCodeEnvsAutomationPythonEditController",
            templateUrl: '/templates/admin/code-envs/automation/python-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (Python) - Code Envs"; }
        });

        $stateProvider.state('admin.codeenvs-automation.r-edit', {
            url: '/r/:envName/',
            controller: "AdminCodeEnvsAutomationREditController",
            templateUrl: '/templates/admin/code-envs/automation/R-edit.html',
            pageTitle: (stateParams) => { return stateParams.envName + " (R) - Code Envs"; }
        });

        /********************
         * Admin / Settings when user logged as non admin
         ********************/

        $stateProvider.state('admin.user-settings', {
            url: 'settings/',
            templateUrl: '/templates/admin/user-settings/index.html',
            controller: "AdminUserSettingsController",
            params: {
                scrollTo: undefined,
            },
        });

        $stateProvider.state('admin.user-settings.cost-limiting', {
            url: 'cost-limiting',
            templateUrl: '/templates/admin/cost-limiting/index.html'
        });

        /********************
         * Admin / Project Standards
         ********************/

        $stateProvider.state('admin.projectstandards', {
            url: 'project-standards/',
            abstract: true,
            templateUrl: '/templates/admin/project-standards/index.html'
        });

        $stateProvider.state('admin.projectstandards.checks', {
            url: 'checks-library/:checkId',
            template: `<ng2-project-standards-settings-checks [check-id]="$state.params.checkId"></ng2-project-standards-settings-checks>`,
            pageTitle: () => "Project Standards Checks Library"
        });

        $stateProvider.state('admin.projectstandards.scopes', {
            url: 'scopes/:scopeName',
            template: `<ng2-project-standards-settings-scopes [name]="$state.params.scopeName"></ng2-project-standards-settings-scopes>`,
            pageTitle: () => "Project Standards Scopes"
        });

        $stateProvider.state('admin.projectstandards.general', {
            url: 'general/',
            template: `<ng2-project-standards-settings-general-parameters></ng2-project-standards-settings-general-parameters>`,
            pageTitle: () => "General Parameters of Project Standards"
        });

        /********************
         * Admin / Maintenance
         ********************/

        $stateProvider.state('admin.maintenance', {
            url: 'maintenance/',
            templateUrl: '/templates/admin/maintenance/index.html'
        });

        $stateProvider.state('admin.maintenance.info', {
            url: 'info/',
            templateUrl: '/templates/admin/maintenance/info.html',
            pageTitle: () => {
                return "System info";
            },
            controller: "AdminMaintenanceInfoController"
        });

        $stateProvider.state('admin.maintenance.logs', {
            url: 'logs/',
            templateUrl: '/templates/admin/maintenance/logs.html',
            pageTitle: () => {
                return "Logs";
            },
            controller: "AdminLogsController"
        });

        $stateProvider.state('admin.maintenance.profiling', {
            url: 'profiling/',
            templateUrl: '/templates/admin/maintenance/profiling.html',
            pageTitle: () => {
                return "Performance profiling";
            },
            controller: "AdminProfilingController"
        });

        $stateProvider.state('admin.maintenance.diagnosis', {
            url: 'diagnosis/',
            templateUrl: '/templates/admin/maintenance/diagnosis.html',
            pageTitle: () => {
                return "Diagnosis";
            },
            controller: "AdminDiagnosticsController"
        });

        $stateProvider.state('admin.maintenance.scheduledtasks', {
            url: 'scheduled/',
            templateUrl: '/templates/admin/maintenance/scheduled-tasks.html',
            pageTitle: () => {
                return "Scheduled Tasks";
            },
            controller: "AdminScheduledTasksController" // Ugly ....
        });

        $stateProvider.state('admin.maintenance.sanitycheck', {
            url: 'sanitycheck/',
            templateUrl: '/templates/admin/maintenance/sanity-check.html',
            pageTitle: () => {
                return "Instance Sanity Check";
            },
            controller: "AdminSanityCheckController"
        });

        /********************
         * Admin / Monitoring
         ********************/

        $stateProvider.state('admin.monitoring', {
            url: 'monitoring',
            abstract: true,
            templateUrl: '/templates/admin/monitoring/index.html'
        });

        $stateProvider.state('admin.monitoring.summary', {
            url: '/',
            controller: "AdminMonitoringSummaryController",
            templateUrl: '/templates/admin/monitoring/global-summary.html',
            pageTitle: () => { return "Summary"; }
        });

        $stateProvider.state('admin.monitoring.clustertasks', {
            url: '/cluster-tasks/',
            controller: "AdminMonitoringClusterTasksController",
            templateUrl: '/templates/admin/monitoring/cluster-tasks.html',
            pageTitle: () => { return "Cluster & DB tasks"; }
        });

        $stateProvider.state('admin.monitoring.connectiondata', {
            url: '/connection-data/',
            controller: "AdminMonitoringConnectionDataController",
            templateUrl: '/templates/admin/monitoring/connection-data.html',
            pageTitle: () => { return "Per-connection data"; }
        });

        $stateProvider.state('admin.monitoring.bgtasks', {
            url: '/background-tasks/',
            controller: "AdminMonitoringBackgroundTasksController",
            templateUrl: '/templates/admin/monitoring/background-tasks.html',
            pageTitle: () => { return "Running background tasks"; }
        });

        $stateProvider.state('admin.monitoring.webapps', {
            url: '/webapp-backends/',
            controller: "AdminMonitoringWebAppBackendsController",
            templateUrl: '/templates/admin/monitoring/webapp-backends.html',
            pageTitle: () => { return "Webapp backends"; }
        });

        $stateProvider.state('admin.monitoring.integrations', {
            url: '/integrations/',
            controller: "AdminMonitoringIntegrationsController",
            templateUrl: '/templates/admin/monitoring/integrations.html',
            pageTitle : () => { return "Integrations"; }
        });

        /********************
         * Admin / Security
         ********************/

        $stateProvider.state('admin.security', {
            url: 'security/',
            abstract: true,
            templateUrl: '/templates/admin/security/index.html',
            controller: "AdminSecurityController"
        });

        $stateProvider.state('admin.security.users', {
            url: 'users/',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
        });

        $stateProvider.state('admin.security.users.list', {
            url:'',
            templateUrl: '/templates/admin/security/users.html',
            controller: 'UsersController',
            pageTitle: () => {
                return "Users";
            }
        });

        $stateProvider.state('admin.security.users.new', {
            url: 'new/',
            templateUrl: '/templates/admin/security/user.html',
            controller: 'UserController',
            pageTitle: () => {
                return "New user";
            }
        });

        $stateProvider.state('admin.security.users.edit', {
            url: 'edit/:login/',
            templateUrl: '/templates/admin/security/user.html',
            controller: 'UserController',
            pageTitle: function(stateParams) {
                return "Edit "+stateParams.login+"";
            }
        });

        $stateProvider.state('admin.security.groups', {
            url: 'groups/',
            abstract: true,
            template: '<div ui-view class="h100"></div>',
        });

        $stateProvider.state('admin.security.groups.list', {
            url: '',
            templateUrl: '/templates/admin/security/groups.html',
            pageTitle: () => {
                return "Groups";
            },
            controller: "GroupsController"
        });

        $stateProvider.state('admin.security.groups.new', {
            url: 'new/',
            templateUrl: '/templates/admin/security/group.html',
            controller: 'GroupController',
            pageTitle: () => {
                return "New group";
            }
        });

        $stateProvider.state('admin.security.groups.edit', {
            url: 'edit/:name/',
            templateUrl: '/templates/admin/security/group.html',
            controller: 'GroupController',
            pageTitle: function(stateParams) {
                return "Edit "+stateParams.name+"";
            }
        });

        $stateProvider.state('admin.security.users.external', {
            url:'external/',
            templateUrl: '/templates/admin/security/external-users.html',
            controller: 'ExternalUsersController',
            pageTitle: () => {
                return "Import from external sources";
            }
        });

        $stateProvider.state('admin.security.globalapi', {
            url: 'apikeys/',
            abstract: true,
            template: '<div ui-view class="h100"></div>'
        });

        $stateProvider.state('admin.security.globalapi.list', {
            url: '',
            templateUrl: '/templates/admin/security/global-api-keys.html',
            pageTitle: () => {
                return "API";
            },
            controller: "GlobalPublicAPIKeysController"
        });

        $stateProvider.state('admin.security.globalapi.new', {
            url: 'new/',
            templateUrl: '/templates/admin/security/global-api-key.html',
            pageTitle: () => {
                return "API";
            },
            controller: "EditGlobalPublicAPIKeyController"
        });

        $stateProvider.state('admin.security.globalapi.edit', {
            url: 'edit/:id/',
            templateUrl: '/templates/admin/security/global-api-key.html',
            controller: 'EditGlobalPublicAPIKeyController',
            pageTitle: () => {
                return "API";
            }
        });

        $stateProvider.state('admin.security.personalapi', {
            url: 'personalapikeys/',
            templateUrl: '/templates/admin/security/personal-api-keys.html',
            pageTitle: () => {
                return "API";
            },
            controller: "AdminPersonalPublicAPIKeysController"
        });

        $stateProvider.state('admin.security.authorizationmatrix', {
            url: 'authorization-matrix/',
            templateUrl: '/templates/admin/security/authorization-matrix.html',
            controller: "AdminSecurityAuthorizationMatrixController",
            pageTitle: () => { return "Authorization Matrix"; }
        });

        $stateProvider.state('admin.security.auditbuffer', {
            url: 'audit-buffer/',
            templateUrl: '/templates/admin/security/audit-buffer.html',
            controller: "AdminSecurityAuditBufferController",
            pageTitle: () => { return "Audit trail"; }
        });

        // Connections management

        $stateProvider.state('admin.connections', {
            url: 'connections/',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('admin.connections.list', {
            url: 'list/',
            templateUrl: '/templates/admin/connections.html',
            controller: 'ConnectionsController',
            pageTitle: () => {
                return "Overview";
            }
        });

        $stateProvider.state('admin.connections.hiveindexing', {
            url: 'hive-indexing/',
            templateUrl: '/templates/admin/connections.html', // Reuses the same template
            controller: 'ConnectionsHiveIndexingController',
            pageTitle: () => {
                return "Hive indexing";
            }
        });

        $stateProvider.state('admin.connections.new', {
            url: 'new/:type/',
            templateUrl: '/templates/admin/connection.html',
            controller: 'ConnectionController',
            pageTitle: function(stateParams) {
                return "New " + stateParams.type + " connection";
            }
        });

        $stateProvider.state('admin.connections.edit', {
            url: ':connectionName/',
            templateUrl: '/templates/admin/connection.html',
            controller: 'ConnectionController',
            pageTitle: function(stateParams) {
                return stateParams.connectionName + " - Connection";
            }
        });

        // Clusters admin
        $stateProvider.state('admin.clusters', {
            url: 'clusters',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('admin.clusters.list', {
            url: '/',
            templateUrl: '/templates/admin/clusters/clusters.html',
            controller: "ClustersController",
            pageTitle: () => {
                return "Clusters";
            }
        });

        $stateProvider.state('admin.clusters.cluster', {
            url: '/:clusterId',
            templateUrl: '/templates/admin/clusters/cluster.html',
            controller: "ClusterController",
            pageTitle: () => {
                return "Cluster";
            }
        });

        // CodeStudios admin
        $stateProvider.state('admin.code-studios', {
            url: 'code-studios',
            abstract: true,
            template: '<div ui-view></div>'
        });

        $stateProvider.state('admin.code-studios.list', {
            url: '/',
            templateUrl: '/templates/admin/code-studios/code-studio-templates.html',
            controller: "CodeStudioTemplatesListController",
            pageTitle: () => "Code Studio templates"
        });

        $stateProvider.state('admin.code-studios.code-studio', {
            url: '/:codeStudioTemplateId',
            templateUrl: '/templates/admin/code-studios/code-studio-template.html',
            controller: "CodeStudioTemplateController",
            pageTitle: (stateParams) => stateParams.codeStudioTemplateId ? stateParams.codeStudioTemplateId : 'Code Studio template'
        });

        //last but not the least : a route to cach everything that could not be routed

        $stateProvider.state("otherwise", {
            url: "*path",
            templateUrl: "/templates/404.html",
            controllerAs: '$ctrl',
            controller: function($window, $state) {
                var $ctrl = this;
                $ctrl.goHome = function() { $state.go('home'); };
            }
        });
    };

    app.provider('routes', function($stateProvider, $urlRouterProvider, WorkspacesUIRouterStates, MLModelsUIRouterStates, InsightsUIRouterStates, GoToStateNameSuffixIfBase) {
        this.$get = function() {
            declareRoutes($stateProvider, $urlRouterProvider, WorkspacesUIRouterStates, MLModelsUIRouterStates, InsightsUIRouterStates, GoToStateNameSuffixIfBase);
            return {};
        }
    });

    app.factory('translate', function($translate, $interpolate, $translateSanitization) {
        return function(translateID, defaultValue, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy = null) {
            let result = $translate.instant(translateID, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy);
            if (result === translateID && defaultValue !== undefined) {
                // sanitize translation for the default value using the same strategy as for a non-default value
                const sanitizedInterpolateParams = $translateSanitization.sanitize(interpolateParams, 'params', sanitizeStrategy);
                const rawResult = $interpolate(defaultValue)(sanitizedInterpolateParams);
                return $translateSanitization.sanitize(rawResult, 'text', sanitizeStrategy);
            }
            return result;
        }
    });

    // Service holding the translation tables preloaded by the UI via the /get-configuation call
    // They are temporarily stored in this service until requested by dssTranslationLoader.
    // This allow to correctly bootstrap the first screens of the UI with translations already loaded.
    app.service("PreloadedTranslationTables", () => {
        const svc = {};
        svc.add = function(language, translations) {
            svc.translationTables[language] = translations;
        };
        svc.getAndRemove = function(language) {
            const result = svc.translationTables[language];
            delete svc.translationTables[language];
            return result;
        };
        svc.translationTables = {};
        return svc;
    });

    app.factory('dssTranslationLoader', function($q, $http, DataikuAPI, PreloadedTranslationTables) {
        return function(options) {
            // First look whether this language was preloaded, if not load it asynchronously
            const preloadedTranslations = PreloadedTranslationTables.getAndRemove(options.key);
            if (preloadedTranslations !== undefined) {
                return $q.resolve(preloadedTranslations);
            } else {
                const deferred = $q.defer();
                DataikuAPI.translations.get("frontend", options.key)
                    .success(function(data) {
                        return deferred.resolve(data.translations);
                    })
                    .catch(() => deferred.resolve({})); // Use an empty dictionary in case of error so that we use the fallbacks
                return deferred.promise;
            }
        }
    });


    app.config(function($locationProvider, $httpProvider, $compileProvider, $translateProvider, $provide, routesProvider) {
        $locationProvider.html5Mode(true);
        routesProvider.$get();
        $httpProvider.interceptors.push('dssInterceptor');

        $translateProvider.preferredLanguage('en');
        $translateProvider.keepContent(true);
        $translateProvider.useLoader('dssTranslationLoader');
        $translateProvider.useSanitizeValueStrategy('escapeParameters');
    });
})();
