(function() {
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/core.js
     */
    app.directive('dashboardRightColumnSummary', function(DataikuAPI, $stateParams, $controller, QuickView, ActivityIndicator) {
        return {
            templateUrl: '/templates/dashboards/right-column-summary.html',
            link: function($scope, element, attrs) {

                $controller('_TaggableObjectsMassActions', { $scope: $scope });

                $scope.QuickView = QuickView;

                function calculateSelectionPromoteLabel() {
                    return $scope.selection.selectedObject && $scope.selection.selectedObject.listed ? $scope.translate('PROJECT.DASHBOARD.RIGHT_PANEL.ACTIONS.UNPROMOTE', 'Unpromote') : $scope.translate('PROJECT.DASHBOARD.RIGHT_PANEL.ACTIONS.PROMOTE', 'Promote');
                }

                const listedListener = $scope.$on('objectTimelineChanged', () => {
                    $scope.selectionPromoteLabel = calculateSelectionPromoteLabel();
                });

                /* Auto save when summary is modified */
                const objectSummaryEditedListener = $scope.$on('objectSummaryEdited', function() {
                    DataikuAPI.dashboards.save($scope.dashboard).success(function(data) {
                        ActivityIndicator.success('Saved');
                    }).error(setErrorInScope.bind($scope));
                });

                $scope.refreshData = function() {
                    DataikuAPI.dashboards.getFullInfo($scope.selection.selectedObject.projectKey, $scope.selection.selectedObject.id).success(function(data) {
                        if (!$scope.selection.selectedObject
                            || $scope.selection.selectedObject.id != data.dashboard.id
                            || $scope.selection.selectedObject.projectKey != data.dashboard.projectKey) {
                            return; //too late!
                        }
                        $scope.dashboardFullInfo = data;
                        $scope.dashboard = data.dashboard;
                    }).error(setErrorInScope.bind($scope));
                };

                $scope.$on('customFieldsSaved', $scope.refreshData);

                $scope.refreshTimeline = function() {
                    DataikuAPI.timelines.getForObject($stateParams.projectKey || $scope.selection.selectedObject.projectKey, 'DASHBOARD', $scope.selection.selectedObject.id)
                        .success(function(data) {
                            $scope.timeline = data;
                        })
                        .error(setErrorInScope.bind($scope));
                };

                $scope.$watch('selection.selectedObject', function(nv) {
                    if (!$scope.selection) {
                        $scope.selection = {};
                    }
                    $scope.dashboardFullInfo = { dashboard: $scope.selection.selectedObject, timeline: {} }; // display temporary (incomplete) data
                    $scope.selectionPromoteLabel = calculateSelectionPromoteLabel();
                });



                $scope.$watch('selection.confirmedItem', function(nv, ov) {
                    if (!nv) {
                        return;
                    }
                    $scope.refreshTimeline();
                    $scope.refreshData();
                });


                $scope.$on('$destroy', listedListener);
                $scope.$on('$destroy', objectSummaryEditedListener);
            }
        };
    });

})();
