(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    /**
     * Mono-valued list drop zone. No placeholder since drop replaces.
     * (!) This directive previously was in static/dataiku/js/simple_report/chart_dragdrop.js
     */
    app.directive('chartDragDropListReplace', function($parse, Assert) {
        return {
            scope: true,
            controller: 'ChartDragDropController',
            link: function($scope, element, attrs) {

                let acceptFunc = function(data) {
                    return {
                        accept: true,
                        message: 'Drop here'
                    };
                };

                if (attrs.acceptDrop) {
                    const parsed = $parse(attrs.acceptDrop);
                    acceptFunc = function(data) {
                        return parsed($scope.$parent || $scope, { 'data': data });
                    };
                }
                const parsed = attrs.getChartDragDropListReplace && $parse(attrs.getChartDragDropListReplace);
                $scope.getChartDragDropListReplace = function(data) {
                    const parsedFn = parsed && parsed($scope.$parent || $scope);
                    if (!parsedFn) {
                        return $scope.$eval(attrs.chartDragDropListReplace);
                    }
                    return parsedFn(data);
                };

                const onDragOverOrEnter = function(e) {
                    this.classList.add('over');
                    $(this).parent().parent().addClass('over');

                    if ($scope.activeDragDrop.draggedElementToHide) {
                        $scope.activeDragDrop.draggedElementToHide.hide();
                    }

                    // Do we accept this payload ?
                    const accepted = acceptFunc($scope.activeDragDrop.data);
                    if (accepted.accept) {
                        e.dataTransfer.dropEffect = 'copyMove';
                        e.preventDefault();
                    } else {
                        $scope.$apply(function() {
                            $scope.validity.tempError = {};
                            $scope.validity.tempError.type = 'MEASURE_REJECTED';
                            $scope.validity.tempError.message = accepted.message;
                        });
                    }
                };

                element[0].addEventListener('dragover', onDragOverOrEnter, false);
                element[0].addEventListener('dragenter', onDragOverOrEnter, false);

                element[0].addEventListener('dragleave', function(e) {
                    this.classList.remove('over');
                    $(this).parent().parent().removeClass('over');
                    $scope.$apply(function() {
                        delete $scope.validity.tempError;
                    });
                    return false;
                }, false);

                /*
                 * This is triggered as soon as a drag becomes active on the page
                 * and highlights the drop zone if it's accepted
                 */
                $scope.$watch('activeDragDrop.active', function(nv, ov) {
                    if (nv) {
                        const accepted = acceptFunc($scope.activeDragDrop.data);

                        if (accepted.accept) {
                            $scope.addClassHereAndThere(element, 'drop-accepted');
                        } else {
                            $scope.addClassHereAndThere(element, 'drop-rejected');
                        }
                    } else {
                        $scope.removeClassHereAndThere(element, 'drop-accepted');
                        $scope.removeClassHereAndThere(element, 'drop-rejected');
                    }
                }, true);

                element[0].addEventListener('drop', function(e) {
                    Assert.trueish($scope.activeDragDrop.active, 'no active drag and drop');

                    // Stops some browsers from redirecting.
                    if (e.stopPropagation) {
                        e.stopPropagation();
                    }

                    this.classList.remove('over');
                    $(this).parent().parent().removeClass('over');

                    // call the passed drop function
                    $scope.$apply(function($scope) {
                        const newData = angular.copy($scope.activeDragDrop.data);
                        // in some cases the list can be dynamic, based on the data we're dropping (hierarchies vs columns)
                        const targetList = $scope.getChartDragDropListReplace(newData);
                        delete newData.$$hashKey;
                        newData.__justDragDropped = true;

                        if ($scope.activeDragDrop.moveFromList && $scope.activeDragDrop.moveFromList === targetList) {
                            // DO nothing ...

                        } else if ($scope.activeDragDrop.moveFromList) {
                            targetList.splice(0, targetList.length);
                            targetList.push(newData);
                            $scope.activeDragDrop.moveFromList.splice($scope.activeDragDrop.moveFromListIndex, 1);
                        } else {
                            targetList.splice(0, targetList.length);
                            targetList.push(newData);
                        }

                        // Force remove placeholder right now
                        element.removeClass('drop-accepted');
                        element.removeClass('drop-rejected');

                        $scope.onDragEnd(newData);

                        $scope.$emit('dragDropSuccess');
                    });
                    return false;
                }, false);
            }
        };
    });
})();
