(function() {
    "use strict";

    /**
     * <opals-home-banner-empty-state/>
     */
    const opalsHomeBannerEmptyState = {
        templateUrl: "/static/dataiku/opals/opals-home-banner-empty-state/opals-home-banner-empty-state.component.html",
        controller: function opalsHomeBannerEmptyStateController(OpalsService, HomeBannerService, LocalStorage) {
            const $ctrl = this;

            $ctrl.$onInit = function() {
                OpalsService.getHomeBannerUrl().then(function(url) {
                  $ctrl.homeBannerUrl = url;
                });
                this.isShownBanner = !!LocalStorage.get("dss.opalsHomeBanner.shown");
            };

            $ctrl.toggleBanner = () => {
                this.isShownBanner = !this.isShownBanner;
                LocalStorage.set("dss.opalsHomeBanner.shown", this.isShownBanner)
                if (this.isShownBanner) {
                    HomeBannerService.showHomeBanner(false);
                } else {
                    HomeBannerService.hideHomeBanner(false);
                }
            }
        }
    };

    angular.module("dataiku.opals").component("opalsHomeBannerEmptyState", opalsHomeBannerEmptyState);
})();
