(function () {
    "use strict";
    angular.module("dataiku.opals").factory("WebappContextService", WebappContextService);
    const webappRoutes = [
        "projects.project.webapps.webapp.view",
        "projects.project.webapps.webapp.edit",
        "projects.project.webapps.webapp.history"
    ];

    function WebappContextService($rootScope, $timeout) {
        let currentWebappData = null;

        function setCurrentWebapp(data) {
            currentWebappData = data;
            $rootScope.$emit("dataiku.opals.WebappContextService.setCurrentWebapp");
        }

        function context(stateInfo) {
            return new Promise((resolve, reject) => {
                if (webappRoutes.includes(stateInfo.toState.name)) {
                    function callResolve() {
                        resolve({ ...stateInfo, ...{ context: [...stateInfo.context, currentWebappData.object.type] } });
                    }

                    function currentWebappDataMatchesStateInfo() {
                        return (
                            currentWebappData.object.projectKey === stateInfo.toParams.projectKey &&
                            currentWebappData.object.id === stateInfo.toParams.webAppId
                        );
                    }

                    if (currentWebappData && currentWebappDataMatchesStateInfo()) {
                        callResolve();
                        return;
                    }

                    const timeoutPromise = $timeout(() => {
                        reject("WebappContextService: setCurrentWebapp() not called after 60 seconds");
                        deregister();
                    }, 60000);
                    const deregister = $rootScope.$on("dataiku.opals.WebappContextService.setCurrentWebapp", () => {
                        if (currentWebappDataMatchesStateInfo()) {
                            $timeout.cancel(timeoutPromise);
                            callResolve();
                        } else {
                            reject("WebappContextService: Project key or Webapp id not matching");
                        }
                        deregister();
                    });
                } else {
                    reject(`WebappContextService: Nominal route (${stateInfo.toState.name}) not matched`);
                }
            });
        }

        return {
            setCurrentWebapp,
            context,
        };
    }
})();
